/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.wechat.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.wechat.core.model.UserAccessToken;
import com.jxdinfo.wechat.core.model.UserInfo;
import com.jxdinfo.wechat.core.model.WxPassenger;
import com.jxdinfo.wechat.core.properties.HussarWechatUserProperties;
import com.jxdinfo.wechat.core.service.WechatUserService;
import com.jxdinfo.wechat.core.service.impl.WechatMessageServiceImpl;
import com.jxdinfo.wechat.core.util.HttpUtils;
import com.jxdinfo.wechat.core.util.WxUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class WechatUserServiceImpl
implements WechatUserService {
    private ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
    private String appId = this.applicationContext.getEnvironment().getProperty("wechat.appId");
    private String appSecret = this.applicationContext.getEnvironment().getProperty("wechat.appSecret");
    private static final Logger logger = LoggerFactory.getLogger(WechatMessageServiceImpl.class);
    private String getUserAccessTokenUrl;
    private String getUserInfoUrl;
    private String grantType;

    @Autowired
    public WechatUserServiceImpl(HussarWechatUserProperties hussarWechatUserProperties) {
        this.getUserAccessTokenUrl = hussarWechatUserProperties.getUserAccessTokenUrl();
        this.getUserInfoUrl = hussarWechatUserProperties.getGetUserInfoUrl();
        this.grantType = hussarWechatUserProperties.getGrantType();
    }

    @Override
    public UserAccessToken getUserAccessToken(WxPassenger wxPassenger, String code) {
        StringBuilder urlPath = new StringBuilder(this.getUserAccessTokenUrl);
        urlPath.append('?');
        urlPath.append("appid=").append(wxPassenger.getAppId());
        urlPath.append("&secret=").append(wxPassenger.getAppSecret());
        urlPath.append("&code=").append(code);
        urlPath.append("&grant_type=").append(this.grantType);
        try {
            String receive = HttpUtils.getHttps(urlPath);
            JSONObject map = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)map)) {
                UserAccessToken userAccessToken = new UserAccessToken();
                userAccessToken.setAccessToken(map.get("access_token").toString());
                userAccessToken.setExpiresIn(map.get("expires_in").toString());
                userAccessToken.setOpenid(map.get("openid").toString());
                userAccessToken.setRefreshToken(map.get("refresh_token").toString());
                userAccessToken.setScope(map.get("scope").toString());
                return userAccessToken;
            }
            logger.warn("getUserAccessTokenError\uff1a" + map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public UserAccessToken getUserAccessToken(String code) {
        WxPassenger wxPassenger = new WxPassenger();
        wxPassenger.setAppId(this.appId);
        wxPassenger.setAppSecret(this.appSecret);
        return this.getUserAccessToken(wxPassenger, code);
    }

    @Override
    public UserInfo getUserInfo(String accessToken, String openid, String lang) {
        String newLang = lang == null ? "CN" : lang;
        StringBuilder urlPath = new StringBuilder(this.getUserInfoUrl);
        urlPath.append('?');
        urlPath.append("access_token=").append(accessToken);
        urlPath.append("&openid=").append(openid);
        urlPath.append("&lang=").append(newLang);
        UserInfo userInfo = this.getUserInfo(urlPath);
        if (userInfo != null) {
            return userInfo;
        }
        return null;
    }

    @Override
    public UserInfo getUserInfo(String accessToken, String openid) {
        String lang = "CN";
        StringBuilder urlPath = new StringBuilder(this.getUserInfoUrl);
        urlPath.append('?');
        urlPath.append("access_token=").append(accessToken);
        urlPath.append("&openid=").append(openid);
        urlPath.append("&lang=").append(lang);
        UserInfo userInfo = this.getUserInfo(urlPath);
        if (userInfo != null) {
            return userInfo;
        }
        return null;
    }

    private UserInfo getUserInfo(StringBuilder urlPath) {
        try {
            String receive = HttpUtils.getHttps(urlPath);
            JSONObject map = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)map)) {
                UserInfo userInfo = new UserInfo();
                userInfo.setOpenid(map.get("openid").toString());
                userInfo.setNickName(map.get("nickname").toString());
                userInfo.setSex(map.get("sex").toString());
                userInfo.setProvince(map.get("province").toString());
                userInfo.setCity(map.get("city").toString());
                userInfo.setCountry(map.get("country").toString());
                userInfo.setHeadImgUrl(map.get("headimgurl").toString());
                userInfo.setPrivilege(map.get("privilege").toString());
                return userInfo;
            }
            logger.warn("getUserInfoError\uff1a" + map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

