/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.wechat.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.wechat.core.model.Template;
import com.jxdinfo.wechat.core.model.WxMessage;
import com.jxdinfo.wechat.core.model.WxPassenger;
import com.jxdinfo.wechat.core.properties.HussarWechatTemplateProperties;
import com.jxdinfo.wechat.core.service.WechatBaseService;
import com.jxdinfo.wechat.core.service.WechatMessageService;
import com.jxdinfo.wechat.core.util.HttpUtils;
import com.jxdinfo.wechat.core.util.MessageUtils;
import com.jxdinfo.wechat.core.util.WxUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class WechatMessageServiceImpl
implements WechatMessageService {
    private ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
    private String appId = this.applicationContext.getEnvironment().getProperty("wechat.appId");
    private String appSecret = this.applicationContext.getEnvironment().getProperty("wechat.appSecret");
    private static final Logger logger = LoggerFactory.getLogger(WechatMessageServiceImpl.class);
    private String sendTemplateApi;
    private String addTemplate;
    private String deleteTemplate;
    private WechatBaseService wechatBaseService;

    @Autowired
    public WechatMessageServiceImpl(HussarWechatTemplateProperties hussarWechatTemplateProperties, WechatBaseService wechatBaseService) {
        this.sendTemplateApi = hussarWechatTemplateProperties.getSendTemplate();
        this.addTemplate = hussarWechatTemplateProperties.getSendTemplate();
        this.deleteTemplate = hussarWechatTemplateProperties.getDeleteTemplate();
        this.wechatBaseService = wechatBaseService;
    }

    @Override
    public Map doGetMessage(HttpServletRequest request) {
        try {
            request.setCharacterEncoding("UTF-8");
            Map<String, String> map = MessageUtils.xmlToMap(request);
            String ToUserName = map.get("ToUserName");
            String FromUserName = map.get("FromUserName");
            String CreateTime = map.get("CreateTime");
            String MsgType = map.get("MsgType");
            String Content = map.get("Content");
            String MsgId = map.get("MsgId");
            String str = null;
            if ("text".equalsIgnoreCase(MsgType)) {
                WxMessage message = new WxMessage();
                message.setFromUserName(ToUserName);
                message.setToUserName(FromUserName);
                message.setContent("\u60a8\u53d1\u9001\u7684\u6d88\u606f\u662ftext\u6587\u672c\u6d88\u606f\u5f88\u5e05");
                message.setMsgId(MsgId);
                message.setMsgType("text");
                message.setCreateTime(System.currentTimeMillis());
                str = MessageUtils.objectToXml(message);
                System.out.println(str);
                return map;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void doSendTemplateMessage(WxPassenger wxPassenger, Template template) {
        String token = this.wechatBaseService.getAccessToken(wxPassenger);
        StringBuilder sb = new StringBuilder(this.sendTemplateApi);
        sb.append(token);
        HttpUtils.postJson(sb, template);
    }

    @Override
    public void doSendTemplateMessage(Template template) {
        WxPassenger wxPassenger = new WxPassenger();
        wxPassenger.setAppId(this.appId);
        wxPassenger.setAppSecret(this.appSecret);
        this.doSendTemplateMessage(wxPassenger, template);
    }

    @Override
    public void doSendTemplateMessage(String token, Template template) {
        StringBuilder sb = new StringBuilder(this.sendTemplateApi);
        sb.append(token);
        HttpUtils.postJsonNoResult(sb, template);
    }

    @Override
    public String addTemplate(String token, String shortId) {
        HashMap<String, String> template_short = new HashMap<String, String>(2);
        template_short.put("template_id_short", shortId);
        StringBuilder sb = new StringBuilder(this.addTemplate);
        sb.append(token);
        try {
            String receive = HttpUtils.postJson(sb, template_short);
            JSONObject map = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)map)) {
                return map.get("template_id").toString();
            }
            logger.warn("addTemplateError\uff1a" + map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "error";
    }

    @Override
    public String deleteTemplate(String token, String templateId) {
        HashMap<String, String> template_short = new HashMap<String, String>(2);
        template_short.put("template_id", templateId);
        StringBuilder sb = new StringBuilder(this.deleteTemplate);
        sb.append(token);
        try {
            String receive = HttpUtils.postJson(sb, template_short);
            JSONObject map = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)map)) {
                return map.get("errcode").toString();
            }
            logger.warn("deleteTemplateError\uff1a" + map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "error";
    }
}

