/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.wechat.core.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.HashMap;

class TokenKitDemo {
    private static final long EXPIRE_TIME = 3600000L;
    private static final String TOKEN_SECRET = "token_secret";

    TokenKitDemo() {
    }

    private static boolean verify(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)TOKEN_SECRET);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            DecodedJWT jwt = verifier.verify(token);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String signDemo(String var1, String var2, String var3) {
        try {
            Date date = new Date(System.currentTimeMillis() + 3600000L);
            Algorithm algorithm = Algorithm.HMAC256((String)TOKEN_SECRET);
            HashMap<String, String> header = new HashMap<String, String>(2);
            header.put("type", "JWT");
            header.put("alg", "HS256");
            return JWT.create().withHeader(header).withClaim("var1", var1).withClaim("var2", var2).withClaim("var3", var3).withExpiresAt(date).sign(algorithm);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String refreshTokenDemo(String token) {
        if (TokenKitDemo.verify(token)) {
            String var1 = TokenKitDemo.getVar1Demo(token);
            String var2 = TokenKitDemo.getVar2Demo(token);
            String var3 = TokenKitDemo.getVar3Demo(token);
            return TokenKitDemo.signDemo(var1, var2, var3);
        }
        return "token is not valid";
    }

    private static String getVar1Demo(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("var1").asString();
        }
        catch (JWTDecodeException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getVar2Demo(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("var2").asString();
        }
        catch (JWTDecodeException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getVar3Demo(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("var3").asString();
        }
        catch (JWTDecodeException e) {
            e.printStackTrace();
            return null;
        }
    }
}

