/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.wechat.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.wechat.core.model.WxPassenger;
import com.jxdinfo.wechat.core.properties.HussarWechatBaseProperties;
import com.jxdinfo.wechat.core.properties.HussarWechatMenuProperties;
import com.jxdinfo.wechat.core.service.WechatBaseService;
import com.jxdinfo.wechat.core.service.WechatMenuService;
import com.jxdinfo.wechat.core.util.HttpUtils;
import com.jxdinfo.wechat.core.util.WxUtil;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class WechatMenuServiceImpl
implements WechatMenuService {
    private ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
    private String appId = this.applicationContext.getEnvironment().getProperty("wechat.appId");
    private String appSecret = this.applicationContext.getEnvironment().getProperty("wechat.appSecret");
    private String baseApi;
    private String getMenuApi;
    private String createMenuApi;
    private WechatBaseService wechatBaseService;

    @Autowired
    public WechatMenuServiceImpl(HussarWechatBaseProperties hussarWechatBaseProperties, HussarWechatMenuProperties hussarWechatMenuProperties, WechatBaseService wechatBaseService) {
        this.baseApi = hussarWechatBaseProperties.getBaseApi();
        this.getMenuApi = hussarWechatMenuProperties.getGetMenuApi();
        this.createMenuApi = hussarWechatMenuProperties.getCreateMenuApi();
        this.wechatBaseService = wechatBaseService;
    }

    @Override
    public Map selectMenu(String token) {
        WxPassenger wxPassenger = new WxPassenger();
        wxPassenger.setAppId("");
        wxPassenger.setAppSecret("");
        String accessToken = this.wechatBaseService.getAccessToken(wxPassenger);
        StringBuilder menuSelectUrl = new StringBuilder(this.getMenuApi);
        menuSelectUrl.append(accessToken);
        try {
            String receive = HttpUtils.getHttps(menuSelectUrl);
            return JSON.parseObject((String)receive);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map selectMenu(WxPassenger wxPassenger) {
        String accessToken = this.wechatBaseService.getAccessToken(wxPassenger);
        StringBuilder menuSelectUrl = new StringBuilder(this.getMenuApi);
        menuSelectUrl.append(accessToken);
        try {
            String receive = HttpUtils.getHttps(menuSelectUrl);
            return JSON.parseObject((String)receive);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map selectMenu() {
        WxPassenger wxPassenger = new WxPassenger();
        wxPassenger.setAppId(this.appId);
        wxPassenger.setAppSecret(this.appSecret);
        return this.selectMenu(wxPassenger);
    }

    @Override
    public String createMenu(WxPassenger wxPassenger, Object menu) {
        String token = this.wechatBaseService.getAccessToken(wxPassenger);
        StringBuilder sb = new StringBuilder(this.createMenuApi);
        sb.append(token);
        try {
            String receive = HttpUtils.postJson(sb, menu);
            JSONObject map = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)map)) {
                return map.get("errcode").toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String createMenu(Object menu) {
        WxPassenger wxPassenger = new WxPassenger();
        wxPassenger.setAppId(this.appId);
        wxPassenger.setAppSecret(this.appSecret);
        return this.createMenu(wxPassenger, menu);
    }

    @Override
    public String createMenu(String token, Object menu) {
        StringBuilder sb = new StringBuilder(this.createMenuApi);
        sb.append(token);
        try {
            String receive = HttpUtils.postJson(sb, menu);
            JSONObject map = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)map)) {
                return map.get("errcode").toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

