/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.wechat.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.wechat.core.model.WxPassenger;
import com.jxdinfo.wechat.core.properties.HussarWechatBaseProperties;
import com.jxdinfo.wechat.core.properties.HussarWechatBaseSettingsProperties;
import com.jxdinfo.wechat.core.properties.HussarWechatJsSdkProperties;
import com.jxdinfo.wechat.core.service.WechatBaseService;
import com.jxdinfo.wechat.core.service.impl.WechatMessageServiceImpl;
import com.jxdinfo.wechat.core.util.HttpUtils;
import com.jxdinfo.wechat.core.util.StringUtil;
import com.jxdinfo.wechat.core.util.WxUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class WechatBaseServiceImpl
implements WechatBaseService {
    private ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
    private String appId = this.applicationContext.getEnvironment().getProperty("wechat.appId");
    private String appSecret = this.applicationContext.getEnvironment().getProperty("wechat.appSecret");
    private static final Logger logger = LoggerFactory.getLogger(WechatMessageServiceImpl.class);
    private String setIndustryApi;
    private String getIndustryApi;
    private String baseApi;
    private String baseTokenApi;
    private String getTicketApi;
    private String getWechatImgTicketApi;

    @Autowired
    public WechatBaseServiceImpl(HussarWechatBaseProperties hussarWechatBaseProperties, HussarWechatBaseSettingsProperties hussarWechatBaseSettingsProperties, HussarWechatJsSdkProperties hussarWechatJsSdkProperties) {
        this.setIndustryApi = hussarWechatBaseSettingsProperties.getSetIndustry();
        this.getIndustryApi = hussarWechatBaseSettingsProperties.getGetIndustry();
        this.baseApi = hussarWechatBaseProperties.getBaseApi();
        this.baseTokenApi = hussarWechatBaseProperties.getBaseTokenApi();
        this.getTicketApi = hussarWechatJsSdkProperties.getGetTicket();
        this.getWechatImgTicketApi = hussarWechatBaseSettingsProperties.getGetWechatImgTicketApi();
    }

    @Override
    public String getAccessToken(WxPassenger wxPassenger) {
        StringBuilder url = new StringBuilder(this.baseTokenApi);
        url.append("grant_type=client_credential");
        url.append("&").append("appid=").append(wxPassenger.getAppId());
        url.append("&").append("secret=").append(wxPassenger.getAppSecret());
        try {
            String receive = HttpUtils.getHttps(url);
            JSONObject map = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)map)) {
                return map.get("access_token").toString();
            }
            logger.warn("getAccessTokenError" + map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getAccessToken() {
        WxPassenger wxPassenger = new WxPassenger();
        wxPassenger.setAppId(this.appId);
        wxPassenger.setAppSecret(this.appSecret);
        return this.getAccessToken(wxPassenger);
    }

    @Override
    public String setIndustry(String token, String firstIndustryId, String secondIndustryId) {
        HashMap<String, String> industry = new HashMap<String, String>(2);
        industry.put("industry_id1", firstIndustryId);
        industry.put("industry_id2", secondIndustryId);
        StringBuilder sb = new StringBuilder(this.setIndustryApi);
        sb.append(token);
        try {
            String receive = HttpUtils.postJson(sb, industry);
            JSONObject map = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)map)) {
                return map.get("errcode").toString();
            }
            logger.warn("setIndustryError\uff1a" + map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "error";
    }

    @Override
    public String setIndustry(WxPassenger wxPassenger, String firstIndustryId, String secondIndustryId) {
        String token = this.getAccessToken(wxPassenger);
        HashMap<String, String> industry = new HashMap<String, String>(2);
        industry.put("industry_id1", firstIndustryId);
        industry.put("industry_id2", secondIndustryId);
        StringBuilder sb = new StringBuilder(this.setIndustryApi);
        sb.append(token);
        try {
            String receive = HttpUtils.postJson(sb, industry);
            JSONObject map = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)map)) {
                return map.get("errcode").toString();
            }
            logger.warn("setIndustryError\uff1a" + map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "error";
    }

    @Override
    public String setIndustry(String firstIndustryId, String secondIndustryId) {
        WxPassenger wxPassenger = new WxPassenger();
        wxPassenger.setAppId(this.appId);
        wxPassenger.setAppSecret(this.appSecret);
        return this.setIndustry(wxPassenger, firstIndustryId, secondIndustryId);
    }

    @Override
    public Map getIndustry(WxPassenger wxPassenger) {
        String token = this.getAccessToken(wxPassenger);
        StringBuilder url = new StringBuilder(this.getIndustryApi);
        url.append(token);
        try {
            String receive = HttpUtils.getHttps(url);
            JSONObject map = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)map)) {
                return map;
            }
            logger.warn("getIndustryError\uff1a" + map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Map getIndustry() {
        WxPassenger wxPassenger = new WxPassenger();
        wxPassenger.setAppId(this.appId);
        wxPassenger.setAppSecret(this.appSecret);
        return this.getIndustry(wxPassenger);
    }

    @Override
    public Map getIndustry(String token) {
        StringBuilder url = new StringBuilder(this.getIndustryApi);
        url.append(token);
        try {
            String receive = HttpUtils.getHttps(url);
            JSONObject map = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)map)) {
                return map;
            }
            logger.warn("getIndustryError\uff1a" + map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getJsapiTicket(String token) {
        StringBuilder sb = new StringBuilder(this.getTicketApi);
        sb.append(token);
        sb.append("&type=jsapi");
        try {
            String receive = HttpUtils.getHttps(sb);
            JSONObject map = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)map)) {
                return map.get("ticket").toString();
            }
            logger.warn("getJsapiTicketError\uff1a" + map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Map getJsSdkSignInfo(String token, String url) {
        String jsapi_ticket = this.getJsapiTicket(token);
        String str = "";
        String noncestr = UUID.randomUUID().toString().replace("-", "").substring(0, 16);
        String timestamp = StringUtil.getTimestamp();
        str = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + noncestr + "&timestamp=" + timestamp + "&url=" + url;
        String signature = StringUtil.getSHA1(str);
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("timestamp", timestamp);
        returnMap.put("nonceStr", noncestr);
        returnMap.put("signature", signature);
        returnMap.put("jsapi_ticket", jsapi_ticket);
        return returnMap;
    }

    @Override
    public String getWechatImgTicket(String token) {
        StringBuilder url = new StringBuilder(this.getWechatImgTicketApi);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("action_name", "QR_LIMIT_SCENE");
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("scene_id", "");
        HashMap<String, HashMap<String, String>> actionInfo = new HashMap<String, HashMap<String, String>>();
        actionInfo.put("scene", map1);
        map.put("action_info", actionInfo);
        url.append(token);
        try {
            String receive = HttpUtils.postJson(url, map);
            JSONObject receivedMap = JSON.parseObject((String)receive);
            if (WxUtil.rightRes((Map)receivedMap)) {
                return receivedMap.get("ticket").toString();
            }
            logger.warn("getWechatImgTicketError\uff1a" + receivedMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

