/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.wechat.core.service.impl;

import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.wechat.core.model.WxPassenger;
import com.jxdinfo.wechat.core.service.WechatBaseService;
import com.jxdinfo.wechat.core.service.WechatTokenManage;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class WechatTokenManageImpl
implements WechatTokenManage {
    private HussarCacheManager hussarCacheManager;
    private ApplicationContext applicationContext = SpringContextHolder.getApplicationContext();
    private WechatBaseService wechatBaseService;
    private String appId = this.applicationContext.getEnvironment().getProperty("wechat.appId");
    private String appSecret = this.applicationContext.getEnvironment().getProperty("wechat.appSecret");

    @Autowired
    public WechatTokenManageImpl(HussarCacheManager hussarCacheManager, WechatBaseService wechatBaseService) {
        this.hussarCacheManager = hussarCacheManager;
        this.wechatBaseService = wechatBaseService;
    }

    @Override
    public void upSetWxAccessToken(String appId, String token) {
        this.hussarCacheManager.setObject("access_token_" + appId, "access_token_" + appId, (Object)token);
    }

    @Override
    public void saveAccessToken() {
        WxPassenger wxPassenger = new WxPassenger();
        wxPassenger.setAppId(this.appId);
        wxPassenger.setAppSecret(this.appSecret);
        String token = this.wechatBaseService.getAccessToken(wxPassenger);
        this.upSetWxAccessToken(this.appId, token);
    }

    @Override
    public String getWxAccessToken(WxPassenger wxPassenger) {
        String token;
        Object obj = this.hussarCacheManager.getObject("access_token_" + wxPassenger.getAppId(), "access_token_" + wxPassenger.getAppId());
        if (ObjectUtils.allNotNull((Object[])new Object[]{obj})) {
            token = (String)obj;
        } else {
            token = this.wechatBaseService.getAccessToken(wxPassenger);
            this.hussarCacheManager.setObject("access_token_" + wxPassenger.getAppId(), "access_token_" + wxPassenger.getAppId(), (Object)token);
        }
        return token;
    }
}

