/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.system.license;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.ApiException;
import com.jxdinfo.hussar.common.firewall.xss.XssChecker;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.Contact;
import com.jxdinfo.hussar.core.ContactInfomation;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import com.jxdinfo.hussar.core.util.SecurityUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/licenseFront"})
public class LicenseFrontController
extends BaseController {
    private static final String NO_LICENSE = "noLicense";
    private static final String ERROR_LICENSE = "errorLicense";
    private static final String NEED_LICENSE = "needLicense";
    private static final String NEED_WARNING = "needWarning";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String PROJECT_NAME = "projectName";
    private static final String MSG_SURPLUS = " < \u5269\u4f59\u53ef\u8bbf\u95ee\u6b21\u6570\uff1a";
    private static final String LICENSE_TYPE = "licenseType";
    private static final String DATE_FORMAT = "yyyy.MM.dd";

    @RequestMapping(value={"/view"})
    @RequiresPermissions(value={"license:view"})
    public ApiResponse<Map<String, Object>> index(@RequestBody Map<String, Object> map) {
        String type = map.get("type") == null ? "" : map.get("type").toString();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(NO_LICENSE, false);
        dataMap.put(ERROR_LICENSE, false);
        dataMap.put(NEED_LICENSE, false);
        dataMap.put(NEED_WARNING, false);
        if ("1".equals(type)) {
            String appliCode = LicenseInfo.generateRequestSN();
            dataMap.put("requestSN", appliCode);
            if (null == appliCode || "".equals(appliCode) || appliCode.length() < 20) {
                dataMap.put(ERROR_LICENSE, true);
            } else {
                dataMap.put(NO_LICENSE, true);
            }
        } else if (this.isLicenseValid()) {
            dataMap.put(START_DATE, DateUtil.format((Date)LicenseInfo.getStartDate(), (String)"yyyy-MM-dd"));
            dataMap.put(END_DATE, DateUtil.format((Date)LicenseInfo.getEndDate(), (String)"yyyy-MM-dd"));
            Integer licenseType = LicenseInfo.getLicenseType();
            dataMap.put(PROJECT_NAME, LicenseInfo.getProjectName());
            if (licenseType == 0) {
                dataMap.put(PROJECT_NAME, LicenseInfo.getProjectName() + MSG_SURPLUS + LicenseInfo.getRequestLimit() + " >");
                dataMap.put(LICENSE_TYPE, "\u5f00\u53d1\u73af\u5883\u6388\u6743");
                dataMap.put(NEED_LICENSE, true);
            } else if (licenseType == 1) {
                dataMap.put(LICENSE_TYPE, "\u90e8\u7f72\u6388\u6743");
                this.putTips(dataMap);
            } else if (licenseType == 2) {
                dataMap.put(LICENSE_TYPE, "VOL\u6279\u91cf\u6388\u6743");
            } else if (licenseType == 3) {
                dataMap.put(PROJECT_NAME, LicenseInfo.getProjectName() + MSG_SURPLUS + LicenseInfo.getRequestLimit() + " >");
                dataMap.put(LICENSE_TYPE, "\u5f00\u53d1\u8005\u6388\u6743");
                this.putTips(dataMap);
            } else if (licenseType == 5) {
                dataMap.put(LICENSE_TYPE, "\u6b63\u5f0f\u6388\u6743");
                dataMap.put(END_DATE, "\u4e0d\u9650");
            } else {
                dataMap.put(PROJECT_NAME, LicenseInfo.getProjectName() + MSG_SURPLUS + LicenseInfo.getRequestLimit() + " >");
                dataMap.put(LICENSE_TYPE, "\u8bd5\u7528\u73af\u5883\u6388\u6743");
            }
            dataMap.put("hasLicense", true);
        } else {
            String appliCode = LicenseInfo.generateRequestSN();
            dataMap.put("requestSN", appliCode);
            if (null == appliCode || "".equals(appliCode) || appliCode.length() < 20) {
                dataMap.put(ERROR_LICENSE, true);
            } else {
                dataMap.put(NO_LICENSE, true);
            }
        }
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"license:upload"})
    @RequestMapping(method={RequestMethod.POST}, path={"/upload"})
    @BussinessLog(key="/licenseFront/upload", type="03", value="\u6388\u6743\u6587\u4ef6\u4e0a\u4f20")
    @ResponseBody
    public ApiResponse<Tip> uploadLicenseFile(@RequestPart(value="file") MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (!StringUtils.isEmpty((CharSequence)XssChecker.checkXss((String)fileName))) {
            throw new ApiException(HttpCode.BAD_REQUEST.value().intValue(), "invalid request , xss code:" + fileName);
        }
        if (!"tianxin.lic".equals(fileName)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u8be5\u6388\u6743\u6587\u4ef6\u65e0\u6548\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u540d\u662f\u5426\u6b63\u786e\uff01");
        }
        try {
            file.transferTo(new File(LicenseInfo.getUploadPath() + "tianxin.lic"));
        }
        catch (IOException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.UPLOAD_ERROR);
        }
        if (this.checkLicense()) {
            this.updateLicense();
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6388\u6743\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u8be5\u6388\u6743\u6587\u4ef6\u65e0\u6548\uff01");
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/check"})
    @BussinessLog(key="/licenseFront/check", type="04", value="\u68c0\u67e5")
    @ResponseBody
    public ApiResponse<Tip> check() {
        boolean isTrial = SecurityUtil.isTrial();
        if (isTrial) {
            JSONObject json = new JSONObject();
            json.put(START_DATE, (Object)DateUtil.format((Date)LicenseInfo.getStartDate(), (String)DATE_FORMAT));
            json.put(END_DATE, (Object)DateUtil.format((Date)LicenseInfo.getEndDate(), (String)DATE_FORMAT));
            json.put("limit", (Object)LicenseInfo.getRequestLimit());
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)json.toJSONString());
        }
        JSONObject json = new JSONObject();
        json.put("message", (Object)("\u6388\u6743\u5c06\u5728" + DateUtil.format((Date)LicenseInfo.getEndDate(), (String)DATE_FORMAT) + "\u8fc7\u671f\uff0c\u8bf7\u5c3d\u5feb\u7533\u8bf7\u6388\u6743"));
        if (LicenseInfo.nearEndDateWarning()) {
            json.put("days", (Object)"7");
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)json.toJSONString());
        }
        if (LicenseInfo.needWarning()) {
            json.put("days", (Object)"30");
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)json.toJSONString());
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u64cd\u4f5c\u6210\u529f");
    }

    private boolean isLicenseValid() {
        return LicenseInfo.isLicenseValidity();
    }

    private boolean checkLicense() {
        return LicenseInfo.checkLicense();
    }

    private void updateLicense() {
        LicenseInfo.update();
    }

    private void putTips(Map<String, Object> dataMap) {
        if (LicenseInfo.nearEndDateWarning()) {
            dataMap.put(NEED_WARNING, true);
            dataMap.put(NEED_LICENSE, true);
        } else if (LicenseInfo.needWarning()) {
            dataMap.put(NEED_LICENSE, true);
        }
    }

    @RequestMapping(value={"/contact"})
    public ApiResponse<List<Contact>> list() {
        List contactList = ContactInfomation.getContactInfo();
        return ApiResponse.data((Object)contactList);
    }
}

