/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.system.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.constant.dictmap.EhcacheDict;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.front.common.response.IResultCode;
import com.jxdinfo.hussar.config.front.common.response.ResultCode;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.cache.HussarEhcacheManager;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.ehcache.search.Result;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ehcacheFront"})
@ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="true", matchIfMissing=false)
public class EhcacheFrontController
extends BaseController {
    @Resource
    private HussarCacheManager hussarCacheManager;
    @Resource
    private GlobalProperties globalProperties;

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"ehcache:list"})
    public ApiResponse<Map<String, Object>> getCacheTableList(@RequestBody Map<String, Object> body) {
        String pageNum = body.get("current") == null ? "" : body.get("current").toString().trim();
        String limitNum = body.get("size") == null ? "" : body.get("size").toString().trim();
        String cacheName = body.get("cacheName") == null ? "" : body.get("cacheName").toString().trim();
        String key = body.get("userName") == null ? "" : body.get("userName").toString().trim();
        Page page = new Page((long)Integer.valueOf(pageNum).intValue(), (long)Integer.valueOf(limitNum).intValue());
        List records = ((HussarEhcacheManager)this.hussarCacheManager).getEhCaches(cacheName, key);
        ArrayList list = new ArrayList();
        for (int i = 0; i < records.size(); ++i) {
            if (i < (Integer.valueOf(pageNum) - 1) * Integer.valueOf(limitNum) || i >= Integer.valueOf(pageNum) * Integer.valueOf(limitNum)) continue;
            Result result = (Result)records.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            String name = result.getKey().toString().split("-")[0];
            map.put("key", name);
            map.put("value", result.getValue());
            list.add(map);
        }
        page.setRecords(list);
        page.setTotal((long)records.size());
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        result.put("code", "0");
        result.put("msg", "");
        result.put("count", page.getTotal());
        result.put("data", page.getRecords());
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/deleteByKeys"})
    @RequiresPermissions(value={"ehcache:deleteByKeys"})
    @BussinessLog(key="/ehcacheFront/deleteByKeys", type="02", value="\u89e3\u51bb\u5bc6\u7801", dict=EhcacheDict.class)
    public ApiResponse<?> deleteByKeys(@RequestBody Map<String, String> map) {
        String cacheName = map.get("cacheName").trim();
        String keys = map.get("keys").trim();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("keys", keys);
        LogObjectHolder.me().set("edit_object_after", map1);
        JSONArray arr = JSON.parseArray((String)keys);
        ArrayList<String> accountList = new ArrayList<String>();
        String connName = DataSourceUtil.currentDsName();
        if (this.globalProperties.isTenantOpen()) {
            for (Object obj : arr) {
                String accountKey = obj.toString();
                if (!ToolUtil.isNotEmpty((Object)accountKey)) continue;
                String account = accountKey.replace("-", "").replace(connName, "");
                accountList.add(account);
            }
        } else {
            for (Object obj : arr) {
                String account = obj.toString();
                accountList.add(account);
            }
        }
        ((HussarEhcacheManager)this.hussarCacheManager).delcache(cacheName, (List)arr);
        ISysUsersService iSysUsersService = (ISysUsersService)SpringContextHolder.getBean(ISysUsersService.class);
        iSysUsersService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"account_status", (Object)UserStatus.OK.getCode())).in((Object)"user_account", accountList)).eq((Object)"account_status", (Object)UserStatus.PWD_LOCK.getCode()));
        return ApiResponse.success((IResultCode)ResultCode.SUCCESS);
    }

    @RequiresPermissions(value={"ehcache:getAllCacheName"})
    @RequestMapping(value={"/getAllCacheName"})
    public ApiResponse<List<JSTreeModel>> getAllCacheName() {
        Collection cacheNamesList = ((HussarEhcacheManager)this.hussarCacheManager).getCacheNames();
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setText("\u7f13\u5b58\u540d\u79f0");
        root.setParent("#");
        root.setType("root");
        result.add(root);
        for (String cacheName : cacheNamesList) {
            JSTreeModel name = new JSTreeModel();
            name.setId(cacheName);
            name.setText(cacheName);
            name.setParent("1");
            name.setType("name");
            result.add(name);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }
}

