/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.constant.HttpCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/userRoleFront"})
public class SysUsersRoleFrontController
extends BaseController {
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private ISysConfRolesService iSysConfRolesService;
    @Resource
    private ISysUserRoleService sysUserRoleService;

    @BussinessLog(key="/userRoleFront/userRoleInfo", type="04", value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u89d2\u8272\u4fe1\u606f")
    @RequiresPermissions(value={"userRole:userRoleInfo"})
    @RequestMapping(value={"/userRoleInfo"})
    public ApiResponse<ArrayList<Object>> userRoleInfo(@RequestBody Map<String, String> map) {
        String userId = map.get("userId") == null ? "" : map.get("userId").trim();
        ArrayList list = this.iSysUsersService.getUserRoleInfo(userId);
        return ApiResponse.data((Object)list);
    }

    @BussinessLog(key="/userRoleFront/saveUserRole", type="03", value="\u7528\u6237\u89d2\u8272\u5173\u8054")
    @RequiresPermissions(value={"userRole:saveUserRole"})
    @RequestMapping(value={"/saveUserRole"})
    public ApiResponse<Map<String, Object>> saveUserOrder(@RequestBody Map<String, Object> objectMap) {
        SysUsers sysUsers = new SysUsers();
        sysUsers.setUserId(objectMap.get("userId") == null ? null : objectMap.get("userId").toString());
        sysUsers.setRoleIds(objectMap.get("roleIds") == null ? null : objectMap.get("roleIds").toString());
        String roleIds = sysUsers.getRoleIds().trim();
        String[] ids = roleIds.split(",");
        LinkedList<String> list = new LinkedList<String>();
        for (String id : ids) {
            if (list.contains(id)) continue;
            list.add(id);
        }
        ids = list.toArray(new String[0]);
        if (this.iSysConfRolesService.isIncludeConfRole(ids)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u6240\u9009\u89d2\u8272\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u7684\u57fa\u6570\uff01\uff09");
        }
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("sysUsers", sysUsers);
        map.put("roleIds", ids);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)this.sysUserRoleService.updateUserRole(map).getMessage());
    }
}

