/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.bsp.baseconfig.dao.SysBaseConfigMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.bsp.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.bsp.permit.dictmap.RoleGroupDict;
import com.jxdinfo.hussar.bsp.permit.dictmap.RoleManagerDict;
import com.jxdinfo.hussar.bsp.permit.dto.RoleTreeQueryDto;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleResource;
import com.jxdinfo.hussar.bsp.permit.model.SysRoles;
import com.jxdinfo.hussar.bsp.permit.model.SysUserRole;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResTypeService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleDataScopeService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleTenantService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruRoleAuditService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.bsp.permit.vo.SysRoleResourceVo;
import com.jxdinfo.hussar.bsp.tenant.model.SysTenant;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.constant.dictmap.FunctionDict;
import com.jxdinfo.hussar.common.constant.dictmap.UserDict;
import com.jxdinfo.hussar.common.log.BussinessLogService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.userutil.UserUtil;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.Contrast;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/roleManagerFront"})
public class RoleManagerFrontController
extends BaseController {
    @Resource
    private UserUtil userUtil;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private ISysResTypeService iSysResTypeService;
    @Resource
    private ISysRolesService iSysRolesService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysRoleResourceService iSysRoleResourceService;
    @Resource
    private ISysConfRolesService isConfRolesService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysUserroleAuditService isAuditService;
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private ISysStruRoleAuditService sysStruroleAuditService;
    @Resource
    private ISysRoleDataScopeService sysRoleDataScopeService;
    @Resource
    private ISysRoleFunctionsService iSysRoleFunctionsService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private ISysRoleTenantService sysRoleTenantService;
    @Resource
    private SysBaseConfigMapper sysBaseConfigMapper;
    @Resource
    private BussinessLogService businessLog;

    @RequiresPermissions(value={"roleManager:roleTree"})
    @RequestMapping(value={"/roleTree"})
    public ApiResponse<List<JSTreeModel>> roleTree(@RequestBody Map<String, Object> map) {
        String nodeId = map.get("nodeId") == null ? null : map.get("nodeId").toString();
        String userId = map.get("userId") == null ? null : map.get("userId").toString();
        String functionType = map.get("functionType") == null ? null : map.get("functionType").toString();
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getRoleTree(nodeId, userId, functionType)));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868", notes="\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    @GetMapping(value={"/roleInfoList"})
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage> roleInfoList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page page, @ApiParam(value="\u89d2\u8272\u6811\u67e5\u8be2dto") RoleTreeQueryDto roleTreeQueryDto) throws Exception {
        roleTreeQueryDto.setGroupName(roleTreeQueryDto.getGroupName().replace("%", "\\%").replace("_", "\\_"));
        roleTreeQueryDto.setRoleName(roleTreeQueryDto.getRoleName().replace("%", "\\%").replace("_", "\\_"));
        return this.iSysRolesService.getRoleInfoList(page, roleTreeQueryDto);
    }

    @RequiresPermissions(value={"roleManager:getUserRole"})
    @RequestMapping(value={"/getUserRole"})
    public ApiResponse<List<String>> getUserRole(@RequestBody Map<String, String> map) {
        String userId = map.get("userId") == null ? "" : map.get("userId");
        return ApiResponse.data((Object)this.iSysRolesService.getUserRoleList(userId));
    }

    @RequestMapping(value={"/lazyRoleTree"})
    public ApiResponse<List<JSTreeModel>> lazyRoleTree(@RequestBody Map<String, String> map) {
        String nodeId = map.get("nodeId");
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getLazyRoleTree(nodeId, null)));
    }

    @RequestMapping(value={"/selfRoleTree"})
    public ApiResponse<List<JSTreeModel>> selfRoleTree(@RequestBody Map<String, String> map) {
        String roleId = map.get("roleIds") == null ? "" : map.get("roleIds").trim();
        String[] roleIds = roleId.split(",");
        String corporationId = map.get("corporationId") == null ? "" : map.get("corporationId").trim();
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getSelfRoleTree(roleIds)));
    }

    @RequestMapping(value={"/resourceTree"})
    public ApiResponse<List<Map<String, Object>>> resourceTree() {
        return ApiResponse.data((Object)this.iSysResTypeService.getResourceTree());
    }

    @RequestMapping(value={"/getOrganAlias"})
    @BussinessLog(key="/roleManagerFront/getOrganAlias", type="04", value="\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f", pk="nodeId", dict=RoleManagerDict.class)
    public ApiResponse<Object> getOrganAlias(@RequestBody Map<String, String> map) {
        String nodeId = map.get("nodeId");
        SysStru stru = (SysStru)this.sysOrgManageService.getById((Serializable)((Object)nodeId));
        String organAlias = stru.getOrganAlias();
        return ApiResponse.data((Object)organAlias);
    }

    @RequestMapping(value={"/addRole"})
    @RequiresPermissions(value={"roleManager:addRole"})
    @BussinessLog(key="/roleManagerFront/addRole", type="01", value="\u65b0\u589e\u89d2\u8272", pk="roleId", dict=RoleManagerDict.class)
    public ApiResponse<Object> addRole(@RequestBody Map<String, String> param) {
        ShiroUser currentUser = ShiroKit.getUser();
        String roleType = param.get("roleType");
        String roleCode = param.get("roleCode");
        String roleName = param.get("roleName");
        String roleYw = param.get("roleAlias");
        String checkNodeId = param.get("groupId");
        String seq = param.get("seq") == null ? "" : param.get("seq").trim();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("roleCode", roleCode);
        map.put("roleName", roleName);
        map.put("roleYw", roleYw);
        map.put("checkNodeId", checkNodeId);
        map.put("seq", seq);
        if (currentUser.isGradeadmin() && "organRoleAdd".equals(roleType)) {
            map.put("isOrganRoleAdd", "true");
        } else {
            map.put("isOrganRoleAdd", "false");
        }
        String roleId = this.iSysRolesService.addRole(map);
        JSONObject result = new JSONObject();
        result.put("roleId", (Object)roleId);
        return ApiResponse.data((Object)result, (String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/editRole"})
    @RequiresPermissions(value={"roleManager:editRole"})
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info"}, allEntries=true)
    @BussinessLog(key="/roleManagerFront/editRole", type="03", value="\u4fee\u6539\u89d2\u8272", pk="roleName", dict=RoleManagerDict.class)
    public ApiResponse<Tip> editRole(@RequestBody Map<String, String> param) {
        String roleId = param.get("roleId") == null ? "" : param.get("roleId").trim();
        String roleName = param.get("roleName") == null ? "" : param.get("roleName").trim();
        String roleYw = param.get("roleAlias") == null ? "" : param.get("roleAlias").trim();
        String seq = param.get("seq") == null ? "" : param.get("seq").trim();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("roleId", roleId);
        map.put("roleName", roleName);
        map.put("roleYw", roleYw);
        map.put("seq", seq);
        QueryWrapper entityWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"role_id", (Object)roleId);
        List roleList = this.iSysRolesService.list((Wrapper)entityWrapper);
        LogObjectHolder.me().set(roleList.get(0));
        boolean flag = this.iSysRolesService.editRole(map);
        if (flag) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/roleView"})
    public ApiResponse<Map<String, Object>> roleView(@RequestBody Map<String, String> body) {
        String id = body.get("id") == null ? "" : body.get("id").trim();
        Map map = this.iSysRolesService.getRoleViewMap(id);
        return ApiResponse.data((Object)map);
    }

    @RequestMapping(value={"/roleResourceView"})
    @BussinessLog(key="/roleManagerFront/roleResourceView", type="04", value="\u67e5\u770b\u89d2\u8272\u8d44\u6e90\u4fe1\u606f", pk="id")
    public ApiResponse<List<SysRoleResource>> getRoleResourceView(@RequestBody Map<String, String> map) {
        String roleId = map.get("id") == null ? "" : map.get("id").trim();
        List resourceList = this.iSysRolesService.getRoleResource(roleId);
        return ApiResponse.data((Object)resourceList);
    }

    @RequestMapping(value={"/delRole"})
    @RequiresPermissions(value={"roleManager:delRole"})
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info"}, allEntries=true)
    @BussinessLog(key="/roleManagerFront/delRole", type="02", value="\u5220\u9664\u89d2\u8272", dict=RoleManagerDict.class)
    public ApiResponse<Tip> delRole(@RequestBody Map<String, String> map) {
        String id = map.get("id") == null ? "" : map.get("id").trim();
        List list = this.isConfRolesService.list((Wrapper)new QueryWrapper().eq((Object)"role_id", (Object)id));
        SysRoles sysRoles = (SysRoles)this.iSysRolesService.getById((Serializable)((Object)id));
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("roleName", sysRoles.getRoleName());
        LogObjectHolder.me().set("edit_object_after", map1);
        if (list.size() > 0) {
            return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u65e0\u6cd5\u5220\u9664\uff01\uff08\u89d2\u8272\u5df2\u5173\u8054\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\uff01\uff09");
        }
        int num = this.isAuditService.isDelete(id);
        if (num > 0) {
            return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u65e0\u6cd5\u5220\u9664\uff01\uff08\u89d2\u8272\u5df2\u5173\u8054\u7528\u6237\uff01\uff09");
        }
        int num1 = this.sysStruroleAuditService.isDelete(id);
        if (num1 > 0) {
            return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u65e0\u6cd5\u5220\u9664\uff01\uff08\u89d2\u8272\u5df2\u5173\u8054\u7ec4\u7ec7\uff01\uff09");
        }
        boolean flag = this.iSysRolesService.delRole(id);
        if (flag) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"roleManager:saveResource"})
    @RequestMapping(value={"/saveResource"})
    @BussinessLog(key="/roleManagerFront/saveResource", type="03", value="\u4fdd\u5b58\u8d44\u6e90")
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info", "menu_info"}, allEntries=true)
    public ApiResponse<Tip> saveResource(@RequestBody Map<String, String> map) {
        String ids = map.get("resourceIds");
        String roId = map.get("roleId");
        this.iSysRoleResourceService.saveResource(ids, roId);
        List userIds = this.iSysRolesService.delCacheAuthInfo(roId);
        for (String userId : userIds) {
            this.iSysRolesService.delRedisAuthInfo(userId);
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u89d2\u8272\u5173\u8054\u8d44\u6e90\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveFunction"})
    @BussinessLog(key="/roleManagerFront/saveFunction", type="03", value="\u4fee\u6539\u89d2\u8272\u5173\u8054\u7684\u529f\u80fd", dict=FunctionDict.class, pk="roleName")
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info", "menu_info", "resource_info"}, allEntries=true)
    public ApiResponse<Tip> saveFunction(@RequestBody Map<String, String> map) {
        String functionsIds = map.get("functionsIds");
        String roleId = map.get("roleId");
        SysRoles sysRoles = (SysRoles)this.iSysRolesService.getById((Serializable)((Object)roleId));
        QueryWrapper sysRoleFunctionsQueryWrapper = new QueryWrapper();
        sysRoleFunctionsQueryWrapper.eq((Object)"ROLE_ID", (Object)roleId);
        List sysRoleFunctionsList = this.iSysRoleFunctionsService.list((Wrapper)sysRoleFunctionsQueryWrapper);
        ArrayList<String> functionsIdList = new ArrayList<String>();
        for (SysRoleFunctions sysRoleFunctions : sysRoleFunctionsList) {
            functionsIdList.add(sysRoleFunctions.getFunctionId());
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("functionsIds", StringUtils.join((Object[])functionsIdList.toArray(), (String)","));
        map1.put("roleName", sysRoles.getRoleName());
        LogObjectHolder.me().set(map1);
        this.iSysRoleFunctionsService.saveFunctions(functionsIds, roleId);
        List userIds = this.iSysRolesService.delCacheAuthInfo(roleId);
        for (String userId : userIds) {
            this.iSysRolesService.delRedisAuthInfo(userId);
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u89d2\u8272\u5173\u8054\u529f\u80fd\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/getRelaFunction"})
    @ResponseBody
    public ApiResponse<List<SysRoleFunctions>> getChooseAuthority(@RequestBody Map<String, Object> map) {
        String roleId = map.get("roleId") == null ? null : map.get("roleId").toString();
        return ApiResponse.data((Object)this.iSysRoleFunctionsService.getRoleFunctions(roleId));
    }

    @RequestMapping(value={"/selfFunctionTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> selfResourceTree(@RequestBody Map<String, String> map) {
        String[] functionIds = map.get("functionIds") == null ? "".split(",") : map.get("functionIds").trim().split(",");
        List result = this.iSysRoleFunctionsService.selfFunctionTree(functionIds);
        List<JSTreeModel> tree = this.doRecursive(result);
        return ApiResponse.data(ForestNodeMerger.merge(tree));
    }

    public List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursive(list, result, "");
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!"#".equals(map.getParent())) continue;
                result.add(map);
            }
        }
        JSTreeModel model = new JSTreeModel();
        model.setParent("#");
        model.setCode("GROUP");
        model.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        model.setId("1");
        model.setType("isRoot");
        model.setState(true, true, true);
        result.add(model);
        return result;
    }

    public void recursive(List<JSTreeModel> list, List<JSTreeModel> result, String parentId) {
        String newParentId = parentId;
        for (int i = 0; i < list.size(); ++i) {
            JSTreeModel map = list.get(i);
            if (!"1".equals(map.getIsRes()) && !newParentId.equals(map.getId())) continue;
            newParentId = map.getParent();
            result.add(map);
            list.remove(map);
            if (--i == 0) {
                i = -1;
            }
            this.recursive(list, result, newParentId);
        }
    }

    @RequestMapping(value={"/reclaimPerm"})
    @RequiresPermissions(value={"roleManager:reclaimPerm"})
    @BussinessLog(key="/roleManagerFront/reclaimPerm", type="02", value="\u89d2\u8272\u56de\u6536\u6743\u9650")
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    public ApiResponse<Tip> reclaimPerm(@RequestBody Map<String, String> map) {
        String id = map.get("id") == null ? "" : map.get("id").trim();
        this.iSysRoleResourceService.reclaimPerm(id);
        List userIds = this.iSysRolesService.delCacheAuthInfo(id);
        for (String userId : userIds) {
            this.iSysRolesService.delRedisAuthInfo(userId);
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u56de\u6536\u6743\u9650\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryPerm"})
    public ApiResponse<List<SysRoleResource>> queryPerm(@RequestBody Map<String, String> map) {
        String id = map.get("id") == null ? "" : map.get("id").trim();
        return ApiResponse.data((Object)this.iSysRoleResourceService.queryPerm(id));
    }

    @RequestMapping(value={"/saveGroup"})
    @RequiresPermissions(value={"roleManager:saveGroup"})
    @BussinessLog(key="/roleManagerFront/saveGroup", type="01", value="\u65b0\u589e\u89d2\u8272\u5206\u7ec4", pk="groupId", dict=RoleGroupDict.class)
    public ApiResponse<Tip> saveGroup(@RequestBody Map<String, String> map) {
        String groupName = map.get("groupName");
        String groupAlias = map.get("groupAlias");
        String checkId = map.get("checkId");
        boolean result = this.iSysRolesService.saveGroup(groupName, checkId, groupAlias);
        if (result) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/editGroup"})
    @RequiresPermissions(value={"roleManager:editGroup"})
    @BussinessLog(key="/roleManagerFront/editGroup", type="03", value="\u4fee\u6539\u89d2\u8272\u5206\u7ec4", pk="groupId", dict=RoleGroupDict.class)
    public ApiResponse<Tip> editGroup(@RequestBody Map<String, String> param) {
        String groupName = param.get("groupName");
        String groupAlias = param.get("groupAlias");
        String checkId = param.get("checkId");
        SysRoleGroup group = (SysRoleGroup)this.sysRoleGroupMapper.selectById((Serializable)((Object)checkId));
        LogObjectHolder.me().set((Object)group);
        boolean result = this.iSysRolesService.editGroup(groupName, checkId, groupAlias);
        if (result) {
            return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"roleManager:sameRoleName"})
    @RequestMapping(value={"/sameRoleName"})
    public ApiResponse<Object> sameRoleName(@RequestBody Map<String, Object> map) {
        String result = "0";
        JSONObject Obj = (JSONObject)map.get("sameRoleName");
        String code = String.valueOf(Obj.get((Object)"roleCode"));
        String name = String.valueOf(Obj.get((Object)"roleName"));
        if (this.iSysRolesService.count((Wrapper)new QueryWrapper().eq((Object)"ROLE_CODE", (Object)code)) > 0) {
            result = "1";
        } else if (this.iSysRolesService.count((Wrapper)new QueryWrapper().eq((Object)"ROLE_NAME", (Object)name)) > 0) {
            result = "2";
        }
        return ApiResponse.data((Object)result);
    }

    @RequiresPermissions(value={"roleManager:sameRoleName"})
    @RequestMapping(value={"/sameRoleNameEdit"})
    public ApiResponse<List<SysRoles>> sameRoleNameEdit(@RequestBody Map<String, String> map) {
        String name = map.get("sameRoleName");
        return ApiResponse.data((Object)this.iSysRolesService.list((Wrapper)new QueryWrapper().eq((Object)"ROLE_NAME", (Object)name)));
    }

    @RequiresPermissions(value={"roleManager:sameGroupName"})
    @RequestMapping(value={"/sameGroupName"})
    public ApiResponse<List<SysRoleGroup>> sameGroupName(@RequestBody Map<String, String> map) {
        String name = map.get("sameGroupName");
        List list = this.sysRoleGroupMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"GROUP_NAME", (Object)name));
        return ApiResponse.data((Object)list);
    }

    @RequiresPermissions(value={"roleManager:searchRoleToGroup"})
    @RequestMapping(value={"/searchRoleToGroup"})
    @BussinessLog(key="/roleManagerFront/searchRoleToGroup", type="04", value="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272")
    @ResponseBody
    public ApiResponse<List<SysRoles>> searchRoleToGroup(@RequestBody Map<String, String> map) {
        String id = map.get("id");
        return ApiResponse.data((Object)this.iSysRolesService.list((Wrapper)new QueryWrapper().eq((Object)"GROUP_ID", (Object)id)));
    }

    @RequestMapping(value={"/delGroup"})
    @RequiresPermissions(value={"roleManager:delGroup"})
    @BussinessLog(key="/roleManagerFront/delGroup", type="02", value="\u5220\u9664\u89d2\u8272\u5206\u7ec4", dict=RoleGroupDict.class)
    public ApiResponse<Tip> delGroup(@RequestBody Map<String, String> map) {
        String id = map.get("id");
        SysRoleGroup sysRoleGroup = (SysRoleGroup)this.sysRoleGroupMapper.selectById((Serializable)((Object)id));
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("groupName", sysRoleGroup.getGroupName());
        LogObjectHolder.me().set("edit_object_after", map1);
        Integer count = this.sysRoleGroupMapper.deleteById((Serializable)((Object)id));
        if (count == 1) {
            this.bpmAbstractPushMsgMatcher.delete("role", id, null);
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/roleGroupViewPage"})
    @RequiresPermissions(value={"roleManager:roleGroupViewPage"})
    public ApiResponse<SysRoleGroup> roleGroupViewPage(@RequestBody Map<String, String> map) {
        String nodeId = map.get("id");
        SysRoleGroup group = (SysRoleGroup)this.sysRoleGroupMapper.selectById((Serializable)((Object)nodeId));
        return ApiResponse.data((Object)group);
    }

    @RequiresPermissions(value={"roleManager:roleUserTreeView"})
    @RequestMapping(value={"/roleUserTreeView"})
    public ApiResponse<List<JSTreeModel>> getRoleUserTreeView(@RequestBody Map<String, String> map) {
        String roleId = map.get("roleId");
        List result = this.userUtil.getUserByRole(roleId, false);
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u5173\u8054\u7528\u6237");
        root.setParent("#");
        root.setType("isRoot");
        result.add(root);
        for (JSTreeModel model : result) {
            if ("USER".equals(model.getType())) {
                model.setState(true, false, true);
                continue;
            }
            model.setState(false, false, true);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequiresPermissions(value={"roleManager:lazyRoleUserTreeView"})
    @RequestMapping(value={"/lazyRoleUserTreeView"})
    public ApiResponse<List<JSTreeModel>> getLazyRoleUserTreeView(@RequestBody Map<String, String> map) {
        String roleId = map.get("roleId");
        String nodeId = map.get("nodeId");
        return ApiResponse.data(ForestNodeMerger.merge(this.userUtil.getLazyUserByRole(roleId, nodeId)));
    }

    @RequiresPermissions(value={"roleManager:getRoleOrgUser"})
    @RequestMapping(value={"/getRoleOrgUser"})
    public ApiResponse<JSONObject> getRoleOrgUsers(@RequestBody Map<String, Object> map) {
        String roleId = map.get("roleId") == null ? null : map.get("roleId").toString();
        String orgId = map.get("orgId") == null ? null : map.get("orgId").toString();
        int pageNo = map.get("pageNo") == null ? 1 : Integer.parseInt(map.get("pageNo").toString());
        int limit = map.get("limit") == null ? 20 : Integer.parseInt(map.get("limit").toString());
        String name = map.get("name") == null ? null : map.get("name").toString();
        String account = map.get("account") == null ? null : map.get("account").toString();
        String isAssociated = map.get("isAssociated") == null ? null : map.get("isAssociated").toString();
        String isSubordinate = map.get("isSubordinate") == null ? null : map.get("isSubordinate").toString();
        String isMasterRoleMaintain = map.get("isMasterRoleMaintain") == null ? null : map.get("isMasterRoleMaintain").toString();
        Page page = new Page((long)pageNo, (long)limit);
        List list = ToolUtil.isEmpty((Object)roleId) ? new ArrayList() : this.sysOrgManageService.getRoleOrgUser(isAssociated, page, roleId, orgId, name, account, isSubordinate, isMasterRoleMaintain);
        JSONObject json = new JSONObject();
        json.put("data", list);
        json.put("code", (Object)"0");
        json.put("msg", (Object)"");
        json.put("count", (Object)page.getTotal());
        return ApiResponse.data((Object)json);
    }

    @RequiresPermissions(value={"roleManager:addOrDelUserRole"})
    @RequestMapping(value={"/addOrDelUserRole"})
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info", "menu_info"}, allEntries=true)
    public ApiResponse<Tip> getRoleOrgUser(@RequestBody Map<String, Object> map) {
        String adds = map.get("adds") == null ? null : map.get("adds").toString();
        String dels = map.get("dels") == null ? null : map.get("dels").toString();
        String roleId = map.get("roleId") == null ? null : map.get("roleId").toString();
        List addList = JSONObject.parseArray((String)adds, RoleOrgUserVo.class);
        List delList = JSONObject.parseArray((String)dels, RoleOrgUserVo.class);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("roleAudit", this.globalProperties.isRoleAudit());
        params.put("criticalAudit", this.globalProperties.isCriticalOperationsAudit());
        QueryWrapper sysUserRoleQueryWrapper = new QueryWrapper();
        sysUserRoleQueryWrapper.eq((Object)"GRANTED_ROLE", (Object)roleId);
        List sysUserRoles = this.iSysUserRoleService.list((Wrapper)sysUserRoleQueryWrapper);
        ArrayList<String> userIds = new ArrayList<String>();
        for (SysUserRole sysUserRole : sysUserRoles) {
            userIds.add(sysUserRole.getUserId());
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("userIds", StringUtils.join((Object[])userIds.toArray(), (String)","));
        Tip result = this.iSysUserRoleService.addOrDelUserRole(addList, delList, roleId, params);
        QueryWrapper sysUserRoleQueryWrapper1 = new QueryWrapper();
        sysUserRoleQueryWrapper1.eq((Object)"GRANTED_ROLE", (Object)roleId);
        List sysUserRoles1 = this.iSysUserRoleService.list((Wrapper)sysUserRoleQueryWrapper1);
        ArrayList<String> userIds1 = new ArrayList<String>();
        for (SysUserRole sysUserRole : sysUserRoles1) {
            userIds1.add(sysUserRole.getUserId());
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("userIds", StringUtils.join((Object[])userIds1.toArray(), (String)","));
        Contrast contrast = new Contrast();
        JSONArray modifyOptDiffLog = contrast.compareModifyModel(map1, map2, "", UserDict.class);
        SysRoles sysRoles = (SysRoles)this.iSysRolesService.getById((Serializable)((Object)roleId));
        JSONObject logContent = new JSONObject(true);
        logContent.put("operate_staff", (Object)ShiroKit.getUser().getName());
        logContent.put("operate_time", (Object)DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        logContent.put("operate_type", (Object)"03");
        logContent.put("operate_action", (Object)"\u89d2\u8272\u5173\u8054\u7528\u6237");
        logContent.put("operate_subject", (Object)sysRoles.getRoleName());
        if (modifyOptDiffLog != null && modifyOptDiffLog.size() > 0) {
            logContent.put("operate_details", (Object)modifyOptDiffLog);
        }
        this.businessLog.saveBusinessLog("03", "/roleManagerFront/addOrDelUserRole", logContent.toJSONString(), "\u4fee\u6539\u89d2\u8272\u5173\u8054\u7528\u6237");
        return ApiResponse.success((int)result.getCode(), (String)result.getMessage());
    }

    @RequiresPermissions(value={"roleManager:roleUserTreeEdit"})
    @RequestMapping(value={"/roleUserTreeEdit"})
    @BussinessLog(key="/roleManagerFront/roleUserTreeEdit", type="04", value="\u89d2\u8272\u5173\u8054\u7528\u6237\u4fee\u6539\u6811")
    public ApiResponse<List<JSTreeModel>> getRoleUserTreeEdit(@RequestBody Map<String, String> map) {
        String roleId = map.get("roleId");
        boolean isSysRole = false;
        String sysRoleGroup = "sys_role_group";
        SysRoles role = (SysRoles)this.iSysRolesService.getById((Serializable)((Object)roleId));
        if (sysRoleGroup.equals(role.getGroupId())) {
            isSysRole = true;
        }
        List result = this.sysOrgManageService.getUserTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId("11");
        jsTreeModel.setCode("11");
        jsTreeModel.setText("\u5173\u8054\u7528\u6237");
        jsTreeModel.setParent("#");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        List userRoles = this.iSysUserRoleService.selectUserIdByRoleId(roleId);
        for (JSTreeModel model : result) {
            model.setState(false, false, false);
            if (userRoles.contains(model.getId())) {
                model.setState(true, true, false);
            }
            if (!isSysRole && (!"USER".equals(model.getType()) || !"11".equals(model.getParent()))) continue;
            model.setState(((Boolean)model.getState().get("selected")).booleanValue(), ((Boolean)model.getState().get("checked")).booleanValue(), true);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequiresPermissions(value={"roleManager:roleUserTreeAdd"})
    @RequestMapping(value={"/roleUserTreeAdd"})
    @BussinessLog(key="/roleManagerFront/roleUserTreeAdd", type="04", value="\u89d2\u8272\u5173\u8054\u7528\u6237\u65b0\u589e\u6811")
    public ApiResponse<List<JSTreeModel>> getRoleUserTreeAdd() {
        List result = this.sysOrgManageService.getUserTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId("11");
        jsTreeModel.setCode("11");
        jsTreeModel.setText("\u5173\u8054\u7528\u6237");
        jsTreeModel.setParent("#");
        jsTreeModel.setType("isRoot");
        result.add(jsTreeModel);
        for (JSTreeModel model : result) {
            model.setState(false, false, false);
            if (!"USER".equals(model.getType()) || !"11".equals(model.getParent())) continue;
            model.setState(((Boolean)model.getState().get("selected")).booleanValue(), ((Boolean)model.getState().get("checked")).booleanValue(), true);
        }
        return ApiResponse.data((Object)result);
    }

    @RequiresPermissions(value={"roleManager:saveRoleUserAdd"})
    @RequestMapping(value={"/saveRoleUserAdd"})
    @BussinessLog(key="/roleManagerFront/saveRoleUserAdd", type="01", pk="roleId,userIds", value="\u89d2\u8272\u65b0\u589e\u5173\u8054\u7528\u6237\u4fdd\u5b58")
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info", "menu_info"}, allEntries=true)
    public ApiResponse<Tip> saveRoleUsersAdd(@RequestBody Map<String, String> map) {
        String roleId = map.get("roleId");
        String userIds = map.get("userIds");
        List<Object> ids = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ids = Arrays.asList(userIds.split(","));
        }
        this.iSysRoleResourceService.saveRoleUserAdd(ids, roleId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u89d2\u8272\u5173\u8054\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"roleManager:saveRoleUserEdit"})
    @RequestMapping(value={"/saveRoleUserEdit"})
    @BussinessLog(key="/roleManagerFront/saveRoleUserEdit", type="03", pk="roleId,userIds", value="\u89d2\u8272\u4fee\u6539\u5173\u8054\u7528\u6237\u4fdd\u5b58")
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info", "menu_info"}, allEntries=true)
    public ApiResponse<Tip> saveRoleUsersEdit(@RequestBody Map<String, String> map) {
        List confRolesList;
        String roleId = map.get("roleId");
        String userIds = map.get("userIds");
        List<Object> ids = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ids = Arrays.asList(userIds.split(","));
        }
        if (ToolUtil.isNotEmpty((Object)(confRolesList = this.isConfRolesService.list((Wrapper)new QueryWrapper().eq((Object)"ROLE_ID", (Object)roleId))))) {
            for (String string : ids) {
                List rolesList = this.iSysUserRoleService.getRolesByUserId(string);
                if (!rolesList.contains(roleId)) {
                    rolesList.add(roleId);
                }
                if (!this.isConfRolesService.isIncludeConfRole(rolesList.toArray(new String[rolesList.size()]))) continue;
                SysUsers user = (SysUsers)this.sysUsersService.getById((Serializable)((Object)string));
                return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)("\u4fee\u6539\u5931\u8d25\uff01\uff08" + user.getUserName() + " \u8fdd\u53cd\u4e86\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u89c4\u5219\uff09"));
            }
        }
        this.iSysRoleResourceService.saveRoleUserEdit(ids, roleId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u89d2\u8272\u5173\u8054\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"roleManager:groupOrderTree"})
    @RequestMapping(value={"/groupOrderTree"})
    public ApiResponse<List<JSTreeModel>> groupOrderTree() {
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getGroupOrderTree()));
    }

    @RequestMapping(value={"/saveGroupOrder"})
    @RequiresPermissions(value={"roleManager:saveGroupOrder"})
    @BussinessLog(key="/roleManagerFront/saveGroupOrder", type="03", value="\u89d2\u8272\u5206\u7ec4\u6392\u5e8f")
    public ApiResponse<Tip> saveGroupOrder(@RequestBody Map<String, Object> map) {
        String info = map.get("info") == null ? "" : map.get("info").toString();
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.iSysRolesService.saveGroupOrder(treeArr);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"roleManager:roleOrderTree"})
    @RequestMapping(value={"/roleOrderTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> roleOrderTree(@RequestBody Map<String, String> map) {
        String parent = map.get("parentId");
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getRoleOrderTree(parent)));
    }

    @RequestMapping(value={"/saveRoleOrder"})
    @RequiresPermissions(value={"roleManager:saveRoleOrder"})
    @BussinessLog(key="/roleManagerFront/saveRoleOrder", type="03", value="\u89d2\u8272\u6392\u5e8f")
    public ApiResponse<Tip> saveRoleOrder(@RequestBody Map<String, Object> map) {
        String info = map.get("info") == null ? "" : map.get("info").toString();
        JSONArray treeArr = JSONArray.parseArray((String)info);
        this.iSysRolesService.saveRoleOrder(treeArr);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"roleManager:exportData"})
    @BussinessLog(key="/roleManagerFront/exportData", type="16", value="\u89d2\u8272\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids") == null ? "" : super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.iSysRolesService.exportData(idList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @RequiresPermissions(value={"roleManager:importData"})
    @BussinessLog(key="/roleManagerFront/importData", type="18", value="\u89d2\u8272\u6570\u636e\u5bfc\u5165")
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    public ApiResponse<Map<String, String>> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        Map message = this.iSysRolesService.importVueData(content);
        return ApiResponse.data((Object)message);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/checkResource"})
    @RequiresPermissions(value={"roleManager:checkResource"})
    public ApiResponse<List<SysRoleResourceVo>> checkResource(@RequestBody Map<String, String> map) {
        String roleId = map.get("roleId");
        String resourceIds = map.get("resourceIds");
        return ApiResponse.data((Object)this.iSysRoleResourceService.checkResource(roleId, resourceIds));
    }

    @RequestMapping(value={"/dataScope"})
    @RequiresPermissions(value={"roleManager:dataScope"})
    @BussinessLog(key="/roleManagerFront/dataScope", type="04", value="\u67e5\u8be2\u89d2\u8272\u6570\u636e\u6743\u9650")
    @ResponseBody
    public ApiResponse<Map<String, Object>> getUserDataScope(@RequestParam String roleId) {
        SysRoles sysRoles = (SysRoles)this.iSysRolesService.getById((Serializable)((Object)roleId));
        HashMap<String, Object> map = new HashMap<String, Object>();
        String dataScopeType = ToolUtil.isNotEmpty((Object)sysRoles.getDataScopeType()) ? sysRoles.getDataScopeType() : "";
        map.put("dataScopeType", dataScopeType);
        List orgIds = this.sysRoleDataScopeService.getOrgListByRoleId(roleId);
        map.put("orgIds", orgIds);
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/saveDataScope"})
    @RequiresPermissions(value={"roleManager:saveDataScope"})
    @BussinessLog(key="/roleManagerFront/saveDataScope", type="01", value="\u4fdd\u5b58\u89d2\u8272\u6570\u636e\u6743\u9650")
    @ResponseBody
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    public ApiResponse<Boolean> saveDataScope(@RequestBody Map<String, String> map) {
        return this.sysRoleDataScopeService.saveDateScope(map);
    }

    @RequestMapping(value={"/saveRoleTenant"})
    @ResponseBody
    public ApiResponse<Tip> saveRoleTenant(@RequestBody Map<String, String> map) {
        String tenantIds = map.get("tenantIds");
        String roleId = map.get("roleId");
        this.sysRoleTenantService.saveRoleTenant(tenantIds, roleId);
        SysTenant sysTenant = new SysTenant();
        String[] ids = tenantIds.split(",");
        QueryWrapper entityWrapper = (QueryWrapper)new QueryWrapper().in((Object)"TENANT_ID", Arrays.asList(ids));
        List tenantList = sysTenant.selectList((Wrapper)entityWrapper);
        StringBuffer content = new StringBuffer();
        String operate_time = DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        content.append("\"" + ShiroKit.getUser().getName() + "\"");
        content.append(" \u5728 " + operate_time);
        content.append(" \u8fdb\u884c\u4e86 \" \u89d2\u8272\u4e0b\u653e \" \u64cd\u4f5c\u3002\n");
        if (tenantList != null && tenantList.size() > 0) {
            List tenantNames = tenantList.stream().map(SysTenant::getTenantName).collect(Collectors.toList());
            content.append(" \u4e0b\u653e\u7684\u79df\u6237\u4e3a: ").append(String.join((CharSequence)",", tenantNames));
        }
        this.businessLog.saveBusinessLog("03", "/roleManagerFront/saveDataScope", content.toString(), "\u89d2\u8272\u4e0b\u653e");
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u89d2\u8272\u4e0b\u653e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/roleTenantView"})
    @ResponseBody
    public ApiResponse<Map<String, Object>> roleTenantView(@RequestParam String id) {
        HashMap<String, List> map = new HashMap<String, List>();
        List tenantIds = this.sysRoleTenantService.getTenantByRoleId(id);
        map.put("tenantIds", tenantIds);
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/lazyGradeRoleTree"})
    @BussinessLog(key="/roleManagerFront/lazyGradeRoleTree", type="04", value="\u9662\u7ea7\u89d2\u8272\u6811\u61d2\u52a0\u8f7d")
    public ApiResponse<List<JSTreeModel>> lazyGradeRoleTree(@RequestBody Map<String, String> map) {
        String nodeId = map.get("nodeId");
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getLazyGradeRoleTree(nodeId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/gradeRoleView"})
    @BussinessLog(key="/roleManagerFront/gradeRoleView", type="04", value="\u67e5\u770b\u9662\u7ea7\u89d2\u8272\u4fe1\u606f")
    public ApiResponse<Map<String, Object>> gradeRoleView(@RequestBody Map<String, String> body) {
        String id = body.get("id") == null ? "" : body.get("id").trim();
        Map map = new HashMap();
        try {
            DataSourceUtil.changeTempDs((String)"master");
            map = this.iSysRolesService.getRoleViewMap(id);
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.data(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/getGradeRelaFunction"})
    @BussinessLog(key="/roleManagerFront/getGradeRelaFunction", type="04", value="\u83b7\u53d6\u9662\u7ea7\u89d2\u8272\u5df2\u5173\u8054\u7684\u529f\u80fd")
    @ResponseBody
    public ApiResponse<List<SysRoleFunctions>> getGradeRelaFunction(@RequestBody Map<String, Object> map) {
        String roleId = map.get("roleId") == null ? null : map.get("roleId").toString();
        List roleFunctionsList = new ArrayList();
        try {
            DataSourceUtil.changeTempDs((String)"master");
            roleFunctionsList = this.iSysRoleFunctionsService.getRoleFunctions(roleId);
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.data(roleFunctionsList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/gradeRoleUserTreeView"})
    @BussinessLog(key="/roleManagerFront/gradeRoleUserTreeView", type="04", value="\u9662\u7ea7\u89d2\u8272\u5173\u8054\u7528\u6237\u67e5\u770b\u6811")
    public ApiResponse<List<JSTreeModel>> gradeRoleUserTreeView(@RequestBody Map<String, String> map) {
        String roleId = map.get("roleId");
        List<JSTreeModel> result = new ArrayList();
        try {
            DataSourceUtil.changeTempDs((String)"master");
            result = this.userUtil.getUserByRole(roleId);
        }
        finally {
            DataSourceUtil.poll();
        }
        JSTreeModel root = new JSTreeModel();
        root.setId("11");
        root.setCode("11");
        root.setText("\u5173\u8054\u7528\u6237");
        root.setParent("#");
        root.setType("isRoot");
        result.add(root);
        for (JSTreeModel model : result) {
            if ("USER".equals(model.getType())) {
                model.setState(true, false, true);
                continue;
            }
            model.setState(false, false, true);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/selfGradeFunctionTree"})
    @BussinessLog(key="/roleManagerFront/selfGradeFunctionTree", type="04", value="\u53ea\u52a0\u8f7d\u5f53\u524d\u9662\u7ea7\u89d2\u8272\u7684\u529f\u80fd\u6811")
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> selfGradeFunctionTree(@RequestBody Map<String, String> map) {
        String[] functionIds = map.get("functionIds") == null ? "".split(",") : map.get("functionIds").trim().split(",");
        ArrayList<JSTreeModel> result = new ArrayList();
        try {
            DataSourceUtil.changeTempDs((String)"master");
            result = this.iSysRoleFunctionsService.selfFunctionTree(functionIds);
        }
        finally {
            DataSourceUtil.poll();
        }
        List<JSTreeModel> tree = this.doRecursive(result);
        return ApiResponse.data(ForestNodeMerger.merge(tree));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/gradeRoleResourceView"})
    @BussinessLog(key="/roleManagerFront/gradeRoleResourceView", type="04", value="\u67e5\u770b\u9662\u7ea7\u89d2\u8272\u8d44\u6e90\u4fe1\u606f", pk="id")
    public ApiResponse<List<SysRoleResource>> gradeRoleResourceView(@RequestBody Map<String, String> map) {
        String roleId = map.get("id") == null ? "" : map.get("id").trim();
        List resourceList = new ArrayList();
        try {
            DataSourceUtil.changeTempDs((String)"master");
            resourceList = this.iSysRolesService.getRoleResource(roleId);
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.data(resourceList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/addOrDelGradeUserRole"})
    @BussinessLog(key="/roleManagerFront/addOrDelGradeUserRole", type="03", value="\u6dfb\u52a0\u5220\u9664\u9662\u7ea7\u7528\u6237\u89d2\u8272")
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info", "menu_info"}, allEntries=true)
    public ApiResponse<Tip> addOrDelGradeUserRole(@RequestBody Map<String, Object> map) {
        String adds = map.get("adds") == null ? null : map.get("adds").toString();
        String dels = map.get("dels") == null ? null : map.get("dels").toString();
        String roleId = map.get("roleId") == null ? null : map.get("roleId").toString();
        List addList = JSONObject.parseArray((String)adds, RoleOrgUserVo.class);
        List delList = JSONObject.parseArray((String)dels, RoleOrgUserVo.class);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("roleAudit", this.globalProperties.isRoleAudit());
        params.put("criticalAudit", this.globalProperties.isCriticalOperationsAudit());
        SuccessTip result = new SuccessTip();
        try {
            DataSourceUtil.changeTempDs((String)"master");
            result = this.iSysUserRoleService.addOrDelUserRole(addList, delList, roleId, params);
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.success((int)result.getCode(), (String)result.getMessage());
    }

    @RequestMapping(value={"/syncDeleteRoleCache"})
    @BussinessLog(key="/roleManagerFront/syncDeleteRoleCache", type="02", value="\u89d2\u8272\u5220\u9664\u7f13\u5b58")
    public ApiResponse<Object> syncDeleteRoleCache() {
        String userId = ShiroKit.getUser().getId();
        try {
            List arrayList = this.sysBaseConfigMapper.getAllClusterAddress();
            if (arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String url = (String)arrayList.get(i) + "/menu/deleteRoleCache";
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("userId", userId);
                    String string = HttpKit.sendPost((String)url, param);
                }
            }
            return ApiResponse.data((Object)SUCCESS_TIP);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/queryRoleTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> queryRoleTree(@RequestParam(value="roleName", required=false) String roleName) {
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysRolesService.getSpecialRoleTree(roleName)));
    }
}

