/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.log;

import com.jxdinfo.hussar.core.log.HussarLogManager;
import com.jxdinfo.hussar.core.log.factory.LogTaskFactory;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/frontLog"})
public class LogController {
    @RequestMapping(method={RequestMethod.POST}, path={"/recordLog"})
    public void recordLog(@RequestBody Map<String, String> map) throws Exception {
        String type = map.get("type");
        String action = map.get("action");
        String title = map.get("title");
        String secretFile = map.get("secretFile");
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("sessionId", (String)((Object)ShiroKit.getSession().getId()));
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        String taskId = map.get("taskId");
        if (HussarUtils.isNotEmpty((Object)taskId)) {
            HistoryService historyService = (HistoryService)SpringContextHolder.getBean(HistoryService.class);
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().taskId(taskId)).includeTaskLocalVariables()).singleResult();
            String todoConfiguration = (String)historicTaskInstance.getTaskLocalVariables().get("todoConfiguration");
            String processInstanceId = historicTaskInstance.getProcessInstanceId();
            String processDefinitionName = ((HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).getProcessDefinitionName();
            title = processDefinitionName + "--" + todoConfiguration;
            info.put("taskId", taskId);
        }
        info.put("title", title);
        info.put("action", action);
        info.put("fileName", secretFile);
        HussarLogManager.me().executeLog(LogTaskFactory.fileLog((ShiroUser)ShiroKit.getUser(), (String)type, info));
    }
}

