/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.group.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.base.mobile.application.model.SysMobileApplication;
import com.jxdinfo.hussar.base.mobile.application.service.ISysMobileApplicationService;
import com.jxdinfo.hussar.base.mobile.group.dao.SysMobileApplicationGroupMapper;
import com.jxdinfo.hussar.base.mobile.group.model.SysMobileApplicationGroup;
import com.jxdinfo.hussar.base.mobile.group.service.ISysMobileApplicationGroupService;
import com.jxdinfo.hussar.base.mobile.group.vo.SysMobileApplicationGroupVo;
import com.jxdinfo.hussar.base.mobile.permission.model.SysMobileApplicationPermission;
import com.jxdinfo.hussar.base.mobile.permission.service.ISysMobileApplicationPermissionService;
import com.jxdinfo.hussar.core.shiro.BaseShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysMobileApplicationGroupServiceImpl
extends ServiceImpl<SysMobileApplicationGroupMapper, SysMobileApplicationGroup>
implements ISysMobileApplicationGroupService {
    @Resource
    private ISysMobileApplicationService sysMobileApplicationService;
    @Resource
    private ISysMobileApplicationPermissionService permissionService;

    public ApiResponse<Boolean> insertOrUpdateGroup(SysMobileApplicationGroup sysMobileApplicationGroup) {
        sysMobileApplicationGroup.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.saveOrUpdate(sysMobileApplicationGroup);
        return ApiResponse.success();
    }

    public ApiResponse<Boolean> deleteGroup(String groupId) {
        this.removeById((Serializable)((Object)groupId));
        return ApiResponse.success();
    }

    public ApiResponse<List<SysMobileApplicationGroupVo>> queryGroupAndAppList() {
        List appList = this.sysMobileApplicationService.list();
        List<SysMobileApplicationGroup> groupList = this.list();
        groupList = groupList.stream().sorted(Comparator.comparing(SysMobileApplicationGroup::getCreateTime, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
        return ApiResponse.success(this.combinedData(appList, groupList));
    }

    public ApiResponse<List<SysMobileApplicationGroupVo>> queryListByPermission() {
        List<SysMobileApplication> appListByPermission = this.getAppListByPermission();
        appListByPermission.addAll(this.getDefaultApp());
        List<SysMobileApplicationGroup> groupList = this.list();
        groupList = groupList.stream().sorted(Comparator.comparing(SysMobileApplicationGroup::getCreateTime, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
        if (HussarUtils.isEmpty(appListByPermission)) {
            return ApiResponse.success();
        }
        List<SysMobileApplicationGroupVo> resultList = this.combinedData(appListByPermission, groupList);
        for (int i = 0; i < resultList.size(); ++i) {
            if (!HussarUtils.isEmpty((Object)resultList.get(i).getApplicationList())) continue;
            resultList.remove(i);
            --i;
        }
        return ApiResponse.success(resultList);
    }

    private List<SysMobileApplication> getAppListByPermission() {
        ArrayList<String> relationIdList = new ArrayList<String>();
        ShiroUser securityUser = BaseShiroKit.getUser();
        if (HussarUtils.isNotEmpty((Object)securityUser)) {
            List rolesList = securityUser.getRolesList();
            relationIdList.add(securityUser.getDeptId());
            relationIdList.add(securityUser.getId());
            relationIdList.addAll(rolesList);
        }
        LambdaQueryWrapper getAppByRoleWrapper = new LambdaQueryWrapper();
        getAppByRoleWrapper.in(SysMobileApplicationPermission::getRelationId, relationIdList);
        getAppByRoleWrapper.orderByDesc(SysMobileApplicationPermission::getCreateTime);
        List permissionList = this.permissionService.list((Wrapper)getAppByRoleWrapper);
        ArrayList<String> appIdList = new ArrayList<String>();
        for (SysMobileApplicationPermission sysMobileApplicationPermission : permissionList) {
            appIdList.add(sysMobileApplicationPermission.getAppId());
        }
        if (HussarUtils.isNotEmpty(appIdList)) {
            return this.sysMobileApplicationService.listByIds(appIdList);
        }
        return new ArrayList<SysMobileApplication>();
    }

    private List<SysMobileApplicationGroupVo> combinedData(List<SysMobileApplication> appList, List<SysMobileApplicationGroup> groupList) {
        List<Object> sysMobileApplications;
        SysMobileApplicationGroupVo sysMobileApplicationGroupVo;
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(groupList), SysMobileApplicationGroupVo.class).stream().collect(Collectors.toMap(SysMobileApplicationGroup::getId, Function.identity(), (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        for (SysMobileApplication sysMobileApplication : appList) {
            sysMobileApplicationGroupVo = (SysMobileApplicationGroupVo)resultCollect.get(sysMobileApplication.getGroupId());
            if (HussarUtils.isEmpty((Object)sysMobileApplicationGroupVo)) continue;
            if (HussarUtils.isNotEmpty((Object)sysMobileApplicationGroupVo.getApplicationList())) {
                sysMobileApplicationGroupVo.getApplicationList().add(sysMobileApplication);
            }
            if (!HussarUtils.isEmpty((Object)sysMobileApplicationGroupVo.getApplicationList())) continue;
            sysMobileApplications = new ArrayList<SysMobileApplication>();
            sysMobileApplications.add(sysMobileApplication);
            sysMobileApplicationGroupVo.setApplicationList(sysMobileApplications);
        }
        for (SysMobileApplication sysMobileApplication : appList) {
            sysMobileApplicationGroupVo = (SysMobileApplicationGroupVo)resultCollect.get(sysMobileApplication.getGroupId());
            sysMobileApplications = sysMobileApplicationGroupVo.getApplicationList();
            sysMobileApplications = sysMobileApplications.stream().sorted(Comparator.comparing(SysMobileApplication::getCreateTime, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
            sysMobileApplicationGroupVo.setApplicationList(sysMobileApplications);
        }
        return new ArrayList<SysMobileApplicationGroupVo>(resultCollect.values());
    }

    private List<SysMobileApplication> getDefaultApp() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMobileApplication::getDefaultApp, (Object)"1");
        return this.sysMobileApplicationService.list((Wrapper)queryWrapper);
    }
}

