/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.mobile.application.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.base.mobile.application.dao.SysMobileApplicationMapper;
import com.jxdinfo.hussar.base.mobile.application.dto.SysMobileApplicationDto;
import com.jxdinfo.hussar.base.mobile.application.model.SysMobileApplication;
import com.jxdinfo.hussar.base.mobile.application.service.ISysMobileApplicationService;
import com.jxdinfo.hussar.base.mobile.permission.model.SysMobileApplicationPermission;
import com.jxdinfo.hussar.base.mobile.permission.service.ISysMobileApplicationPermissionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysMobileApplicationServiceImpl
extends ServiceImpl<SysMobileApplicationMapper, SysMobileApplication>
implements ISysMobileApplicationService {
    @Resource
    private ISysMobileApplicationPermissionService permissionService;

    public ApiResponse<Boolean> addApp(SysMobileApplicationDto sysMobileApplicationDto) {
        sysMobileApplicationDto.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.save(sysMobileApplicationDto);
        if (HussarUtils.isNotEmpty((Object)sysMobileApplicationDto.getPermissionList())) {
            ArrayList permissionList = new ArrayList(sysMobileApplicationDto.getPermissionList());
            for (SysMobileApplicationPermission sysMobileApplicationPermission : permissionList) {
                sysMobileApplicationPermission.setAppId(sysMobileApplicationDto.getId());
            }
            this.permissionService.saveBatch(permissionList, permissionList.size());
        }
        return ApiResponse.success();
    }

    public ApiResponse<Boolean> deleteApp(String appId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysMobileApplicationPermission::getAppId, (Object)appId);
        this.permissionService.remove((Wrapper)queryWrapper);
        this.removeById((Serializable)((Object)appId));
        return ApiResponse.success();
    }

    public ApiResponse<Boolean> updateApp(SysMobileApplicationDto sysMobileApplicationDto) {
        List permissionList;
        this.updateById(sysMobileApplicationDto);
        List oldList = sysMobileApplicationDto.getOldPermissionList();
        List newList = sysMobileApplicationDto.getPermissionList();
        if (HussarUtils.isNotEmpty((Object)oldList)) {
            List differentList = oldList.stream().filter(newList::contains).collect(Collectors.toList());
            oldList.removeAll(differentList);
            ArrayList<String> removeIdList = new ArrayList<String>();
            for (SysMobileApplicationPermission mobileApplicationPermission : oldList) {
                removeIdList.add(mobileApplicationPermission.getId());
            }
            this.permissionService.removeByIds(removeIdList);
            if (HussarUtils.isNotEmpty((Object)newList)) {
                newList.removeAll(differentList);
            }
        }
        if (HussarUtils.isEmpty((Object)(permissionList = sysMobileApplicationDto.getPermissionList()))) {
            return ApiResponse.success();
        }
        for (SysMobileApplicationPermission sysMobileApplicationPermission : permissionList) {
            sysMobileApplicationPermission.setAppId(sysMobileApplicationDto.getId());
        }
        this.permissionService.saveBatch((Collection)permissionList, permissionList.size());
        return ApiResponse.success();
    }
}

