/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pageoffice.controller;

import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.util.LicenseInfo;
import com.zhuozhengsoft.pageoffice.FileSaver;
import com.zhuozhengsoft.pageoffice.OfficeVendorType;
import com.zhuozhengsoft.pageoffice.OpenModeType;
import com.zhuozhengsoft.pageoffice.PDFCtrl;
import com.zhuozhengsoft.pageoffice.PageOfficeCtrl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pageOffice"})
public class PageController
extends BaseController
implements EnvironmentAware {
    private Environment environment;

    @RequestMapping(value={"/word"})
    @ResponseBody
    public String showWord(HttpServletRequest request) throws Exception {
        String docPath = this.getDocPath();
        PageOfficeCtrl poCtrl = new PageOfficeCtrl(request);
        String as = LicenseInfo.getUploadPath();
        poCtrl.setServerPage("/hussarApi/poserver.zz");
        poCtrl.setTitlebar(true);
        poCtrl.setMenubar(true);
        poCtrl.setOfficeToolbars(false);
        poCtrl.setCustomToolbar(true);
        poCtrl.addCustomToolButton("\u4fdd\u5b58", "Save() ", 1);
        poCtrl.addCustomToolButton("\u7b7e\u7ae0", "InsertSeal()", 2);
        poCtrl.addCustomToolButton("\u5173\u95ed", "Close()", 21);
        poCtrl.setOfficeVendor(OfficeVendorType.AutoSelect);
        poCtrl.setSaveFilePage("/hussarApi/pageOffice/save");
        poCtrl.webOpen("file://" + docPath + "text.doc", OpenModeType.docReadOnly, "\u674e\u5fd7");
        return poCtrl.getHtmlCode("PageOfficeCtrl1");
    }

    @RequestMapping(value={"/pdf"})
    @ResponseBody
    public String showPdf(HttpServletRequest request) throws Exception {
        String docPath = this.getDocPath();
        PDFCtrl pdfCtrl1 = new PDFCtrl(request);
        pdfCtrl1.setServerPage("/hussarApi/poserver.zz");
        pdfCtrl1.addCustomToolButton("\u4fdd\u5b58", "Save() ", 1);
        pdfCtrl1.addCustomToolButton("\u7b7e\u7ae0", "InsertSeal()", 2);
        pdfCtrl1.addCustomToolButton("\u6253\u5370", "PrintFile()", 6);
        pdfCtrl1.addCustomToolButton("-", "", 0);
        pdfCtrl1.addCustomToolButton("\u5173\u95ed", "Close()", 21);
        pdfCtrl1.setSaveFilePage("/hussarApi/pageOffice/save");
        pdfCtrl1.webOpen("file://" + docPath + "text.pdf");
        return pdfCtrl1.getHtmlCode("PageOfficeCtrl1");
    }

    @RequestMapping(value={"/excel"})
    @ResponseBody
    public String showExcel(HttpServletRequest request) {
        String docPath = this.getDocPath();
        PageOfficeCtrl poCtrl = new PageOfficeCtrl(request);
        poCtrl.setServerPage("/hussarApi/poserver.zz");
        poCtrl.addCustomToolButton("\u4fdd\u5b58", "Save", 1);
        poCtrl.addCustomToolButton("\u76d6\u7ae0", "InsertSeal", 2);
        poCtrl.addCustomToolButton("\u5173\u95ed", "Close()", 21);
        poCtrl.setSaveFilePage("/hussarApi/pageOffice/save");
        poCtrl.webOpen("file://" + docPath + "text.xlsx", OpenModeType.xlsNormalEdit, "\u674e\u5fd7");
        return poCtrl.getHtmlCode("PageOfficeCtrl1");
    }

    @RequestMapping(value={"/save"})
    public void saveFile(HttpServletRequest request, HttpServletResponse response) {
        String docPath = this.getDocPath();
        FileSaver fs = new FileSaver(request, response);
        fs.saveToFile(docPath + fs.getFileName());
        fs.setCustomSaveResult("ok");
        fs.close();
    }

    private String getDocPath() {
        return this.environment.getProperty("pageoffice.docpath");
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

