/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.system.security;

import com.jxdinfo.hussar.bsp.permit.model.SysResType;
import com.jxdinfo.hussar.bsp.permit.model.SysSecurityLog;
import com.jxdinfo.hussar.bsp.permit.service.ISysResTypeService;
import com.jxdinfo.hussar.bsp.permit.service.ISysSecurityLogService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.export.ExportExcel;
import com.jxdinfo.hussar.common.export.bean.ExcelEntity;
import com.jxdinfo.hussar.common.export.bean.ExcelTitle;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/securityLogFront"})
public class SecurityLogFrontController
extends BaseController {
    @Resource
    private ISysSecurityLogService iSysSecurityLogService;
    @Resource
    private ISysResTypeService iSysResTypeService;

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"securityLog:list"})
    @BussinessLog(key="/securityLogFront/list", type="04", value="\u4f1a\u8bdd\u8ffd\u8e2a\u5217\u8868")
    public ApiResponse<Object> logList(@RequestBody Map<String, Object> body) {
        String page = body.get("current") == null ? null : body.get("current").toString();
        String limit = body.get("size") == null ? null : body.get("size").toString();
        String isQuery = body.get("isQuery") == null ? null : body.get("isQuery").toString();
        String startDate = body.get("dateStart") == null ? null : body.get("dateStart").toString();
        String endDate = body.get("dateEnd") == null ? null : body.get("dateEnd").toString();
        String logType = body.get("logType") == null ? null : body.get("logType").toString();
        String userAccount = body.get("userAccount") == null ? null : body.get("userAccount").toString();
        String sessionId = body.get("sessionId") == null ? null : body.get("sessionId").toString();
        String levelEvent = body.get("levelEvent") == null ? null : body.get("levelEvent").toString();
        String loginLog = body.get("loginLog") == null ? null : body.get("loginLog").toString();
        ArrayList<String> loginLogTypes = new ArrayList<String>();
        loginLogTypes.add("05");
        loginLogTypes.add("06");
        if (!StringUtils.isEmpty((CharSequence)userAccount)) {
            userAccount = userAccount.replace("%", "\\\\%").replace("_", "\\\\_");
        }
        Date start = ToolUtil.isEmpty((Object)startDate) ? null : DateUtil.parseTime((String)startDate);
        Date end = ToolUtil.isEmpty((Object)endDate) ? null : DateUtil.parseTime((String)endDate);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("startDate", start);
        map.put("endDate", end);
        map.put("logType", logType);
        map.put("userAccount", userAccount);
        map.put("levelEvent", levelEvent);
        map.put("isQuery", isQuery);
        map.put("sessionId", sessionId);
        map.put("loginLog", loginLog);
        map.put("loginLogTypes", loginLogTypes);
        Object result = this.iSysSecurityLogService.getSecurityLogList(page, limit, map);
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(value={"/logTypeOption"})
    @BussinessLog(key="/securityLogFront/logTypeOption", type="04", value="\u83b7\u53d6\u65e5\u5fd7\u7c7b\u578boption")
    public ApiResponse<List<SysResType>> logTypeOption() {
        List list = this.iSysResTypeService.getLogTypeOption();
        return ApiResponse.data((Object)list);
    }

    @RequestMapping(value={"/cmdDetail"})
    @RequiresPermissions(value={"securityLog:cmdDetail"})
    @BussinessLog(key="/securityLogFront/cmdDetail", type="04", value="\u5ba1\u8ba1\u65e5\u5fd7\u660e\u7ec6")
    public SysSecurityLog list(@RequestBody Map<String, String> map) {
        String logId = map.get("sysBaseConfigId");
        if (ToolUtil.isNotEmpty((Object)logId)) {
            return (SysSecurityLog)this.iSysSecurityLogService.getById((Serializable)((Object)logId));
        }
        return new SysSecurityLog();
    }

    @RequestMapping(value={"/selectNum"})
    @BussinessLog(key="/securityLogFront/selectNum", type="04", value="\u67e5\u8be2\u5bfc\u51fa\u884c\u6570")
    public Integer selectNum(@RequestBody Map<String, Object> body) {
        String levelEvent;
        String startDate = body.get("dateStart") == null ? null : body.get("dateStart").toString();
        String endDate = body.get("dateEnd") == null ? null : body.get("dateEnd").toString();
        String logType = body.get("logType") == null ? null : body.get("logType").toString();
        String userAccount = body.get("userAccount") == null ? null : body.get("userAccount").toString();
        String sessionId = body.get("sessionId") == null ? null : body.get("sessionId").toString();
        String string = levelEvent = body.get("levelEvent") == null ? null : body.get("levelEvent").toString();
        if (!StringUtils.isEmpty((CharSequence)userAccount)) {
            userAccount = userAccount.replace("%", "\\\\%").replace("_", "\\\\_");
        }
        Date start = ToolUtil.isEmpty((Object)startDate) ? null : DateUtil.parseTime((String)startDate);
        Date end = ToolUtil.isEmpty((Object)endDate) ? null : DateUtil.parseTime((String)endDate);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("startDate", start);
        map.put("endDate", end);
        map.put("logType", logType);
        map.put("userAccount", userAccount);
        map.put("levelEvent", levelEvent);
        map.put("sessionId", sessionId);
        return this.iSysSecurityLogService.getListRow(map);
    }

    @RequestMapping(value={"/export"})
    @RequiresPermissions(value={"securityLog:exportTable"})
    @BussinessLog(key="/securityLogFront/export", type="04", value="\u5bfc\u51fa\u65e5\u5fd7\u660e\u7ec6")
    public void exportLog(HttpServletResponse response, @RequestParam(value="dateStart", required=false) String startDate, @RequestParam(value="dateEnd", required=false) String endDate, @RequestParam(value="logType", required=false) String logType, @RequestParam(value="userAccount", required=false) String userAccount, @RequestParam(value="sessionId", required=false) String sessionId, @RequestParam(value="levelEvent", required=false) String levelEvent, @RequestParam(value="loginLog") String loginLog) {
        if (!StringUtils.isEmpty((CharSequence)userAccount)) {
            userAccount = userAccount.replace("%", "\\\\%").replace("_", "\\\\_");
        }
        Date start = ToolUtil.isEmpty((Object)startDate) ? null : DateUtil.parseTime((String)startDate);
        Date end = ToolUtil.isEmpty((Object)endDate) ? null : DateUtil.parseTime((String)endDate);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("startDate", start);
        map.put("endDate", end);
        map.put("logType", logType);
        map.put("userAccount", userAccount);
        map.put("levelEvent", levelEvent);
        map.put("sessionId", sessionId);
        map.put("loginLog", loginLog);
        ArrayList<String> loginLogTypes = new ArrayList<String>();
        loginLogTypes.add("05");
        loginLogTypes.add("06");
        map.put("loginLogTypes", loginLogTypes);
        List list = this.iSysSecurityLogService.getSecurityLogList(map);
        ArrayList<ExcelTitle> excelTitles = new ArrayList<ExcelTitle>();
        String[] title = new String[]{"\u5e8f\u53f7", "\u7528\u6237\u8d26\u53f7", "\u7528\u6237\u540d\u79f0", "\u65e5\u5fd7\u7c7b\u578b", "\u64cd\u4f5c\u4e1a\u52a1\u542b\u4e49", "\u7cfb\u7edf/\u4e1a\u52a1\u7ea7\u4e8b\u4ef6", "\u6267\u884c\u72b6\u6001", "\u5ba2\u6237\u7aef\u5730\u5740", "\u64cd\u4f5c\u65f6\u95f4", "\u65e5\u5fd7"};
        String[] idTitle = new String[]{"no", "userAccount", "userName", "logTypeName", "resourceAlias", "levelEventName", "state", "remoteaddr", "logTime", "logContent"};
        for (int i = 0; i < title.length; ++i) {
            ExcelTitle excelTitle = new ExcelTitle();
            excelTitle.setTitleId(idTitle[i]);
            excelTitle.setTitleText(title[i]);
            excelTitles.add(excelTitle);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date date = new Date(System.currentTimeMillis());
        String fileName = "\u5ba1\u8ba1\u65e5\u5fd7\u8868" + formatter.format(date) + ".xls";
        String sheetName = "\u5ba1\u8ba1\u65e5\u5fd7\u8868";
        SimpleDateFormat logFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        ArrayList querys = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> querysMap = new HashMap<String, Object>(10);
            querysMap.put("no", i + 1);
            querysMap.put("userAccount", ((SysSecurityLog)list.get(i)).getUserAccount());
            querysMap.put("userName", ((SysSecurityLog)list.get(i)).getUserName());
            querysMap.put("corporationName", ((SysSecurityLog)list.get(i)).getCorporationName());
            querysMap.put("logTypeName", ((SysSecurityLog)list.get(i)).getLogTypeName());
            querysMap.put("resourceAlias", ((SysSecurityLog)list.get(i)).getResourceAlias());
            querysMap.put("levelEventName", ((SysSecurityLog)list.get(i)).getLevelEventName());
            querysMap.put("state", ((SysSecurityLog)list.get(i)).getState());
            querysMap.put("remoteaddr", ((SysSecurityLog)list.get(i)).getRemoteaddr());
            querysMap.put("logTime", logFormatter.format(((SysSecurityLog)list.get(i)).getLogTime()));
            querysMap.put("logContent", ((SysSecurityLog)list.get(i)).getLogContent());
            querys.add(querysMap);
            if (i == 999) break;
        }
        ExcelEntity excelEntity = new ExcelEntity();
        excelEntity.setQuerys(querys);
        excelEntity.setTitles(excelTitles);
        excelEntity.setBlankLeft(true);
        excelEntity.setBlankTop(true);
        ExportExcel exportExcel = new ExportExcel();
        try (ServletOutputStream os = response.getOutputStream();){
            this.setResponseHeader(response, fileName);
            exportExcel.exportExcel((OutputStream)os, excelEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setResponseHeader(HttpServletResponse response, String fileName) {
        String newFileName = fileName;
        try {
            try {
                newFileName = new String(newFileName.getBytes(), "ISO8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.setHeader("Content-Disposition", "attachment;filename=" + newFileName);
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

