/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.pageoffice.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.attachment.model.AttachmentManagerModel;
import com.jxdinfo.hussar.common.attachment.service.AttachmentManagerService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.encrypt.file.FileEncryptUtil;
import com.zhuozhengsoft.pageoffice.FileSaver;
import com.zhuozhengsoft.pageoffice.OfficeVendorType;
import com.zhuozhengsoft.pageoffice.OpenModeType;
import com.zhuozhengsoft.pageoffice.PDFCtrl;
import com.zhuozhengsoft.pageoffice.PageOfficeCtrl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pageOffice"})
public class PageController
extends BaseController
implements EnvironmentAware {
    private Environment environment;
    @Resource
    AttachmentManagerService attachmentManagerService;

    @RequestMapping(value={"/word"})
    public void showWord(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String docPath = this.getDocPath();
        String pageFile = request.getParameter("id");
        String filePath = "file://";
        if (ToolUtil.isNotEmpty((Object)pageFile)) {
            filePath = pageFile.indexOf(".") >= 0 ? filePath + docPath + pageFile : filePath + this.findDirByBusinessId(pageFile);
        }
        PageOfficeCtrl poCtrl = new PageOfficeCtrl(request);
        poCtrl.setServerPage("/poserver.zz");
        poCtrl.setTitlebar(true);
        poCtrl.setMenubar(true);
        poCtrl.setOfficeToolbars(true);
        poCtrl.setCustomToolbar(true);
        poCtrl.addCustomToolButton("\u4fdd\u5b58", "Save() ", 1);
        poCtrl.addCustomToolButton("\u9690\u85cf\u75d5\u8ff9", "Hidden", 18);
        poCtrl.addCustomToolButton("\u663e\u793a\u75d5\u8ff9", "Show", 9);
        poCtrl.addCustomToolButton("\u5168\u5c4f\u5207\u6362", "SwitchFullScreen", 4);
        poCtrl.addCustomToolButton("\u5173\u95ed", "Close()", 21);
        poCtrl.setOfficeVendor(OfficeVendorType.AutoSelect);
        poCtrl.setSaveFilePage("/pageOffice/save");
        response.setContentType("text/html;charset=utf-8");
        try {
            poCtrl.webOpen(filePath, OpenModeType.docReadOnly, "\u674e\u5fd7");
            InputStream pageOfficeTemplateStream = ((Object)((Object)this)).getClass().getResourceAsStream("/templates/openWord.html");
            String pageOfficeTemplateStr = IOUtils.toString((InputStream)pageOfficeTemplateStream, (Charset)StandardCharsets.UTF_8);
            String resStr = pageOfficeTemplateStr.replace("${pageoffice}", poCtrl.getHtmlCode("PageOfficeCtrl1"));
            response.getWriter().write(resStr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            response.getWriter().write(ex.getMessage());
        }
    }

    @RequestMapping(value={"/pdf"})
    @ResponseBody
    public void showPdf(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String docPath = this.getDocPath();
        String pageFile = request.getParameter("id");
        String filePath = "file://";
        if (ToolUtil.isNotEmpty((Object)pageFile)) {
            filePath = pageFile.indexOf(".") >= 0 ? filePath + docPath + pageFile : filePath + this.findDirByBusinessId(pageFile);
        }
        PDFCtrl pdfCtrl1 = new PDFCtrl(request);
        pdfCtrl1.setServerPage("/poserver.zz");
        pdfCtrl1.addCustomToolButton("\u4fdd\u5b58", "Save() ", 1);
        pdfCtrl1.addCustomToolButton("\u7b7e\u7ae0", "InsertSeal()", 2);
        pdfCtrl1.addCustomToolButton("\u6253\u5370", "PrintFile()", 6);
        pdfCtrl1.addCustomToolButton("-", "", 0);
        pdfCtrl1.addCustomToolButton("\u5168\u5c4f\u5207\u6362", "SwitchFullScreen", 4);
        pdfCtrl1.addCustomToolButton("\u5173\u95ed", "Close()", 21);
        pdfCtrl1.setSaveFilePage("/pageOffice/save");
        response.setContentType("text/html;charset=utf-8");
        try {
            pdfCtrl1.webOpen(filePath);
            InputStream pageOfficeTemplateStream = ((Object)((Object)this)).getClass().getResourceAsStream("/templates/openPdf.html");
            String pageOfficeTemplateStr = IOUtils.toString((InputStream)pageOfficeTemplateStream, (Charset)StandardCharsets.UTF_8);
            String resStr = pageOfficeTemplateStr.replace("${pageoffice}", pdfCtrl1.getHtmlCode("PageOfficeCtrl1"));
            response.getWriter().write(resStr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            response.getWriter().write(ex.getMessage());
        }
    }

    @RequestMapping(value={"/excel"})
    public void showExcel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String docPath = this.getDocPath();
        String pageFile = request.getParameter("id");
        String filePath = "file://";
        if (ToolUtil.isNotEmpty((Object)pageFile)) {
            filePath = pageFile.indexOf(".") >= 0 ? filePath + docPath + pageFile : filePath + this.findDirByBusinessId(pageFile);
        }
        PageOfficeCtrl poCtrl = new PageOfficeCtrl(request);
        poCtrl.setServerPage("/poserver.zz");
        poCtrl.addCustomToolButton("\u4fdd\u5b58", "Save", 1);
        poCtrl.addCustomToolButton("\u76d6\u7ae0", "InsertSeal", 2);
        poCtrl.addCustomToolButton("\u5168\u5c4f\u5207\u6362", "SwitchFullScreen", 4);
        poCtrl.addCustomToolButton("\u5173\u95ed", "Close()", 21);
        poCtrl.setSaveFilePage("/pageOffice/save");
        response.setContentType("text/html;charset=utf-8");
        try {
            poCtrl.webOpen(filePath, OpenModeType.xlsNormalEdit, "\u674e\u5fd7");
            InputStream pageOfficeTemplateStream = ((Object)((Object)this)).getClass().getResourceAsStream("/templates/openExcel.html");
            String pageOfficeTemplateStr = IOUtils.toString((InputStream)pageOfficeTemplateStream, (Charset)StandardCharsets.UTF_8);
            String resStr = pageOfficeTemplateStr.replace("${pageoffice}", poCtrl.getHtmlCode("PageOfficeCtrl1"));
            response.getWriter().write(resStr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            response.getWriter().write(ex.getMessage());
        }
    }

    public String findDirByBusinessId(String businessId) {
        String filePath = "";
        AttachmentManagerModel attachmentManagerModel = (AttachmentManagerModel)this.attachmentManagerService.getOne((Wrapper)new QueryWrapper().eq((Object)"BUSINESS_ID", (Object)businessId), false);
        if (ToolUtil.isNotEmpty((Object)attachmentManagerModel)) {
            String fileId = attachmentManagerModel.getId();
            String encryptKey = attachmentManagerModel.getEncrypt();
            String path = attachmentManagerModel.getAttachmentDir();
            String suffix = attachmentManagerModel.getAttachmentType();
            FileEncryptUtil feu = FileEncryptUtil.getInstance();
            String targetPath = path + fileId + "." + suffix;
            String pathEncrypt = path + fileId + "." + suffix + ".encrypt";
            if (feu.decrypt(pathEncrypt, targetPath, encryptKey.trim()).booleanValue()) {
                filePath = targetPath;
            }
        }
        return filePath;
    }

    @RequestMapping(value={"/save"})
    public void saveFile(HttpServletRequest request, HttpServletResponse response) {
        String docPath = this.getDocPath();
        FileSaver fs = new FileSaver(request, response);
        String fileName = fs.getFileName();
        String filePath = docPath + fileName;
        File file = new File(filePath);
        if (!file.exists()) {
            String fileId = UUID.randomUUID().toString().replaceAll("-", "");
            fileName = fileId + fs.getFileExtName();
            fs.saveToFile(docPath + fileId + fs.getFileExtName());
        } else {
            fs.saveToFile(filePath);
        }
        fs.setCustomSaveResult(fileName);
        fs.close();
    }

    private String getDocPath() {
        return this.environment.getProperty("pageoffice.docpath");
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

