/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.system.cache;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.redis.service.RedisService;
import com.jxdinfo.hussar.core.redis.util.RedisUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/redisFront"})
@ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="false", matchIfMissing=false)
public class RedisFrontController
extends BaseController {
    @Resource
    RedisService redisService;
    @Resource
    private GlobalProperties globalProperties;
    @Autowired
    RedisUtil redisUtil;
    @Value(value="${spring.redis.host}")
    private String host;

    @RequestMapping(value={"/showRedisValue"})
    @BussinessLog(key="/redisFront/showRedisValue", type="04", value="\u83b7\u53d6\u67d0redis db\u4e2d\u7684\u5168\u90e8\u952e\u503c\u5bf9\u6216\u67d0key\u7684\u952e\u503c\u5bf9")
    public ApiResponse<Map<String, Object>> showRedisValue() {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        List list = this.redisService.getKeyAndValues("shiro_is_lock:");
        result.put("code", 0);
        result.put("count", list.size());
        result.put("data", list);
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/deleteNoSQLKeys"})
    @BussinessLog(key="/redisFront/deleteNoSQLKeys", type="02", value="\u5220\u9664redis key")
    public ApiResponse<?> deleteNoSQLKeys(@RequestBody Map<String, String> map) {
        JSONArray arr = JSON.parseArray((String)map.get("keys"));
        String[] strarr = (String[])arr.toArray((Object[])new String[arr.size()]);
        ArrayList<String> accountList = new ArrayList<String>();
        boolean tenantFlag = this.globalProperties.isTenantOpen();
        try {
            for (String id : strarr) {
                this.redisService.delete(id);
                String account = tenantFlag ? id.replace("shiro_is_lock:", "").replace("-" + DataSourceUtil.currentDsName(), "") : id.replace("shiro_is_lock:", "");
                accountList.add(account);
            }
            ISysUsersService iSysUsersService = (ISysUsersService)SpringContextHolder.getBean(ISysUsersService.class);
            iSysUsersService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"account_status", (Object)UserStatus.OK.getCode())).in((Object)"user_account", accountList)).eq((Object)"account_status", (Object)UserStatus.PWD_LOCK.getCode()));
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25\uff01");
        }
    }

    @RequiresPermissions(value={"redis:deleteNoSQLKeys"})
    @RequestMapping(value={"/deleteKeys"})
    @BussinessLog(key="/redisFront/deleteKeys", type="02", value="\u5220\u9664key")
    @ResponseBody
    public ApiResponse<?> deleteKeys(@RequestBody Map<String, String> map) {
        String noSQLDbName = map.get("NoSQLDbName");
        String keys = map.get("keys");
        try {
            JSONArray arr = JSON.parseArray((String)keys);
            String[] strarr = (String[])arr.toArray((Object[])new String[arr.size()]);
            this.redisService.deleteNoSQLKeyForRedis(noSQLDbName, strarr);
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5220\u9664\u5931\u8d25\uff01");
        }
    }

    @RequiresPermissions(value={"redis:getAllRedisDatabaseList"})
    @RequestMapping(value={"getAllRedisDatabaseList"})
    @BussinessLog(key="/redisFront/getAllRedisDatabaseList", type="04", value="\u83b7\u53d6\u5f53\u524d\u6570\u636e\u5e93\u4e2d\u6240\u6709db\u7684map")
    public ApiResponse<List<JSTreeModel>> getAllRedisDatabaseList() {
        ArrayList<JSTreeModel> listAll = new ArrayList<JSTreeModel>();
        JSTreeModel tempObject = new JSTreeModel();
        try {
            int e = 0;
            int index = e + 1;
            tempObject.setId(index + "");
            tempObject.setText(this.host);
            tempObject.setType("database");
            listAll.add(tempObject);
            int pid = index;
            int dbAmount = this.redisUtil.getDbAmountForRedis();
            for (int y = 0; y < dbAmount; ++y) {
                JSTreeModel tempObjectTable2 = new JSTreeModel();
                tempObjectTable2.setId(String.valueOf(++index));
                tempObjectTable2.setParent(String.valueOf(pid));
                tempObjectTable2.setText("DB" + y);
                tempObjectTable2.setType("table");
                listAll.add(tempObjectTable2);
            }
            return ApiResponse.data(ForestNodeMerger.merge(listAll));
        }
        catch (Exception e) {
            String info = "\u53d6\u5f97reids\u4e2d\u6570\u636e\u5e93\u6570\u636e\u51fa\u9519,\u53ef\u80fd\u6570\u636e\u5e93\u8fde\u63a5\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff01\n " + e.getMessage();
            System.out.println(info);
            e.printStackTrace();
            return null;
        }
    }

    @RequiresPermissions(value={"redis:showRedisDBValue"})
    @RequestMapping(value={"/showRedisDBValue"})
    @BussinessLog(key="/redisFront/showRedisDBValue", type="04", value="\u83b7\u53d6\u67d0redis db\u4e2d\u7684\u5168\u90e8\u952e\u503c\u5bf9\u6216\u67d0key\u7684\u952e\u503c\u5bf9")
    public ApiResponse<Map<String, Object>> showNoSQLDBValue(@RequestBody Map<String, Object> map) {
        String noSQLDbName = map.get("NoSQLDbName") == null ? null : map.get("NoSQLDbName").toString();
        String selectKey = map.get("selectKey") == null ? null : map.get("selectKey").toString();
        int pageNo = map.get("page") == null ? 1 : Integer.parseInt(map.get("page").toString());
        int limit = map.get("limit") == null ? 10 : Integer.parseInt(map.get("limit").toString());
        Page page = new Page((long)pageNo, (long)limit);
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        if (StringUtils.isBlank((CharSequence)noSQLDbName)) {
            result.put("code", 0);
            result.put("count", 0);
            result.put("data", null);
            return ApiResponse.data(result);
        }
        if (selectKey == null) {
            selectKey = "nokey";
        }
        List list = this.redisService.getNoSQLDBForRedis(page, noSQLDbName, selectKey).getRecords();
        result.put("code", 0);
        result.put("count", page.getTotal());
        result.put("data", list);
        return ApiResponse.data(result);
    }

    @RequiresPermissions(value={"redis:getKeysSize"})
    @RequestMapping(value={"getKeysSize"})
    @BussinessLog(key="/redisFront/getKeysSize", type="04", value="\u83b7\u53d6\u5f53\u524d\u6570\u636e\u5e93\u4e2dkey\u7684\u6570\u91cf")
    public ApiResponse<Map<String, Object>> getKeysSize() {
        return ApiResponse.data((Object)this.redisService.getKeysSize());
    }
}

