/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.message.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.baseconfig.dao.SysBaseConfigMapper;
import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.datasource.dao.SysDataSourceTenantMapper;
import com.jxdinfo.hussar.bsp.message.dao.LeaveMessagesMapper;
import com.jxdinfo.hussar.bsp.message.model.LeaveMessages;
import com.jxdinfo.hussar.bsp.message.service.LeaveMessagesService;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class LeaveMessagesServiceImpl
extends ServiceImpl<LeaveMessagesMapper, LeaveMessages>
implements LeaveMessagesService {
    @Autowired
    private LeaveMessagesMapper leaveMessagesMapper;
    @Autowired
    private SysBaseConfigMapper sysBaseConfigMapper;
    @Autowired
    private SysDataSourceTenantMapper sysDataSourceTenantMapper;
    @Autowired
    private DruidProperties druidProperties;

    @Override
    public List<LeaveMessages> queryMessages(String userId) {
        Page page = new Page(0L, 5L);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("messageStatus", "0");
        return this.leaveMessagesMapper.hussarQueryPage(page, map);
    }

    @Override
    public List<LeaveMessages> hussarQueryPage(Page page, String sendUserName, String startDate, String endDate) {
        String userId = ShiroKit.getUser().getId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("sendUserName", sendUserName);
        map.put("startTime", startDate);
        map.put("endTime", endDate);
        String dbType = this.druidProperties.getUrl().split(":")[1];
        String days = ((SysBaseConfig)this.sysBaseConfigMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)" CONFIG_KEY", (Object)"message_days"))).getConfigValue();
        map.put("dbType", dbType);
        return this.leaveMessagesMapper.hussarQueryPage(page, map);
    }

    @Override
    public boolean del(List<String> ids) {
        if (null != ids && ids.size() > 0) {
            this.removeByIds(ids);
        }
        return true;
    }

    @Override
    public LeaveMessages formQuery(String id) {
        LeaveMessages leaveMessages = (LeaveMessages)((Object)this.getById((Serializable)((Object)id)));
        return leaveMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(LeaveMessages leaveMessages) {
        String dbName = "master";
        leaveMessages.setMessageMode("0");
        if (ToolUtil.isEmpty((Object)leaveMessages.getMessageUrl()) && ToolUtil.isEmpty((Object)leaveMessages.getProcessDefinitionKey())) {
            leaveMessages.setMessageMode("1");
        }
        leaveMessages.setMessageStatus("0");
        leaveMessages.setCreateTime(new Date());
        try {
            if ("1".equals(leaveMessages.getIsTenant())) {
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT sd.DB_NAME FROM SYS_TENANT st, SYS_DATASOURCE sd ");
                sb.append("WHERE st.DB_ID = sd.DB_ID AND st.TENANT_ID = (");
                sb.append("SELECT TENANT_ID FROM SYS_STRU ");
                sb.append("WHERE STRU_ID = (");
                sb.append("SELECT PERMISSION_STRU_ID FROM SYS_STRU WHERE STRU_ID = (");
                sb.append("SELECT stru.STRU_ID FROM SYS_USERS su, SYS_STRU stru ");
                sb.append("WHERE su.DEPARTMENT_ID = stru.STRU_ID ");
                sb.append("AND su.USER_ID = '");
                sb.append(leaveMessages.getReceiveUserId());
                sb.append("')))");
                try {
                    dbName = (String)new JdbcTemplate(DataSourceUtil.getDataSource((String)"master")).queryForObject(sb.toString(), String.class);
                }
                catch (Exception e) {
                    dbName = ShiroKit.getUser().getConnName();
                    DataSourceUtil.changeTempDs((String)dbName);
                    this.save((Object)leaveMessages);
                }
            }
            DataSourceUtil.changeTempDs((String)dbName);
            this.save((Object)leaveMessages);
        }
        finally {
            DataSourceUtil.poll();
        }
        return true;
    }

    @Override
    public boolean updateSatus(List<String> ids) {
        ArrayList<LeaveMessages> updateList = new ArrayList<LeaveMessages>();
        if (null != ids && ids.size() > 0) {
            for (String id : ids) {
                LeaveMessages messages = new LeaveMessages();
                messages.setId(id);
                messages.setMessageStatus("1");
                messages.setMessageTime(new Date());
                updateList.add(messages);
            }
            this.updateBatchById(updateList);
        }
        return true;
    }

    @Override
    public boolean delMessage() {
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        String days = ((SysBaseConfig)this.sysBaseConfigMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)" CONFIG_KEY", (Object)"message_days"))).getConfigValue();
        cal.add(5, -Integer.valueOf(days).intValue());
        Date countTime = cal.getTime();
        String countDate = formater.format(countTime);
        List<String> msgIds = this.leaveMessagesMapper.getOverdueMessages(countDate);
        if (ToolUtil.isNotEmpty(msgIds)) {
            this.del(msgIds);
        }
        return true;
    }
}

