/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.menu;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bpm.messagepush.util.ShiroBpmConfiguration;
import com.jxdinfo.hussar.bsp.baseconfig.dao.SysBaseConfigMapper;
import com.jxdinfo.hussar.bsp.menu.model.MenuInfo;
import com.jxdinfo.hussar.bsp.menu.model.SysMenu;
import com.jxdinfo.hussar.bsp.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.bsp.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.bsp.permit.model.SysFunctions;
import com.jxdinfo.hussar.bsp.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.constant.dictmap.MenuDict;
import com.jxdinfo.hussar.common.constant.factory.ConstantFactory;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.front.common.response.ResultCode;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.BussinessLogImpl;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/frontMenu"})
public class SysMenuFrontController
extends BaseController {
    @Resource
    ISysMenuManageService sysMenuManageService;
    @Resource
    private ISysDicRefService iSysDicRefService;
    @Resource
    private ISysMenuManageService iSysMenuManageService;
    @Resource
    private ShiroBpmConfiguration bpmConf;
    @Resource
    private ISysFunctionModulesService iSysFunctionModulesService;
    @Resource
    private ISysFunctionsService iSysFunctionsService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private SysBaseConfigMapper sysBaseConfigMapper;
    @Value(value="${spring.profiles.active}")
    private String profiles;
    @Resource
    private BussinessLogImpl businessLog;

    @PostMapping(value={"getMenu"})
    public ApiResponse<?> getMenu(@RequestBody Map<String, String> map) {
        String type = ToolUtil.isNotEmpty((Object)map.get("type")) ? map.get("type") : "";
        ShiroUser shiroUser = ShiroKit.getUser();
        List roleIdList = ConstantFactory.me().getRolesIdByShiroUser(shiroUser);
        if (shiroUser != null) {
            List<Object> menus = roleIdList != null && roleIdList.size() > 0 ? (this.globalProperties.isTenantOpen() ? this.iSysMenuManageService.getTenantMenuByRoles(shiroUser.getId(), roleIdList, this.profiles, shiroUser.getConnName()) : this.iSysMenuManageService.getMenuByRoles(shiroUser.getId(), roleIdList, this.profiles)) : new ArrayList<MenuInfo>();
            if (!"true".equals(this.bpmConf.getSendMessage())) {
                this.removeMenus(menus, "e3296a07c84bda0135bb32a008c186b1");
            }
            if (!this.globalProperties.isTenantOpen()) {
                this.removeMenus(menus, "9181137daa25f2505e9e2e16622e3125");
                this.removeMenus(menus, "4d8a36281441e225ba6a9508af7052aa");
            }
            String menuStr = JSONObject.toJSONString(menus);
            List result = JSONObject.parseArray((String)menuStr, MenuInfo.class);
            if ("0".equals(type)) {
                this.updateComponentByType(result, "/pages/console");
            } else if ("1".equals(type)) {
                this.updateComponentByType(result, "/pages/index");
            }
            return ApiResponse.data((Object)result);
        }
        return ApiResponse.fail((int)ResultCode.UN_AUTHORIZED.getCode(), (String)ResultCode.UN_AUTHORIZED.getMessage());
    }

    @RequestMapping(value={"/searchMenu"})
    @BussinessLog(key="/frontMenu/searchMenu", type="04", value="\u83dc\u5355\u641c\u7d22")
    public ApiResponse<?> searchMenu(@RequestBody Map<String, String> map) {
        String type = ToolUtil.isNotEmpty((Object)map.get("type")) ? map.get("type") : "";
        String text = ToolUtil.isNotEmpty((Object)map.get("text")) ? map.get("text") : "";
        ShiroUser shiroUser = ShiroKit.getUser();
        List roleIdList = ConstantFactory.me().getRolesIdByShiroUser(shiroUser);
        if (shiroUser != null) {
            List<Object> menus = roleIdList != null && roleIdList.size() > 0 ? (this.globalProperties.isTenantOpen() ? this.iSysMenuManageService.getTenantMenuByRolesAndText(shiroUser.getId(), roleIdList, this.profiles, shiroUser.getConnName(), text) : this.iSysMenuManageService.getMenuByRolesAndText(shiroUser.getId(), roleIdList, this.profiles, text)) : new ArrayList<MenuInfo>();
            if (!"true".equals(this.bpmConf.getSendMessage())) {
                this.removeMenus(menus, "e3296a07c84bda0135bb32a008c186b1");
            }
            if (!this.globalProperties.isTenantOpen()) {
                this.removeMenus(menus, "9181137daa25f2505e9e2e16622e3125");
                this.removeMenus(menus, "4d8a36281441e225ba6a9508af7052aa");
            }
            String menuStr = JSONObject.toJSONString(menus);
            List result = JSONObject.parseArray((String)menuStr, MenuInfo.class);
            if ("0".equals(type)) {
                this.updateComponentByType(result, "/pages/console");
            } else if ("1".equals(type)) {
                this.updateComponentByType(result, "/pages/index");
            }
            return ApiResponse.data((Object)result);
        }
        return ApiResponse.fail((int)ResultCode.UN_AUTHORIZED.getCode(), (String)ResultCode.UN_AUTHORIZED.getMessage());
    }

    @PostMapping(value={"getMasterMenu"})
    public ApiResponse<?> getMasterMenu(@RequestBody Map<String, String> map) {
        String type = ToolUtil.isNotEmpty((Object)map.get("type")) ? map.get("type") : "";
        ShiroUser shiroUser = ShiroKit.getUser();
        if (shiroUser != null) {
            List menus = this.sysMenuManageService.findMasterAppRefMenu();
            String menuStr = JSONObject.toJSONString((Object)menus);
            List result = JSONObject.parseArray((String)menuStr, MenuInfo.class);
            return ApiResponse.data((Object)result);
        }
        return ApiResponse.fail((int)ResultCode.UN_AUTHORIZED.getCode(), (String)ResultCode.UN_AUTHORIZED.getMessage());
    }

    @RequestMapping(value={"/searchMasterMenu"})
    @BussinessLog(key="/frontMenu/searchMasterMenu", type="04", value="\u641c\u7d22\u4e3b\u5e93\u83dc\u5355")
    public ApiResponse<?> searchMasterMenu(@RequestBody Map<String, String> map) {
        String text = ToolUtil.isNotEmpty((Object)map.get("text")) ? map.get("text") : "";
        ShiroUser shiroUser = ShiroKit.getUser();
        if (shiroUser != null) {
            List menus = this.sysMenuManageService.findMasterAppRefMenuByText(text);
            String menuStr = JSONObject.toJSONString((Object)menus);
            List result = JSONObject.parseArray((String)menuStr, MenuInfo.class);
            return ApiResponse.data((Object)result);
        }
        return ApiResponse.fail((int)ResultCode.UN_AUTHORIZED.getCode(), (String)ResultCode.UN_AUTHORIZED.getMessage());
    }

    private void removeMenus(List<MenuInfo> menus, String menuId) {
        for (MenuInfo menuInfo : menus) {
            if (menuId.equals(menuInfo.getMenuId())) {
                menus.remove(menuInfo);
                break;
            }
            List childList = menuInfo.getChildMenus();
            if (!ToolUtil.isNotEmpty((Object)childList)) continue;
            this.removeMenus(menuInfo.getChildMenus(), menuId);
        }
    }

    private void updateComponentByType(List<MenuInfo> menus, String extra) {
        for (MenuInfo menuInfo : menus) {
            List childList;
            String component = menuInfo.getComponent();
            if (ToolUtil.isNotEmpty((Object)component) && !component.contains(extra)) {
                int index = component.indexOf("@");
                String pre = component.substring(0, index + 1);
                String suf = component.substring(index + 1);
                String newComponent = pre + extra + suf;
                menuInfo.setComponent(newComponent);
            }
            if (!ToolUtil.isNotEmpty((Object)(childList = menuInfo.getChildMenus()))) continue;
            this.updateComponentByType(menuInfo.getChildMenus(), extra);
        }
    }

    @RequiresPermissions(value={"menu:menuTree"})
    @RequestMapping(value={"/menuTree"})
    public ApiResponse<List<JSTreeModel>> menuTree() {
        List result = this.sysMenuManageService.getMenuTree();
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setText("\u83dc\u5355\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/menuInfoSave"})
    @RequiresPermissions(value={"menu:menuInfoSave"})
    @BussinessLog(key="/frontMenu/menuInfoSave", type="01", value="\u65b0\u589e\u83dc\u5355", dict=MenuDict.class, pk="menuId")
    @CacheEvict(value={"menu_info"}, allEntries=true)
    public ApiResponse<Tip> menuInfoSave(@RequestBody SysMenu sysMenu) {
        this.sysMenuManageService.menuInfoSave(sysMenu);
        if (ToolUtil.isNotEmpty((Object)sysMenu.getOuterLink())) {
            sysMenu.setOuterLink("0");
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/menuInfoEditSave"})
    @RequiresPermissions(value={"menu:menuInfoEditSave"})
    @BussinessLog(key="/frontMenu/menuInfoEditSave", type="03", value="\u4fee\u6539\u83dc\u5355", pk="text", dict=MenuDict.class)
    @CacheEvict(value={"menu_info", "resource_info"}, allEntries=true)
    public ApiResponse<Tip> menuInfoEditSave(@RequestBody SysMenu sysMenu) {
        SysMenu result = this.sysMenuManageService.getMenuInfo(sysMenu.getMenuId());
        LogObjectHolder.me().set((Object)result);
        this.sysMenuManageService.menuInfoSave(sysMenu);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"menu:menuInfo"})
    @RequestMapping(value={"/menuInfo"})
    public ApiResponse<Map> menuInfo(@RequestBody Map<String, String> body) {
        String menuId = body.get("menuId");
        String length = body.get("length");
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysMenu result = this.sysMenuManageService.getMenuInfo(menuId);
        map.put("menuInfo", result);
        map.put("length", length);
        map.put("openType", this.iSysDicRefService.getDictLabel("menu_type", result.getOpenType()));
        return ApiResponse.data(map);
    }

    @BussinessLog(key="/frontMenu/delMenuById", type="02", value="\u5220\u9664\u83dc\u5355", pk="menuId", dict=MenuDict.class)
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequestMapping(value={"/delMenuById"})
    @RequiresPermissions(value={"menu:delMenuById"})
    public ApiResponse<?> delMenuById(@RequestBody Map<String, String> map) {
        String ids = map.get("menuIds") == null ? "" : map.get("menuIds");
        List<String> menuIds = Arrays.asList(ids.split(","));
        List menuInfoList = this.sysMenuManageService.list((Wrapper)new QueryWrapper().in((Object)"MENU_ID", menuIds));
        ArrayList<String> list = new ArrayList<String>();
        for (SysMenu sysMenu : menuInfoList) {
            list.add(sysMenu.getText());
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("text", StringUtils.join((Object[])list.toArray(), (String)","));
        LogObjectHolder.me().set("edit_object_after", map1);
        return this.sysMenuManageService.delMenuById(menuIds);
    }

    @RequestMapping(value={"/checkMenuRes"})
    public ApiResponse<?> checkMenuRes(@RequestBody Map<String, String> map) {
        String ids = map.get("menuIds") == null ? "" : map.get("menuIds");
        List<String> menuIds = Arrays.asList(ids.split(","));
        return this.sysMenuManageService.checkMenuById(menuIds);
    }

    @RequiresPermissions(value={"menu:menuTreeById"})
    @RequestMapping(value={"/menuTreeById"})
    public ApiResponse<List<JSTreeModel>> menuTreeById(@RequestBody Map<String, Object> map) {
        String menuId = map.get("menuId") == null ? null : map.get("menuId").toString();
        String isHead = map.get("isRoot") == null ? null : map.get("isRoot").toString();
        Boolean isRoot = Boolean.valueOf(isHead);
        List result = this.sysMenuManageService.menuTreeById(menuId);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("1");
            root.setText("\u83dc\u5355\u5217\u8868");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/menuTreeOrder"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequiresPermissions(value={"menu:menuTreeOrder"})
    @BussinessLog(key="/frontMenu/menuTreeOrder", type="03", value="\u83dc\u5355\u6811\u4e0b\u7ea7\u6392\u5e8f")
    public ApiResponse<Tip> menuTreeOrder(@RequestBody Map<String, Object> map) {
        String treeInfo = map.get("treeInfo") == null ? "" : map.get("treeInfo").toString();
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        ArrayList<SysMenu> list = new ArrayList<SysMenu>();
        ArrayList<SysFunctionModules> functionModules = new ArrayList<SysFunctionModules>();
        ArrayList<SysFunctions> functions = new ArrayList<SysFunctions>();
        for (int i = 0; i < treeArr.size(); ++i) {
            JSONObject json = treeArr.getJSONObject(i);
            String id = json.getString("id");
            String order = i + 1 + "";
            SysMenu sm = new SysMenu();
            sm.setMenuId(id);
            sm.setSeq(new BigDecimal(order));
            list.add(sm);
            SysFunctionModules sysFunctionModules = new SysFunctionModules();
            SysFunctions sysFunctions = new SysFunctions();
            SysMenu sysMenu = (SysMenu)this.sysMenuManageService.getById((Serializable)((Object)id));
            if (ToolUtil.isNotEmpty((Object)sysMenu) && ToolUtil.isNotEmpty((Object)sysMenu.getFunctionModuleId())) {
                sysFunctionModules.setFunctionModuleId(sysMenu.getFunctionModuleId());
                sysFunctionModules.setSeq(new BigDecimal(order));
                functionModules.add(sysFunctionModules);
            }
            if (!ToolUtil.isNotEmpty((Object)sysMenu) || !ToolUtil.isNotEmpty((Object)sysMenu.getFunctionId())) continue;
            sysFunctions.setFunctionId(sysMenu.getFunctionId());
            sysFunctions.setSeq(new BigDecimal(order));
            functions.add(sysFunctions);
        }
        if (ToolUtil.isNotEmpty(list)) {
            this.sysMenuManageService.updateBatchById(list, list.size());
        }
        if (ToolUtil.isNotEmpty(functionModules)) {
            this.iSysFunctionModulesService.updateBatchById(functionModules, functionModules.size());
        }
        if (ToolUtil.isNotEmpty(functions)) {
            this.iSysFunctionsService.updateBatchById(functions, functions.size());
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/menuTreeChange"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequiresPermissions(value={"menu:menuTreeChange"})
    @BussinessLog(key="/frontMenu/menuTreeChange", type="20", value="\u83dc\u5355\u6811\u8f6c\u79fb")
    public ApiResponse<Tip> menuTreeChange(@RequestBody Map<String, String> map) {
        String menuId = map.get("menuId");
        SysMenu sysMenu = this.sysMenuManageService.getMenuById(menuId);
        SysMenu sysMenu1 = this.sysMenuManageService.getMenuById(sysMenu.getParentId());
        LogObjectHolder.me().set("transfer_before_parent", (Object)sysMenu1.getText());
        String parentId = map.get("parentId");
        SysMenu sysMenu2 = this.sysMenuManageService.getMenuById(parentId);
        LogObjectHolder.me().set("transfer_after_parent", (Object)sysMenu2.getText());
        this.sysMenuManageService.menuTreeChange(menuId, parentId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/singleMove"})
    @CacheEvict(value={"menu_info"}, allEntries=true)
    @RequiresPermissions(value={"menu:singleMove"})
    @BussinessLog(key="/frontMenu/singleMove", type="03", value="\u83dc\u5355\u6811\u4e0a\u79fb/\u83dc\u5355\u6811\u4e0b\u79fb")
    public ApiResponse<Object> updateMoveNode(@RequestBody Map<String, Object> map) {
        boolean isUp;
        String menuId = map.get("menuId") == null ? null : map.get("menuId").toString();
        boolean bl = isUp = map.get("isUp") != null && "true".equals(map.get("isUp").toString());
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.sysMenuManageService.updateMoveNode(menuId, isUp);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/exportMenu"})
    @RequiresPermissions(value={"menu:exportMenu"})
    @BussinessLog(key="/frontMenu/exportMenu", type="16", value="\u83dc\u5355\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String menuIds = super.getPara("menuIds") == null ? "" : super.getPara("menuIds");
        List<String> menuIdList = Arrays.asList(menuIds.split(","));
        this.sysMenuManageService.exportMenu(menuIdList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @RequiresPermissions(value={"menu:importData"})
    @BussinessLog(key="/frontMenu/importData", type="18", value="\u83dc\u5355\u5bfc\u5165")
    public ApiResponse<JSONObject> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        JSONObject result = this.sysMenuManageService.importMenuData(content);
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/recordMenu"})
    public void recordMenu(@RequestBody Map<String, Object> map) throws Exception {
        ShiroUser user = ShiroKit.getUser();
        JSONObject logContent = new JSONObject(true);
        logContent.put("operate_staff", (Object)user.getName());
        logContent.put("operate_time", (Object)DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        logContent.put("operate_type", (Object)"17");
        logContent.put("operate_action", map.get("title"));
        this.businessLog.saveBusinessLog("17", "/frontMenu/recordMenu", logContent.toJSONString(), map.get("title").toString());
    }

    @RequestMapping(value={"/syncDeleteMenuCache"})
    @BussinessLog(key="/frontMenu/syncDeleteMenuCache", type="02", value="\u83dc\u5355\u5220\u9664\u7f13\u5b58")
    public ApiResponse<Object> syncDeleteDictCache() {
        String userId = ShiroKit.getUser().getId();
        try {
            List arrayList = this.sysBaseConfigMapper.getAllClusterAddress();
            if (arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String url = (String)arrayList.get(i) + "/menu/deleteMenuCache";
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("userId", userId);
                    String string = HttpKit.sendPost((String)url, param);
                }
            }
            return ApiResponse.data((Object)SUCCESS_TIP);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
        }
    }
}

