/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.download;

import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.attachment.controller.AttachmentManagerController;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/download"})
public class DownloadController {
    private static Logger logger = LogManager.getLogger(AttachmentManagerController.class);
    @Value(value="${download.chromePath:}")
    private String chromePath;
    @Value(value="${download.helpDocPath:}")
    private String helpDocPath;

    @RequestMapping(value={"/chromeDownload"})
    @BussinessLog(key="/download/chromeDownload", type="03", value="\u6587\u4ef6\u4e0b\u8f7d")
    @ResponseBody
    public void chromeDownload(HttpServletResponse response) {
        File chromeFile = new File(this.chromePath);
        String fileName = chromeFile.getName();
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(this.chromePath)), 10240);
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            int len = 0;
            int i = ((InputStream)bis).available();
            byte[] buff = new byte[i];
            while ((len = ((InputStream)bis).read(buff)) > 0) {
                out.write(buff, 0, len);
                out.flush();
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u672a\u627e\u5230" + e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.FILE_NOT_FOUND);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u5f02\u5e38\uff1a" + e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.DOWNLOAD_ERROR);
        }
        catch (IOException e) {
            logger.error("IO\u5f02\u5e38\uff1a" + e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.DOWNLOAD_ERROR);
        }
    }

    @RequestMapping(value={"/helpDocDownload"})
    @BussinessLog(key="/download/helpDocDownload", type="03", value="\u6587\u4ef6\u4e0b\u8f7d")
    @ResponseBody
    public void helpDocDownload(HttpServletResponse response) {
        File chromeFile = new File(this.helpDocPath);
        String fileName = chromeFile.getName();
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(this.helpDocPath)), 10240);
             BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            int len = 0;
            int i = ((InputStream)bis).available();
            byte[] buff = new byte[i];
            while ((len = ((InputStream)bis).read(buff)) > 0) {
                out.write(buff, 0, len);
                out.flush();
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u672a\u627e\u5230" + e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.FILE_NOT_FOUND);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u5f02\u5e38\uff1a" + e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.DOWNLOAD_ERROR);
        }
        catch (IOException e) {
            logger.error("IO\u5f02\u5e38\uff1a" + e.getMessage());
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.DOWNLOAD_ERROR);
        }
    }
}

