/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.service.logdownload;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.Log4jUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logDownloadFront"})
public class LogDownLoadFrontController
extends BaseController {
    private static Map<String, String> FILE_PATH = new HashMap<String, String>();

    @RequiresPermissions(value={"logDownload:logTree"})
    @RequestMapping(value={"/logTree"})
    public ApiResponse<?> getLogTree() {
        List<JSTreeModel> result = new ArrayList<JSTreeModel>();
        String path = Log4jUtil.getLogPath();
        if (ToolUtil.isEmpty((Object)path)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65e5\u5fd7\u914d\u7f6e\u6587\u4ef6\u4e0d\u6b63\u786e\uff01");
        }
        String pathId = UUID.randomUUID().toString();
        if (!FILE_PATH.containsValue(path)) {
            FILE_PATH.put(pathId, path);
        }
        File file = new File(path);
        String rootName = file.getName();
        result = this.getLogDirectory(file, result);
        JSTreeModel root = new JSTreeModel();
        root.setId(rootName);
        root.setText("\u65e5\u5fd7\u76ee\u5f55");
        root.setParent("#");
        root.setType("root");
        root.setPath(LogDownLoadFrontController.getKey(FILE_PATH, path));
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequiresPermissions(value={"logDownload:logTable"})
    @RequestMapping(value={"/logTable"})
    public ApiResponse<Map<String, Object>> getLogTable(@RequestBody Map<String, String> body) {
        String pathId = body.get("pathId");
        String directory = FILE_PATH.get(pathId);
        Page page = new Page();
        List<Map<String, Object>> list = this.getFiles(directory);
        page.setRecords(list);
        page.setTotal((long)list.size());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", page.getRecords());
        map.put("code", "0");
        map.put("msg", "");
        map.put("count", page.getTotal());
        return ApiResponse.data(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"logDownload:download"})
    @RequestMapping(value={"/download"})
    @BussinessLog(key="/logDownloadFront/download", type="19", value="\u65e5\u5fd7\u6587\u4ef6\u4e0b\u8f7d")
    public void fileDownload(HttpServletResponse response) {
        String fileId = super.getPara("fileId");
        String filePath = FILE_PATH.get(fileId);
        File file = new File(filePath);
        String fileName = file.getName();
        BufferedInputStream bis = null;
        FilterOutputStream output = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file), 10240);
            fileName = URLEncoder.encode(file.getName(), "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            output = new BufferedOutputStream((OutputStream)response.getOutputStream());
            int len = 0;
            int i = bis.available();
            byte[] buff = new byte[i];
            while ((len = bis.read(buff)) > 0) {
                ((BufferedOutputStream)output).write(buff, 0, len);
                ((BufferedOutputStream)output).flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != bis) {
                    bis.close();
                }
                if (null != output) {
                    output.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private List<JSTreeModel> getLogDirectory(File file, List<JSTreeModel> resultFiles) {
        File[] files = file.listFiles();
        if (ToolUtil.isEmpty((Object)files)) {
            return resultFiles;
        }
        for (File f : files) {
            String filePath = f.getAbsolutePath();
            String pathId = UUID.randomUUID().toString();
            if (!FILE_PATH.containsValue(filePath)) {
                if (f.isFile()) {
                    if (filePath.endsWith(".log")) {
                        FILE_PATH.put(pathId, filePath);
                    }
                } else {
                    FILE_PATH.put(pathId, filePath);
                }
            }
            if (!f.isDirectory()) continue;
            JSTreeModel node = new JSTreeModel();
            node.setId(f.getName());
            node.setText(f.getName());
            node.setParent(f.getParentFile().getName());
            node.setType("directory");
            node.setPath(LogDownLoadFrontController.getKey(FILE_PATH, filePath));
            resultFiles.add(node);
            this.getLogDirectory(f, resultFiles);
        }
        return resultFiles;
    }

    private List<Map<String, Object>> getFiles(String directory) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        File file = new File(directory);
        File[] files = file.listFiles();
        if (ToolUtil.isEmpty((Object)files)) {
            return result;
        }
        for (File f : files) {
            String filePath;
            if (!f.isFile() || !file.getPath().equals(f.getParent()) || !(filePath = f.getAbsolutePath()).endsWith(".log")) continue;
            if (!FILE_PATH.containsValue(filePath)) {
                String uuid = UUID.randomUUID().toString();
                FILE_PATH.put(uuid, filePath);
            }
            HashMap<String, Object> node = new HashMap<String, Object>(3);
            node.put("fileId", LogDownLoadFrontController.getKey(FILE_PATH, filePath));
            node.put("fileName", f.getName());
            node.put("fileSize", f.length() / 1024L);
            node.put("fileLastEditTime", this.formatDate(f.lastModified()));
            result.add(node);
        }
        return result;
    }

    private String formatDate(long timestamp) {
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        date.setTime(timestamp);
        return DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    private static String getKey(Map<String, String> map, String value) {
        String key = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            key = entry.getKey();
        }
        return key;
    }
}

