/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.organ.dictmap.StruDict;
import com.jxdinfo.hussar.bsp.organ.model.SysOffice;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.model.SysStruRule;
import com.jxdinfo.hussar.bsp.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrgService;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrganService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.tenant.model.SysTenant;
import com.jxdinfo.hussar.bsp.tenant.service.SysTenantService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.log.BussinessLogService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/orgMainFront"})
public class SysOrgManageFrontController
extends BaseController {
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysOrganService iSysOrganService;
    @Resource
    ISysStruAuditService iSysStruAuditService;
    @Resource
    private ISysOrgService iSysOrgService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    ISysStruService sysStruService;
    @Resource
    private ISysOfficeService sysOfficeService;
    @Resource
    private BussinessLogService bussinessLogService;
    @Resource
    private SysTenantService sysTenantService;

    @RequiresPermissions(value={"orgMain:orgTree"})
    @RequestMapping(value={"/orgTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> orgTree(@RequestBody Map<String, Object> map) {
        String isEmployee = map.get("isEmployee") == null ? null : map.get("isEmployee").toString();
        String isExport = map.get("isExport") == null ? null : map.get("isExport").toString();
        String resourceId = map.get("resourceId") == null ? null : map.get("resourceId").toString();
        String type = map.get("type") == null ? null : map.get("type").toString();
        String handle = map.get("handle") == null ? null : map.get("handle").toString();
        String parentId = map.get("parentId") == null ? null : map.get("parentId").toString();
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysOrgService.getOrgTreeVue(isEmployee, isExport, resourceId, type, handle, parentId)));
    }

    @RequiresPermissions(value={"orgMainFront:getDeReTree"})
    @RequestMapping(value={"/getDelegateRetrieveTree"})
    @BussinessLog(key="/orgMainFront/getDelegateRetrieveTree", type="04", value="\u67e5\u8be2\u56de\u6536\u4e0b\u653e\u6811")
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> getStruParentId(@RequestBody Map<String, Object> map) {
        String isEmployee = map.get("isEmployee") == null ? null : map.get("isEmployee").toString();
        String isExport = map.get("isExport") == null ? null : map.get("isExport").toString();
        String resourceId = map.get("resourceId") == null ? null : map.get("resourceId").toString();
        String type = map.get("type") == null ? null : map.get("type").toString();
        String handle = map.get("handle") == null ? null : map.get("handle").toString();
        String parentId = map.get("parentId") == null ? null : map.get("parentId").toString();
        List list = this.iSysOrgService.getOrgTreeVue(isEmployee, isExport, resourceId, type, handle, parentId);
        List idList = this.iSysOrgService.getAllParentId();
        if (ToolUtil.isNotEmpty((Object)idList)) {
            for (JSTreeModel jsTreeModel : list) {
                String treeId = jsTreeModel.getId();
                if (!idList.contains(treeId)) continue;
                jsTreeModel.setState(false, false, true);
            }
        }
        return ApiResponse.data(ForestNodeMerger.merge(list));
    }

    @RequiresPermissions(value={"orgMain:orgTree"})
    @RequestMapping(value={"/orgResourceStruId"})
    @BussinessLog(key="/orgMainFront/orgResourceStruId", type="04", value="\u83b7\u53d6\u4e0b\u653e\u8d44\u6e90\u7684\u7ec4\u7ec7\u673a\u6784id")
    @ResponseBody
    public ApiResponse<List<String>> orgResourceStruId(@RequestBody Map<String, Object> map) {
        String resourceId = map.get("resourceId") == null ? "" : map.get("resourceId").toString();
        String type = map.get("type") == null ? "" : map.get("type").toString();
        return ApiResponse.data((Object)this.iSysOrgService.getResourceStruId(resourceId, type));
    }

    @RequiresPermissions(value={"orgMain:orgTreeById"})
    @RequestMapping(value={"/orgTreeById"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> orgTreeById(@RequestBody Map<String, Object> map, HttpServletRequest request) {
        String orgId = map.get("orgId") == null ? null : map.get("orgId").toString();
        String isEmployee = map.get("isEmployee") == null ? null : map.get("isEmployee").toString();
        String isHead = map.get("isRoot") == null ? null : map.get("isRoot").toString();
        List result = this.orgMaintenanceService.getOrgTreeByIdVue(orgId, isEmployee, isHead);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/orgInfo"})
    @RequiresPermissions(value={"orgMain:orgInfo"})
    @ResponseBody
    public ApiResponse<SysOrganVo> orgInfo(@RequestBody Map<String, String> map) {
        String struId = map.get("struId");
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(struId);
        return ApiResponse.data((Object)orgInfo);
    }

    @RequestMapping(value={"/orgInfoAdd"})
    @RequiresPermissions(value={"orgMain:add"})
    @ResponseBody
    public ApiResponse<Map<String, Object>> orgInfoAdd(@RequestBody Map<String, Object> map) {
        String orgParentId = map.get("orgParentId") == null ? null : map.get("orgParentId").toString();
        String orgType = map.get("orgType") == null ? null : map.get("orgType").toString();
        String orgTypeName = map.get("orgTypeName") == null ? null : map.get("orgTypeName").toString();
        String childNum = map.get("childNum") == null ? null : map.get("childNum").toString();
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(orgParentId);
        String orgParentCode = "";
        String orgParentName = "";
        String parentTypeCode = "";
        if (ToolUtil.isNotEmpty((Object)orgInfo)) {
            orgParentCode = orgInfo.getOrganCode();
            if (ToolUtil.isEmpty((Object)orgParentCode)) {
                orgParentCode = "";
            }
            orgParentName = orgInfo.getOrganName();
            parentTypeCode = orgInfo.getParentTypeCode();
            if (ToolUtil.isEmpty((Object)parentTypeCode)) {
                parentTypeCode = "";
            }
        }
        String businessName = "STRU_CODE";
        String tableName = "SYS_STRU";
        String currentCode = this.sysIdtableService.getCurrentCode(businessName, tableName, orgParentCode);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("currentCode", currentCode);
        dataMap.put("orgInfo", null);
        dataMap.put("orgType", orgType);
        dataMap.put("orgParentId", orgParentId);
        dataMap.put("orgParentCode", orgParentCode);
        dataMap.put("orgParentName", orgParentName);
        if (ToolUtil.isNotEmpty((Object)orgInfo)) {
            dataMap.put("struLevel", orgInfo.getStruLevel());
        } else {
            dataMap.put("struLevel", "0");
        }
        dataMap.put("childNum", childNum);
        dataMap.put("orgTypeName", orgTypeName);
        dataMap.put("parentTypeCode", parentTypeCode);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"orgMain:edit"})
    @RequestMapping(value={"/orgInfoEdit"})
    @ResponseBody
    public ApiResponse<SysOrganVo> orgInfoEdit(@RequestBody Map<String, String> map) {
        String orgId = map.get("orgId");
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(orgId);
        return ApiResponse.data((Object)orgInfo);
    }

    @RequestMapping(value={"/struRoleInfo"})
    @ResponseBody
    public ApiResponse<ArrayList<Object>> getStruRoleInfo(@RequestBody Map<String, String> map) {
        String id = map.get("struId") == null ? "" : map.get("struId").trim();
        ArrayList list = this.orgMaintenanceService.getStruRole(id);
        return ApiResponse.data((Object)list);
    }

    @RequestMapping(value={"/getOrgRoleByCode"})
    @ResponseBody
    public ApiResponse<Object> getOrgRoleByCode(@RequestBody Map<String, Object> map) {
        String orgType = map.get("orgType") == null ? null : map.get("orgType").toString();
        String isRoot = map.get("isRoot") == null ? null : map.get("isRoot").toString();
        return ApiResponse.data((Object)this.orgMaintenanceService.getOrgRoleByCode(orgType, isRoot));
    }

    @RequestMapping(value={"/getExitOrgRoleByCode"})
    @ResponseBody
    public ApiResponse<Boolean> getExitOrgRoleByCode(@RequestBody Map<String, Object> map) {
        SysStruRule sysStruRule;
        String orgType = map.get("orgType") == null ? null : map.get("orgType").toString();
        String isRoot = map.get("isRoot") == null ? null : map.get("isRoot").toString();
        List ruleList = this.orgMaintenanceService.getOrgRoleByCode(orgType, isRoot);
        boolean result = true;
        boolean isEmpl = false;
        if (ruleList != null && ruleList.size() == 1 && "9".equals((sysStruRule = (SysStruRule)ruleList.get(0)).getSysOrganType())) {
            isEmpl = true;
        }
        if (ruleList != null && ruleList.size() == 0 || isEmpl) {
            result = false;
        }
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(value={"/orgInfoSave"})
    @RequiresPermissions(value={"orgMain:orgInfoSave"})
    @ResponseBody
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    public ApiResponse<JSONObject> orgInfoSave(@RequestBody Map<String, Object> map) {
        SysStru sysStru = new SysStru();
        SysOrgan sysOrgan = new SysOrgan();
        SysOffice sysOffice = new SysOffice();
        sysStru.setStruId(null);
        sysStru.setStruType(map.get("struType") == null ? null : map.get("struType").toString());
        sysStru.setOrganAlias(map.get("organAlias") == null ? null : map.get("organAlias").toString());
        sysStru.setParentId(map.get("parentId") == null ? null : map.get("parentId").toString());
        sysStru.setPrincipalId(map.get("principalId") == null ? null : map.get("principalId").toString());
        sysStru.setStruLevel(new BigDecimal(map.get("struLevel") == null ? "1" : map.get("struLevel").toString()));
        sysStru.setStruOrder(new BigDecimal(map.get("struOrder") == null ? "1" : map.get("struOrder").toString()));
        sysStru.setRoleIds(map.get("roleIds") == null ? null : map.get("roleIds").toString());
        sysStru.setIsPermission(map.get("isPermission") == null ? null : map.get("isPermission").toString());
        sysStru.setTenantId(map.get("tenantId") == null ? null : map.get("tenantId").toString());
        sysOrgan.setOrganCode(map.get("organCode") == null ? null : map.get("organCode").toString());
        sysOrgan.setOrganName(map.get("organName") == null ? null : map.get("organName").toString());
        sysOrgan.setShortName(map.get("shortName") == null ? null : map.get("shortName").toString());
        sysOrgan.setOrganType(map.get("organType") == null ? null : map.get("organType").toString());
        sysOrgan.setBeginDate(map.get("beginDate") == null ? null : map.get("beginDate").toString());
        sysOrgan.setEndDate(map.get("endDate") == null ? null : map.get("endDate").toString());
        sysOrgan.setParentTypeCode(map.get("parentTypeCode") == null ? null : map.get("parentTypeCode").toString());
        sysOffice.setOfficeAlias(map.get("officeAlias") == null ? null : map.get("officeAlias").toString());
        sysOffice.setOfficeAddress(map.get("officeAddress") == null ? null : map.get("officeAddress").toString());
        if (ToolUtil.isEmpty((Object)sysStru.getOrganAlias())) {
            sysStru.setOrganAlias(sysOrgan.getOrganName());
        }
        sysStru.setOrganId(null);
        sysStru.setIsLeaf("0");
        sysStru.setInUse("1");
        sysStru.setStruPath("");
        sysOrgan.setOrganId(null);
        sysOrgan.setInUse("1");
        sysStru.setStruLevel(sysStru.getStruLevel().add(new BigDecimal(1)));
        long orderTree = 1L;
        Long maxOrder = this.orgMaintenanceService.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1L;
        }
        BigDecimal struOrder = BigDecimal.valueOf(orderTree);
        sysStru.setStruOrder(struOrder);
        return ApiResponse.data((Object)this.orgMaintenanceService.orgInfoSaveVue(sysStru, sysOrgan, null, sysOffice, Boolean.valueOf(true), Boolean.valueOf(false)));
    }

    @RequestMapping(value={"/orgInfoEditSave"})
    @RequiresPermissions(value={"orgMain:orgInfoEditSave"})
    @ResponseBody
    public ApiResponse<JSONObject> orgInfoEditSave(@RequestBody Map<String, Object> map) {
        SysStru sysStru = new SysStru();
        SysOrgan sysOrgan = new SysOrgan();
        SysOffice sysOffice = new SysOffice();
        sysStru.setStruId(map.get("struId") == null ? null : map.get("struId").toString());
        sysStru.setStruType(map.get("struType") == null ? null : map.get("struType").toString());
        sysStru.setOrganId(map.get("organId") == null ? null : map.get("organId").toString());
        sysStru.setOrganAlias(map.get("organAlias") == null ? null : map.get("organAlias").toString());
        sysStru.setParentId(map.get("parentId") == null ? null : map.get("parentId").toString());
        sysStru.setPrincipalId(map.get("principalId") == null ? null : map.get("principalId").toString());
        sysStru.setStruLevel(new BigDecimal(map.get("struLevel") == null ? "1" : map.get("struLevel").toString()));
        sysStru.setStruOrder(new BigDecimal(map.get("struOrder") == null ? "1" : map.get("struOrder").toString()));
        sysStru.setRoleIds(map.get("roleIds") == null ? null : map.get("roleIds").toString());
        sysStru.setIsPermission(map.get("isPermission") == null ? null : map.get("isPermission").toString());
        sysStru.setTenantId(map.get("tenantId") == null ? null : map.get("tenantId").toString());
        sysOrgan.setOrganId(map.get("organId") == null ? null : map.get("organId").toString());
        sysOrgan.setOrganCode(map.get("organCode") == null ? null : map.get("organCode").toString());
        sysOrgan.setOrganName(map.get("organName") == null ? null : map.get("organName").toString());
        sysOrgan.setShortName(map.get("shortName") == null ? null : map.get("shortName").toString());
        sysOrgan.setOrganType(map.get("organType") == null ? null : map.get("organType").toString());
        sysOrgan.setBeginDate(map.get("beginDate") == null ? null : map.get("beginDate").toString());
        sysOrgan.setEndDate(map.get("endDate") == null ? null : map.get("endDate").toString());
        sysOffice.setOfficeId(map.get("officeId") == null ? null : map.get("officeId").toString());
        sysOffice.setStruId(map.get("struId") == null ? null : map.get("struId").toString());
        sysOffice.setOfficeAlias(map.get("officeAlias") == null ? null : map.get("officeAlias").toString());
        sysOffice.setOfficeAddress(map.get("officeAddress") == null ? null : map.get("officeAddress").toString());
        if (!this.iSysStruAuditService.checkCanOperate(sysStru.getStruId())) {
            return ApiResponse.fail((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
        if (ToolUtil.isEmpty((Object)sysStru.getOrganAlias())) {
            sysStru.setOrganAlias(sysOrgan.getOrganName());
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"PARENT_ID", (Object)sysStru.getParentId());
        ew.eq((Object)"IN_USE", (Object)"1");
        ew.eq((Object)"STRU_ORDER", (Object)sysStru.getStruOrder());
        ew.ne((Object)"STRU_ID", (Object)sysStru.getStruId());
        int num = this.sysStruService.count((Wrapper)ew);
        if (num > 0) {
            return ApiResponse.fail((String)"\u6392\u5e8f\u503c\u5df2\u5b58\u5728\uff01");
        }
        SysOrgan sysOrgan1 = (SysOrgan)this.iSysOrganService.getById((Serializable)((Object)sysOrgan.getOrganId()));
        SysStru sysStru1 = (SysStru)this.sysStruService.getById((Serializable)((Object)sysStru.getStruId()));
        if (sysStru1.getStruId().equals(sysStru1.getPermissionStruId())) {
            sysStru1.setIsPermission("1");
        } else {
            sysStru1.setIsPermission("0");
        }
        SysOffice sysOffice1 = (SysOffice)this.sysOfficeService.getById((Serializable)((Object)sysOffice.getOfficeId()));
        Map map1 = (Map)JSON.parseObject((String)JSON.toJSONString((Object)sysOrgan1), Map.class);
        Map map2 = (Map)JSON.parseObject((String)JSON.toJSONString((Object)sysStru1), Map.class);
        Map map3 = (Map)JSON.parseObject((String)JSON.toJSONString((Object)sysOffice1), Map.class);
        HashMap<String, Object> map4 = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)map1)) {
            map4.putAll(map1);
        }
        if (ToolUtil.isNotEmpty((Object)map2)) {
            map4.putAll(map2);
        }
        if (ToolUtil.isNotEmpty((Object)map3)) {
            map4.putAll(map3);
        }
        map4.put("orgParentName", map.get("orgParentName"));
        SysTenant sysTenant = (SysTenant)this.sysTenantService.getById((Serializable)((Object)sysStru1.getTenantId()));
        if (ToolUtil.isNotEmpty((Object)sysTenant)) {
            map4.put("tenantName", sysTenant.getTenantName());
        }
        LogObjectHolder.me().set(map4);
        return ApiResponse.data((Object)this.orgMaintenanceService.orgInfoSaveVue(sysStru, sysOrgan, null, sysOffice, Boolean.valueOf(false), Boolean.valueOf(false)));
    }

    @RequestMapping(value={"/orgTreeOrder"})
    @ResponseBody
    @RequiresPermissions(value={"orgMain:orgTreeOrder"})
    public ApiResponse<Object> orgTreeOrder(@RequestBody Map<String, String> map) {
        String treeInfo = map.get("treeInfo");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        if (treeArr.size() > 0) {
            this.orgMaintenanceService.saveOrgTreeOrder(treeArr);
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"orgMain:del"})
    @RequestMapping(value={"/delOrgById"})
    @BussinessLog(key="/orgMainFront/delOrgById", type="02", value="\u7ec4\u7ec7\u673a\u6784\u5220\u9664", dict=StruDict.class)
    @ResponseBody
    public ApiResponse<JSONObject> delOrgById(@RequestBody Map<String, String> map) {
        String struId = map.get("struId");
        SysOrgan sysOrgan = this.sysStruService.getOrganInfoByDeparmentId(struId);
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("organName", sysOrgan.getOrganName());
        LogObjectHolder.me().set("edit_object_after", map1);
        JSONObject result = this.orgMaintenanceService.delOrgByIdVue(struId, Boolean.valueOf(false));
        if (result.getBoolean("success").booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)result.getString("msg"));
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)result.getString("msg"));
    }

    @RequiresPermissions(value={"orgMainFront:principalSelect"})
    @RequestMapping(value={"principalSelect"})
    @ResponseBody
    public ApiResponse<JSONObject> principalSelect(@RequestBody Map<String, Object> map) {
        int curr = map.get("curr") == null ? 1 : Integer.parseInt(map.get("curr").toString());
        int nums = map.get("nums") == null ? 10 : Integer.parseInt(map.get("nums").toString());
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        String userName = map.get("userName") == null ? null : map.get("userName").toString();
        String departmentName = map.get("departmentName") == null ? null : map.get("departmentName").toString();
        SysStru sysStru = (SysStru)this.orgMaintenanceService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)shiroUser.getDeptId()));
        String permissionStruId = sysStru.getPermissionStruId();
        if (shiroUser.getTenantCode().equals("000000")) {
            permissionStruId = null;
        }
        if (ToolUtil.isNotEmpty((Object)curr) && ToolUtil.isNotEmpty((Object)nums)) {
            Page page = new Page((long)curr, (long)nums);
            Map dataScopeMap = ShiroFactroy.me().getDataScopeInfo(shiroUser);
            String dataScopeType = dataScopeMap.get("data_scope_type").toString();
            if (isGradeAdmin) {
                page = this.orgMaintenanceService.getPrincipalSelectList(page, userName, departmentName, shiroUser.getDeptId());
            } else if ("1".equals(dataScopeType)) {
                page = this.orgMaintenanceService.getPrincipalSelectListByPermissionStruId(page, userName, departmentName, permissionStruId);
            } else {
                Set orgList = (Set)dataScopeMap.get("data_scope_list");
                page = this.orgMaintenanceService.getPrincipalSelectListByOrgIds(page, userName, departmentName, orgList, dataScopeType);
            }
            JSONObject json = new JSONObject();
            json.put("data", (Object)page.getRecords());
            json.put("code", (Object)"0");
            json.put("msg", (Object)"");
            json.put("count", (Object)page.getTotal());
            return ApiResponse.data((Object)json);
        }
        JSONObject json = new JSONObject();
        json.put("data", null);
        json.put("code", (Object)"500");
        json.put("msg", (Object)"\u53c2\u6570\u4e0d\u7b26\uff01");
        json.put("count", null);
        return ApiResponse.data((Object)json);
    }

    @RequiresPermissions(value={"orgMain:orgChangeById"})
    @RequestMapping(value={"/orgChangeById"})
    @ResponseBody
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    public ApiResponse<List<JSTreeModel>> orgChangeById(@RequestBody Map<String, Object> map, HttpServletRequest request) {
        String isEmployee = map.get("isEmployee") == null ? null : map.get("isEmployee").toString();
        String isExport = map.get("isExport") == null ? null : map.get("isExport").toString();
        String resourceId = map.get("resourceId") == null ? null : map.get("resourceId").toString();
        String type = map.get("type") == null ? null : map.get("type").toString();
        String handle = map.get("handle") == null ? null : map.get("handle").toString();
        String parentId = map.get("parentId") == null ? null : map.get("parentId").toString();
        List result = this.iSysOrgService.getOrgTreeVue(isEmployee, isExport, resourceId, type, handle, parentId);
        for (JSTreeModel jsTreeModel : result) {
            jsTreeModel.setChildren("false");
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/orgTreeChange"})
    @ResponseBody
    @BussinessLog(key="/orgMainFront/orgTreeChange", type="20", value="\u7ec4\u7ec7\u673a\u6784\u8f6c\u79fb", pk="orgName")
    @RequiresPermissions(value={"orgMain:orgTreeChange"})
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    public ApiResponse<JSONObject> orgTreeChange(@RequestBody Map<String, Object> map) {
        String orgId = map.get("orgId") == null ? null : map.get("orgId").toString();
        String parentId = map.get("parentId") == null ? null : map.get("parentId").toString();
        String orgType = map.get("orgType") == null ? null : map.get("orgType").toString();
        String isRoot = map.get("isRoot") == null ? null : map.get("isRoot").toString();
        String changeLevel = map.get("changeLevel") == null ? null : map.get("changeLevel").toString();
        SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)((Object)orgId));
        SysOrgan sysOrgan = (SysOrgan)this.iSysOrganService.getById((Serializable)((Object)sysStru.getOrganId()));
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("orgName", sysOrgan.getOrganName());
        LogObjectHolder.me().set("transfer_before_name", map1);
        JSONObject result = this.orgMaintenanceService.orgTreeChangeVue(orgId, parentId, orgType, isRoot, changeLevel, Boolean.valueOf(false));
        if (result.getBoolean("success").booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)result.getString("msg"));
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)result.getString("msg"));
    }

    @RequestMapping(value={"/singleMove"})
    @ResponseBody
    @BussinessLog(key="/orgMainFront/singleMove", type="03", pk="orgName", value="\u7ec4\u7ec7\u673a\u6784\u4e0a\u79fb/\u7ec4\u7ec7\u673a\u6784\u4e0b\u79fb", dict=StruDict.class)
    @RequiresPermissions(value={"orgMain:singleMove"})
    public ApiResponse<Tip> updateMoveNode(@RequestBody Map<String, Object> map) {
        String orgId = map.get("orgId") == null ? null : map.get("orgId").toString();
        boolean isUp = map.get("isUp") != null && Boolean.parseBoolean(map.get("isUp").toString());
        SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)((Object)orgId));
        SysOrgan sysOrgan = (SysOrgan)this.iSysOrganService.getById((Serializable)((Object)sysStru.getOrganId()));
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("orgName", sysOrgan.getOrganName());
        LogObjectHolder.me().set(map1);
        if (ToolUtil.isEmpty((Object)orgId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.orgMaintenanceService.updateMoveNode(orgId, isUp);
        return ApiResponse.success((String)"\u79fb\u52a8\u6210\u529f");
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"orgMain:exportData"})
    @BussinessLog(key="/orgMainFront/exportData", type="16", value="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.orgMaintenanceService.exportData(idList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @ResponseBody
    @RequiresPermissions(value={"orgMain:importData"})
    @BussinessLog(key="/orgMainFront/importData", type="18", value="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u5165")
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    public ApiResponse<Object> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return ApiResponse.data((Object)this.orgMaintenanceService.importVueOrg(content));
    }

    @RequestMapping(value={"/isAudit"})
    @ResponseBody
    public ApiResponse<?> isAudit() {
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isOrganAudit()) {
            return ApiResponse.data((Object)true);
        }
        return ApiResponse.data((Object)false);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/isPermissionStru"})
    @ResponseBody
    public JSONObject isPermissionStru(@RequestBody Map<String, Object> map) throws Exception {
        String type = map.get("type") == null ? null : map.get("type").toString();
        String struId = map.get("struId") == null ? null : map.get("struId").toString();
        return this.orgMaintenanceService.isPermissionStru(type, struId);
    }

    @RequestMapping(value={"/queryUserTree"})
    @ResponseBody
    @BussinessLog(key="/orgMainFront/queryUserTree", type="04", value="\u7528\u6237\u6811\u641c\u7d22")
    public ApiResponse<List<JSTreeModel>> queryUserTree(@RequestParam(value="userName", required=false) String userName) {
        return ApiResponse.data(ForestNodeMerger.merge(this.orgMaintenanceService.getSpecialUserTree(userName, "0", "0")));
    }
}

