/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.utils;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConvertBeanUtil {
    public static Map convertBean(Object bean) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Class<?> type = bean.getClass();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String propertyName = descriptor.getName();
                if (propertyName.equals("class")) continue;
                Method readMethod = descriptor.getReadMethod();
                Object result = readMethod.invoke(bean, new Object[0]);
                if (result != null) {
                    returnMap.put(propertyName, result);
                    continue;
                }
                returnMap.put(propertyName, "");
            }
        }
        catch (Exception e) {
            return null;
        }
        return returnMap;
    }

    public static <T> List<Map<String, Object>> convertListBean(List<T> beanList, Class<T> T) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        try {
            int n = beanList.size();
            for (int i = 0; i < n; ++i) {
                T bean = beanList.get(i);
                Map map = ConvertBeanUtil.convertBean(bean);
                mapList.add(map);
            }
        }
        catch (Exception e) {
            return null;
        }
        return mapList;
    }
}

