/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.tenant;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.datasource.dao.SysDataSourceMapper;
import com.jxdinfo.hussar.bsp.datasource.model.SysDataSource;
import com.jxdinfo.hussar.bsp.tenant.model.SysTenant;
import com.jxdinfo.hussar.bsp.tenant.service.SysTenantService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.constant.dictmap.TenantDict;
import com.jxdinfo.hussar.common.log.BussinessLogService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant"})
@Master
public class SysTenantController
extends BaseController {
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private BussinessLogService bussinessLogService;
    @Resource
    private SysDataSourceMapper sysDataSourceMapper;

    @RequiresPermissions(value={"tenant:detail"})
    @RequestMapping(value={"/detail"})
    public ApiResponse<SysTenant> detail(@RequestBody Map<String, Object> map) {
        String tenantId = map.get("tenantId") == null ? "" : map.get("tenantId").toString();
        return this.sysTenantService.getDetail(tenantId);
    }

    @RequiresPermissions(value={"tenant:list"})
    @RequestMapping(value={"/list"})
    public ApiResponse<Map<String, Object>> list(@RequestBody Map<String, Object> map) {
        String tenantName = map.get("tenantName") == null ? "" : map.get("tenantName").toString();
        String domain = map.get("tenantDomain") == null ? "" : map.get("tenantDomain").toString();
        String page = map.get("page") == null ? "1" : map.get("page").toString();
        String limit = map.get("limit") == null ? "10" : map.get("limit").toString();
        return ApiResponse.data((Object)this.sysTenantService.queryList(tenantName, domain, page, limit));
    }

    @RequiresPermissions(value={"tenant:add"})
    @RequestMapping(value={"/add"})
    @BussinessLog(key="/tenant/add", value="\u65b0\u589e\u79df\u6237", type="01", dict=TenantDict.class)
    public ApiResponse<SysTenant> add(@RequestBody SysTenant sysTenant) {
        return this.sysTenantService.add(sysTenant, false);
    }

    @RequiresPermissions(value={"tenant:edit"})
    @RequestMapping(value={"/edit"})
    @BussinessLog(key="/tenant/edit", value="\u4fee\u6539\u79df\u6237", type="03", dict=TenantDict.class, pk="tenantName")
    public ApiResponse<SysTenant> edit(@RequestBody SysTenant sysTenant) {
        SysTenant sysTenant1 = (SysTenant)this.sysTenantService.getById((Serializable)((Object)sysTenant.getTenantId()));
        sysTenant1.setTenantCode("");
        if (ToolUtil.isNotEmpty((Object)sysTenant1.getDbId())) {
            SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceMapper.selectById((Serializable)((Object)sysTenant1.getDbId()));
            sysTenant1.setDbName(sysDataSource.getDbName());
        }
        LogObjectHolder.me().set((Object)sysTenant1);
        return this.sysTenantService.edit(sysTenant);
    }

    @RequiresPermissions(value={"tenant:remove"})
    @RequestMapping(value={"/remove"})
    @BussinessLog(key="/tenant/remove", value="\u5220\u9664\u79df\u6237", type="02", dict=TenantDict.class)
    public ApiResponse<SysTenant> remove(@RequestBody Map<String, Object> map) {
        String ids = map.get("ids") == null ? "" : map.get("ids").toString();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"TENANT_ID", Arrays.asList(ids.split(",")));
        List sysTenantList = this.sysTenantService.list((Wrapper)queryWrapper);
        ArrayList<String> list = new ArrayList<String>();
        for (SysTenant sysTenant : sysTenantList) {
            list.add(sysTenant.getTenantName());
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("tenantName", StringUtils.join((Object[])list.toArray(), (String)","));
        LogObjectHolder.me().set("edit_object_after", map1);
        boolean type = map.get("type") != null && (Boolean)map.get("type") != false;
        return this.sysTenantService.delete(ids, type);
    }

    @RequestMapping(value={"/devolution"})
    public ApiResponse<String> devolutionAuthority(@RequestBody Map<String, Object> map) {
        List authorityMap = map.get("authority") == null ? null : (List)map.get("authority");
        String tenantId = map.get("tenantId") == null ? "" : map.get("tenantId").toString();
        SysTenant sysTenant = (SysTenant)this.sysTenantService.getById((Serializable)((Object)tenantId));
        ArrayList resources = new ArrayList();
        for (int i = 0; i < authorityMap.size(); ++i) {
            resources.add(((Map)authorityMap.get(i)).get("text"));
        }
        StringBuffer result = new StringBuffer();
        result.append("\"" + ShiroKit.getUser().getName() + "\"");
        result.append(" \u5728 " + DateUtil.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        result.append(" \u8fdb\u884c\u4e86 \"\u6743\u9650\u4e0b\u653e\" \u64cd\u4f5c\u3002\n");
        result.append("\u4e0b\u653e\u79df\u6237\uff1a\"" + sysTenant.getTenantName() + "\"\n");
        result.append("\u4e0b\u653e\u8d44\u6e90\uff1a" + StringUtils.join((Object[])resources.toArray(), (String)","));
        this.bussinessLogService.saveBusinessLog("01", "/tenant/devolution", result.toString(), "\u6743\u9650\u4e0b\u653e");
        return this.sysTenantService.devolutionAuthority(authorityMap, tenantId);
    }

    @RequiresPermissions(value={"tenant:getTenantCode"})
    @RequestMapping(value={"/getTenantCode"})
    @BussinessLog(key="/tenant/getTenantCode", value="\u83b7\u53d6\u79df\u6237\u7f16\u53f7", type="04")
    public ApiResponse<String> getModuleCode() {
        return ApiResponse.data((Object)this.sysTenantService.getTenantCode());
    }

    @RequestMapping(value={"/obtainSchema"})
    public ApiResponse<Map<String, Object>> obtainSchema() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tenantOpen", this.globalProperties.isTenantOpen());
        result.put("level", this.globalProperties.getTenantLevel());
        result.put("userModel", this.globalProperties.getTenantUserModel());
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/syncTenantUser"})
    public ApiResponse<?> syncTenantUser(@RequestParam(value="tenantCode") String tenantCode) {
        return this.sysTenantService.syncTenantUser(tenantCode);
    }

    @RequestMapping(value={"/getTenantTree"})
    public ApiResponse<List<JSTreeModel>> getTenantTree() {
        return ApiResponse.data(ForestNodeMerger.merge(this.sysTenantService.getTenantTree()));
    }

    @RequestMapping(value={"/getAllTenantTree"})
    public ApiResponse<List<JSTreeModel>> getAllTenantTree(@RequestParam(required=false) String flag) {
        return ApiResponse.data(ForestNodeMerger.merge(this.sysTenantService.getAllTenantTree(flag)));
    }
}

