/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.datasource;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.datasource.model.SysDataSource;
import com.jxdinfo.hussar.bsp.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.constant.dictmap.SysDataSourceDict;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource"})
@Master
public class SysDataSourceController {
    @Resource
    private SysDataSourceService sysDataSourceService;
    @Resource
    private GlobalProperties globalProperties;

    @RequiresPermissions(value={"datasource:detail"})
    @RequestMapping(value={"/detail"})
    public ApiResponse<SysDataSource> detail(@RequestBody Map<String, Object> map) {
        String dbId = map.get("dbId") == null ? "" : map.get("dbId").toString();
        return this.sysDataSourceService.getDetail(dbId);
    }

    @RequiresPermissions(value={"datasource:list"})
    @RequestMapping(value={"/list"})
    public ApiResponse<Map<String, Object>> list(@RequestBody Map<String, Object> map) {
        String dbName = map.get("dbName") == null ? "" : map.get("dbName").toString();
        String driverClass = map.get("driverClass") == null ? "" : map.get("driverClass").toString();
        String page = map.get("page") == null ? "1" : map.get("page").toString();
        String limit = map.get("limit") == null ? "10" : map.get("limit").toString();
        String status = map.get("status") == null ? "" : map.get("status").toString();
        return ApiResponse.data((Object)this.sysDataSourceService.queryList(dbName, driverClass, page, limit, status));
    }

    @RequiresPermissions(value={"datasource:add"})
    @RequestMapping(value={"/add"})
    @BussinessLog(key="/datasource/add", value="\u65b0\u589e\u6570\u636e\u6e90", type="01", dict=SysDataSourceDict.class)
    public ApiResponse<SysDataSource> add(@RequestBody SysDataSource sysDatasource) {
        return this.sysDataSourceService.add(sysDatasource);
    }

    @RequiresPermissions(value={"datasource:checkDataSource"})
    @RequestMapping(value={"/checkDataSource"})
    @BussinessLog(key="/datasource/checkDataSource", value="\u65b0\u589e\u6570\u636e\u6e90", type="01", dict=SysDataSourceDict.class)
    public ApiResponse<SysDataSource> checkDataSource(@RequestBody SysDataSource sysDataSource) {
        return this.sysDataSourceService.checkDataSource(sysDataSource, false);
    }

    @RequiresPermissions(value={"datasource:checkDataSource"})
    @RequestMapping(value={"/checkSource"})
    @BussinessLog(key="/datasource/checkSource", value="\u68c0\u67e5\u6570\u636e\u6e90", type="04")
    public ApiResponse<SysDataSource> checkSource(@RequestBody SysDataSource sysDataSource) {
        return this.sysDataSourceService.checkDataSource(sysDataSource, true);
    }

    @RequiresPermissions(value={"datasource:edit"})
    @RequestMapping(value={"/edit"})
    @BussinessLog(key="/datasource/edit", value="\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f", type="03", dict=SysDataSourceDict.class, pk="dbName")
    public ApiResponse<SysDataSource> edit(@RequestBody SysDataSource sysDatasource) {
        SysDataSource oldDataSource = (SysDataSource)this.sysDataSourceService.getById((Serializable)((Object)sysDatasource.getDbId()));
        LogObjectHolder.me().set((Object)oldDataSource);
        return this.sysDataSourceService.edit(sysDatasource);
    }

    @RequiresPermissions(value={"datasource:remove"})
    @RequestMapping(value={"/remove"})
    @BussinessLog(key="/datasource/remove", value="\u5220\u9664\u6570\u636e\u6e90\u4fe1\u606f", type="02", dict=SysDataSourceDict.class)
    public ApiResponse<SysDataSource> remove(@RequestBody Map<String, Object> map) {
        String ids = map.get("ids") == null ? "" : map.get("ids").toString();
        List sysTenantList = this.sysDataSourceService.list((Wrapper)new QueryWrapper().in((Object)"DB_ID", Arrays.asList(ids.split(","))));
        ArrayList<String> list = new ArrayList<String>();
        for (SysDataSource sysDataSource : sysTenantList) {
            list.add(sysDataSource.getConnName());
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("dbName", StringUtils.join((Object[])list.toArray(), (String)","));
        LogObjectHolder.me().set("edit_object_after", map1);
        return this.sysDataSourceService.delete(ids);
    }

    @RequestMapping(value={"/valDbName"})
    public ApiResponse<SysDataSource> valDbName(@RequestBody Map<String, Object> map) {
        String dbName = map.get("dbName") == null ? "" : map.get("dbName").toString();
        return this.sysDataSourceService.valDbName(dbName);
    }

    @RequestMapping(value={"/getTenantPermission"})
    public ApiResponse<Map<String, Object>> getTenantPermission() {
        String tenantLevel = this.globalProperties.getTenantLevel();
        boolean isAdmin = ShiroKit.isAdmin();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantLevel", tenantLevel);
        map.put("isAdmin", isAdmin);
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/tryConnection"})
    @BussinessLog(key="/datasource/tryConnection", value="\u6d4b\u8bd5\u6570\u636e\u5e93\u8fde\u63a5", type="04")
    public ApiResponse<String> tryConnection(@RequestBody Map<String, Object> map) {
        String url = ToolUtil.isEmpty((Object)map.get("jdbcUrl")) ? "" : map.get("jdbcUrl").toString();
        String userName = ToolUtil.isEmpty((Object)map.get("userName")) ? "" : map.get("userName").toString();
        String password = ToolUtil.isEmpty((Object)map.get("password")) ? "" : map.get("password").toString();
        boolean printFlag = ToolUtil.isEmpty((Object)map.get("print")) ? true : Boolean.valueOf(map.get("print").toString());
        return this.sysDataSourceService.tryConnection(url, userName, password, printFlag);
    }

    @RequestMapping(value={"/initDataSource"})
    @BussinessLog(key="/datasource/initDataSource", value="\u521d\u59cb\u5316\u6570\u636e\u5e93", type="01")
    public ApiResponse<?> initDataSource(@RequestParam(value="dbId") String dbId, @RequestParam(value="isBpmType", required=false) String isBpmType, @RequestParam(value="tenantId", required=false) String tenantId) {
        return this.sysDataSourceService.execSqlFile(dbId, isBpmType, tenantId);
    }

    @RequestMapping(value={"/checkConnName"})
    public ApiResponse<Boolean> checkConnName(@RequestParam(value="connName") String connName) {
        return this.sysDataSourceService.checkConnName(connName);
    }
}

