/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.login;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.code.kaptcha.Producer;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.datasource.model.SysDataSource;
import com.jxdinfo.hussar.bsp.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.bsp.loginuser.service.SysLoginUserService;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.permit.model.SysOnline;
import com.jxdinfo.hussar.bsp.permit.model.SysRoles;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysOnlineHistService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.bsp.tenant.model.SysTenant;
import com.jxdinfo.hussar.bsp.tenant.service.SysTenantService;
import com.jxdinfo.hussar.bsp.theme.service.IThemeService;
import com.jxdinfo.hussar.bsp.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.common.annotion.DynamicDS;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.InvalidKaptchaException;
import com.jxdinfo.hussar.common.exception.TenantLoginException;
import com.jxdinfo.hussar.common.exception.TotpKeyException;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.front.common.response.IResultCode;
import com.jxdinfo.hussar.config.front.common.response.ResultCode;
import com.jxdinfo.hussar.config.front.config.SessionUtils;
import com.jxdinfo.hussar.config.properties.EncryptTypeProperties;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.aop.NoRepeatMethod;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.encrypt.CryptoUtil;
import com.jxdinfo.hussar.core.log.HussarLogManager;
import com.jxdinfo.hussar.core.log.factory.LogTaskFactory;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.encrypt.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.core.shiro.factory.IShiro;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.RSAEncryptorForIOS;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.gateway.util.AuthenticationUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/frontLogin"})
public class FrontLoginController
extends BaseController {
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private IThemeService themeService;
    @Resource
    private ISysOnlineHistService iSysOnlineHistService;
    @Resource
    private HussarProperties hussarProperties;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private ISysWelcomeService sysWelcomeService;
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private SysDataSourceService sysDataSourceService;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private SysLoginUserService sysLoginUserService;
    @Resource
    private Producer producer;
    @Resource
    private EncryptTypeProperties etp;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private DruidProperties druidProperties;
    @Value(value="${open.type:1}")
    private String openType;
    @Value(value="${open.isMultiple:false}")
    private Boolean isMultiple;
    @Resource
    private HussarCacheManager hussarCacheManager;

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    @NoRepeatMethod(timeout=500L)
    @DynamicDS(isIntercept=false)
    public ApiResponse<?> loginVali(@RequestBody Map<String, String> body) {
        String cardID;
        String newInfo;
        String encryptedInfo = body.get("i");
        if (ToolUtil.isNotEmpty((Object)encryptedInfo) && StrUtil.isNotEmpty((CharSequence)(newInfo = AuthenticationUtil.decode_text_time((String)encryptedInfo, (long)180000L))) && !"-1".equalsIgnoreCase(newInfo)) {
            String[] arrInfo = newInfo.split(";");
            String cardID2 = arrInfo[1];
            String userIp = "";
            if (arrInfo.length > 2) {
                userIp = arrInfo[2];
            }
            body.put("cardID", cardID2);
            body.put("userIp", userIp);
        }
        if (ToolUtil.isNotEmpty((Object)(cardID = body.get("cardID")))) {
            Map userMap = this.iSysUsersService.getAccountByIdCard(cardID, "1");
            if (ToolUtil.isNotEmpty((Object)userMap)) {
                String userName = userMap.get("account").toString();
                this.hussarCacheManager.setObject("gateway_info", userName, (Object)body.get("userIp"));
                body.put("username", userName);
            } else {
                String uName = cardID;
                String errorMsg = "\u7528\u6237\u4e0d\u5b58\u5728";
                Map failMap = this.iSysUsersService.getAccountByIdCard(cardID, "");
                if (ToolUtil.isNotEmpty((Object)failMap)) {
                    uName = failMap.get("account").toString();
                    String userStatus = failMap.get("status").toString();
                    if (UserStatus.LOCKED.getCode().equals(userStatus)) {
                        errorMsg = "\u8d26\u53f7\u88ab\u9501\u5b9a";
                    }
                    if (UserStatus.CANCEL.getCode().equals(userStatus)) {
                        errorMsg = "\u8d26\u53f7\u88ab\u6ce8\u9500";
                    }
                    if (UserStatus.DORMANCY.getCode().equals(userStatus)) {
                        errorMsg = "\u8d26\u53f7\u5df2\u4f11\u7720";
                    }
                }
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("sessionId", (String)((Object)ShiroKit.getSession().getId()));
                info.put("ip", body.get("userIp"));
                info.put("port", HttpKit.getPort());
                info.put("host", HttpKit.getHost());
                info.put("localIp", HttpKit.getLocalIp());
                info.put("localPort", HttpKit.getLocalPort());
                info.put("localHost", HttpKit.getLocalHost());
                HussarLogManager.me().executeLog(LogTaskFactory.loginLog(null, (String)uName, (String)errorMsg, (String)"07", info));
                return ApiResponse.fail((String)errorMsg);
            }
        }
        if (this.globalProperties.isTenantOpen()) {
            if ("1".equals(this.globalProperties.getTenantUserModel())) {
                return this.tenantLoginWithCode(body);
            }
            return this.tenantLoginByAccount(body);
        }
        return this.userLogin(body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResponse<?> tenantLoginWithCode(Map<String, String> body) {
        String tenantCode = body.get("tenantCode");
        if ("000000".equals(tenantCode)) {
            return this.userLogin(body);
        }
        List list = this.sysTenantService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_code", (Object)tenantCode)).eq((Object)"is_deleted", (Object)"0"));
        SysDataSource dataSource = this.sysDataSourceService.getByTenantCode(tenantCode);
        if (list == null || list.size() <= 0) {
            throw new TenantLoginException(body.get("username"), "\u79df\u6237\u7f16\u53f7\u4e0d\u5b58\u5728", "tenantNoExist");
        }
        SysTenant tenant = (SysTenant)list.get(0);
        if ("1".equals(tenant.getLoginTimeLimit())) {
            String beginTime = tenant.getAccessLoginStartTime();
            String endTime = tenant.getAccessLoginEndTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date begin = sdf.parse(beginTime);
                Date end = sdf.parse(endTime);
                Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                    throw new TenantLoginException(body.get("username"), "\u79df\u6237\u672a\u5728\u6709\u6548\u671f\u5185", "tenantAccountExpired");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (ToolUtil.isEmpty((Object)dataSource) || ToolUtil.isEmpty((Object)dataSource.getConnName())) {
            throw new TenantLoginException(body.get("username"), "\u672a\u80fd\u83b7\u53d6\u79df\u6237\u7684\u6570\u636e\u6e90", "dataSourceUndefined");
        }
        this.sysDataSourceService.addDataSourceByConnName(dataSource.getConnName());
        try {
            DataSourceUtil.changeTempDs((String)dataSource.getConnName());
            ApiResponse<?> apiResponse = this.userLogin(body);
            return apiResponse;
        }
        finally {
            DataSourceUtil.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResponse<?> tenantLoginByAccount(Map<String, String> body) {
        String username = body.get("username");
        String isIndex = body.get("isIndex");
        String tenantCode = "";
        if (Arrays.asList(Constants.MANAGE_USER).contains(username)) {
            tenantCode = "000000";
        } else {
            SysUsers sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)username), false);
            if (ToolUtil.isNotEmpty((Object)sysUsers)) {
                tenantCode = this.sysOrgManageService.getTenantCodeByStruId(sysUsers.getCorporationId());
            }
        }
        if (ToolUtil.isNotEmpty((Object)tenantCode)) {
            SysDataSource dataSource;
            if ("000000".equals(tenantCode)) {
                body.put("connName", "master");
                return this.userLogin(body);
            }
            List list = this.sysTenantService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_code", (Object)tenantCode)).eq((Object)"is_deleted", (Object)"0"));
            if (list == null || list.size() <= 0) {
                throw new TenantLoginException(body.get("username"), "\u7528\u6237\u6240\u5728\u79df\u6237\u83b7\u53d6\u5931\u8d25", "failedObtainTenant");
            }
            SysTenant tenant = (SysTenant)list.get(0);
            if ("1".equals(tenant.getLoginTimeLimit())) {
                String beginTime = tenant.getAccessLoginStartTime();
                String endTime = tenant.getAccessLoginEndTime();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date begin = sdf.parse(beginTime);
                    Date end = sdf.parse(endTime);
                    Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                    if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                        throw new TenantLoginException(body.get("username"), "\u6240\u5728\u79df\u6237\u672a\u5728\u6709\u6548\u671f\u5185", "belongTenantAccountExpired");
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if ("1".equals(isIndex) && "1".equals(tenant.getTenantMenu())) {
                tenantCode = "000000";
            }
            if (ToolUtil.isEmpty((Object)(dataSource = this.sysDataSourceService.getByTenantCode(tenantCode))) || ToolUtil.isEmpty((Object)dataSource.getConnName())) {
                throw new TenantLoginException(body.get("username"), "\u672a\u80fd\u83b7\u53d6\u79df\u6237\u7684\u6570\u636e\u6e90", "dataSourceUndefined");
            }
            this.sysDataSourceService.addDataSourceByConnName(dataSource.getConnName());
            try {
                body.put("connName", dataSource.getConnName());
                DataSourceUtil.changeTempDs((String)dataSource.getConnName());
                ApiResponse<?> apiResponse = this.userLogin(body);
                return apiResponse;
            }
            finally {
                DataSourceUtil.poll();
            }
        }
        throw new TenantLoginException(body.get("username"), "\u7528\u6237\u6240\u5728\u79df\u6237\u83b7\u53d6\u5931\u8d25", "failedObtainTenant");
    }

    private ApiResponse<?> userLogin(Map<String, String> body) {
        UsernamePasswordToken token;
        String username = body.get("username");
        String password = body.get("cipher");
        String encrypted = body.get("encrypted");
        String remember = body.get("remember");
        String userIp = body.get("userIp");
        String cardID = body.get("cardID");
        String clientType = body.get("clientType");
        String connName = body.get("connName");
        SysUsers sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)username)).eq((Object)"ACCOUNT_STATUS", (Object)UserStatus.OK.getCode()), false);
        Subject currentUser = ShiroKit.getSubject();
        currentUser.getSession().setAttribute((Object)"connName", (Object)connName);
        if (ToolUtil.isEmpty((Object)cardID)) {
            boolean isNoPwd;
            boolean bl = isNoPwd = ToolUtil.isNotEmpty((Object)body.get("noPwd")) ? Boolean.valueOf(body.get("noPwd")) : false;
            if (StringUtils.isEmpty((CharSequence)password)) {
                password = encrypted;
            }
            if (StringUtils.isNotBlank((CharSequence)clientType) && "ios".equalsIgnoreCase(clientType)) {
                RSAEncryptorForIOS rsaencryptor = RSAEncryptorForIOS.getInstance();
                password = rsaencryptor.decryptWithBase64(password);
            } else {
                password = CryptoUtil.decode((String)password);
            }
            if (this.hussarProperties.getKaptchaOpen().booleanValue() && !isNoPwd) {
                String kaptcha = body.get("kaptcha");
                String code = (String)super.getSession().getAttribute("KAPTCHA_SESSION_KEY");
                if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
                    super.getSession().setAttribute("KAPTCHA_SESSION_KEY", (Object)this.producer.createText());
                    throw new InvalidKaptchaException(username, "\u9a8c\u8bc1\u7801\u9519\u8bef", "verificationError");
                }
            }
            if (this.hussarProperties.getTotpOpen().booleanValue() && !isNoPwd) {
                String totp = body.get("totp");
                if (sysUsers != null && !this.abstractOTPCredentialsMatcher.verify(sysUsers.getTotpKey(), totp, this.hussarProperties.getTotpOffsetMin())) {
                    throw new TotpKeyException(username, "\u52a8\u6001\u5bc6\u7801\u9519\u8bef", "dynamicPassword");
                }
            }
            if (isNoPwd) {
                password = this.credentialsMatcher.passwordEncode(username.getBytes());
                String host = this.etp.getSecretFreeIp();
                token = new UsernamePasswordToken(username, password.toCharArray(), host);
            } else {
                token = new UsernamePasswordToken(username, password.toCharArray());
            }
            if ("on".equals(remember)) {
                token.setRememberMe(true);
            } else {
                token.setRememberMe(false);
            }
            currentUser.login((AuthenticationToken)token);
        } else {
            password = this.credentialsMatcher.passwordEncode(username.getBytes());
            String host = this.etp.getSecretFreeIp();
            token = new UsernamePasswordToken(username, password.toCharArray(), host);
            token.setRememberMe(false);
            currentUser.login((AuthenticationToken)token);
        }
        Session session = currentUser.getSession();
        ShiroUser shiroUser = ShiroKit.getUser();
        session.setAttribute((Object)"username", (Object)shiroUser.getName());
        session.setAttribute((Object)"sessionFlag", (Object)true);
        session.setAttribute((Object)"shiroUser", (Object)shiroUser);
        session.setAttribute((Object)"userId", (Object)shiroUser.getId());
        if (sysUsers != null && "1".equals(sysUsers.getLoginTimeLimit())) {
            session.setAttribute((Object)"startTime", (Object)sysUsers.getAccessLoginStartTime());
            session.setAttribute((Object)"endTime", (Object)sysUsers.getAccessLoginEndTime());
        }
        if (ToolUtil.isEmpty((Object)cardID)) {
            this.hussarCacheManager.delete("gateway_info", shiroUser.getId());
        } else {
            this.hussarCacheManager.setObject("gateway_info", shiroUser.getId(), (Object)userIp);
        }
        SysOnline online = this.iSysOnlineHistService.addRecord();
        session.setAttribute((Object)"online", (Object)online);
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("sessionId", (String)((Object)ShiroKit.getSession().getId()));
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        HussarLogManager.me().executeLog(LogTaskFactory.loginLog((ShiroUser)shiroUser, (String)"05", info));
        SysUsers user = new SysUsers();
        user.setUserId(shiroUser.getId());
        user.setLastLoginTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        this.iSysUsersService.updateById((Object)user);
        HashMap<String, Object> map = new HashMap<String, Object>();
        IShiro shiroFactory = ShiroFactroy.me();
        List permissionList = new ArrayList();
        shiroFactory.getDataScopeInfo(shiroUser);
        if (!StringUtils.isNotBlank((CharSequence)clientType) || !"mobile".equalsIgnoreCase(clientType) && !"ios".equalsIgnoreCase(clientType)) {
            permissionList = shiroFactory.getAuthInfo(shiroUser);
            map.put("permissions", permissionList);
            map.put("theme", this.themeService.getUserTheme());
            ArrayList<String> rolesList = new ArrayList<String>();
            if (ToolUtil.isNotEmpty((Object)shiroUser.getRolesList())) {
                rolesList.addAll(shiroUser.getRolesList());
            }
            rolesList.add(shiroUser.getId());
            map.put("welcomeUrl", this.sysWelcomeService.getUserIndex(rolesList));
        }
        map.put("accessToken", SessionUtils.encode((String)String.valueOf(session.getId())));
        map.put("userName", shiroUser.getName());
        map.put("gradeAdmin", shiroUser.isGradeadmin());
        map.put("userId", shiroUser.getId());
        map.put("deptId", shiroUser.getDeptId());
        map.put("deptName", shiroUser.getDeptName());
        map.put("roles", shiroUser.getRolesList());
        map.put("openType", this.openType);
        map.put("isMultiple", this.isMultiple);
        String tenantCode = shiroUser.getTenantCode();
        map.put("tenantCode", tenantCode);
        SysTenant tenant = new SysTenant();
        if (ToolUtil.isNotEmpty((Object)tenantCode)) {
            tenant = (SysTenant)this.sysTenantService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_code", (Object)tenantCode)).eq((Object)"is_deleted", (Object)"0"));
        }
        map.put("tenantName", ToolUtil.isNotEmpty((Object)tenant) ? tenant.getTenantName() : "");
        map.put("showTenant", this.showTenantInfo(shiroUser));
        List allOrgans = ShiroKit.getAllOrgan();
        List allAssistOrganName = ShiroKit.getAllAssistOrganName();
        map.put("allOrgans", JSON.toJSONString((Object)allOrgans));
        map.put("allAssistOrganName", JSON.toJSONString((Object)allAssistOrganName));
        map.put("securityLevel", shiroUser.getSecurityLevel());
        map.put("bpmTenantId", shiroUser.getTenantId());
        map.put("bpmTenantCipher", shiroUser.getTenantCipher());
        if (ToolUtil.isNotEmpty((Object)shiroUser.getRolesList())) {
            SysRoles sysRoles = new SysRoles();
            List sysRoleList = sysRoles.selectList((Wrapper)new QueryWrapper().in((Object)"ROLE_ID", (Collection)shiroUser.getRolesList()));
            List roleCode = sysRoleList.stream().map(SysRoles::getRoleCode).collect(Collectors.toList());
            map.put("roleCode", roleCode);
        } else {
            map.put("roleCode", "");
        }
        if (ToolUtil.isNotEmpty((Object)shiroUser.getEmployeeId())) {
            map.putAll(this.iSysUsersService.getUserByStruId(shiroUser.getEmployeeId()));
        } else {
            map.put("orgCode", "");
            map.put("idCard", "");
        }
        map.put("adminType", "");
        List roleList = shiroUser.getRolesList();
        if (roleList.contains(SysUserAndRole.SECURITYADMIN_ROLE.getValue())) {
            map.put("adminType", SysUserAndRole.SECURITYADMIN_ROLE.getValue());
        } else if (roleList.contains(SysUserAndRole.SECAUDITADMIN_ROLE.getValue())) {
            map.put("adminType", SysUserAndRole.SECAUDITADMIN_ROLE.getValue());
        } else if (roleList.contains(SysUserAndRole.SYSTEMADMIN_ROLE.getValue())) {
            map.put("adminType", SysUserAndRole.SYSTEMADMIN_ROLE.getValue());
        } else if (roleList.contains(SysUserAndRole.GRADESECURITYADMIN_ROLE.getValue())) {
            map.put("adminType", SysUserAndRole.GRADESECURITYADMIN_ROLE.getValue());
        } else if (roleList.contains(SysUserAndRole.GRADESECAUDITADMIN_ROLE.getValue())) {
            map.put("adminType", SysUserAndRole.GRADESECAUDITADMIN_ROLE.getValue());
        } else if (roleList.contains(SysUserAndRole.GRADESYSTEMADMIN_ROLE.getValue())) {
            map.put("adminType", SysUserAndRole.GRADESYSTEMADMIN_ROLE.getValue());
        }
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/logout"})
    public ApiResponse<?> logOut() {
        ShiroKit.getSubject().logout();
        return ApiResponse.success((IResultCode)ResultCode.SUCCESS, (String)ResultCode.SUCCESS.getMessage());
    }

    @RequestMapping(value={"/check"})
    public ApiResponse<Map<String, String>> check() {
        ShiroUser shiroUser = ShiroKit.getUser();
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.globalProperties.isForceChangePwd()) {
            SysUsers sysUser = this.iSysUsersService.getUser(shiroUser.getId());
            if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
                map.put("firstLogin", "NO");
                map.put("changePwd", "NO");
                return ApiResponse.data(map);
            }
            if (this.iSysUsersService.isFirstLogin(shiroUser.getId())) {
                map.put("firstLogin", "YES");
            } else {
                map.put("firstLogin", "NO");
            }
            if (this.iSysUsersService.isPwdOverdue(shiroUser.getId())) {
                map.put("changePwd", "YES");
            } else {
                map.put("changePwd", "NO");
            }
        } else {
            map.put("firstLogin", "NO");
            map.put("changePwd", "NO");
        }
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/getTotpKapcha"})
    public ApiResponse<Map<String, Object>> getShow() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("totp", this.hussarProperties.getTotpOpen());
        map.put("kaptcha", this.hussarProperties.getKaptchaOpen());
        map.put("tenant", this.globalProperties.isTenantOpen());
        map.put("tenantModel", this.globalProperties.getTenantUserModel());
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/validateLogin"})
    public Map<String, Object> validateLogin() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", "success");
        return map;
    }

    @RequestMapping(value={"/validateLogout"})
    public Map<String, Object> validateLogout() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return map;
    }

    @RequestMapping(value={"/isCasActive"})
    public Map<String, Object> isCasActive() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("casActive", false);
        map.put("showLoginPage", this.globalProperties.isShowLoginPage());
        return map;
    }

    @RequestMapping(value={"/getTenantCodeByDomain"})
    public ApiResponse<String> getTenantCodeByDomain(@RequestParam(value="domain") String domain) {
        String tenantCode = "";
        String masterDomain = this.druidProperties.getDomain();
        if (ToolUtil.isNotEmpty((Object)masterDomain) && masterDomain.equals(domain)) {
            return ApiResponse.data((Object)"000000");
        }
        List list = this.sysTenantService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_domain", (Object)domain)).eq((Object)"is_deleted", (Object)"0"));
        if (list.size() > 0) {
            tenantCode = ((SysTenant)list.get(0)).getTenantCode();
        }
        return ApiResponse.data((Object)tenantCode);
    }

    private boolean showTenantInfo(ShiroUser shiroUser) {
        boolean flag = false;
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            List rolesList = shiroUser.getRolesList();
            String[] gradeAdmins = new String[]{"gradesecauditadmin_role", "gradesecurityadmin_role", "gradesystemadmin_role", "securityadmin_role", "secauditadmin_role", "systemadmin_role"};
            if (this.globalProperties.isTenantOpen() && "2".equals(this.globalProperties.getTenantUserModel())) {
                for (int i = 0; i < rolesList.size(); ++i) {
                    if (!Arrays.asList(gradeAdmins).contains(rolesList.get(i))) continue;
                    flag = true;
                }
            }
        }
        return flag;
    }

    @RequestMapping(value={"/changeTenant"}, method={RequestMethod.POST})
    @NoRepeatMethod(timeout=500L)
    @DynamicDS(isIntercept=false)
    public ApiResponse<?> changeTenant(@RequestBody Map<String, String> body) {
        String password = body.get("password");
        ShiroUser shiroUser = ShiroKit.getUser();
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            body.put("username", shiroUser.getAccount());
        }
        body.put("cipher", password);
        body.put("encrypted", password);
        if (this.globalProperties.isTenantChangeInputPwd()) {
            body.put("noPwd", String.valueOf(false));
        } else {
            body.put("noPwd", String.valueOf(true));
        }
        return this.tenantLoginWithCode(body);
    }

    @RequestMapping(value={"/switchTenant"}, method={RequestMethod.POST})
    @NoRepeatMethod(timeout=500L)
    @DynamicDS(isIntercept=false)
    public ApiResponse<?> switchTenant(@RequestBody Map<String, String> body) {
        SysDataSource sysDataSource;
        String tenantCode = body.get("tenantCode");
        ShiroUser shiroUser = ShiroKit.getUser();
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            body.put("username", shiroUser.getAccount());
        }
        if (ToolUtil.isNotEmpty((Object)(sysDataSource = this.sysDataSourceService.getByTenantCode(tenantCode)))) {
            body.put("connName", sysDataSource.getConnName());
        }
        body.put("noPwd", String.valueOf(true));
        return this.tenantLoginWithCode(body);
    }

    @RequestMapping(value={"/getTenant"}, method={RequestMethod.POST})
    public ApiResponse<?> getTenant() {
        ArrayList<SysTenant> list = new ArrayList<SysTenant>();
        ShiroUser shiroUser = ShiroKit.getUser();
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            String tenantCode = this.sysOrgManageService.getTenantCodeByStruId(shiroUser.getDeptId());
            SysTenant sysTenant = new SysTenant();
            if (ToolUtil.isNotEmpty((Object)tenantCode)) {
                sysTenant = (SysTenant)this.sysTenantService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_code", (Object)tenantCode)).eq((Object)"is_deleted", (Object)"0"));
            }
            SysTenant sysTenant1 = (SysTenant)this.sysTenantService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_code", (Object)shiroUser.getTenantCode())).eq((Object)"is_deleted", (Object)"0"));
            sysTenant1.setCurrentTenant("1");
            list.add(sysTenant1);
            if ("3".equals(sysTenant.getTenantMenu()) && shiroUser.getTenantCode().equals(tenantCode)) {
                sysTenant = (SysTenant)this.sysTenantService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_code", (Object)"000000")).eq((Object)"is_deleted", (Object)"0"));
                list.add(sysTenant);
            }
            if ("3".equals(sysTenant.getTenantMenu()) && !shiroUser.getTenantCode().equals(tenantCode)) {
                list.add(sysTenant);
            }
        }
        return ApiResponse.data(list);
    }

    @RequestMapping(value={"/getAllTenant"}, method={RequestMethod.POST})
    public ApiResponse<?> getAllTenant() {
        int i;
        ShiroUser shiroUser = ShiroKit.getUser();
        ArrayList result = new ArrayList();
        SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)((Object)shiroUser.getDeptId()));
        SysStru sysStru1 = (SysStru)this.sysStruService.getById((Serializable)((Object)sysStru.getPermissionStruId()));
        SysTenant sysTenant = (SysTenant)this.sysTenantService.getById((Serializable)((Object)sysStru1.getTenantId()));
        if (!"000000".equals(sysTenant.getTenantCode())) {
            return ApiResponse.data(result);
        }
        List list = this.sysTenantService.list((Wrapper)new QueryWrapper().eq((Object)"IS_DELETED", (Object)"0"));
        for (i = 0; i < list.size(); ++i) {
            if (!shiroUser.getTenantCode().equals(((SysTenant)list.get(i)).getTenantCode())) continue;
            ((SysTenant)list.get(i)).setCurrentTenant("1");
            result.add(list.get(i));
        }
        for (i = 0; i < list.size(); ++i) {
            if (!shiroUser.getTenantCode().equals(((SysTenant)list.get(i)).getTenantCode())) continue;
            list.remove(list.get(i));
            break;
        }
        result.addAll(list);
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/changeTenantNeedPwd"})
    public ApiResponse<Map<String, Object>> changeTenantNeedPwd() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("showPwd", this.globalProperties.isTenantChangeInputPwd());
        return ApiResponse.data(map);
    }
}

