/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.quartz;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.annotion.DynamicDS;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.constant.BizExceptionEnum;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.quartz.job.BaseJob;
import com.jxdinfo.hussar.quartz.model.JobLog;
import com.jxdinfo.hussar.quartz.model.JobTrigger;
import com.jxdinfo.hussar.quartz.service.IJobLogService;
import com.jxdinfo.hussar.quartz.service.IJobTriggerService;
import com.jxdinfo.hussar.support.plugin.integration.user.PluginUser;
import com.jxdinfo.hussar.timejob.JobService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerUtils;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobFront"})
@DynamicDS(isIntercept=false)
public class JobFrontController
extends BaseController {
    @Resource
    private IJobLogService iJobLogService;
    @Resource
    private IJobTriggerService iJobTriggerService;
    @Value(value="${org.quartz.trigger-group:}")
    private List<String> triggerGroup;
    @Resource
    private PluginUser pluginUser;
    @Resource
    @Qualifier(value="Scheduler")
    private Scheduler scheduler;
    private static Logger log = LogManager.getLogger(JobFrontController.class);

    @RequiresPermissions(value={"job:query"})
    @RequestMapping(value={"/query"})
    @BussinessLog(key="/jobFront/query", type="04", value="\u67e5\u8be2")
    public ApiResponse<Map<String, Object>> query(@RequestBody Map<String, Object> body) {
        String jobName = body.get("jobName") == null ? null : body.get("jobName").toString();
        String jobGroup = body.get("jobGroup") == null ? null : body.get("jobGroup").toString();
        int page = body.get("page") == null ? 1 : Integer.parseInt(body.get("page").toString());
        int limit = body.get("limit") == null ? 10 : Integer.parseInt(body.get("limit").toString());
        JobLog jobLog = new JobLog();
        jobLog.setJobName(jobName);
        jobLog.setJobGroup(jobGroup);
        Page jobPage = new Page((long)page, (long)limit);
        jobPage = this.iJobLogService.getJobLogDetails(jobPage, jobLog);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("data", jobPage.getRecords());
        map.put("count", jobPage.getTotal());
        map.put("code", 0);
        map.put("message", "");
        return ApiResponse.data(map);
    }

    @RequiresPermissions(value={"job:query"})
    @RequestMapping(value={"/list"})
    @BussinessLog(key="/jobFront/list", type="04", value="\u67e5\u8be2\u8ba1\u5212")
    public ApiResponse<Map<String, Object>> list(@RequestBody Map<String, Object> body) {
        int page = body.get("page") == null ? 1 : Integer.parseInt(body.get("page").toString());
        int limit = body.get("limit") == null ? 10 : Integer.parseInt(body.get("limit").toString());
        JobTrigger jobTrigger = new JobTrigger();
        jobTrigger.setJobName(body.get("jobName") == null ? "" : body.get("jobName").toString());
        jobTrigger.setJobGroup(ShiroKit.getUser().getTenantCode());
        Page jobTriggerPage = new Page((long)page, (long)limit);
        jobTriggerPage = this.iJobTriggerService.getJobTriggerDetails(jobTriggerPage, jobTrigger);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("data", jobTriggerPage.getRecords());
        map.put("count", jobTriggerPage.getTotal());
        map.put("code", 0);
        map.put("message", "");
        return ApiResponse.data(map);
    }

    @RequiresPermissions(value={"job:add"})
    @PostMapping(value={"/add"})
    @BussinessLog(key="/jobFront/add", type="01", value="\u6dfb\u52a0\u8ba1\u5212")
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<?> add(@RequestBody Map<String, String> map) {
        try {
            String jobClassName = map.get("jobClassName");
            String jobName = map.get("jobName");
            String pluginClassName = map.get("pluginClassName");
            String jobGroup = ShiroKit.getUser().getTenantCode();
            String jobDescription = map.get("description");
            String cronExpression = map.get("cronExpression");
            String misfirePolicy = map.get("misfirePolicy");
            this.scheduler.start();
            JobDataMap pluginJobData = new JobDataMap();
            pluginJobData.put("pluginClassName", pluginClassName);
            JobDetail jobDetail = JobBuilder.newJob(JobFrontController.getClass(jobClassName).getClass()).withIdentity(jobName, jobGroup).withDescription(jobDescription).usingJobData(pluginJobData).build();
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
            scheduleBuilder = this.handleMisfirePolicy(misfirePolicy, scheduleBuilder);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, jobGroup).withDescription(jobDescription).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            log.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            e.printStackTrace();
            return ApiResponse.fail((int)BizExceptionEnum.ADD_QUARTZ.getCode(), (String)this.schedulerExceptionMessageResolver1(e));
        }
        catch (HussarException e) {
            log.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            e.printStackTrace();
            return ApiResponse.fail((int)BizExceptionEnum.ADD_QUARTZ.getCode(), (String)e.getMessage());
        }
        this.iJobTriggerService.addJobExtend(map);
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    private String schedulerExceptionMessageResolver1(SchedulerException e) {
        if (e instanceof JobExecutionException) {
            return "executeFail";
        }
        if (e instanceof JobPersistenceException) {
            if (e instanceof ObjectAlreadyExistsException) {
                return "alreadyExists";
            }
            return "database";
        }
        if (e instanceof SchedulerConfigException) {
            return "configurationException";
        }
        if (e instanceof UnableToInterruptJobException) {
            return "interrupted";
        }
        return "unknownError";
    }

    private String schedulerExceptionMessageResolver(SchedulerException e) {
        if (e instanceof JobExecutionException) {
            return "\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff01";
        }
        if (e instanceof JobPersistenceException) {
            if (e instanceof ObjectAlreadyExistsException) {
                return "\u5df2\u5b58\u5728\u4efb\u52a1\u7ec4\u548c\u4efb\u52a1\u540d\u76f8\u540c\u7684\u4efb\u52a1\uff01";
            }
            return "\u6570\u636e\u5e93\u5f02\u5e38\uff01";
        }
        if (e instanceof SchedulerConfigException) {
            return "\u5b9a\u65f6\u4efb\u52a1\u914d\u7f6e\u5f02\u5e38\uff01";
        }
        if (e instanceof UnableToInterruptJobException) {
            return "\u8be5\u5b9a\u65f6\u4efb\u52a1\u4e0d\u53ef\u88ab\u6253\u65ad\uff01";
        }
        return "\u672a\u77e5\u9519\u8bef\uff01";
    }

    private static BaseJob getClass(String classname) throws HussarException {
        try {
            Class<?> class1 = Class.forName(classname);
            return (BaseJob)class1.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.error("\u83b7\u53d6\u53cd\u5c04\u7c7b\u5931\u8d25\uff01");
            HussarException he = new HussarException((ServiceExceptionEnum)BizExceptionEnum.GETCLASS_QUARTZ);
            he.setMessage("\u5b9a\u65f6\u4efb\u52a1\u7c7b\u672a\u627e\u5230\uff01");
            throw he;
        }
    }

    private CronScheduleBuilder handleMisfirePolicy(String misfirePolicy, CronScheduleBuilder cb) {
        if (ToolUtil.isEmpty((Object)misfirePolicy)) {
            return cb;
        }
        switch (misfirePolicy) {
            case "1": {
                return cb.withMisfireHandlingInstructionIgnoreMisfires();
            }
            case "2": {
                return cb.withMisfireHandlingInstructionFireAndProceed();
            }
            case "3": {
                return cb.withMisfireHandlingInstructionDoNothing();
            }
        }
        return cb;
    }

    @RequiresPermissions(value={"job:delete"})
    @RequestMapping(value={"/delete"})
    @BussinessLog(key="/jobFront/delete", type="02", value="\u5220\u9664\u8ba1\u5212")
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<?> delete(@RequestBody Map<String, Object> map) {
        String jobName = map.get("jobName") == null ? null : map.get("jobName").toString();
        String jobGroup = map.get("jobGroup") == null ? null : map.get("jobGroup").toString();
        try {
            this.scheduler.pauseTrigger(TriggerKey.triggerKey((String)jobName, (String)jobGroup));
            this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)jobName, (String)jobGroup));
            this.scheduler.deleteJob(JobKey.jobKey((String)jobName, (String)jobGroup));
        }
        catch (SchedulerException e) {
            log.error("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            return ApiResponse.fail((int)BizExceptionEnum.DELETE_QUARTZ.getCode(), (String)(BizExceptionEnum.DELETE_QUARTZ.getMessage() + "\uff0c" + this.schedulerExceptionMessageResolver(e)));
        }
        this.iJobTriggerService.deleteJobExtend(jobName, jobGroup);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"job:reschedule"})
    @RequestMapping(value={"/reschedule"})
    @BussinessLog(key="/jobFront/reschedule", type="03", value="\u4fee\u6539\u8ba1\u5212")
    @Transactional(rollbackFor={Exception.class})
    public ApiResponse<?> reschedule(@RequestBody Map<String, Object> map) throws HussarException {
        String jobName = map.get("jobName") == null ? null : map.get("jobName").toString();
        String cronExpression = map.get("cronExpression") == null ? null : map.get("cronExpression").toString();
        String misfirePolicy = map.get("misfirePolicy") == null ? null : map.get("misfirePolicy").toString();
        String jobGroup = ShiroKit.getUser().getTenantCode();
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)jobName, (String)jobGroup);
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
            scheduleBuilder = this.handleMisfirePolicy(misfirePolicy, scheduleBuilder);
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            this.scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            log.error("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            e.printStackTrace();
            return ApiResponse.fail((int)BizExceptionEnum.READD_QUARTZ.getCode(), (String)(BizExceptionEnum.READD_QUARTZ.getMessage() + "\uff0c" + this.schedulerExceptionMessageResolver(e)));
        }
        this.iJobTriggerService.updateJobExtend(map);
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"job:pause"})
    @PostMapping(value={"/pause"})
    @BussinessLog(key="/jobFront/pause", type="03", value="\u6682\u505c\u8ba1\u5212")
    public ApiResponse<?> pause(@RequestBody Map<String, Object> map) throws HussarException {
        String jobName = map.get("jobName") == null ? null : map.get("jobName").toString();
        String jobGroup = map.get("jobGroup") == null ? null : map.get("jobGroup").toString();
        try {
            DataSourceUtil.changeTempDs((String)"master");
            this.scheduler.pauseJob(JobKey.jobKey((String)jobName, (String)jobGroup));
        }
        catch (SchedulerException e) {
            log.error("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            ApiResponse apiResponse = ApiResponse.fail((int)BizExceptionEnum.PAUSE_QUARTZ.getCode(), (String)(BizExceptionEnum.PAUSE_QUARTZ.getMessage() + "\uff0c" + this.schedulerExceptionMessageResolver(e)));
            return apiResponse;
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.success((String)"\u6682\u505c\u6210\u529f\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"job:resume"})
    @PostMapping(value={"/resume"})
    @BussinessLog(key="/jobFront/resume", type="03", value="\u6062\u590d\u8ba1\u5212")
    public ApiResponse<?> resume(@RequestBody Map<String, Object> map) throws HussarException {
        String jobName = map.get("jobName") == null ? null : map.get("jobName").toString();
        String jobGroup = map.get("jobGroup") == null ? null : map.get("jobGroup").toString();
        try {
            DataSourceUtil.changeTempDs((String)"master");
            this.scheduler.resumeJob(JobKey.jobKey((String)jobName, (String)jobGroup));
        }
        catch (SchedulerException e) {
            log.error("\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
            ApiResponse apiResponse = ApiResponse.fail((int)BizExceptionEnum.RESUME_QUARTZ.getCode(), (String)(BizExceptionEnum.RESUME_QUARTZ.getMessage() + "\uff0c" + this.schedulerExceptionMessageResolver(e)));
            return apiResponse;
        }
        finally {
            DataSourceUtil.poll();
        }
        return ApiResponse.success((String)"\u6062\u590d\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/checkCron"})
    @BussinessLog(key="/jobFront/checkCron", type="04", value="\u8fd4\u56de\u6700\u8fd13\u6b21\u8868\u8fbe\u5f0f")
    public ApiResponse<?> fileCheck(@RequestBody Map<String, Object> map) throws HussarException {
        String cron = map.get("cron") == null ? null : map.get("cron").toString();
        CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
        ArrayList<String> result = new ArrayList<String>();
        try {
            String decodeCron = URLDecoder.decode(cron, "UTF-8");
            cronTriggerImpl.setCronExpression(decodeCron);
        }
        catch (ParseException e) {
            log.error("\u5b9a\u65f6\u5668\u8868\u8fbe\u5f0f\u6709\u8bef\uff01");
            return ApiResponse.fail((String)"\u5b9a\u65f6\u5668\u8868\u8fbe\u5f0f\u6709\u8bef\uff01");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            log.error("\u5b9a\u65f6\u5668URL\u89e3\u7801\u9519\u8bef\uff01");
            return ApiResponse.fail((String)"\u5b9a\u65f6\u5668URL\u89e3\u7801\u9519\u8bef\uff01");
        }
        List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)3);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < dates.size() && i <= 2; ++i) {
            result.add(dateFormat.format((Date)dates.get(i)));
        }
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/getTriggerGroup"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getTriggerGroup() {
        return this.triggerGroup;
    }

    @RequestMapping(value={"/getClasses"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getClasses() {
        ArrayList<String> classNames = new ArrayList<String>();
        Map map = SpringContextHolder.getApplicationContext().getBeansOfType(BaseJob.class);
        for (String key : map.keySet()) {
            if ("accountJob".equals(key)) continue;
            String className = ((BaseJob)map.get(key)).getClass().getName();
            classNames.add(className);
        }
        return classNames;
    }

    @RequestMapping(value={"/getNameClasses"}, method={RequestMethod.GET})
    @ResponseBody
    public Object getNameClasses() {
        ArrayList<String> nameClasses = new ArrayList<String>();
        List classLists = this.pluginUser.getPluginBeans(JobService.class);
        Iterator iterator = classLists.iterator();
        while (iterator.hasNext()) {
            String className = ((JobService)iterator.next()).getClass().getName();
            nameClasses.add(className);
        }
        return nameClasses;
    }
}

