/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.loginuser.service.SysLoginUserService;
import com.jxdinfo.hussar.bsp.organ.dictmap.StruDict;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStaff;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.IStaffUserService;
import com.jxdinfo.hussar.bsp.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStaffService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/employeeFront"})
public class SysEmployeeFrontController
extends BaseController {
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private IStaffUserService staffUserService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysDicRefService iSysDicRefService;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    ISysStruAuditService iSysStruAuditService;
    @Resource
    ISysStruService iSysStruService;
    @Resource
    ISysStruRuleService iSysStruRuleService;
    @Resource
    ISysStruAssistOrganService iSysStruAssistOrganService;
    @Resource
    private SysLoginUserService sysLoginUserService;
    @Resource
    ISysStruService sysStruService;

    @RequiresPermissions(value={"employee:employeeTree"})
    @RequestMapping(value={"/employeeTree"})
    @BussinessLog(key="/employeeFront/employeeTree", type="04", value="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u804c\u5de5\u6811")
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> employeeTree(@RequestBody Map<String, Object> map) {
        String isEmployee = map.get("isEmployee") == null ? "" : map.get("isEmployee").toString();
        String parentId = map.get("parentId") == null ? "" : map.get("parentId").toString();
        String isExport = map.get("isExport") == null ? "" : map.get("isExport").toString();
        return ApiResponse.data(ForestNodeMerger.merge(this.sysEmployeeService.getEmployeeTreeVue(isEmployee, parentId, isExport)));
    }

    @RequestMapping(value={"/employeeAdd"})
    @RequiresPermissions(value={"employee:add"})
    @BussinessLog(key="/employeeFront/employeeAdd", type="01", value="\u4eba\u5458\u65b0\u589e", dict=StruDict.class)
    @ResponseBody
    public ApiResponse<Map<String, Object>> orgInfoAdd(@RequestBody Map<String, Object> map) {
        String orgParentCode;
        String parentType = map.get("parentType") == null ? null : map.get("parentType").toString();
        String parentTypeCode = "";
        String orgType = map.get("orgType") == null ? null : map.get("orgType").toString();
        String string = orgParentCode = map.get("orgParentCode") == null ? null : map.get("orgParentCode").toString();
        if (ToolUtil.isEmpty((Object)parentType) || ToolUtil.isEmpty((Object)orgType) || ToolUtil.isEmpty((Object)orgParentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        String filedName = "ORGAN_CODE_" + orgType;
        String currentCode = this.sysIdtableService.getCurrentCode(filedName, "SYS_STRU");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        if (parentType.equals(orgType)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.EMPLOYEE_CANNOT_HAVE_SUBORDINATES);
        }
        currentCode = orgParentCode + currentCode;
        parentTypeCode = orgParentCode;
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("operation", this.iSysDicRefService.getDicListByType("staff_position"));
        dataMap.put("currentCode", currentCode);
        dataMap.put("parentTypeCode", parentTypeCode);
        dataMap.put("orgInfo", null);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"employee:view"})
    @RequestMapping(value={"/employeeInfo"})
    @BussinessLog(key="/employeeFront/employeeInfo", type="04", value="\u67e5\u770b\u4eba\u5458\u4fe1\u606f")
    @ResponseBody
    public ApiResponse<Map<String, Object>> employeeInfo(@RequestBody Map<String, String> map) {
        String struId = map.get("struId");
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(struId);
        SysStaff staff = (SysStaff)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"stru_id", (Object)struId), false);
        if (ToolUtil.isEmpty((Object)staff)) {
            staff = new SysStaff();
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("orgInfo", orgInfo);
        dataMap.put("staff", staff);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"employee:edit"})
    @RequestMapping(value={"/employeeEdit"})
    @BussinessLog(key="/employeeFront/employeeEdit", type="04", value="\u4eba\u5458\u4fee\u6539")
    @ResponseBody
    public ApiResponse<Map<String, Object>> employeeEdit(@RequestBody Map<String, String> map) {
        String orgId = map.get("orgId");
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(orgId);
        SysStaff staff = (SysStaff)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"stru_id", (Object)orgId), false);
        if (ToolUtil.isEmpty((Object)staff)) {
            staff = new SysStaff();
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("orgInfo", orgInfo);
        dataMap.put("staff", staff);
        dataMap.put("operation", this.iSysDicRefService.getDicListByType("staff_position"));
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"employee:save"})
    @RequestMapping(value={"/emplInfoSave"})
    @BussinessLog(key="/employeeFront/employeeAdd", type="01", value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u65b0\u589e", dict=StruDict.class)
    @ResponseBody
    public ApiResponse<Object> emplInfoSave(@RequestBody Map<String, String> map) {
        SysStru sysStru = new SysStru();
        SysOrgan sysOrgan = new SysOrgan();
        SysStaff sysStaff = new SysStaff();
        sysStru.setParentId(map.get("parentId"));
        sysStru.setStruType(map.get("struType"));
        sysStru.setStruLevel(new BigDecimal(map.get("struLevel") == null ? "1" : map.get("struLevel")));
        sysStru.setStaffPosition(map.get("staffPosition"));
        sysStru.setIsEmployee(map.get("isEmployee"));
        sysStru.setStruOrder(new BigDecimal(map.get("struOrder") == null ? "1" : map.get("struOrder")));
        sysOrgan.setOrganName(map.get("organName"));
        sysOrgan.setParentTypeCode(map.get("parentTypeCode"));
        sysOrgan.setBeginDate(map.get("beginDate"));
        sysOrgan.setEndDate(map.get("endDate"));
        sysOrgan.setOrganType(map.get("organType"));
        sysOrgan.setOrganCode(map.get("organCode"));
        sysStaff.setSex(map.get("sex"));
        sysStaff.setBirthday(map.get("birthday"));
        sysStaff.setIdcard(map.get("idcard"));
        sysStaff.setAddress(map.get("address"));
        sysStaff.setWorkId(map.get("workId"));
        sysStaff.setWorkDate(map.get("workDate"));
        sysStaff.setGraduateDate(map.get("graduateDate"));
        sysStaff.setGraduateSchool(map.get("graduateSchool"));
        if (this.staffUserService.isExistIdcard(sysStaff.getIdcard()).booleanValue()) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u8be5\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\uff01");
        }
        SysStru parent = (SysStru)this.iSysStruService.getById((Serializable)((Object)sysStru.getParentId()));
        int count = this.iSysStruRuleService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"sys_organ_type", (Object)parent.getStruType())).eq((Object)"organ_type", (Object)"9"));
        if (count < 1) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u65b0\u589e\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff09");
        }
        if (this.globalProperties.isOperateStaffWithUser()) {
            boolean tenantFlag;
            if (this.sysUsersService.isExistAccount(sysOrgan.getOrganName())) {
                return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
            }
            this.staffUserService.addStaffUser(sysStru, sysOrgan, sysStaff, null, null);
            boolean bl = tenantFlag = this.globalProperties.isTenantOpen() && "2".equals(this.globalProperties.getTenantUserModel());
            if (tenantFlag) {
                List sysUsers = this.sysUsersService.list((Wrapper)new QueryWrapper().eq((Object)"USER_NAME", (Object)map.get("organName")));
                SysUsers users = (SysUsers)sysUsers.get(0);
                boolean existAccount = this.sysLoginUserService.validateAccount(map.get("organName"));
                if (existAccount) {
                    return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
                }
                this.sysLoginUserService.syncAddUser(users);
            }
        } else {
            this.sysEmployeeService.addStaff(sysStru, sysOrgan, sysStaff);
        }
        String organIds = map.get("organIds") == null ? "" : String.valueOf(map.get("organIds"));
        String sysStruId = sysStru.getStruId();
        Boolean saveAssistOrgan = this.iSysStruAssistOrganService.saveAssistOrgan(organIds, sysStruId);
        if (!saveAssistOrgan.booleanValue()) {
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success((int)SUCCESS_TIP.getCode(), (String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/judgeAddRules"})
    @BussinessLog(key="/employeeFront/judgeAddRules", type="04", value="\u65ad\u8be5\u7ec4\u7ec7\u673a\u6784\u4e0b\u80fd\u5426\u65b0\u589e\u4eba\u5458")
    @ResponseBody
    public ApiResponse<Boolean> judgeAddRules(@RequestBody Map<String, String> map) {
        String parentId = map.get("parentId");
        SysStru parent = (SysStru)this.iSysStruService.getById((Serializable)((Object)parentId));
        int count = this.iSysStruRuleService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"sys_organ_type", (Object)parent.getStruType())).eq((Object)"organ_type", (Object)"9"));
        if (count < 1) {
            return ApiResponse.data((Object)false);
        }
        return ApiResponse.data((Object)true);
    }

    @RequiresPermissions(value={"employee:editSave"})
    @RequestMapping(value={"/emplInfoEditSave"})
    @BussinessLog(key="/employeeFront/employeeEdit", type="03", value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u4fee\u6539", pk="struId,organId", dict=StruDict.class)
    @ResponseBody
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    public ApiResponse<Object> emplInfoEditSave(@RequestBody Map<String, String> map) {
        SysStru sysStru = new SysStru();
        SysOrgan sysOrgan = new SysOrgan();
        SysStaff sysStaff = new SysStaff();
        sysStru.setStruId(map.get("struId"));
        sysStru.setStruType(map.get("struType"));
        sysStru.setOrganId(map.get("organId"));
        sysStru.setParentId(map.get("parentId"));
        sysStru.setStruLevel(new BigDecimal(map.get("struLevel") == null ? "1" : map.get("struLevel")));
        sysStru.setStruOrder(new BigDecimal(map.get("struOrder") == null ? "1" : map.get("struOrder")));
        sysStru.setStaffPosition(map.get("staffPosition"));
        sysOrgan.setOrganId(map.get("organId"));
        sysOrgan.setOrganCode(map.get("organCode"));
        sysOrgan.setOrganName(map.get("organName"));
        sysOrgan.setOrganType(map.get("organType"));
        sysOrgan.setBeginDate(map.get("beginDate"));
        sysOrgan.setEndDate(map.get("endDate"));
        sysStaff.setStaffId(map.get("staffId"));
        sysStaff.setStruId(map.get("struId"));
        sysStaff.setSex(map.get("sex"));
        sysStaff.setBirthday(map.get("birthday"));
        sysStaff.setIdcard(map.get("idcard"));
        sysStaff.setAddress(map.get("address"));
        sysStaff.setWorkId(map.get("workId"));
        sysStaff.setWorkDate(map.get("workDate"));
        sysStaff.setGraduateDate(map.get("graduateDate"));
        sysStaff.setGraduateSchool(map.get("graduateSchool"));
        String organIds = map.get("organIds") == null ? "" : String.valueOf(map.get("organIds"));
        String idcard = ((SysStaff)this.staffUserService.getById((Serializable)((Object)sysStaff.getStaffId()))).getIdcard();
        if (!idcard.equals(sysStaff.getIdcard()) && this.staffUserService.isExistIdcard(sysStaff.getIdcard()).booleanValue()) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u8be5\u8eab\u4efd\u8bc1\u53f7\u5df2\u5b58\u5728\uff01");
        }
        if (!this.iSysStruAuditService.checkCanOperate(sysStru.getStruId())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
        QueryWrapper ew = new QueryWrapper();
        ew.eq((Object)"PARENT_ID", (Object)sysStru.getParentId());
        ew.eq((Object)"IN_USE", (Object)"1");
        ew.eq((Object)"STRU_ORDER", (Object)sysStru.getStruOrder());
        ew.ne((Object)"STRU_ID", (Object)sysStru.getStruId());
        int num = this.sysStruService.count((Wrapper)ew);
        if (num > 0) {
            return ApiResponse.fail((String)"\u6392\u5e8f\u503c\u5df2\u5b58\u5728\uff01");
        }
        if (!this.globalProperties.isOperateStaffWithUser()) {
            Tip tip = this.sysEmployeeService.editStaffVue(sysStru, sysOrgan, sysStaff, organIds);
            return ApiResponse.fail((int)tip.getCode(), (String)tip.getMessage());
        }
        this.staffUserService.editStaffUserVue(sysStru, sysOrgan, sysStaff, organIds, null, null, null);
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(sysStru.getStruId());
        LogObjectHolder.me().set((Object)orgInfo);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"employee:del"})
    @RequestMapping(value={"/delEmployeeById"})
    @ResponseBody
    @BussinessLog(key="/employeeFront/delEmployeeById", type="02", value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u5220\u9664")
    public ApiResponse<Object> delEmployeeById(@RequestBody Map<String, String> map) {
        String orgId = map.get("orgId");
        if (this.globalProperties.isOperateStaffWithUser()) {
            JSONObject result = this.staffUserService.deleteStaffUserVue(orgId);
            if (result.getBoolean("success").booleanValue()) {
                return ApiResponse.success((int)HttpCode.OK.value(), (String)result.getString("msg"));
            }
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)result.getString("msg"));
        }
        JSONObject result = this.orgMaintenanceService.delOrgByIdVue(orgId, Boolean.valueOf(false));
        if (result.getBoolean("success").booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)result.getString("msg"));
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)result.getString("msg"));
    }

    @RequestMapping(value={"/staffTransfer"})
    @ResponseBody
    @RequiresPermissions(value={"employee:staffTransfer"})
    @BussinessLog(key="/employeeFront/staffTransfer", type="03", value="\u4eba\u5458\u8f6c\u79fb")
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    public ApiResponse<Object> orgTreeChange(@RequestBody Map<String, Object> map) {
        String changeLevel;
        String isRoot;
        String orgType;
        String parentId;
        String struId = map.get("orgId") == null ? null : map.get("orgId").toString();
        JSONObject result = this.orgMaintenanceService.orgTreeChangeVue(struId, parentId = map.get("parentId") == null ? null : map.get("parentId").toString(), orgType = map.get("orgType") == null ? null : map.get("orgType").toString(), isRoot = map.get("isRoot") == null ? null : map.get("isRoot").toString(), changeLevel = map.get("changeLevel") == null ? null : map.get("changeLevel").toString(), Boolean.valueOf(false));
        if (result.getBoolean("success").booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)result.getString("msg"));
        }
        return ApiResponse.success((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)result.getString("msg"));
    }

    @RequiresPermissions(value={"employee:employeeTreeById"})
    @RequestMapping(value={"/employeeTreeById"})
    @BussinessLog(key="/employeeFront/employeeTreeById", type="04", value="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u4eba\u5458\u6811")
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> employeeTreeById(@RequestBody Map<String, String> map) {
        String orgId;
        String string = orgId = map.get("orgId") == null ? "" : map.get("orgId").trim();
        if (this.globalProperties.isUserOnOneEmp()) {
            return ApiResponse.data(ForestNodeMerger.merge(this.sysEmployeeService.getEmployeeTreeById(orgId, true)));
        }
        return ApiResponse.data(ForestNodeMerger.merge(this.sysEmployeeService.getEmployeeTreeById(orgId)));
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"employee:exportData"})
    @BussinessLog(key="/employeeFront/exportData", type="03", value="\u4eba\u5458\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.sysEmployeeService.exportDataVue(idList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @ResponseBody
    @RequiresPermissions(value={"employee:importData"})
    @BussinessLog(key="/employeeFront/importData", type="03", value="\u4eba\u5458\u6570\u636e\u5bfc\u5165")
    public ApiResponse<Object> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return ApiResponse.data((Object)this.sysEmployeeService.importVueStaff(content));
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/saveOrgan"})
    @ResponseBody
    public ApiResponse<?> saveOrgan(@RequestBody Map<String, Object> body) {
        String sysStruId;
        String organIds = body.get("organIds") == null ? "" : String.valueOf(body.get("organIds"));
        String string = sysStruId = body.get("sysStruId") == null ? "" : String.valueOf(body.get("sysStruId"));
        if (ToolUtil.equals((Object)"", (Object)sysStruId)) {
            return ApiResponse.fail((String)"\u6570\u636e\u4e0d\u5b8c\u6574");
        }
        Boolean saveAssistOrgan = this.iSysStruAssistOrganService.saveAssistOrgan(organIds, sysStruId);
        if (!saveAssistOrgan.booleanValue()) {
            return ApiResponse.fail((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success((int)SUCCESS_TIP.getCode(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(path={"/initOrgTree"})
    @ResponseBody
    public ApiResponse<?> getOrgTree(@RequestBody Map<String, Object> map) {
        String isEmployee = map.get("isEmployee") == null ? null : map.get("isEmployee").toString();
        String parentId = map.get("parentId") == null ? null : map.get("parentId").toString();
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysStruAssistOrganService.getOrgTree(isEmployee, parentId)));
    }

    @RequestMapping(path={"/initLazyOrgTree"})
    @ResponseBody
    public ApiResponse<?> initLazyOrgTree(@RequestBody Map<String, Object> map) {
        String parentId = map.get("parentId") == null ? null : map.get("parentId").toString();
        String disabledId = map.get("disabledId") == null ? null : map.get("disabledId").toString();
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysStruAssistOrganService.getLazyOrgTree(parentId, disabledId)));
    }

    @RequestMapping(value={"/getAssistOrgan"})
    @ResponseBody
    public ApiResponse<?> assistOrgan(@RequestBody Map<String, Object> body) {
        String struId = body.get("struId") == null ? "" : String.valueOf(body.get("struId"));
        List assistOrgan = this.iSysStruAssistOrganService.getAssistOrgan(struId);
        return ApiResponse.data((Object)assistOrgan);
    }

    @RequestMapping(value={"/orgTreeVue"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> orgTree(@RequestBody Map<String, Object> map) {
        String label = map.get("label") == null ? null : map.get("label").toString();
        String parentId = map.get("struId") == null ? "#" : map.get("struId").toString();
        String flag = map.get("flag") == null ? "true" : map.get("flag").toString();
        List<JSTreeModel> orgTrees = ForestNodeMerger.merge(this.iSysStruService.getOrgTree(label, parentId, flag));
        return ApiResponse.data(orgTrees);
    }

    @RequestMapping(value={"/orgUserStaff"})
    @ResponseBody
    public ApiResponse<?> orgUserStaff(@RequestBody Map<String, Object> map) {
        String struId = map.get("struId") == null ? null : map.get("struId").toString();
        return ApiResponse.data((Object)this.staffUserService.queryUserStaff(struId));
    }

    @RequestMapping(value={"/getOrgUerInfo"})
    @ResponseBody
    public ApiResponse<?> getOrgUerInfo(@RequestBody Map<String, Object> map) {
        String ids;
        String type = map.get("type") == null ? null : map.get("type").toString();
        String string = ids = map.get("ids") == null ? null : map.get("ids").toString();
        if (ToolUtil.isNotEmpty((Object)ids)) {
            String[] struIds = ids.split(",");
            if ("1".equals(type)) {
                List orgStru = this.orgMaintenanceService.queryOrgStru(struIds);
                return ApiResponse.data((Object)orgStru);
            }
            List staffs = this.staffUserService.list((Wrapper)new QueryWrapper().in((Object)"STRU_ID", Arrays.asList(struIds)));
            return ApiResponse.data((Object)staffs);
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u9519\u8bef");
    }

    @RequestMapping(value={"/queryOrgTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> queryOrgTree(@RequestParam(value="orgName") String orgName) {
        return ApiResponse.data(ForestNodeMerger.merge(this.orgMaintenanceService.getSpecialOrgTree(orgName)));
    }

    @RequestMapping(value={"/queryStaffTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> queryStaffTree(@RequestParam(value="staffName", required=false) String staffName) {
        return ApiResponse.data(ForestNodeMerger.merge(this.orgMaintenanceService.getSpecialStaffTree(staffName)));
    }
}

