/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.system.idtable;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bsp.permit.model.SysIdtable;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.service.TableService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.datasource.DruidProperties;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/idtableFront"})
public class IdtableFrontController
extends BaseController {
    @Resource
    ISysIdtableService sysIdtableService;
    @Resource
    private TableService tableService;
    @Autowired
    private DruidProperties druidProperties;

    @RequestMapping(value={"/getAllTable"})
    @BussinessLog(key="/idtableFront/getAllTable", type="04", value="\u67e5\u8be2\u6240\u6709\u7684\u8868")
    public ApiResponse<List<Map<String, Object>>> getAllTable() throws SQLException {
        List list = this.tableService.getTables();
        String dbUrl = this.druidProperties.getUrl();
        if (dbUrl.startsWith("jdbc:postgresql")) {
            ArrayList newList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                Set se = ((Map)list.get(i)).keySet();
                for (String set : se) {
                    map.put(set.toUpperCase(), ((Map)list.get(i)).get(set).toString().toUpperCase());
                }
                newList.add(map);
            }
            return ApiResponse.data(newList);
        }
        return ApiResponse.data((Object)list);
    }

    @RequestMapping(value={"/list"})
    @BussinessLog(key="/idtableFront/list", type="04", value="\u6700\u5927\u53f7\u8868\u5217\u8868")
    @RequiresPermissions(value={"idtable:list"})
    public ApiResponse<JSONObject> list(@RequestBody Map<String, Object> map) {
        String serTableName;
        String serFieldName = map.get("fieldName") == null ? null : map.get("fieldName").toString();
        String string = serTableName = map.get("tableName") == null ? null : map.get("tableName").toString();
        if (ToolUtil.isNotEmpty((Object)serTableName)) {
            serTableName = serTableName.toLowerCase();
        }
        if (ToolUtil.isNotEmpty((Object)serFieldName)) {
            serFieldName = serFieldName.replace("%", "\\\\%");
        }
        String page = map.get("current") == null ? "1" : map.get("current").toString();
        String limit = map.get("size") == null ? "10" : map.get("size").toString();
        JSONObject result = this.sysIdtableService.getList(page, limit, "", serFieldName, serTableName);
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(value={"/getAllList"})
    @BussinessLog(key="/idtableFront/getAllList", type="04", value="\u6700\u5927\u53f7\u8868\u5217\u8868")
    @RequiresPermissions(value={"idtable:list"})
    public ApiResponse<JSONObject> getAllList(@RequestBody Map<String, Object> map) {
        String serTableName;
        String serFieldName = map.get("fieldName") == null ? null : map.get("fieldName").toString();
        String string = serTableName = map.get("tableName") == null ? null : map.get("tableName").toString();
        if (ToolUtil.isNotEmpty((Object)serTableName)) {
            serTableName = serTableName.toLowerCase();
        }
        if (ToolUtil.isNotEmpty((Object)serFieldName)) {
            serFieldName = serFieldName.replace("%", "\\\\%");
        }
        JSONObject result = this.sysIdtableService.getAllList(serFieldName, serTableName);
        return ApiResponse.data((Object)result);
    }

    @BussinessLog(key="/idtableFront/addSave", type="01", value="\u6700\u5927\u53f7\u8868\u65b0\u589e\u4fdd\u5b58")
    @RequiresPermissions(value={"idtable:addSave"})
    @RequestMapping(value={"/addSave"})
    public ApiResponse<?> addSave(@RequestBody SysIdtable sysIdtable) {
        String fieldName = sysIdtable.getFieldName();
        String tableName = sysIdtable.getTableName().toLowerCase();
        sysIdtable.setIsGlobal("0");
        sysIdtable.setTableName(tableName);
        sysIdtable.setFieldName(fieldName.toUpperCase());
        SysIdtable idtable = this.sysIdtableService.getIdtableByQuery(fieldName, tableName);
        if (ToolUtil.isNotEmpty((Object)idtable)) {
            return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"busNameAndTableNameExist");
        }
        if (this.sysIdtableService.saveIdtable(sysIdtable) == 1) {
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)500, (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @BussinessLog(key="/idtableFront/editSave", type="03", value="\u6700\u5927\u53f7\u8868\u4fee\u6539\u4fdd\u5b58")
    @RequiresPermissions(value={"idtable:editSave"})
    @RequestMapping(value={"/editSave"})
    public ApiResponse<?> editSave(@RequestBody SysIdtable sysIdtable) {
        String tableName;
        String fieldName = sysIdtable.getFieldName();
        SysIdtable idtable = this.sysIdtableService.getIdtableByQuery(fieldName, tableName = sysIdtable.getTableName());
        if (ToolUtil.isNotEmpty((Object)idtable) && !idtable.getIdId().equals(sysIdtable.getIdId())) {
            return ApiResponse.fail((int)500, (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        SysIdtable sysIdtable1 = (SysIdtable)this.sysIdtableService.getById((Serializable)((Object)sysIdtable.getIdId()));
        LogObjectHolder.me().set((Object)sysIdtable1);
        if (this.sysIdtableService.saveIdtable(sysIdtable) == 1) {
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)500, (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @BussinessLog(key="/idtableFront/del", type="02", value="\u6700\u5927\u53f7\u8868\u5220\u9664")
    @RequiresPermissions(value={"idtable:del"})
    @RequestMapping(value={"/delByIds"})
    public ApiResponse<?> delByIds(@RequestBody Map<String, String> map) {
        String[] ids = map.get("ids").split(",");
        if (this.sysIdtableService.delByIds(Arrays.asList(ids))) {
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)500, (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/exportData"})
    @BussinessLog(key="/idtableFront/exportData", type="03", value="\u6700\u5927\u53f7\u8868\u5bfc\u51fa")
    @RequiresPermissions(value={"idtable:exportData"})
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.sysIdtableService.exportData(idList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @BussinessLog(key="/idtableFront/importData", type="03", value="\u6700\u5927\u53f7\u8868\u5bfc\u5165")
    @RequiresPermissions(value={"idtable:importData"})
    public ApiResponse<JSONObject> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        JSONObject result = this.sysIdtableService.importIdTableData(content);
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(value={"/getCurrentCode"})
    @BussinessLog(key="/idtableFront/getCurrentCode", type="04", value="\u83b7\u53d6\u5f53\u524d\u7f16\u53f7")
    public ApiResponse<String> getCurrentCode(@RequestBody Map<String, String> map) {
        String fieldName = ToolUtil.isNotEmpty((Object)map.get("fieldName")) ? map.get("fieldName") : "";
        String tableName = ToolUtil.isNotEmpty((Object)map.get("tableName")) ? map.get("tableName") : "";
        String parentNumber = ToolUtil.isNotEmpty((Object)map.get("parentNumber")) ? map.get("parentNumber") : "";
        String currentCode = ToolUtil.isNotEmpty((Object)parentNumber) ? this.sysIdtableService.getCurrentCode(fieldName, tableName, parentNumber) : this.sysIdtableService.getCurrentCode(fieldName, tableName);
        return ApiResponse.data((Object)currentCode);
    }
}

