/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.system.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.system.dict.service.SysDicFrontService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.sys.model.DicGroup;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.model.DicType;
import com.jxdinfo.hussar.core.sys.service.ISysDicGroupService;
import com.jxdinfo.hussar.core.sys.service.ISysDicSingleService;
import com.jxdinfo.hussar.core.sys.service.ISysDicTypeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysDicFrontServiceImpl
implements SysDicFrontService {
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicTypeService dicTypeService;

    @Override
    public List<JSTreeModel> dicTypeTreeData() {
        List dicChilds;
        List types;
        ArrayList<JSTreeModel> mapList = new ArrayList<JSTreeModel>();
        List groups = this.dicGroupService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"SORT"));
        if (groups != null && groups.size() > 0) {
            for (DicGroup group : groups) {
                JSTreeModel tempObject = new JSTreeModel();
                tempObject.setId(group.getId());
                tempObject.setParent(group.getParentId());
                tempObject.setText(group.getGroupDescription());
                tempObject.setType("dict");
                tempObject.setRangeType(group.getRangeType());
                mapList.add(tempObject);
            }
        }
        if ((types = this.dicTypeService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"SORT"))) != null && types.size() > 0) {
            ArrayList<String> typeIds = new ArrayList<String>();
            for (Object type : types) {
                typeIds.add(type.getId());
            }
            List allDics = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"type_id", typeIds)).orderByAsc((Object)"sort"));
            for (DicType type : types) {
                String rangeType = type.getRangeType();
                String typeName = type.getTypeName();
                JSTreeModel tempObject = new JSTreeModel();
                tempObject.setId(type.getId());
                tempObject.setParent(type.getParentId());
                tempObject.setText(type.getTypeDescription());
                tempObject.setType("type");
                tempObject.setRangeType(rangeType);
                tempObject.setTypeName(typeName);
                mapList.add(tempObject);
                if (allDics == null || allDics.size() <= 0) continue;
                ArrayList<DicSingle> dics = new ArrayList<DicSingle>();
                for (DicSingle dicSingle : allDics) {
                    if (!type.getId().equals(dicSingle.getTypeId())) continue;
                    dics.add(dicSingle);
                }
                if (dics.size() <= 0) continue;
                for (DicSingle dic : dics) {
                    tempObject = new JSTreeModel();
                    tempObject.setId(dic.getId());
                    tempObject.setParent(dic.getTypeId());
                    tempObject.setText(dic.getLabel());
                    tempObject.setType("dic");
                    tempObject.setRangeType(rangeType);
                    tempObject.setTypeName(typeName);
                    mapList.add(tempObject);
                }
            }
        }
        if ((dicChilds = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().isNotNull((Object)"PARENT_ID")).orderByAsc((Object)"SORT"))) != null && dicChilds.size() > 0) {
            for (DicSingle dicChild : dicChilds) {
                JSTreeModel tempObject = new JSTreeModel();
                tempObject.setId(dicChild.getId());
                tempObject.setParent(dicChild.getParentId());
                tempObject.setText(dicChild.getLabel());
                tempObject.setType("dic");
                tempObject.setRangeType("child");
                tempObject.setTypeName("child");
                mapList.add(tempObject);
            }
        }
        return mapList;
    }

    @Override
    public List<JSTreeModel> dicOrderTreeData(String typeId) {
        ArrayList<JSTreeModel> mapList = new ArrayList<JSTreeModel>();
        DicType pDic = (DicType)this.dicTypeService.getById((Serializable)((Object)typeId));
        if (pDic != null) {
            JSTreeModel parent = new JSTreeModel();
            parent.setId(pDic.getId());
            parent.setParent("#");
            parent.setText(pDic.getTypeDescription());
            parent.setType("type");
            mapList.add(parent);
            DicSingle finder = new DicSingle();
            finder.setTypeId(typeId);
            List subDict = this.dicSingleService.list((Wrapper)new QueryWrapper((Object)finder).orderByAsc((Object)"SORT"));
            if (subDict != null && subDict.size() > 0) {
                for (DicSingle dic : subDict) {
                    JSTreeModel tempObject = new JSTreeModel();
                    tempObject.setId(dic.getId());
                    tempObject.setParent(dic.getTypeId());
                    tempObject.setText(dic.getLabel());
                    tempObject.setType("dic");
                    mapList.add(tempObject);
                }
            }
        }
        return mapList;
    }
}

