/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.choose.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bsp.choose.model.ChooseGroup;
import com.jxdinfo.hussar.bsp.choose.service.ChooseGroupService;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/chooseGroup"})
public class ChooseGroupController
extends BaseController {
    @Resource
    ChooseGroupService chooseGroupService;

    @PostMapping(value={"/saveChooseGroup"})
    public ApiResponse<ChooseGroup> saveChooseGroup(@RequestBody Map<String, Object> map) {
        String dbName = map.get("dbName") != null ? map.get("dbName").toString() : null;
        String groupId = map.get("groupId") == null ? null : map.get("groupId").toString();
        String type = map.get("type") == null ? null : map.get("type").toString();
        String groupName = map.get("groupName") == null ? null : map.get("groupName").toString();
        String struIds = map.get("struIds") == null ? "" : map.get("struIds").toString();
        String roleIds = map.get("roleIds") == null ? "" : map.get("roleIds").toString();
        List<String> struIdsList = Arrays.asList(struIds.split(","));
        List<String> roleIdsList = Arrays.asList(roleIds.split(","));
        if (ToolUtil.isEmpty((Object)groupId)) {
            return this.chooseGroupService.saveChooseGroup(groupName, type, struIdsList, roleIdsList, dbName);
        }
        return this.chooseGroupService.updateChooseGroup(groupId, groupName, type, struIdsList, roleIdsList);
    }

    @PostMapping(value={"/saveGroup"})
    public ApiResponse<Tip> saveGroup(@RequestBody Map<String, String> map) {
        String dbName = map.get("dbName");
        List delList = JSONObject.parseArray((String)map.get("del"), ChooseGroup.class);
        List updateList = JSONObject.parseArray((String)map.get("insertAndUpdate"), ChooseGroup.class);
        return this.chooseGroupService.saveGroup(delList, updateList, dbName);
    }

    @PostMapping(value={"/deleteChooseGroup"})
    public ApiResponse<Tip> deleteChooseGroup(@RequestBody Map<String, String> map) {
        String groupIds = map.get("groupIds");
        if (ToolUtil.isEmpty((Object)groupIds)) {
            throw new HussarException("\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> groupIdsList = Arrays.asList(groupIds.split(","));
        return this.chooseGroupService.deleteChooseGroup(groupIdsList);
    }

    @GetMapping(value={"/queryChooseGroup"})
    public ApiResponse<Map<String, Object>> queryChooseGroup(@RequestParam(value="type") String type, @RequestParam(value="dbName") String dbName) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        List list = this.chooseGroupService.queryChooseGroup(type, dbName);
        result.put("count", list.size());
        result.put("data", list);
        result.put("code", "0");
        return ApiResponse.data(result);
    }

    @PostMapping(value={"/queryChooseGroupDetail"})
    public ApiResponse<Map<String, Object>> queryChooseGroupDetail(@RequestBody Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        String groupId = map.get("groupId") == null ? null : map.get("groupId").toString();
        String chooseType = map.get("chooseType") == null ? null : map.get("chooseType").toString();
        List list = this.chooseGroupService.queryChooseGroupDetail(groupId, chooseType);
        result.put("count", list.size());
        result.put("data", list);
        result.put("code", "0");
        return ApiResponse.data(result);
    }

    @GetMapping(value={"/queryChooseStru"})
    public ApiResponse<Map<String, Object>> queryChooseStru(@RequestParam(value="type") String type) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        List list = this.chooseGroupService.queryChooseStru(type);
        result.put("count", list.size());
        result.put("data", list);
        result.put("code", "0");
        return ApiResponse.data(result);
    }

    @PostMapping(value={"/queryChooseStruRole"})
    public ApiResponse<Map<String, Object>> queryChooseStruRole(@RequestBody Map<String, Object> map) {
        String struId = map.get("struId") == null ? null : map.get("struId").toString();
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        List list = this.chooseGroupService.queryChooseStruRole(struId);
        result.put("count", list.size());
        result.put("data", list);
        result.put("code", "0");
        return ApiResponse.data(result);
    }
}

