/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.permit.dictmap.IncompatibleRolesDict;
import com.jxdinfo.hussar.bsp.permit.model.SysConfRoles;
import com.jxdinfo.hussar.bsp.permit.model.SysConfRoleset;
import com.jxdinfo.hussar.bsp.permit.model.SysRoles;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesetService;
import com.jxdinfo.hussar.bsp.permit.vo.SysConfRolesVo;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/incompatibleRolesFront"})
public class IncompatibleRolesFrontController
extends BaseController {
    @Resource
    private ISysConfRolesetService isConfRolesetService;
    @Resource
    private ISysConfRolesService isConfRolesService;

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"incompatibleRoles:list"})
    public ApiResponse<Map<String, Object>> list(@RequestBody Map<String, Object> map) {
        String limit;
        String org = map.get("orgId") == null ? null : map.get("orgId").toString();
        String name = map.get("setName") == null ? null : map.get("setName").toString();
        String page = map.get("current") == null ? "1" : map.get("current").toString();
        String string = limit = map.get("size") == null ? "10" : map.get("size").toString();
        if (!StringUtils.isEmpty((CharSequence)name)) {
            name = name.replace("%", "\\\\%").replace("_", "\\\\_");
        }
        Map result = this.isConfRolesetService.getRolesList(page, limit, name, org);
        return ApiResponse.data((Object)result);
    }

    @RequiresPermissions(value={"incompatibleRoles:selectInRoles"})
    @RequestMapping(value={"/selectInRoles"})
    @BussinessLog(key="/incompatibleRolesFront/selectInRoles", type="04", value="\u83b7\u53d6\u4e0d\u76f8\u5bb9\u89d2\u8272\u8d44\u6e90")
    public ApiResponse<List<Map<String, String>>> selectInRoles() {
        List list = this.isConfRolesService.getSelectInRoles("");
        ArrayList result = new ArrayList();
        for (SysRoles sysRoles : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", sysRoles.getRoleId());
            map.put("name", sysRoles.getRoleName());
            result.add(map);
        }
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/addRole"})
    @RequiresPermissions(value={"incompatibleRoles:addRole"})
    @BussinessLog(key="/incompatibleRolesFront/addRole", type="01", pk="setId", value="\u65b0\u589e\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", dict=IncompatibleRolesDict.class)
    public ApiResponse<?> addRole(@RequestBody Map<String, Object> body) {
        String rolesName = body.get("setName") == null ? null : body.get("setName").toString().trim();
        String count = body.get("cardinality") == null ? null : body.get("cardinality").toString().trim();
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("rolesName", rolesName);
        map.put("count", count);
        List<SysConfRoleset> list = this.sameRoleName(rolesName);
        if (list != null && list.size() > 0) {
            return ApiResponse.fail((int)HttpCode.BAD_REQUEST.value(), (String)"\u89d2\u8272\u96c6\u540d\u79f0\u5df2\u5b58\u5728");
        }
        boolean flag = this.isConfRolesetService.addRole(map);
        if (flag) {
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"incompatibleRoles:selectInRole"})
    @RequestMapping(value={"selectInRole"})
    @BussinessLog(key="/incompatibleRolesFront/selectInRole", type="04", pk="setId", value="\u6839\u636eid\u83b7\u53d6\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u4fe1\u606f", dict=IncompatibleRolesDict.class)
    public SysConfRoleset selectInRole(@RequestBody Map<String, String> map) {
        String rolesId = map.get("setId");
        return (SysConfRoleset)this.isConfRolesetService.getById((Serializable)((Object)rolesId));
    }

    @RequestMapping(value={"/editRole"})
    @RequiresPermissions(value={"incompatibleRoles:editRole"})
    @BussinessLog(key="/incompatibleRolesFront/editRole", type="03", pk="setName", value="\u4fee\u6539\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", dict=IncompatibleRolesDict.class)
    public ApiResponse<?> editRole(@RequestBody Map<String, String> param) {
        String id = param.get("setId");
        SysConfRoleset sysConfRoleset = (SysConfRoleset)this.isConfRolesetService.getById((Serializable)((Object)id));
        LogObjectHolder.me().set((Object)sysConfRoleset);
        String rolesName = param.get("setName").trim();
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("rolesName", rolesName);
        map.put("id", id);
        List<SysConfRoleset> list = this.sameRoleName(rolesName);
        if (list != null && list.size() > 0 && rolesName.equals(list.get(0).getSetName())) {
            return ApiResponse.fail((int)HttpCode.BAD_REQUEST.value(), (String)"\u89d2\u8272\u96c6\u540d\u79f0\u5df2\u5b58\u5728");
        }
        boolean flag = this.isConfRolesetService.editRole(map);
        if (flag) {
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((String)"\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/delRole"})
    @RequiresPermissions(value={"incompatibleRoles:delRole"})
    @BussinessLog(key="/incompatibleRolesFront/delRole", type="02", value="\u5220\u9664\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", dict=IncompatibleRolesDict.class)
    public ApiResponse<String> delRole(@RequestBody Map<String, String> map) {
        String id = map.get("setIds").trim();
        List list = this.isConfRolesetService.list((Wrapper)new QueryWrapper().in((Object)"SET_ID", Arrays.asList(id.split(","))));
        ArrayList<String> names = new ArrayList<String>();
        for (SysConfRoleset sysConfRoleset : list) {
            names.add(sysConfRoleset.getSetName());
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("setName", StringUtils.join((Object[])names.toArray(), (String)","));
        LogObjectHolder.me().set("edit_object_after", map1);
        this.isConfRolesetService.delRole(id);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"incompatibleRoles:roleView"})
    @RequestMapping(value={"/roleView"})
    public ApiResponse<List<String>> roleView(@RequestBody Map<String, String> map) {
        String id = map.get("setId").trim();
        ArrayList<String> result = new ArrayList<String>();
        List roleList = this.isConfRolesetService.getSelectInRoles(id);
        if (roleList != null && roleList.size() > 0) {
            for (SysConfRolesVo sysConfRolesVo : roleList) {
                result.add(sysConfRolesVo.getRoleId());
            }
        }
        HashMap<String, String> logMap = new HashMap<String, String>();
        SysConfRoleset sysConfRoleset = (SysConfRoleset)this.isConfRolesetService.getById((Serializable)((Object)id));
        logMap.put("roleIds", String.join((CharSequence)",", result));
        logMap.put("setName", sysConfRoleset.getSetName());
        LogObjectHolder.me().set(logMap);
        LogObjectHolder.me().set("user_tenant_connName", (Object)ShiroKit.getUser().getConnName());
        return ApiResponse.data(result);
    }

    @RequiresPermissions(value={"incompatibleRoles:transferData"})
    @RequestMapping(value={"/transferData"})
    public ApiResponse<List<Map<String, Object>>> getTransferData() {
        return ApiResponse.data((Object)this.isConfRolesetService.getTransferData());
    }

    @RequestMapping(value={"/saveInRoles"})
    @RequiresPermissions(value={"incompatibleRoles:saveInRoles"})
    @BussinessLog(key="/incompatibleRolesFront/saveInRoles", type="03", value="\u7ef4\u62a4\u4e0d\u76f8\u5bb9\u89d2\u8272", dict=IncompatibleRolesDict.class, pk="setName")
    public ApiResponse<?> saveInRoles(@RequestBody Map<String, String> param) {
        String roIds = param.get("roleIds");
        String setId = param.get("setId");
        String[] ids = roIds.split(",");
        this.isConfRolesService.remove((Wrapper)new QueryWrapper().eq((Object)"SET_ID", (Object)setId));
        ArrayList<SysConfRoles> list = new ArrayList<SysConfRoles>();
        for (String id : ids) {
            SysConfRoles sysConfRoles = new SysConfRoles();
            sysConfRoles.setSetId(setId);
            sysConfRoles.setRoleId(id);
            list.add(sysConfRoles);
        }
        if (ToolUtil.isNotEmpty(list)) {
            this.isConfRolesService.saveBatch(list, list.size());
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    private List<SysConfRoleset> sameRoleName(String name) {
        return this.isConfRolesetService.list((Wrapper)new QueryWrapper().eq((Object)"SET_NAME", (Object)name));
    }
}

