/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.message.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.bsp.message.dict.LeaveMessagesDict;
import com.jxdinfo.hussar.bsp.message.model.LeaveMessages;
import com.jxdinfo.hussar.bsp.message.service.LeaveMessagesService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.front.common.response.ResultCode;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/leaveMessages"})
public class LeaveMessagesController
extends BaseController {
    @Resource
    private LeaveMessagesService leaveMessagesService;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;

    @RequestMapping(value={"/queryMessages"})
    public ApiResponse<Map<String, Object>> queryMessages() {
        String userId = ShiroKit.getUser().getId();
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        List<LeaveMessages> list = this.leaveMessagesService.queryMessages(userId);
        int count = this.leaveMessagesService.count((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"MESSAGE_STATUS", (Object)"0")).eq((Object)"RECEIVE_USER_ID", (Object)userId));
        result.put("count", count);
        result.put("data", list);
        return ApiResponse.data(result);
    }

    @PostMapping(value={"/hussarQueryPage"})
    public ApiResponse<Map<String, Object>> hussarQueryPage(@RequestBody JSONObject queryParameters) {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        Page pager = new Page((long)Integer.parseInt(queryParameters.getString("current")), (long)Integer.parseInt(queryParameters.getString("size")));
        String sendUserName = queryParameters.getString("sendUserName");
        String startDate = queryParameters.getString("startDate");
        String endDate = queryParameters.getString("endDate");
        List<LeaveMessages> list = this.leaveMessagesService.hussarQueryPage(pager, sendUserName, startDate, endDate);
        SysBaseConfig sysBaseConfig = this.sysBaseConfigService.getSysBaseConfig("message_days");
        result.put("count", pager.getTotal());
        result.put("data", list);
        result.put("code", "0");
        result.put("days", sysBaseConfig.getConfigValue());
        return ApiResponse.data(result);
    }

    @PostMapping(value={"/del"})
    @BussinessLog(key="/leaveMessages/del", type="02", value="\u7559\u8a00\u6d88\u606f\u8868\u6279\u91cf\u5220\u9664")
    public ApiResponse<Boolean> del(@RequestParam(value="ids") String[] ids) {
        return ApiResponse.data((Object)this.leaveMessagesService.del(Arrays.asList(ids)));
    }

    @GetMapping(value={"/formQuery"})
    public ApiResponse<LeaveMessages> formQuery(@RequestParam(value="id") String id) {
        return ApiResponse.data((Object)((Object)this.leaveMessagesService.formQuery(id)));
    }

    @PostMapping(value={"/insert"})
    @BussinessLog(key="/leaveMessages/insert", type="01", value="\u7559\u8a00\u6d88\u606f\u8868\u65b0\u589e", dict=LeaveMessagesDict.class)
    public ApiResponse<Tip> insert(@RequestBody LeaveMessages leaveMessages) {
        if (ToolUtil.isEmpty((Object)leaveMessages.getReceiveUserId()) || ToolUtil.isEmpty((Object)leaveMessages.getIsTenant())) {
            return ApiResponse.fail((int)HttpCode.BAD_REQUEST.value(), (String)ResultCode.PARAM_MISS.getMessage());
        }
        boolean flag = this.leaveMessagesService.insert(leaveMessages);
        if (flag) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @PostMapping(value={"/updateSatus"})
    public ApiResponse<Boolean> updateSatus(@RequestParam(value="ids") String[] ids) {
        return ApiResponse.data((Object)this.leaveMessagesService.updateSatus(Arrays.asList(ids)));
    }
}

