/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.pdf.utils;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jodconverter.OfficeDocumentConverter;
import org.jodconverter.office.DefaultOfficeManagerBuilder;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.springframework.core.env.Environment;

public class PdfUtils {
    private static Environment env = (Environment)SpringContextHolder.getBean(Environment.class);

    private static void startService(OfficeManager officeManager) {
        try {
            officeManager.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void stopService(OfficeManager officeManager) throws OfficeException {
        if (null != officeManager) {
            officeManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pdfTransOut(Map<String, Object> map, String templatePath) {
        String pdfPath = "";
        int doc = templatePath.lastIndexOf("/");
        String templateName = templatePath.substring(doc + 1, templatePath.length());
        templatePath = templatePath.substring(0, doc);
        String docPath = env.getProperty("doc.path");
        String officePath = env.getProperty("libreoffice.path");
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String wordPath = docPath + "//" + timeStamp + ".fodt";
        PdfUtils.createDoc(map, templatePath, templateName, wordPath);
        File sourceFile = new File(wordPath);
        String tempPath = docPath + "//" + timeStamp + ".pdf";
        File tarPdfFile = new File(tempPath);
        File inputFile = sourceFile;
        String libreOfficePath = officePath;
        DefaultOfficeManagerBuilder builder = new DefaultOfficeManagerBuilder();
        builder.setOfficeHome(new File(libreOfficePath));
        builder.setPortNumber(8100);
        builder.setTaskExecutionTimeout(3000000L);
        builder.setTaskQueueTimeout(864000000L);
        OfficeManager officeManager = builder.build();
        PdfUtils.startService(officeManager);
        OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
        File outputFile = tarPdfFile;
        try {
            converter.convert(inputFile, outputFile);
            pdfPath = outputFile.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                PdfUtils.stopService(officeManager);
            }
            catch (OfficeException e) {
                e.printStackTrace();
            }
            if (sourceFile != null && sourceFile.exists()) {
                sourceFile.delete();
            }
        }
        return pdfPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDoc(Map<String, Object> dataMap, String templatePath, String templatename, String fileName) {
        Writer out = null;
        Configuration configuration = new Configuration();
        configuration.setDefaultEncoding("UTF-8");
        Template templat = null;
        try {
            configuration.setDirectoryForTemplateLoading(new File(templatePath));
            templat = configuration.getTemplate(templatename, "UTF-8");
            File outFile = new File(fileName);
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
            templat.process(dataMap, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String transferSpecialChar(String str) {
        if (str == null) {
            return str;
        }
        if ("".equals(str)) {
            return str;
        }
        return str.replaceAll("\\+", "%20").replaceAll("%28", "\\(").replaceAll("%29", "\\)").replaceAll("%3B", ";").replaceAll("%40", "@").replaceAll("%23", "\\#").replaceAll("%26", "\\&").replaceAll("%2C", "\\,").replaceAll("%2B", "\\+").replaceAll("%7D", "\\}").replaceAll("%7B", "\\{").replaceAll("%24", "\\$").replaceAll("%5E", "\\^").replaceAll("%25", "\\%").replaceAll("%7E", "\\~").replaceAll("%3D", "\\=").replaceAll("%60", "\\`");
    }

    public static boolean checkIsEmpty(String str) {
        return str == null || "".equals(str) || "null".equals(str);
    }

    public static byte[] getImageBinary(String imagePath) {
        File f = new File(imagePath);
        try {
            BufferedImage bi = ImageIO.read(f);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "jpg", baos);
            byte[] bytes = baos.toByteArray();
            return bytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map convertBean(Object bean) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        Class<?> type = bean.getClass();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String propertyName = descriptor.getName();
                if (propertyName.equals("class")) continue;
                Method readMethod = descriptor.getReadMethod();
                Object result = readMethod.invoke(bean, new Object[0]);
                if (result != null) {
                    returnMap.put(propertyName, result);
                    continue;
                }
                returnMap.put(propertyName, "");
            }
        }
        catch (Exception e) {
            return null;
        }
        return returnMap;
    }

    public static <T> List<Map<String, Object>> convertListBean(List<T> beanList, Class<T> T) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        try {
            int n = beanList.size();
            for (int i = 0; i < n; ++i) {
                T bean = beanList.get(i);
                Map map = PdfUtils.convertBean(bean);
                mapList.add(map);
            }
        }
        catch (Exception e) {
            return null;
        }
        return mapList;
    }

    private static String covnDate(String dateTime) {
        DateFormat df = null;
        Date date1 = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            Date date = sdf.parse(dateTime);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(10, 8);
            date1 = cal.getTime();
            df = new SimpleDateFormat("yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return df.format(date1);
    }
}

