/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.pdf.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.pdf.dao.TemplateFileMapper;
import com.jxdinfo.hussar.bsp.pdf.model.TemplateFile;
import com.jxdinfo.hussar.bsp.pdf.service.TemplateFileService;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateFileServiceImpl
extends ServiceImpl<TemplateFileMapper, TemplateFile>
implements TemplateFileService {
    @Autowired
    private TemplateFileMapper templateFileMapper;

    @Override
    public List<TemplateFile> hussarQuery() {
        List<TemplateFile> templateList = this.templateFileMapper.hussarQuery();
        String suffix = ".ftl";
        for (TemplateFile template : templateList) {
            String fileDir = template.getFileDir().replace("\\", "/");
            template.setFileDir(fileDir + template.getAttachmentId() + suffix);
        }
        return templateList;
    }

    @Override
    public List<TemplateFile> hussarQueryPage(Page page, String fileName) {
        return this.templateFileMapper.hussarQueryPage(page, fileName);
    }

    @Override
    public boolean insertOrUpdate(TemplateFile templateFile) {
        ShiroUser shiroUser = ShiroKit.getUser();
        templateFile.setCreateUser(shiroUser.getName());
        templateFile.setCreateDate(new Date());
        this.saveOrUpdate((Object)templateFile);
        return true;
    }

    @Override
    public TemplateFile formQuery(String id) {
        TemplateFile templateFile = (TemplateFile)((Object)this.getById((Serializable)((Object)id)));
        return templateFile;
    }

    @Override
    public boolean del(List<String> ids) {
        if (null != ids && ids.size() > 0) {
            this.removeByIds(ids);
        }
        return true;
    }

    @Override
    public List<TemplateFile> fileTypefileDir(List<String> inValues) {
        return this.templateFileMapper.fileTypefileDir(inValues);
    }
}

