/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.pdf.controller;

import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/pdf"})
public class ExportPdfController
extends BaseController {
    @RequestMapping(value={"/exportPdf"})
    @ResponseBody
    public void exportPdf(@RequestParam(value="pdfPath") String pdfPath, HttpServletResponse response) {
        InputStream bis = null;
        FilterOutputStream out = null;
        File file = new File(pdfPath);
        try {
            if (!file.exists()) {
                response.sendError(404, "File not found!");
                return;
            }
            bis = new BufferedInputStream(new FileInputStream(file), 10240);
            String fileName = URLEncoder.encode(file.getName(), "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            int len = 0;
            int i = bis.available();
            byte[] buff = new byte[i];
            while ((len = bis.read(buff)) > 0) {
                ((BufferedOutputStream)out).write(buff, 0, len);
                ((BufferedOutputStream)out).flush();
            }
        }
        catch (FileNotFoundException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.FILE_NOT_FOUND);
        }
        catch (UnsupportedEncodingException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.DOWNLOAD_ERROR);
        }
        catch (IOException e) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.DOWNLOAD_ERROR);
        }
        finally {
            try {
                if (null != bis) {
                    bis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }
}

