/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.excel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.excel.ImportExcel;
import com.jxdinfo.hussar.bsp.excel.service.ImportExcelService;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrganService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruService;
import com.jxdinfo.hussar.bsp.permit.model.SysUserRole;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.encrypt.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImportExcelServiceImpl
implements ImportExcelService {
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysStruService sysStruService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ImportExcel importExcel;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private GlobalProperties globalProperties;

    @Override
    @Transactional
    public void importUserData(MultipartFile file) {
        try {
            Row row;
            XSSFWorkbook workbook = new XSSFWorkbook(file.getInputStream());
            XSSFSheet sheet = workbook.getSheetAt(0);
            int rowNum = sheet.getLastRowNum() + 1;
            for (int i = 1; i < rowNum && (row = sheet.getRow(i)) != null; ++i) {
                SysUsers sysUsers = new SysUsers();
                sysUsers.setUserId(UUID.randomUUID().toString().replace("-", ""));
                if (row.getCell(1).getCellType().equals((Object)CellType.NUMERIC)) {
                    sysUsers.setUserName(NumberToTextConverter.toText((double)row.getCell(1).getNumericCellValue()));
                } else {
                    sysUsers.setUserName(row.getCell(1).getStringCellValue());
                }
                if (row.getCell(2).getCellType().equals((Object)CellType.NUMERIC)) {
                    sysUsers.setUserAccount(NumberToTextConverter.toText((double)row.getCell(2).getNumericCellValue()));
                } else {
                    sysUsers.setUserAccount(row.getCell(2).getStringCellValue());
                }
                if (ToolUtil.isNotEmpty((Object)row.getCell(3))) {
                    if (row.getCell(3).getCellType().equals((Object)CellType.NUMERIC)) {
                        sysUsers.setPassword(this.credentialsMatcher.passwordEncode(String.valueOf((int)row.getCell(3).getNumericCellValue()).getBytes()));
                    } else {
                        sysUsers.setPassword(this.credentialsMatcher.passwordEncode(String.valueOf(row.getCell(3).getStringCellValue()).getBytes()));
                    }
                } else {
                    sysUsers.setPassword(this.credentialsMatcher.passwordEncode(this.globalProperties.getDefaultPassword().getBytes()));
                }
                sysUsers.setAccountStatus("1");
                sysUsers.setMaxSessions(new BigDecimal(-1));
                sysUsers.setIsSys("0");
                sysUsers.setCreateTime(new Date());
                QueryWrapper sysOrganWrapper = new QueryWrapper();
                sysOrganWrapper.eq((Object)"ORGAN_NAME", (Object)row.getCell(4).getStringCellValue());
                SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getOne((Wrapper)sysOrganWrapper);
                SysStru sysStru = new SysStru();
                if (ToolUtil.isNotEmpty((Object)sysOrgan)) {
                    QueryWrapper sysStruQueryWrapper = new QueryWrapper();
                    sysStruQueryWrapper.eq((Object)"ORGAN_ID", (Object)sysOrgan.getOrganId());
                    sysStru = (SysStru)this.sysStruService.getOne((Wrapper)sysStruQueryWrapper);
                    sysUsers.setCorporationId(sysStru.getStruId());
                    sysUsers.setDepartmentId(sysStru.getStruId());
                } else {
                    sysUsers.setCorporationId("1");
                    sysUsers.setDepartmentId("1");
                }
                if (ToolUtil.isNotEmpty((Object)row.getCell(5))) {
                    if (row.getCell(5).getCellType().equals((Object)CellType.NUMERIC)) {
                        sysUsers.setEMail(NumberToTextConverter.toText((double)row.getCell(5).getNumericCellValue()));
                    } else {
                        sysUsers.setEMail(row.getCell(5).getStringCellValue());
                    }
                }
                if (ToolUtil.isNotEmpty((Object)row.getCell(6))) {
                    if (row.getCell(6).getCellType().equals((Object)CellType.NUMERIC)) {
                        sysUsers.setWeChat(NumberToTextConverter.toText((double)row.getCell(6).getNumericCellValue()));
                    } else {
                        sysUsers.setWeChat(row.getCell(6).getStringCellValue());
                    }
                }
                if (ToolUtil.isNotEmpty((Object)row.getCell(7))) {
                    if (row.getCell(7).getCellType().equals((Object)CellType.NUMERIC)) {
                        sysUsers.setTelephone(NumberToTextConverter.toText((double)row.getCell(7).getNumericCellValue()));
                    } else {
                        sysUsers.setTelephone(row.getCell(7).getStringCellValue());
                    }
                }
                if (ToolUtil.isNotEmpty((Object)row.getCell(8))) {
                    if (row.getCell(8).getCellType().equals((Object)CellType.NUMERIC)) {
                        sysUsers.setMobile(NumberToTextConverter.toText((double)row.getCell(8).getNumericCellValue()));
                    } else {
                        sysUsers.setMobile(row.getCell(8).getStringCellValue());
                    }
                }
                sysUsers.setUserOrder(new BigDecimal(i));
                SysOrgan sysOrgan1 = new SysOrgan();
                sysOrgan1.setOrganName(sysUsers.getUserName());
                sysOrgan1.setShortName(sysUsers.getUserName());
                sysOrgan1.setOrganType("9");
                sysOrgan1.setScn(new BigDecimal(i));
                String struId = this.importExcel.orgInfoSave(sysOrgan1, row.getCell(4).getStringCellValue(), "1");
                if (!ToolUtil.isNotEmpty((Object)struId)) continue;
                sysUsers.setEmployeeId(struId);
                this.sysUsersService.save((Object)sysUsers);
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(sysUsers.getUserId());
                sysUserRole.setGrantedRole("public_role");
                sysUserRole.setAdminOption("1");
                sysUserRole.setCreator(ShiroKit.getUser().getId());
                sysUserRole.setCreateTime(new Date());
                sysUserRole.setLastEditor(ShiroKit.getUser().getId());
                sysUserRole.setLastTime(new Date());
                this.sysUserRoleService.save((Object)sysUserRole);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Transactional
    public void importOrganData(MultipartFile file) {
        try {
            Row row;
            XSSFWorkbook workbook = new XSSFWorkbook(file.getInputStream());
            XSSFSheet sheet = workbook.getSheetAt(0);
            int rowNum = sheet.getLastRowNum() + 1;
            for (int i = 1; i < rowNum && (row = sheet.getRow(i)) != null; ++i) {
                String code = this.importExcel.orgTypeOption(row.getCell(4).getStringCellValue());
                SysOrgan sysOrgan = new SysOrgan();
                sysOrgan.setOrganName(row.getCell(1).getStringCellValue());
                sysOrgan.setShortName(row.getCell(2).getStringCellValue());
                sysOrgan.setOrganType(code);
                sysOrgan.setScn(new BigDecimal(i));
                this.importExcel.orgInfoSave(sysOrgan, row.getCell(3).getStringCellValue(), "0");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

