/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.tenant;

import com.baomidou.dynamic.datasource.annotation.Master;
import com.jxdinfo.hussar.bsp.tenant.model.SysTenant;
import com.jxdinfo.hussar.bsp.tenant.service.SysTenantService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tenant"})
@Master
public class SysTenantController
extends BaseController {
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private GlobalProperties globalProperties;

    @RequiresPermissions(value={"tenant:detail"})
    @RequestMapping(value={"/detail"})
    @BussinessLog(key="/tenant/detail", value="\u79df\u6237\u8be6\u60c5", type="04")
    public ApiResponse<SysTenant> detail(@RequestBody Map<String, Object> map) {
        String tenantId = map.get("tenantId") == null ? "" : map.get("tenantId").toString();
        return this.sysTenantService.getDetail(tenantId);
    }

    @RequiresPermissions(value={"tenant:list"})
    @RequestMapping(value={"/list"})
    @BussinessLog(key="/tenant/list", value="\u79df\u6237\u5217\u8868", type="04")
    public ApiResponse<Map<String, Object>> list(@RequestBody Map<String, Object> map) {
        String tenantName = map.get("tenantName") == null ? "" : map.get("tenantName").toString();
        String domain = map.get("tenantDomain") == null ? "" : map.get("tenantDomain").toString();
        String page = map.get("page") == null ? "1" : map.get("page").toString();
        String limit = map.get("limit") == null ? "10" : map.get("limit").toString();
        return ApiResponse.data((Object)this.sysTenantService.queryList(tenantName, domain, page, limit));
    }

    @RequiresPermissions(value={"tenant:add"})
    @RequestMapping(value={"/add"})
    @BussinessLog(key="/tenant/add", value="\u65b0\u589e\u79df\u6237", type="01")
    public ApiResponse<SysTenant> add(@RequestBody SysTenant sysTenant) {
        return this.sysTenantService.add(sysTenant, false);
    }

    @RequiresPermissions(value={"tenant:edit"})
    @RequestMapping(value={"/edit"})
    @BussinessLog(key="/tenant/edit", value="\u4fee\u6539\u79df\u6237\u4fe1\u606f", type="03")
    public ApiResponse<SysTenant> edit(@RequestBody SysTenant sysTenant) {
        return this.sysTenantService.edit(sysTenant);
    }

    @RequiresPermissions(value={"tenant:remove"})
    @RequestMapping(value={"/remove"})
    @BussinessLog(key="/tenant/remove", value="\u5220\u9664\u79df\u6237\u4fe1\u606f", type="02")
    public ApiResponse<SysTenant> remove(@RequestBody Map<String, Object> map) {
        String ids = map.get("ids") == null ? "" : map.get("ids").toString();
        return this.sysTenantService.delete(ids);
    }

    @RequiresPermissions(value={"tenant:getTenantCode"})
    @RequestMapping(value={"/getTenantCode"})
    @BussinessLog(key="/tenant/getTenantCode", value="\u83b7\u53d6\u79df\u6237\u7f16\u53f7", type="04")
    public ApiResponse<String> getModuleCode() {
        return ApiResponse.data((Object)this.sysTenantService.getTenantCode());
    }

    @RequestMapping(value={"/obtainSchema"})
    @BussinessLog(key="/tenant/obtainSchema", value="\u83b7\u53d6\u5f53\u524d\u79df\u6237\u6a21\u5f0f", type="04")
    public ApiResponse<Map<String, Object>> obtainSchema() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("level", this.globalProperties.getTenantLevel());
        result.put("userModel", this.globalProperties.getTenantUserModel());
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/syncTenantUser"})
    @BussinessLog(key="/tenant/syncTenantUser", value="\u540c\u6b65\u7528\u6237\u5230\u7ba1\u7406\u5458\u79df\u6237", type="01")
    public ApiResponse<?> syncTenantUser(@RequestParam(value="tenantCode") String tenantCode) {
        return this.sysTenantService.syncTenantUser(tenantCode);
    }

    @RequestMapping(value={"/getTenantTree"})
    @BussinessLog(key="/tenant/getTenantTree", value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u53ef\u9009\u62e9\u79df\u6237\u6811", type="04")
    public ApiResponse<List<JSTreeModel>> getTenantTree() {
        return ApiResponse.data(ForestNodeMerger.merge(this.sysTenantService.getTenantTree()));
    }
}

