/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.system.calendar;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.sys.model.SysCalendar;
import com.jxdinfo.hussar.core.sys.service.ISysCalendarService;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/calendarFront"})
public class WorkCalendarFrontController
extends BaseController {
    @Resource
    private ISysCalendarService sysCalendarService;

    @RequiresPermissions(value={"calendar:list"})
    @RequestMapping(value={"/list"})
    @BussinessLog(key="/calendarFront/list", type="04", value="\u83b7\u53d6\u65e5\u5386\u4e8b\u4ef6")
    public ApiResponse<List<SysCalendar>> eventsList(@RequestBody Map<String, Object> map) {
        String startTime = map.get("startTime") == null ? null : map.get("startTime").toString();
        String endTime = map.get("endTime") == null ? null : map.get("endTime").toString();
        Date start = ToolUtil.isEmpty((Object)startTime) ? null : DateUtil.parse((String)startTime, (String)"yyyy-MM-dd");
        Date end = ToolUtil.isEmpty((Object)startTime) ? null : DateUtil.parse((String)endTime, (String)"yyyy-MM-dd");
        return ApiResponse.data((Object)this.sysCalendarService.getEventsBetweenDate(start, end));
    }

    @RequestMapping(value={"/addEvent"})
    @BussinessLog(key="/calendarFront/addEvent", type="01", value="\u5de5\u4f5c\u65e5\u5386\u6279\u91cf\u65b0\u589e")
    @RequiresPermissions(value={"calendar:addEvent"})
    public ApiResponse<?> addEvent(@RequestBody SysCalendar sysCalendar) {
        List calendarList = this.sysCalendarService.getEventsBetweenDate(sysCalendar.getStartTime(), sysCalendar.getEndTime());
        if (ToolUtil.isNotEmpty((Object)calendarList)) {
            return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u8be5\u65f6\u95f4\u8303\u56f4\u5185\u5df2\u5b58\u5728\u4e8b\u4ef6\uff01\uff09");
        }
        List<Date> list = this.getBetweenDates(sysCalendar.getStartTime(), sysCalendar.getEndTime());
        if (list.size() > 31) {
            return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01\uff08\u65b0\u589e\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7\u4e00\u4e2a\u6708\uff09");
        }
        Date createTime = new Date();
        String creator = ShiroKit.getUser().getAccount();
        ArrayList<SysCalendar> sysCalendarList = new ArrayList<SysCalendar>();
        for (Date start : list) {
            SysCalendar cal = new SysCalendar();
            cal.setTitle(sysCalendar.getTitle());
            cal.setClassName(sysCalendar.getClassName());
            cal.setRemark(sysCalendar.getRemark());
            cal.setCreator(creator);
            cal.setCreateTime(createTime);
            cal.setStartTime(start);
            sysCalendarList.add(cal);
        }
        if (ToolUtil.isNotEmpty(sysCalendarList)) {
            this.sysCalendarService.saveBatch(sysCalendarList, sysCalendarList.size());
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/addOneEvent"})
    @BussinessLog(key="/calendarFront/addOneEvent", type="01", value="\u5de5\u4f5c\u65e5\u5386\u5355\u65e5\u65b0\u589e")
    @RequiresPermissions(value={"calendar:addOneEvent"})
    public ApiResponse<?> addOneEvent(@RequestBody SysCalendar sysCalendar) {
        Date createTime = new Date();
        String creator = ShiroKit.getUser().getAccount();
        sysCalendar.setCreator(creator);
        sysCalendar.setCreateTime(createTime);
        this.sysCalendarService.save((Object)sysCalendar);
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/editEvent"})
    @BussinessLog(key="/calendarFront/editEvent", type="03", value="\u5de5\u4f5c\u65e5\u5386\u4fee\u6539")
    @RequiresPermissions(value={"calendar:editEvent"})
    public ApiResponse<?> editEvent(@RequestBody SysCalendar sysCalendar) {
        this.sysCalendarService.updateById((Object)sysCalendar);
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/dayEvent"})
    @BussinessLog(key="/calendarFront/dayEvent", type="04", value="\u67e5\u8be2")
    public ApiResponse<SysCalendar> dayEvent(@RequestBody Map<String, Object> map) {
        String startTime = map.get("startTime") == null ? null : map.get("startTime").toString();
        Date start = ToolUtil.isEmpty((Object)startTime) ? null : DateUtil.parse((String)startTime, (String)"yyyy-MM-dd");
        SysCalendar sysCalendar = (SysCalendar)this.sysCalendarService.getOne((Wrapper)new QueryWrapper().eq((Object)"start_time", (Object)start), false);
        return ApiResponse.data((Object)sysCalendar);
    }

    @RequestMapping(value={"/delEvent"})
    @BussinessLog(key="/calendarFront/delEvent", type="02", value="\u5de5\u4f5c\u65e5\u5386\u6279\u91cf\u5220\u9664")
    @RequiresPermissions(value={"calendar:delEvent"})
    public ApiResponse<?> delEvent(@RequestBody SysCalendar sysCalendar) {
        this.sysCalendarService.remove((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().ge((Object)"start_time", (Object)sysCalendar.getStartTime())).le((Object)"start_time", (Object)sysCalendar.getEndTime())).in((Object)"class_name", new Object[]{sysCalendar.getClassName()}));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delOneEvent"})
    @BussinessLog(key="/calendarFront/delOneEvent", type="02", value="\u5de5\u4f5c\u65e5\u5386\u5355\u65e5\u5220\u9664")
    @RequiresPermissions(value={"calendar:delOneEvent"})
    public ApiResponse<?> delOneEvent(@RequestBody Map<String, String> map) {
        String id = map.get("id");
        this.sysCalendarService.removeById((Serializable)((Object)id));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private List<Date> getBetweenDates(Date startDate, Date endDate) {
        Date newStartDate = startDate;
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(newStartDate);
        while (newStartDate.getTime() <= endDate.getTime()) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
            newStartDate = tempStart.getTime();
        }
        return result;
    }
}

