/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.bsp.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.bsp.loginuser.service.SysLoginUserService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.ProxyTreeVo;
import com.jxdinfo.hussar.bsp.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.constant.dictmap.UserDict;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.datasource.DataSourceUtil;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.encrypt.CryptoUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.encrypt.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/userFront"})
public class SysUsersFrontController
extends BaseController {
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private ISysConfRolesService iSysConfRolesService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private HussarProperties hussarProperties;
    @Resource
    private ISysUsersAuditService iSysUsersAuditService;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private SysLoginUserService sysLoginUserService;
    @Resource
    private HussarCacheManager hussarCacheManager;
    @Autowired
    private RedisTemplate redisTemplate;

    @RequestMapping(value={"/gradeRole"})
    @BussinessLog(key="/userFront/gradeRole", type="04", value="\u5f53\u524d\u7528\u6237\u662f\u5426\u662f\u5206\u7ea7\u7ba1\u7406\u5458")
    public ApiResponse<Boolean> gradeRole() {
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        return ApiResponse.data((Object)isGradeAdmin);
    }

    @RequiresPermissions(value={"user:userTree"})
    @RequestMapping(value={"/userTree"})
    @BussinessLog(key="/userFront/userTree", type="04", value="\u52a0\u8f7d\u7ec4\u7ec7\u673a\u6784\u7528\u6237\u6811")
    public ApiResponse<List<JSTreeModel>> userTree(@RequestBody Map<String, Object> map) {
        String isExport = map.get("isExport") == null ? null : map.get("isExport").toString();
        String parentId = map.get("parentId") == null ? null : map.get("parentId").toString();
        List result = this.iSysUsersService.getUserTree(isExport, parentId);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @Deprecated
    public List<ProxyTreeVo> doRecursive(List<ProxyTreeVo> list) {
        ArrayList<ProxyTreeVo> result = new ArrayList<ProxyTreeVo>();
        this.recursive(list, result, "");
        if (result.size() == 0) {
            for (ProxyTreeVo proxyTreeVo : list) {
                if (!"#".equals(proxyTreeVo.getParent())) continue;
                result.add(proxyTreeVo);
            }
        }
        return result;
    }

    @Deprecated
    public void recursive(List<ProxyTreeVo> list, List<ProxyTreeVo> result, String parentId) {
        String newParentId = parentId;
        for (int i = list.size() - 1; i >= 0; --i) {
            ProxyTreeVo proxyTreeVo;
            if (i > list.size() - 1) {
                i = list.size() - 1;
            }
            if (!"USER".equals((proxyTreeVo = list.get(i)).getCode()) && !newParentId.equals(proxyTreeVo.getId())) continue;
            newParentId = proxyTreeVo.getParent();
            result.add(proxyTreeVo);
            list.remove(i);
            this.recursive(list, result, newParentId);
        }
    }

    @RequiresPermissions(value={"user:orderTree"})
    @RequestMapping(value={"/orderTree"})
    @BussinessLog(key="/userFront/orderTree", type="04", value="\u52a0\u8f7d\u6392\u5e8f\u6811")
    public ApiResponse<List<JSTreeModel>> orderTree(@RequestBody Map<String, String> map) {
        String orgId = map.get("orgId") == null ? "" : map.get("orgId").trim();
        List result = this.sysOrgManageService.getUserOrderTree(orgId);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @BussinessLog(key="/userFront/saveUserOrder", type="03", value="\u7528\u6237\u6392\u5e8f")
    @RequiresPermissions(value={"user:saveUserOrder"})
    @RequestMapping(value={"/saveUserOrder"})
    public ApiResponse<Map<String, Object>> saveUserOrder(@RequestBody Map<String, String> map) {
        String treeInfo = map.get("treeInfo") == null ? "" : map.get("treeInfo").trim();
        JSONArray treeArr = JSONArray.parseArray((String)treeInfo);
        if (ToolUtil.isNotEmpty((Object)treeArr)) {
            this.iSysUsersService.saveUserOrder(treeArr);
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u6392\u5e8f\u7684\u7528\u6237\uff01");
    }

    @BussinessLog(key="/userFront/add", type="01", value="\u65b0\u589e\u7528\u6237")
    @RequiresPermissions(value={"user:add"})
    @RequestMapping(value={"/add"})
    @ResponseBody
    @CacheEvict(value={"user_ip"}, allEntries=true)
    public ApiResponse<Object> addUser(@RequestBody Map<String, Object> map) {
        boolean existAccount;
        boolean tenantFlag;
        String roleIds = map.get("roleIds") == null ? "" : map.get("roleIds").toString().trim();
        SysUsers sysUsers = new SysUsers();
        sysUsers.setUserAccount(map.get("userAccount") == null ? null : map.get("userAccount").toString());
        sysUsers.setUserName(map.get("userName") == null ? null : map.get("userName").toString());
        sysUsers.setAccountStatus(map.get("accountStatus") == null ? null : map.get("accountStatus").toString());
        sysUsers.setTypeProperty(map.get("typeProperty") == null ? null : map.get("typeProperty").toString());
        sysUsers.setMaxSessions(new BigDecimal(map.get("maxSessions") == null ? "1" : map.get("maxSessions").toString()));
        sysUsers.setIsSys(map.get("isSys") == null ? null : map.get("isSys").toString());
        sysUsers.setStartTime(map.get("startTime") == null ? null : map.get("startTime").toString());
        sysUsers.setExpiredTime(map.get("expiredTime") == null ? null : map.get("expiredTime").toString());
        sysUsers.setCorporationId(map.get("corporationId") == null ? null : map.get("corporationId").toString());
        sysUsers.setEmployeeId(map.get("employeeId") == null ? null : map.get("employeeId").toString());
        sysUsers.setEMail(map.get("eMail") == null ? null : map.get("eMail").toString());
        sysUsers.setMobile(map.get("mobile") == null ? null : map.get("mobile").toString());
        sysUsers.setWeChat(map.get("weChat") == null ? null : map.get("weChat").toString());
        sysUsers.setTelephone(map.get("telephone") == null ? null : map.get("telephone").toString());
        sysUsers.setPermissionStruId("");
        sysUsers.setLoginTimeLimit(map.get("loginTimeLimit") == null ? null : map.get("loginTimeLimit").toString());
        sysUsers.setAccessLoginIp(map.get("accessLoginIp") == null ? null : map.get("accessLoginIp").toString());
        sysUsers.setAccessLoginStartTime(map.get("accessLoginStartTime") == null ? null : map.get("accessLoginStartTime").toString());
        sysUsers.setAccessLoginEndTime(map.get("accessLoginEndTime") == null ? null : map.get("accessLoginEndTime").toString());
        sysUsers.setLoginIpLimit(map.get("loginIpLimit") == null ? null : map.get("loginIpLimit").toString());
        boolean bl = tenantFlag = this.globalProperties.isTenantOpen() && "2".equals(this.globalProperties.getTenantUserModel());
        if (tenantFlag && (existAccount = this.sysLoginUserService.validateAccount(sysUsers.getUserAccount()).booleanValue())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        }
        Tip result = this.iSysUsersService.addUser(sysUsers, roleIds);
        if (result.getCode() != HttpCode.OK.value().intValue()) {
            return ApiResponse.fail((int)result.getCode(), (String)result.getMessage());
        }
        if (tenantFlag) {
            SysUsers users = (SysUsers)this.iSysUsersService.getById((Serializable)((Object)result.getMessage()));
            this.sysLoginUserService.syncAddUser(users);
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @BussinessLog(key="/userFront/edit", type="03", value="\u4fee\u6539\u7528\u6237", pk="userId", dict=UserDict.class)
    @RequiresPermissions(value={"user:edit"})
    @RequestMapping(value={"/edit"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    public ApiResponse<Map<String, Object>> editUser(@RequestBody Map<String, Object> objectMap) {
        SysUsers sysUsers = new SysUsers();
        sysUsers.setCorporationId(objectMap.get("corporationId") == null ? null : objectMap.get("corporationId").toString());
        sysUsers.setUserId(objectMap.get("userId") == null ? null : objectMap.get("userId").toString());
        sysUsers.setUserAccount(objectMap.get("userAccount") == null ? null : objectMap.get("userAccount").toString());
        sysUsers.setUserName(objectMap.get("userName") == null ? null : objectMap.get("userName").toString());
        sysUsers.setStartTime(objectMap.get("startTime") == null ? null : objectMap.get("startTime").toString());
        sysUsers.setExpiredTime(objectMap.get("expiredTime") == null ? null : objectMap.get("expiredTime").toString());
        sysUsers.setMaxSessions(objectMap.get("maxSessions") == null ? null : new BigDecimal(Integer.parseInt(objectMap.get("maxSessions").toString())));
        sysUsers.setEMail(objectMap.get("email") == null ? null : objectMap.get("email").toString());
        sysUsers.setWeChat(objectMap.get("weChat") == null ? null : objectMap.get("weChat").toString());
        sysUsers.setMobile(objectMap.get("mobile") == null ? null : objectMap.get("mobile").toString());
        sysUsers.setTelephone(objectMap.get("telephone") == null ? null : objectMap.get("telephone").toString());
        sysUsers.setAccountStatus(objectMap.get("accountStatus") == null ? null : objectMap.get("accountStatus").toString());
        sysUsers.setTypeProperty(objectMap.get("typeProperty") == null ? null : objectMap.get("typeProperty").toString());
        sysUsers.setLoginTimeLimit(objectMap.get("loginTimeLimit") == null ? null : objectMap.get("loginTimeLimit").toString());
        sysUsers.setAccessLoginIp(objectMap.get("accessLoginIp") == null ? null : objectMap.get("accessLoginIp").toString());
        sysUsers.setAccessLoginStartTime(objectMap.get("accessLoginStartTime") == null ? null : objectMap.get("accessLoginStartTime").toString());
        sysUsers.setAccessLoginEndTime(objectMap.get("accessLoginEndTime") == null ? null : objectMap.get("accessLoginEndTime").toString());
        sysUsers.setLoginIpLimit(objectMap.get("loginIpLimit") == null ? null : objectMap.get("loginIpLimit").toString());
        sysUsers.setEmployeeId(objectMap.get("employeeId") == null ? null : objectMap.get("employeeId").toString());
        sysUsers.setIsSys(objectMap.get("isSys") == null ? null : objectMap.get("isSys").toString());
        sysUsers.setRoleIds(objectMap.get("roleIds") == null ? null : objectMap.get("roleIds").toString());
        String userId = sysUsers.getUserId();
        String roleIds = sysUsers.getRoleIds().trim();
        if (!this.hussarProperties.getLoginUpperOpen().booleanValue()) {
            sysUsers.setUserAccount(sysUsers.getUserAccount().toUpperCase());
        }
        String[] ids = roleIds.split(",");
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < ids.length; ++i) {
            if (list.contains(ids[i])) continue;
            list.add(ids[i]);
        }
        ids = list.toArray(new String[list.size()]);
        if (this.iSysConfRolesService.isIncludeConfRole(ids)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u6240\u9009\u89d2\u8272\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u7684\u57fa\u6570\uff01\uff09");
        }
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit() && this.iSysUsersAuditService.adjustEdit(sysUsers.getUserId())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
        sysUsers.setDepartmentId(sysUsers.getCorporationId());
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("userId", userId);
        map.put("roleIds", ids);
        map.put("sysUsers", sysUsers);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)this.iSysUsersService.editUser(map).getMessage());
    }

    @RequestMapping(value={"/userInfo"})
    @BussinessLog(key="/userFront/userInfo", type="04", value="\u7528\u6237\u8be6\u60c5")
    @RequiresPermissions(value={"user:userInfo"})
    public ApiResponse<ArrayList<Object>> userInfo(@RequestBody Map<String, String> map) {
        String id = map.get("id") == null ? "" : map.get("id").trim();
        ArrayList list = this.iSysUsersService.getUserInfo(id);
        LogObjectHolder.me().set(list.get(0));
        return ApiResponse.data((Object)list);
    }

    @RequestMapping(value={"/currentUserInfo"})
    @BussinessLog(key="/userFront/currentUserInfo", type="04", value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u7684\u4fe1\u606f")
    public ApiResponse<ArrayList<Object>> currentUserInfo() {
        String userId = ShiroKit.getUser().getId();
        ArrayList list = this.iSysUsersService.getUserInfo(userId);
        return ApiResponse.data((Object)list);
    }

    @BussinessLog(key="/userFront/delete", type="02", value="\u5220\u9664\u7528\u6237")
    @RequiresPermissions(value={"user:delete"})
    @RequestMapping(value={"/delete"})
    public ApiResponse<Map<String, Object>> delUser(@RequestBody Map<String, String> map) {
        String userId;
        String string = userId = map.get("userId") == null ? "" : map.get("userId").trim();
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        ShiroUser shiroUser = ShiroKit.getUser();
        SysUsers sysUser = this.iSysUsersService.getUser(userId);
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u5220\u9664\u7ba1\u7406\u5458\u7528\u6237\uff01\uff09");
        }
        if (shiroUser.getId().equals(userId)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u7528\u6237\uff01\uff09");
        }
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit() && this.iSysUsersAuditService.adjustEdit(userId)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
        }
        Tip tip = this.iSysUsersService.delUser(sysUser);
        if (ToolUtil.isNotEmpty((Object)tip.getCode())) {
            return ApiResponse.fail((int)tip.getCode(), (String)tip.getMessage());
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)tip.getMessage());
    }

    @BussinessLog(key="/userFront/cancelUser", type="02", value="\u6ce8\u9500\u7528\u6237")
    @RequiresPermissions(value={"user:cancelUser"})
    @RequestMapping(value={"/cancelUser"})
    public ApiResponse<Map<String, Object>> cancelUser(@RequestBody Map<String, String> map) {
        String userId;
        String string = userId = map.get("userId") == null ? "" : map.get("userId").trim();
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        ShiroUser shiroUser = ShiroKit.getUser();
        SysUsers sysUser = this.iSysUsersService.getUser(userId);
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u6ce8\u9500\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u6ce8\u9500\u7ba1\u7406\u5458\u7528\u6237\uff01\uff09");
        }
        if (shiroUser.getId().equals(userId)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u6ce8\u9500\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u6ce8\u9500\u5f53\u524d\u7528\u6237\uff01\uff09");
        }
        if (this.globalProperties.isCriticalOperationsAudit() && this.globalProperties.isUserAudit() && this.iSysUsersAuditService.adjustEdit(userId)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u6ce8\u9500\uff01");
        }
        Tip tip = this.iSysUsersService.cancelUser(sysUser);
        if (ToolUtil.isNotEmpty((Object)tip.getCode())) {
            return ApiResponse.fail((int)tip.getCode(), (String)tip.getMessage());
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)tip.getMessage());
    }

    @RequestMapping(value={"/updatePwd"})
    @BussinessLog(key="/userFront/updatePwd", type="03", value="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @RequiresPermissions(value={"user:updatePwd"})
    public ApiResponse<Map<String, Object>> updatePwd(@RequestBody Map<String, String> map) {
        String oldPwd = map.get("oldPwd") == null ? "" : map.get("oldPwd");
        String newPwd = map.get("newPwd") == null ? "" : map.get("newPwd");
        String cPwd = map.get("confirmPwd") == null ? "" : map.get("confirmPwd");
        oldPwd = CryptoUtil.decode((String)oldPwd);
        newPwd = CryptoUtil.decode((String)newPwd);
        cPwd = CryptoUtil.decode((String)cPwd);
        String regular = this.globalProperties.getPwdComplexityRegular().replaceAll("/", "");
        String hint = this.globalProperties.getUnmatchedHint();
        if (!newPwd.matches(regular)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)hint);
        }
        if (!newPwd.equals(cPwd)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01\uff09");
        }
        String oPwd = this.credentialsMatcher.passwordEncode(oldPwd.getBytes());
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        String userId = ShiroKit.getUser().getId();
        SysUsers user = this.iSysUsersService.getUser(userId);
        String userAccount = user.getUserAccount();
        if (newPwd.toLowerCase().contains(userAccount.toLowerCase())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u5bc6\u7801\u5305\u542b\u7528\u6237\u540d\uff01\uff09");
        }
        if (!oPwd.equals(user.getPassword())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff01\uff09");
        }
        List list = this.iSysUsersService.getPwdHist(userId);
        if (ToolUtil.isEmpty((Object)list) && this.globalProperties.getDefaultPassword().equals(newPwd)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u9ed8\u8ba4\u5bc6\u7801\u76f8\u540c\uff01\uff09");
        }
        for (SysPasswordHist sysPasswordHist : list) {
            if (!nPwd.equals(sysPasswordHist.getPassword())) continue;
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)("\u4fee\u6539\u5931\u8d25\uff01\uff08\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u524d" + this.globalProperties.getPwdRepeatTime() + "\u6b21\u7684\u5bc6\u7801\u76f8\u540c\uff09"));
        }
        user.setPassword(nPwd);
        this.iSysUsersService.updatePwd(user);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/resetAllPwd"})
    @RequiresPermissions(value={"user:resetAllPwd"})
    @BussinessLog(key="/userFront/resetAllPwd", type="11", value="\u91cd\u7f6e\u5bc6\u7801")
    public ApiResponse<Map<String, Object>> resetAllPwd(@RequestBody Map<String, String> body) {
        String userId;
        SysUsers user;
        Object[] userIds = body.get("userIds") == null ? "".split(",") : body.get("userIds").split(",");
        String adminPwd = body.get("superPws") == null ? "" : body.get("superPws");
        String newPwd = body.get("password") == null ? "" : body.get("password");
        String cPwd = body.get("passwordRepeat") == null ? "" : body.get("passwordRepeat");
        adminPwd = CryptoUtil.decode((String)adminPwd);
        newPwd = CryptoUtil.decode((String)newPwd);
        cPwd = CryptoUtil.decode((String)cPwd);
        String aPwd = this.credentialsMatcher.passwordEncode(adminPwd.getBytes());
        if (!aPwd.equals((user = this.iSysUsersService.getUser(userId = ShiroKit.getUser().getId())).getPassword())) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u91cd\u7f6e\u5931\u8d25\uff01\uff08\u60a8\u7684\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff09");
        }
        if (!newPwd.equals(cPwd)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u91cd\u7f6e\u5931\u8d25\uff01\uff08\u4e24\u6b21\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u4e00\u81f4\uff01\uff09");
        }
        String regular = this.globalProperties.getPwdComplexityRegular().replaceAll("/", "");
        String hint = this.globalProperties.getUnmatchedHint();
        if (!newPwd.matches(regular)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)hint);
        }
        List sysUsers = this.iSysUsersService.list((Wrapper)new QueryWrapper().in((Object)"user_id", userIds));
        for (SysUsers users : sysUsers) {
            if (!newPwd.toLowerCase().contains(users.getUserAccount().toLowerCase())) continue;
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)("\u4fee\u6539\u5931\u8d25\uff01\uff08" + users.getUserName() + "\u5bc6\u7801\u5305\u542b\u7528\u6237\u540d\uff09"));
        }
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("newPwd", nPwd);
        map.put("userIds", userIds);
        long count = this.iSysUsersService.resetAllPwd(map);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)("\u91cd\u7f6e\u6210\u529f\uff0c" + count + "\u4e2a\u7528\u6237\u7684\u5bc6\u7801\u5df2\u88ab\u91cd\u7f6e\uff01"));
    }

    @RequestMapping(value={"/setGetBackPwd"})
    @BussinessLog(key="/userFront/setGetBackPwd", type="03", value="\u8bbe\u7f6e\u627e\u56de\u5bc6\u7801\u95ee\u9898\u548c\u7b54\u6848")
    public ApiResponse<Map<String, Object>> setGetBackPwd(@RequestBody Map<String, String> param) {
        String ques = param.get("ques") == null ? "" : param.get("ques").trim();
        String key = param.get("key") == null ? "" : param.get("key").trim();
        String userId = ShiroKit.getUser().getId();
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("userId", userId);
        map.put("ques", ques);
        map.put("key", key);
        if (this.iSysUsersService.setGetBackPwd(map)) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u8bbe\u7f6e\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u8bbe\u7f6e\u5931\u8d25\uff01");
    }

    @BussinessLog(key="/userFront/copyRole", type="03", value="\u590d\u5236\u89d2\u8272")
    @RequiresPermissions(value={"user:copyRole"})
    @RequestMapping(value={"/copyRole"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    public ApiResponse<Map<String, Object>> copyRole(@RequestBody Map<String, String> map) {
        String[] copyTos;
        String copyFrom = map.get("copyFrom") == null ? "" : map.get("copyFrom").trim();
        for (String copyTo : copyTos = map.get("copyTo") == null ? "".split(",") : map.get("copyTo").trim().split(",")) {
            boolean result = this.iSysUsersService.copyRole(copyFrom, copyTo);
            if (result) continue;
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u89d2\u8272\u590d\u5236\u5931\u8d25\uff01\uff08\u590d\u5236\u7684\u89d2\u8272\u4e0e\u539f\u89d2\u8272\u4e2d\u6709\u4e0d\u76f8\u5bb9\u89d2\u8272\uff01\uff09");
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u89d2\u8272\u590d\u5236\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/userList"})
    @BussinessLog(key="/userFront/userList", type="04", value="\u91cd\u7f6e\u5bc6\u7801\u7528\u6237\u5217\u8868")
    @RequiresPermissions(value={"user:userList"})
    public ApiResponse<Object> userTableList(@RequestBody Map<String, Object> map) {
        String userName;
        String pageNum = map.get("current") == null ? "1" : map.get("current").toString().trim();
        String limitNum = map.get("size") == null ? "10" : map.get("size").toString().trim();
        String userAccount = map.get("userAccount") == null ? "" : map.get("userAccount").toString().trim();
        String string = userName = map.get("userName") == null ? "" : map.get("userName").toString().trim();
        if (ToolUtil.isNotEmpty((Object)userAccount)) {
            userAccount = userAccount.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        if (ToolUtil.isNotEmpty((Object)userName)) {
            userName = userName.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        Page page = new Page((long)Integer.valueOf(pageNum).intValue(), (long)Integer.valueOf(limitNum).intValue());
        page = this.iSysUsersService.getUserList(page, userAccount, userName);
        JSONObject json = new JSONObject();
        json.put("data", (Object)page.getRecords());
        json.put("code", (Object)"0");
        json.put("msg", (Object)"");
        json.put("count", (Object)page.getTotal());
        return ApiResponse.data((Object)json);
    }

    @RequestMapping(value={"/saveSelfInfo"})
    @BussinessLog(key="/userFront/saveSelfInfo", type="03", value="\u4e2a\u4eba\u4fe1\u606f\u4fee\u6539\u4fdd\u5b58")
    public ApiResponse<Map<String, Object>> saveSelfInfo(@RequestBody Map<String, Object> map) {
        String shiroUserId = ShiroKit.getUser().getId();
        String userId = map.get("userId") == null ? "" : map.get("userId").toString().trim();
        userId = CryptoUtil.decode((String)userId);
        if (shiroUserId != null && shiroUserId.equals(userId)) {
            String eMail = map.get("eMail") == null ? "" : map.get("eMail").toString().trim();
            eMail = CryptoUtil.decode((String)eMail);
            String weChat = map.get("weChat") == null ? "" : map.get("weChat").toString().trim();
            weChat = CryptoUtil.decode((String)weChat);
            String mobile = map.get("mobile") == null ? "" : map.get("mobile").toString().trim();
            mobile = CryptoUtil.decode((String)mobile);
            String telephone = map.get("telephone") == null ? "" : map.get("telephone").toString().trim();
            telephone = CryptoUtil.decode((String)telephone);
            SysUsers user = (SysUsers)this.iSysUsersService.getById((Serializable)((Object)userId));
            user.setEMail(eMail);
            user.setWeChat(weChat);
            user.setMobile(mobile);
            user.setTelephone(telephone);
            user.updateById();
            this.bpmAbstractPushMsgMatcher.pushUser(user, "update", null);
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u975e\u6cd5\u8bf7\u6c42\uff01");
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"user:exportData"})
    @BussinessLog(key="/userFront/exportData", type="04", value="\u7528\u6237\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.iSysUsersService.exportData(idList, response);
    }

    @RequestMapping(value={"/reChecking"})
    @BussinessLog(key="/userFront/reChecking", type="04", value="\u9a8c\u8bc1\u4e8c\u6b21\u9a8c\u8bc1\u7684\u5bc6\u7801\u662f\u5426\u6b63\u786e")
    @ResponseBody
    public ApiResponse<Boolean> reChecking(@RequestBody Map<String, String> dataMap) {
        String reUrl = dataMap.get("reUrl");
        String userName = ShiroKit.getUser().getAccount();
        String cipher = dataMap.get("cipher");
        return ApiResponse.data((Object)this.iSysUsersService.reChecking(reUrl, userName, cipher));
    }

    @RequestMapping(value={"/accountList"})
    @RequiresPermissions(value={"user:accountList"})
    @BussinessLog(key="/userFront/accountList", type="04", value="\u7528\u6237\u8d26\u53f7\u5217\u8868")
    @ResponseBody
    public ApiResponse<Object> accountList(@RequestBody Map<String, String> map) {
        String page = map.get("page") == null ? "1" : map.get("page");
        String limit = map.get("limit") == null ? "10" : map.get("limit");
        Page pages = new Page((long)Integer.parseInt(page), (long)Integer.parseInt(limit));
        return ApiResponse.data((Object)this.iSysUsersService.getAccountList(map, pages));
    }

    @RequestMapping(value={"/unlockUser"})
    @RequiresPermissions(value={"user:unlockUser"})
    @BussinessLog(key="/userFront/unlockUser", type="03", value="\u6fc0\u6d3b\u7528\u6237\u8d26\u53f7")
    @ResponseBody
    public ApiResponse<Boolean> unlockUser(@RequestParam String userId) {
        SysUsers sysUsers = this.iSysUsersService.getUser(userId);
        boolean flag = true;
        if ("0".equals(sysUsers.getTypeProperty())) {
            String nowDay = DateUtil.getDay((Date)new Date());
            String expiredDay = sysUsers.getExpiredTime();
            String startDay = sysUsers.getStartTime();
            flag = DateUtil.compareDate((String)nowDay, (String)startDay);
            if (flag) {
                flag = DateUtil.compareDate((String)expiredDay, (String)nowDay);
            }
        }
        if (flag) {
            String connName = DataSourceUtil.currentDsName();
            if (this.globalProperties.isTenantOpen()) {
                if (!this.hussarProperties.isStandAlone()) {
                    this.redisTemplate.delete((Object)("shiro_is_lock:" + sysUsers.getUserAccount() + "-" + connName));
                } else {
                    this.hussarCacheManager.delete("Login_Lock", sysUsers.getUserAccount() + "-" + connName);
                }
            } else if (!this.hussarProperties.isStandAlone()) {
                this.redisTemplate.delete((Object)("shiro_is_lock:" + sysUsers.getUserAccount()));
            } else {
                this.hussarCacheManager.delete("Login_Lock", sysUsers.getUserAccount());
            }
            return ApiResponse.data((Object)this.iSysUsersService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"account_status", (Object)UserStatus.OK.getCode())).set((Object)"last_login_time", (Object)new Date())).eq((Object)"user_id", (Object)userId)));
        }
        return ApiResponse.fail((String)"\u4e0d\u80fd\u6fc0\u6d3b\u6709\u6548\u671f\u5916\u7684\u4e34\u65f6\u8d26\u53f7");
    }
}

