/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.organ.dictmap.StruDict;
import com.jxdinfo.hussar.bsp.organ.model.SysOffice;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.model.SysStruRule;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrgService;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrganService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/orgMainFront"})
public class SysOrgManageFrontController
extends BaseController {
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysOrganService iSysOrganService;
    @Autowired
    ISysStruAuditService iSysStruAuditService;
    @Resource
    private ISysOrgService iSysOrgService;

    @RequiresPermissions(value={"orgMain:orgTree"})
    @RequestMapping(value={"/orgTree"})
    @BussinessLog(key="/orgMainFront/orgTree", type="04", value="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811")
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> orgTree(@RequestBody Map<String, Object> map) {
        String isEmployee = map.get("isEmployee") == null ? null : map.get("isEmployee").toString();
        String isExport = map.get("isExport") == null ? null : map.get("isExport").toString();
        String resourceId = map.get("resourceId") == null ? null : map.get("resourceId").toString();
        String type = map.get("type") == null ? null : map.get("type").toString();
        String handle = map.get("handle") == null ? null : map.get("handle").toString();
        String parentId = map.get("parentId") == null ? null : map.get("parentId").toString();
        return ApiResponse.data(ForestNodeMerger.merge(this.iSysOrgService.getOrgTree(isEmployee, isExport, resourceId, type, handle, parentId)));
    }

    @RequiresPermissions(value={"orgMainFront:getDeReTree"})
    @RequestMapping(value={"/getDelegateRetrieveTree"})
    @BussinessLog(key="/orgMainFront/getDelegateRetrieveTree", type="04", value="\u67e5\u8be2\u56de\u6536\u4e0b\u653e\u6811")
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> getStruParentId(@RequestBody Map<String, Object> map) {
        String isEmployee = map.get("isEmployee") == null ? null : map.get("isEmployee").toString();
        String isExport = map.get("isExport") == null ? null : map.get("isExport").toString();
        String resourceId = map.get("resourceId") == null ? null : map.get("resourceId").toString();
        String type = map.get("type") == null ? null : map.get("type").toString();
        String handle = map.get("handle") == null ? null : map.get("handle").toString();
        String parentId = map.get("parentId") == null ? null : map.get("parentId").toString();
        List list = this.iSysOrgService.getOrgTree(isEmployee, isExport, resourceId, type, handle, parentId);
        List idList = this.iSysOrgService.getAllParentId();
        if (ToolUtil.isNotEmpty((Object)idList)) {
            for (JSTreeModel jsTreeModel : list) {
                String treeId = jsTreeModel.getId();
                if (!idList.contains(treeId)) continue;
                jsTreeModel.setState(false, false, true);
            }
        }
        return ApiResponse.data(ForestNodeMerger.merge(list));
    }

    @RequiresPermissions(value={"orgMain:orgTree"})
    @RequestMapping(value={"/orgResourceStruId"})
    @BussinessLog(key="/orgMainFront/orgResourceStruId", type="04", value="\u83b7\u53d6\u4e0b\u653e\u8d44\u6e90\u7684\u7ec4\u7ec7\u673a\u6784id")
    @ResponseBody
    public ApiResponse<List<String>> orgResourceStruId(@RequestBody Map<String, Object> map) {
        String resourceId = map.get("resourceId") == null ? "" : map.get("resourceId").toString();
        String type = map.get("type") == null ? "" : map.get("type").toString();
        return ApiResponse.data((Object)this.iSysOrgService.getResourceStruId(resourceId, type));
    }

    @RequiresPermissions(value={"orgMain:orgTreeById"})
    @RequestMapping(value={"/orgTreeById"})
    @BussinessLog(key="/orgMainFront/orgTreeById", type="04", value="\u6839\u636e\u8282\u70b9\u7ec4\u7ec7\u673a\u6784ID\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811")
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> orgTreeById(@RequestBody Map<String, Object> map, HttpServletRequest request) {
        String orgId = map.get("orgId") == null ? null : map.get("orgId").toString();
        String isEmployee = map.get("isEmployee") == null ? null : map.get("isEmployee").toString();
        String isHead = map.get("isRoot") == null ? null : map.get("isRoot").toString();
        List result = this.orgMaintenanceService.getOrgTreeById(orgId, isEmployee, isHead);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/orgInfo"})
    @RequiresPermissions(value={"orgMain:orgInfo"})
    @BussinessLog(key="/orgMainFront/orgInfo", type="04", value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u67e5\u770b")
    @ResponseBody
    public ApiResponse<SysOrganVo> orgInfo(@RequestBody Map<String, String> map) {
        String struId = map.get("struId");
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(struId);
        return ApiResponse.data((Object)orgInfo);
    }

    @RequestMapping(value={"/orgInfoAdd"})
    @RequiresPermissions(value={"orgMain:add"})
    @BussinessLog(key="/orgMainFront/orgInfoAdd", type="01", value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e", pk="struId", dict=StruDict.class)
    @ResponseBody
    public ApiResponse<Map<String, Object>> orgInfoAdd(@RequestBody Map<String, Object> map) {
        String orgParentId = map.get("orgParentId") == null ? null : map.get("orgParentId").toString();
        String orgType = map.get("orgType") == null ? null : map.get("orgType").toString();
        String orgTypeName = map.get("orgTypeName") == null ? null : map.get("orgTypeName").toString();
        String childNum = map.get("childNum") == null ? null : map.get("childNum").toString();
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(orgParentId);
        String orgParentCode = "";
        String orgParentName = "";
        String parentTypeCode = "";
        if (ToolUtil.isNotEmpty((Object)orgInfo)) {
            orgParentCode = orgInfo.getOrganCode();
            if (ToolUtil.isEmpty((Object)orgParentCode)) {
                orgParentCode = "";
            }
            orgParentName = orgInfo.getOrganName();
            parentTypeCode = orgInfo.getParentTypeCode();
            if (ToolUtil.isEmpty((Object)parentTypeCode)) {
                parentTypeCode = "";
            }
        }
        String businessName = "STRU_CODE";
        String tableName = "sys_stru";
        String currentCode = this.sysIdtableService.getCurrentCode(businessName, tableName, orgParentCode);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("currentCode", currentCode);
        dataMap.put("orgInfo", null);
        dataMap.put("orgType", orgType);
        dataMap.put("orgParentId", orgParentId);
        dataMap.put("orgParentCode", orgParentCode);
        dataMap.put("orgParentName", orgParentName);
        if (ToolUtil.isNotEmpty((Object)orgInfo)) {
            dataMap.put("struLevel", orgInfo.getStruLevel());
        } else {
            dataMap.put("struLevel", "0");
        }
        dataMap.put("childNum", childNum);
        dataMap.put("orgTypeName", orgTypeName);
        dataMap.put("parentTypeCode", parentTypeCode);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"orgMain:edit"})
    @RequestMapping(value={"/orgInfoEdit"})
    @BussinessLog(key="/orgMainFront/orgInfoEdit", type="03", value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4fee\u6539")
    @ResponseBody
    public ApiResponse<SysOrganVo> orgInfoEdit(@RequestBody Map<String, String> map) {
        String orgId = map.get("orgId");
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(orgId);
        return ApiResponse.data((Object)orgInfo);
    }

    @RequiresPermissions(value={"orgMain:getOrgRoleByCode"})
    @RequestMapping(value={"/getOrgRoleByCode"})
    @BussinessLog(key="/orgMainFront/getOrgRoleByCode", type="04", value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u83b7\u53d6\u4e0b\u5c5e\u5355\u4f4d\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b")
    @ResponseBody
    public ApiResponse<Object> getOrgRoleByCode(@RequestBody Map<String, Object> map) {
        String orgType = map.get("orgType") == null ? null : map.get("orgType").toString();
        String isRoot = map.get("isRoot") == null ? null : map.get("isRoot").toString();
        return ApiResponse.data((Object)this.orgMaintenanceService.getOrgRoleByCode(orgType, isRoot));
    }

    @RequestMapping(value={"/getExitOrgRoleByCode"})
    @BussinessLog(key="/orgMainFront/getExitOrgRoleByCode", type="04", value="\u8be5\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u662f\u5426\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b")
    @ResponseBody
    public ApiResponse<Boolean> getExitOrgRoleByCode(@RequestBody Map<String, Object> map) {
        SysStruRule sysStruRule;
        String orgType = map.get("orgType") == null ? null : map.get("orgType").toString();
        String isRoot = map.get("isRoot") == null ? null : map.get("isRoot").toString();
        List ruleList = this.orgMaintenanceService.getOrgRoleByCode(orgType, isRoot);
        boolean result = true;
        boolean isEmpl = false;
        if (ruleList != null && ruleList.size() == 1 && "9".equals((sysStruRule = (SysStruRule)ruleList.get(0)).getSysOrganType())) {
            isEmpl = true;
        }
        if (ruleList != null && ruleList.size() == 0 || isEmpl) {
            result = false;
        }
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(value={"/orgInfoSave"})
    @RequiresPermissions(value={"orgMain:orgInfoSave"})
    @BussinessLog(key="/orgMainFront/orgInfoSave", type="01", value="\u7ec4\u7ec7\u673a\u6784\u65b0\u589e", pk="struId,organId", dict=StruDict.class)
    @ResponseBody
    public ApiResponse<JSONObject> orgInfoSave(@RequestBody Map<String, Object> map) {
        SysStru sysStru = new SysStru();
        SysOrgan sysOrgan = new SysOrgan();
        SysOffice sysOffice = new SysOffice();
        sysStru.setStruId(null);
        sysStru.setStruType(map.get("struType") == null ? null : map.get("struType").toString());
        sysStru.setOrganAlias(map.get("organAlias") == null ? null : map.get("organAlias").toString());
        sysStru.setParentId(map.get("parentId") == null ? null : map.get("parentId").toString());
        sysStru.setPrincipalId(map.get("principalId") == null ? null : map.get("principalId").toString());
        sysStru.setStruLevel(new BigDecimal(map.get("struLevel") == null ? "1" : map.get("struLevel").toString()));
        sysStru.setStruOrder(new BigDecimal(map.get("struOrder") == null ? "1" : map.get("struOrder").toString()));
        sysOrgan.setOrganCode(map.get("organCode") == null ? null : map.get("organCode").toString());
        sysOrgan.setOrganName(map.get("organName") == null ? null : map.get("organName").toString());
        sysOrgan.setShortName(map.get("shortName") == null ? null : map.get("shortName").toString());
        sysOrgan.setOrganType(map.get("organType") == null ? null : map.get("organType").toString());
        sysOrgan.setBeginDate(map.get("beginDate") == null ? null : map.get("beginDate").toString());
        sysOrgan.setEndDate(map.get("endDate") == null ? null : map.get("endDate").toString());
        sysOrgan.setParentTypeCode(map.get("parentTypeCode") == null ? null : map.get("parentTypeCode").toString());
        sysOffice.setOfficeAlias(map.get("officeAlias") == null ? null : map.get("officeAlias").toString());
        sysOffice.setOfficeAddress(map.get("officeAddress") == null ? null : map.get("officeAddress").toString());
        if (ToolUtil.isEmpty((Object)sysStru.getOrganAlias())) {
            sysStru.setOrganAlias(sysOrgan.getOrganName());
        }
        sysStru.setOrganId(null);
        sysStru.setIsLeaf("0");
        sysStru.setInUse("1");
        sysStru.setStruPath("");
        sysOrgan.setOrganId(null);
        sysOrgan.setInUse("1");
        sysStru.setStruLevel(sysStru.getStruLevel().add(new BigDecimal(1)));
        Long orderTree = 1L;
        Long maxOrder = this.orgMaintenanceService.getMaxOrderById(sysStru.getParentId());
        orderTree = ToolUtil.isNotEmpty((Object)maxOrder) ? Long.valueOf(maxOrder + 1L) : Long.valueOf(1L);
        BigDecimal struOrder = BigDecimal.valueOf(orderTree);
        sysStru.setStruOrder(struOrder);
        return ApiResponse.data((Object)this.orgMaintenanceService.orgInfoSave(sysStru, sysOrgan, null, sysOffice, Boolean.valueOf(true)));
    }

    @RequestMapping(value={"/orgInfoEditSave"})
    @RequiresPermissions(value={"orgMain:orgInfoEditSave"})
    @BussinessLog(key="/orgMainFront/orgInfoEditSave", type="03", value="\u7ec4\u7ec7\u673a\u6784\u4fee\u6539", pk="struId,organId", dict=StruDict.class)
    @ResponseBody
    public ApiResponse<JSONObject> orgInfoEditSave(@RequestBody Map<String, Object> map) {
        SysStru sysStru = new SysStru();
        SysOrgan sysOrgan = new SysOrgan();
        SysOffice sysOffice = new SysOffice();
        sysStru.setStruId(map.get("struId") == null ? null : map.get("struId").toString());
        sysStru.setStruType(map.get("struType") == null ? null : map.get("struType").toString());
        sysStru.setOrganId(map.get("organId") == null ? null : map.get("organId").toString());
        sysStru.setOrganAlias(map.get("organAlias") == null ? null : map.get("organAlias").toString());
        sysStru.setParentId(map.get("parentId") == null ? null : map.get("parentId").toString());
        sysStru.setPrincipalId(map.get("principalId") == null ? null : map.get("principalId").toString());
        sysStru.setStruLevel(new BigDecimal(map.get("struLevel") == null ? "1" : map.get("struLevel").toString()));
        sysStru.setStruOrder(new BigDecimal(map.get("struOrder") == null ? "1" : map.get("struOrder").toString()));
        sysOrgan.setOrganId(map.get("organId") == null ? null : map.get("organId").toString());
        sysOrgan.setOrganCode(map.get("organCode") == null ? null : map.get("organCode").toString());
        sysOrgan.setOrganName(map.get("organName") == null ? null : map.get("organName").toString());
        sysOrgan.setShortName(map.get("shortName") == null ? null : map.get("shortName").toString());
        sysOrgan.setOrganType(map.get("organType") == null ? null : map.get("organType").toString());
        sysOrgan.setBeginDate(map.get("beginDate") == null ? null : map.get("beginDate").toString());
        sysOrgan.setEndDate(map.get("endDate") == null ? null : map.get("endDate").toString());
        sysOffice.setOfficeId(map.get("officeId") == null ? null : map.get("officeId").toString());
        sysOffice.setStruId(map.get("struId") == null ? null : map.get("struId").toString());
        sysOffice.setOfficeAlias(map.get("officeAlias") == null ? null : map.get("officeAlias").toString());
        sysOffice.setOfficeAddress(map.get("officeAddress") == null ? null : map.get("officeAddress").toString());
        if (!this.iSysStruAuditService.checkCanOperate(sysStru.getStruId())) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", (Object)HttpCode.INTERNAL_SERVER_ERROR.value());
            jsonObject.put("message", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
            return ApiResponse.data((Object)jsonObject);
        }
        SysOrgan sysOrgan1 = (SysOrgan)this.iSysOrganService.getById((Serializable)((Object)sysOrgan.getOrganId()));
        LogObjectHolder.me().set((Object)sysOrgan1);
        return ApiResponse.data((Object)this.orgMaintenanceService.orgInfoSave(sysStru, sysOrgan, null, sysOffice, Boolean.valueOf(false)));
    }

    @RequestMapping(value={"/orgTreeOrder"})
    @ResponseBody
    @BussinessLog(key="/orgMainFront/orgTreeOrder", type="03", value="\u4fdd\u5b58\u7ec4\u7ec7\u673a\u6784\u6811\u6392\u5e8f")
    @RequiresPermissions(value={"orgMain:orgTreeOrder"})
    public ApiResponse<Object> orgTreeOrder(@RequestBody Map<String, String> map) {
        String treeInfo = map.get("treeInfo");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        this.orgMaintenanceService.saveOrgTreeOrder(treeArr);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"orgMain:del"})
    @RequestMapping(value={"/delOrgById"})
    @BussinessLog(key="/orgMainFront/delOrgById", type="02", value="\u7ec4\u7ec7\u673a\u6784\u5220\u9664", dict=StruDict.class)
    @ResponseBody
    public ApiResponse<JSONObject> delOrgById(@RequestBody Map<String, String> map) {
        String struId = map.get("struId");
        JSONObject result = this.orgMaintenanceService.delOrgById(struId);
        if (result.getBoolean("success").booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)result.getString("msg"));
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)result.getString("msg"));
    }

    @RequiresPermissions(value={"orgMainFront:principalSelect"})
    @RequestMapping(value={"principalSelect"})
    @BussinessLog(key="/orgMainFront/principalSelect", type="04", value="\u83b7\u53d6\u8d1f\u8d23\u4eba\u5217\u8868")
    @ResponseBody
    public ApiResponse<JSONObject> principalSelect(@RequestBody Map<String, Object> map) {
        String departmentName;
        int curr = map.get("curr") == null ? 1 : Integer.parseInt(map.get("curr").toString());
        int nums = map.get("nums") == null ? 10 : Integer.parseInt(map.get("nums").toString());
        ShiroUser shiroUser = ShiroKit.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        String userName = map.get("userName") == null ? null : map.get("userName").toString();
        String string = departmentName = map.get("departmentName") == null ? null : map.get("departmentName").toString();
        if (ToolUtil.isNotEmpty((Object)curr) && ToolUtil.isNotEmpty((Object)nums)) {
            Page page = new Page((long)curr, (long)nums);
            page = isGradeAdmin ? this.orgMaintenanceService.getPrincipalSelectList(page, userName, departmentName, shiroUser.getDeptId()) : this.orgMaintenanceService.getPrincipalSelectList(page, userName, departmentName);
            JSONObject json = new JSONObject();
            json.put("data", (Object)page.getRecords());
            json.put("code", (Object)"0");
            json.put("msg", (Object)"");
            json.put("count", (Object)page.getTotal());
            return ApiResponse.data((Object)json);
        }
        JSONObject json = new JSONObject();
        json.put("data", null);
        json.put("code", (Object)"500");
        json.put("msg", (Object)"\u53c2\u6570\u4e0d\u7b26\uff01");
        json.put("count", null);
        return ApiResponse.data((Object)json);
    }

    @RequiresPermissions(value={"orgMain:orgChangeById"})
    @RequestMapping(value={"/orgChangeById"})
    @BussinessLog(key="/orgMainFront/orgChangeById", type="04", value="\u83b7\u53d6\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784\u6811")
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> orgChangeById(@RequestBody Map<String, Object> map, HttpServletRequest request) {
        String isEmployee = map.get("isEmployee") == null ? null : map.get("isEmployee").toString();
        String isExport = map.get("isExport") == null ? null : map.get("isExport").toString();
        String resourceId = map.get("resourceId") == null ? null : map.get("resourceId").toString();
        String type = map.get("type") == null ? null : map.get("type").toString();
        String handle = map.get("handle") == null ? null : map.get("handle").toString();
        String parentId = map.get("parentId") == null ? null : map.get("parentId").toString();
        List<JSTreeModel> result = new ArrayList();
        result = this.iSysOrgService.getOrgTree(isEmployee, isExport, resourceId, type, handle, parentId);
        for (JSTreeModel jsTreeModel : result) {
            jsTreeModel.setChildren("false");
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/orgTreeChange"})
    @ResponseBody
    @BussinessLog(key="/orgMainFront/orgTreeChange", type="03", value="\u7ec4\u7ec7\u673a\u6784\u8f6c\u79fb")
    @RequiresPermissions(value={"orgMain:orgTreeChange"})
    public ApiResponse<JSONObject> orgTreeChange(@RequestBody Map<String, Object> map) {
        String changeLevel;
        String isRoot;
        String orgType;
        String parentId;
        String orgId = map.get("orgId") == null ? null : map.get("orgId").toString();
        JSONObject result = this.orgMaintenanceService.orgTreeChange(orgId, parentId = map.get("parentId") == null ? null : map.get("parentId").toString(), orgType = map.get("orgType") == null ? null : map.get("orgType").toString(), isRoot = map.get("isRoot") == null ? null : map.get("isRoot").toString(), changeLevel = map.get("changeLevel") == null ? null : map.get("changeLevel").toString());
        if (result.getBoolean("success").booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)result.getString("msg"));
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)result.getString("msg"));
    }

    @RequestMapping(value={"/singleMove"})
    @ResponseBody
    @BussinessLog(key="/orgMainFront/singleMove", type="03", value="\u7ec4\u7ec7\u673a\u6784\u4e0a\u79fb/\u4e0b\u79fb")
    @RequiresPermissions(value={"orgMain:singleMove"})
    public ApiResponse<Tip> updateMoveNode(@RequestBody Map<String, Object> map) {
        String orgId = map.get("orgId") == null ? null : map.get("orgId").toString();
        boolean isUp = map.get("isUp") == null ? null : Boolean.valueOf(Boolean.parseBoolean(map.get("isUp").toString()));
        if (ToolUtil.isEmpty((Object)orgId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.orgMaintenanceService.updateMoveNode(orgId, isUp);
        return ApiResponse.success((String)"\u79fb\u52a8\u6210\u529f");
    }

    @RequestMapping(value={"/exportData"})
    @RequiresPermissions(value={"orgMain:exportData"})
    @BussinessLog(key="/orgMainFront/exportData", type="04", value="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.orgMaintenanceService.exportData(idList, response);
    }
}

