/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysFunctions;
import com.jxdinfo.hussar.bsp.permit.model.SysModules;
import com.jxdinfo.hussar.bsp.permit.model.SysResources;
import com.jxdinfo.hussar.bsp.permit.model.SysRoleResource;
import com.jxdinfo.hussar.bsp.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.bsp.permit.service.ISysIdtableService;
import com.jxdinfo.hussar.bsp.permit.service.ISysModulesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResManageService;
import com.jxdinfo.hussar.bsp.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/resourceFront"})
public class SysResManageFrontController
extends BaseController {
    @Resource
    ISysResManageService sysResManageService;
    @Resource
    ISysResourcesService iSysResourcesService;
    @Resource
    ISysStruResourcesService iSysStruResourcesService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    SysResourcesMapper sysResourcesMapper;
    @Resource
    ISysRoleResourceService sysRoleResourceService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysModulesService iSysModulesService;
    @Resource
    private ISysFunctionsService iSysFunctionsService;
    @Resource
    private ISysStruResourcesService sysStruResourcesService;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private HussarProperties hussarProperties;

    @RequestMapping(value={"/resTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> resTree(@RequestBody Map<String, Object> map) {
        String type = map.get("type") == null ? null : map.get("type").toString();
        String nodeId = map.get("nodeId") == null ? null : map.get("nodeId").toString();
        String leaf = map.get("isLeaf") == null ? null : map.get("isLeaf").toString();
        String nodeType = map.get("nodeType") == null ? null : map.get("nodeType").toString();
        List result = this.sysResManageService.getFunResource(type, nodeId, leaf, nodeType);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/moduleTreeById"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> moduleTreeById(@RequestBody Map<String, Object> map) {
        String moduleId = map.get("moduleId") == null ? null : map.get("moduleId").toString();
        String isHead = map.get("isRoot") == null ? null : map.get("isRoot").toString();
        Boolean isRoot = Boolean.valueOf(isHead);
        List result = this.sysResManageService.moduleTreeById(moduleId);
        if (isRoot.booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId("1");
            root.setCode("1");
            root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
            root.setParent("#");
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequiresPermissions(value={"resource:moduleAdd"})
    @RequestMapping(value={"moduleAdd"})
    public ApiResponse<Map<String, Object>> moduleAdd() {
        String currentCode = this.sysIdtableService.getCurrentCode("module_code", "sys_modules");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("currentCode", currentCode);
        return ApiResponse.data(dataMap);
    }

    @RequestMapping(value={"moduleView"})
    @BussinessLog(key="/resource/moduleView", type="04", value="\u67e5\u770b\u6a21\u5757\u4fe1\u606f")
    public ApiResponse<Map<String, Object>> moduleView(@RequestBody Map<String, String> map) {
        String moduleId = map.get("moduleId");
        SysModules result = this.sysResManageService.getModuleInfoById(moduleId);
        HashMap<String, SysModules> dataMap = new HashMap<String, SysModules>();
        dataMap.put("sysModules", result);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"resource:moduleSave"})
    @RequestMapping(value={"moduleSave"})
    @BussinessLog(key="/resource/moduleSave", type="01", value="\u65b0\u589e\u6a21\u5757")
    @ResponseBody
    public ApiResponse<Integer> moduleSave(@RequestBody SysModules sysModules) {
        Integer result = this.sysResManageService.moduleSave(sysModules);
        if (result > 0) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u65b0\u589e\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"resource:moduleEditSave"})
    @RequestMapping(value={"moduleEditSave"})
    @BussinessLog(key="/resource/moduleEdit", type="03", value="\u4fee\u6539\u6a21\u5757", pk="moduleId")
    public ApiResponse<Tip> moduleEditSave(@RequestBody SysModules sysModules) {
        boolean isAllowEditModule = this.sysResManageService.isAllowEditModule(sysModules);
        SysModules sysModules1 = (SysModules)this.iSysModulesService.getById((Serializable)((Object)sysModules.getModuleId()));
        LogObjectHolder.me().set((Object)sysModules1);
        if (isAllowEditModule) {
            Integer count = this.sysResManageService.moduleSave(sysModules);
            if (count != 0) {
                SuccessTip tip = new SuccessTip();
                tip.setMessage("\u4fee\u6539\u6210\u529f\uff01");
                return ApiResponse.data((Object)tip);
            }
            return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01\uff08\u5b58\u5728\u4e0b\u7ea7\u6a21\u5757\u6216\u4e0b\u7ea7\u529f\u80fd\u65f6\u4e0d\u80fd\u4fee\u6539\u6a21\u5757\u7c7b\u578b\uff01\uff09");
    }

    @RequiresPermissions(value={"resource:delModule"})
    @RequestMapping(value={"delModule"})
    @BussinessLog(key="/resource/delModule", type="02", value="\u5220\u9664\u6a21\u5757", pk="moduleId")
    public ApiResponse<JSONObject> delModule(@RequestBody Map<String, String> map) {
        String moduleId = map.get("moduleId");
        if (this.delCascade(moduleId, null, null).booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    private Boolean delCascade(String moduleId, String functionId, String resId) {
        ArrayList<String> functionIdList = new ArrayList<String>();
        ArrayList<String> resourceIdList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)moduleId)) {
            Object sysModules2;
            List moduleList = this.iSysModulesService.list((Wrapper)new QueryWrapper().eq((Object)"PARENT_MODULE_ID", (Object)moduleId));
            for (Object sysModules2 : moduleList) {
                this.delCascade(sysModules2.getModuleId(), null, null);
            }
            List functionList = this.iSysFunctionsService.list((Wrapper)new QueryWrapper().eq((Object)"MODULE_ID", (Object)moduleId));
            sysModules2 = functionList.iterator();
            while (sysModules2.hasNext()) {
                SysFunctions sysFunctions = (SysFunctions)sysModules2.next();
                functionIdList.add(sysFunctions.getFunctionId());
            }
        }
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            List res = this.iSysResourcesService.list((Wrapper)new QueryWrapper().eq((Object)"function_id", (Object)functionId));
            for (SysResources sysResources : res) {
                resourceIdList.add(sysResources.getResourceId());
            }
        } else if (ToolUtil.isNotEmpty(functionIdList)) {
            for (String functionIds : functionIdList) {
                List res = this.iSysResourcesService.list((Wrapper)new QueryWrapper().eq((Object)"function_id", (Object)functionIds));
                for (SysResources sysResources : res) {
                    resourceIdList.add(sysResources.getResourceId());
                }
            }
        }
        if (ToolUtil.isNotEmpty((Object)resId)) {
            this.sysRoleResourceService.remove((Wrapper)new QueryWrapper().eq((Object)"resource_id", (Object)resId));
            this.iSysResourcesService.remove((Wrapper)new QueryWrapper().eq((Object)"resource_id", (Object)resId));
        }
        if (resourceIdList.size() != 0) {
            this.sysRoleResourceService.removeByIds(resourceIdList);
            this.iSysResourcesService.removeByIds(resourceIdList);
        }
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            this.iSysFunctionsService.remove((Wrapper)new QueryWrapper().eq((Object)"function_id", (Object)functionId));
        }
        this.iSysFunctionsService.removeByIds(functionIdList);
        if (ToolUtil.isNotEmpty((Object)moduleId)) {
            this.iSysModulesService.removeById((Serializable)((Object)moduleId));
        }
        return true;
    }

    @RequiresPermissions(value={"resource:functionAdd"})
    @RequestMapping(value={"functionAdd"})
    public ApiResponse<Map<String, Object>> functionAdd(@RequestBody Map<String, String> map) {
        String moduleCode = map.get("moduleCode");
        String currentCode = this.sysIdtableService.getCurrentCode("function_code", "sys_functions");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("currentCode", moduleCode + currentCode);
        return ApiResponse.data(dataMap);
    }

    @RequestMapping(value={"functionView"})
    @RequiresPermissions(value={"resource:functionView"})
    @BussinessLog(key="/resource/functionView", type="04", value="\u67e5\u770b\u529f\u80fd\u4fe1\u606f")
    public ApiResponse<Map<String, Object>> functionView(@RequestBody Map<String, String> map) {
        String functionId = map.get("functionId");
        SysFunctions result = this.sysResManageService.getFunctionInfoById(functionId);
        HashMap<String, SysFunctions> dataMap = new HashMap<String, SysFunctions>();
        dataMap.put("sysFunctions", result);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"resource:functionSave"})
    @RequestMapping(value={"functionSave"})
    @ResponseBody
    @BussinessLog(key="/resource/functionAdd", type="01", value="\u65b0\u589e\u529f\u80fd", pk="functionId")
    public ApiResponse<Object> functionSave(@RequestBody SysFunctions sysFunctions) {
        sysFunctions.setFunctionId(null);
        Integer result = this.sysResManageService.functionSave(sysFunctions);
        if (result > 0) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u65b0\u589e\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"resource:functionEditSave"})
    @RequestMapping(value={"functionEditSave"})
    @ResponseBody
    @BussinessLog(key="/resource/functionEdit", type="03", value="\u4fee\u6539\u529f\u80fd", pk="functionId")
    public ApiResponse<Integer> functionEditSave(@RequestBody SysFunctions sysFunctions) {
        SysFunctions sysFunctions1 = (SysFunctions)this.iSysFunctionsService.getById((Serializable)((Object)sysFunctions.getFunctionId()));
        LogObjectHolder.me().set((Object)sysFunctions1);
        Integer result = this.sysResManageService.functionSave(sysFunctions);
        if (result > 0) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"resource:delFunction"})
    @BussinessLog(key="/resource/delFunction", type="02", value="\u5220\u9664\u529f\u80fd", pk="functionId")
    @RequestMapping(value={"delFunction"})
    @ResponseBody
    public ApiResponse<Object> delFunction(@RequestBody Map<String, String> map) {
        String functionId = map.get("functionId");
        if (this.delCascade(null, functionId, null).booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequiresPermissions(value={"resource:resourceAdd"})
    @RequestMapping(value={"resourceAdd"})
    public ApiResponse<Map<String, Object>> resourceAdd(@RequestBody Map<String, String> map) {
        String functionCode = map.get("functionCode");
        String currentCode = this.sysIdtableService.getCurrentCode("resource_code", "sys_resources");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NOHAS_IDTABLE);
        }
        List resTypes = this.sysDicRefService.getDictByType("res_type");
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("currentCode", functionCode + currentCode);
        dataMap.put("resTypes", resTypes);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"resource:resourceSave"})
    @RequestMapping(value={"resourceSave"})
    @ResponseBody
    @BussinessLog(key="/resource/resourceAdd", type="01", value="\u65b0\u589e\u8d44\u6e90", pk="resourceId")
    public ApiResponse<String> resourceSave(@RequestBody SysResources sysResources) {
        sysResources.setResourceId(null);
        String resourceId = this.sysResManageService.resourceSave(sysResources);
        return ApiResponse.data((Object)resourceId);
    }

    @RequiresPermissions(value={"resource:resourceEditSave"})
    @RequestMapping(value={"resourceEditSave"})
    @ResponseBody
    @CacheEvict(value={"authorization_info", "menu_info"}, allEntries=true)
    @BussinessLog(key="/resource/resourceEdit", type="03", value="\u4fee\u6539\u8d44\u6e90", pk="resourceId")
    public ApiResponse<String> resourceEditSave(@RequestBody SysResources sysResources) {
        if ("res_menu".equals(sysResources.getResTypeId())) {
            sysResources.setIsRepeatAuthenticate("0");
        }
        SysResources result = this.sysResManageService.getResourceInfoById(sysResources.getResourceId());
        LogObjectHolder.me().set((Object)result);
        String resouceId = this.sysResManageService.resourceSave(sysResources);
        return ApiResponse.data((Object)resouceId);
    }

    @RequestMapping(value={"resourceView"})
    @BussinessLog(key="/resource/resourceView", type="04", value="\u67e5\u770b\u8d44\u6e90\u4fe1\u606f")
    public ApiResponse<Map<String, Object>> resourceView(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        SysResources result = this.sysResManageService.getResourceInfoById(resourceId);
        List resTypes = this.sysDicRefService.getDictByType("res_type");
        HashMap dataMap = new HashMap();
        dataMap.put("resTypes", resTypes);
        dataMap.put("sysResources", result);
        return ApiResponse.data(dataMap);
    }

    @RequiresPermissions(value={"resource:delResource"})
    @BussinessLog(key="/resource/delResource", type="02", value="\u5220\u9664\u8d44\u6e90", pk="resourceId")
    @RequestMapping(value={"delResource"})
    @ResponseBody
    public ApiResponse<JSONObject> delResource(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        if (this.delCascade(null, null, resourceId).booleanValue()) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"moduleTreeOrder"})
    @RequiresPermissions(value={"resource:moduleTreeOrder"})
    @BussinessLog(key="/resource/moduleTreeOrder", type="03", value="\u8d44\u6e90\u6a21\u5757\u4e0b\u7ea7\u6392\u5e8f")
    public ApiResponse<Tip> moduleTreeOrder(@RequestBody Map<String, String> map) {
        String treeInfo = map.get("treeInfo");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        this.sysResManageService.saveModuleTreeOrder(treeArr);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"resource:functionTreeById"})
    @RequestMapping(value={"/functionTreeById"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> functionTreeById(@RequestBody Map<String, String> map) {
        String moduleId = map.get("moduleId");
        String moduleName = map.get("moduleName");
        List result = this.sysResManageService.functionTreeByModuleId(moduleId);
        JSTreeModel root = new JSTreeModel();
        root.setId(moduleId);
        root.setText(moduleName);
        root.setParent("#");
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isModule");
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"functionTreeOrder"})
    @ResponseBody
    @RequiresPermissions(value={"resource:functionTreeOrder"})
    @BussinessLog(key="/resource/functionTreeOrder", type="03", value="\u8d44\u6e90\u529f\u80fd\u4e0b\u7ea7\u6392\u5e8f")
    public ApiResponse<Tip> functionTreeOrder(@RequestBody Map<String, String> map) {
        String treeInfo = map.get("treeInfo");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        this.sysResManageService.saveFunctionTreeOrder(treeArr);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"resource:resourceTreeById"})
    @RequestMapping(value={"resourceTreeById"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> resourceTreeById(@RequestBody Map<String, String> map) {
        String functionId = map.get("functionId");
        String functionName = map.get("functionName");
        List result = this.sysResManageService.resourceTreeByModuleId(functionId);
        JSTreeModel root = new JSTreeModel();
        root.setId(functionId);
        root.setText(functionName);
        root.setParent("#");
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isFun");
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"resourceTreeOrder"})
    @ResponseBody
    @RequiresPermissions(value={"resource:resourceTreeOrder"})
    @BussinessLog(key="/resource/resourceTreeOrder", type="03", value="\u8d44\u6e90\u4e0b\u7ea7\u6392\u5e8f")
    public ApiResponse<Object> resourceTreeOrder(@RequestBody Map<String, String> map) {
        String treeInfo = map.get("treeInfo") == null ? "" : map.get("treeInfo");
        JSONArray treeArr = JSON.parseArray((String)treeInfo);
        this.sysResManageService.saveResourceTreeOrder(treeArr);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"resource:moduleChangeById"})
    @RequestMapping(value={"moduleChangeById"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> moduleChangeById(@RequestBody Map<String, Object> map) {
        String moduleId = map.get("moduleId") == null ? null : map.get("moduleId").toString();
        String isLeaf = map.get("isLeaf") == null ? null : map.get("isLeaf").toString();
        List result = this.sysResManageService.moduleChangeById(moduleId, isLeaf);
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"moduleTreeChange"})
    @ResponseBody
    @RequiresPermissions(value={"resource:moduleTreeChange"})
    @BussinessLog(key="/resource/moduleTreeChange", type="03", value="\u6a21\u5757\u8f6c\u79fb")
    public ApiResponse<Tip> moduleTreeChange(@RequestBody Map<String, String> map) {
        String moduleId = map.get("moduleId");
        String parentId = map.get("parentId");
        this.sysResManageService.moduleTreeChange(moduleId, parentId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u8f6c\u79fb\u6210\u529f\uff01");
    }

    @RequestMapping(value={"functionTreeChange"})
    @ResponseBody
    @RequiresPermissions(value={"resource:functionTreeChange"})
    @BussinessLog(key="/resource/functionTreeChange", type="03", value="\u529f\u80fd\u8f6c\u79fb")
    public ApiResponse<Tip> functionTreeChange(@RequestBody Map<String, String> map) {
        String functionId = map.get("functionId");
        String parentId = map.get("parentId");
        this.sysResManageService.functionTreeChange(functionId, parentId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u8f6c\u79fb\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"resource:resourceChangeById"})
    @RequestMapping(value={"resourceChangeById"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> resourceChangeById(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        List result = this.sysResManageService.resourceChangeById(resourceId);
        JSTreeModel root = new JSTreeModel();
        root.setId("1");
        root.setCode("1");
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent("#");
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"resourceTreeChange"})
    @ResponseBody
    @RequiresPermissions(value={"resource:resourceTreeChange"})
    @BussinessLog(key="/resource/resourceTreeChange", type="03", value="\u8d44\u6e90\u8f6c\u79fb")
    public ApiResponse<Tip> resourceTreeChange(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        String parentId = map.get("parentId");
        this.sysResManageService.resourceTreeChange(resourceId, parentId);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u8f6c\u79fb\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"resource:selfResourceTree"})
    @RequestMapping(value={"/selfResourceTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> selfResourceTree(@RequestBody Map<String, String> map) {
        String[] resourceIds = map.get("resourceIds") == null ? "".split(",") : map.get("resourceIds").trim().split(",");
        List result = this.sysResManageService.selfResourceTree(resourceIds);
        List<JSTreeModel> tree = this.doRecursive(result);
        return ApiResponse.data(ForestNodeMerger.merge(tree));
    }

    public List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursive(list, result, "");
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!"#".equals(map.getParent())) continue;
                result.add(map);
            }
        }
        JSTreeModel model = new JSTreeModel();
        model.setParent("#");
        model.setCode("GROUP");
        model.setText("\u89d2\u8272\u8d44\u6e90\u6811");
        model.setId("1");
        model.setType("isRoot");
        model.setState(true, true, true);
        result.add(model);
        return result;
    }

    public void recursive(List<JSTreeModel> list, List<JSTreeModel> result, String parentId) {
        for (int i = 0; i < list.size(); ++i) {
            JSTreeModel map = list.get(i);
            if (!"1".equals(map.getIsRes()) && !parentId.equals(map.getId())) continue;
            parentId = map.getParent();
            result.add(map);
            list.remove(i);
            this.recursive(list, result, parentId);
        }
    }

    @RequestMapping(value={"/sameUrl"})
    @ResponseBody
    public ApiResponse<List<SysResources>> sameUrl(@RequestBody Map<String, String> map) {
        String url = map.get("url");
        SysResources sysResources = new SysResources();
        sysResources.setFunction(null);
        List list = this.sysResourcesMapper.sameUrl(url);
        return ApiResponse.data((Object)list);
    }

    @RequiresPermissions(value={"resource:roleTreeView"})
    @RequestMapping(value={"/roleTreeView"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> getRoleTreeView(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        List roleResourceList = this.sysRoleResourceService.list((Wrapper)new QueryWrapper().eq((Object)"resource_id", (Object)resourceId));
        if (ToolUtil.isEmpty((Object)roleResourceList)) {
            ArrayList<JSTreeModel> emptyList = new ArrayList<JSTreeModel>();
            JSTreeModel model = new JSTreeModel();
            model.setId("1");
            model.setCode("GROUP");
            model.setParent("#");
            model.setText("\u5173\u8054\u89d2\u8272");
            model.setType("isRoot");
            model.setState(false, false, true);
            emptyList.add(model);
            return ApiResponse.data(ForestNodeMerger.merge(emptyList));
        }
        ArrayList<String> roleIds = new ArrayList<String>();
        for (SysRoleResource roleResource : roleResourceList) {
            roleIds.add(roleResource.getRoleId());
        }
        List result = this.orgMaintenanceService.selfRoleTree(roleIds.toArray(new String[roleIds.size()]));
        List<JSTreeModel> tree = this.getRoleTree(result);
        block1: for (JSTreeModel js : tree) {
            for (String id : roleIds) {
                if (ToolUtil.equals((Object)js.getId(), (Object)id)) {
                    js.setState(true, true, true);
                    continue block1;
                }
                js.setState(false, false, true);
            }
        }
        return ApiResponse.data(ForestNodeMerger.merge(tree));
    }

    public List<JSTreeModel> getRoleTree(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursiveRoleTree(list, result, "");
        JSTreeModel model = new JSTreeModel();
        model.setId("1");
        model.setCode("GROUP");
        model.setParent("#");
        model.setText("\u5173\u8054\u89d2\u8272");
        model.setType("isRoot");
        result.add(model);
        return result;
    }

    public void recursiveRoleTree(List<JSTreeModel> list, List<JSTreeModel> result, String parentId) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i > list.size() - 1) {
                i = list.size() - 1;
            }
            if (i < 0) break;
            JSTreeModel map = list.get(i);
            if (!"ROLE".equals(map.getCode()) && !parentId.equals(map.getId())) continue;
            parentId = map.getParent();
            result.add(map);
            list.remove(i);
            this.recursiveRoleTree(list, result, parentId);
        }
    }

    @RequiresPermissions(value={"resource:resourceAddSaveRole"})
    @RequestMapping(value={"/resourceAddSaveRole"})
    @ResponseBody
    public ApiResponse<Tip> resourceAddSaveRole(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        String[] roleIds = map.get("roleIds") == null ? "".split(",") : map.get("roleIds").split(",");
        Date currentDate = new Date();
        String currentUser = ShiroKit.getUser().getAccount();
        ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
        for (String roleId : roleIds) {
            if (ToolUtil.isEmpty((Object)roleId)) continue;
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setRoleId(roleId);
            sysRoleResource.setResourceId(resourceId);
            sysRoleResource.setCreateTime(currentDate);
            sysRoleResource.setCreator(currentUser);
            sysRoleResource.setLastEditor(currentUser);
            sysRoleResource.setLastTime(currentDate);
            sysRoleResourceList.add(sysRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            this.sysRoleResourceService.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
        }
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"resource:resourceEditSaveRole"})
    @RequestMapping(value={"/resourceEditSaveRole"})
    @ResponseBody
    public ApiResponse<Tip> resourceEditSaveRole(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        String[] roleIds = map.get("roleIds") == null ? "".split(",") : map.get("roleIds").split(",");
        this.sysRoleResourceService.resourceEditSaveRole(resourceId, roleIds);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/getResourceRoles"})
    @ResponseBody
    public ApiResponse<List<SysRoleResource>> getResourceRoles(@RequestBody Map<String, String> map) {
        String resourceId = map.get("resourceId");
        List roleResourceList = this.sysRoleResourceService.list((Wrapper)new QueryWrapper().eq((Object)"resource_id", (Object)resourceId));
        return ApiResponse.data((Object)roleResourceList);
    }

    @RequestMapping(value={"/exportRes"})
    @RequiresPermissions(value={"resource:exportRes"})
    @BussinessLog(key="/resource/exportRes", type="03", value="\u8d44\u6e90\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String ids = super.getPara("ids");
        List<String> idList = Arrays.asList(ids.split(","));
        this.sysResManageService.exportRes(idList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @ResponseBody
    @RequiresPermissions(value={"resource:importData"})
    @BussinessLog(key="/resource/importData", type="03", value="\u8d44\u6e90\u5bfc\u5165")
    public ApiResponse<Tip> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return ApiResponse.data((Object)this.sysResManageService.importRes(content));
    }

    @RequestMapping(value={"/checkHasResources"})
    @ResponseBody
    public ApiResponse<Object> checkHasResources(@RequestBody Map<String, Object> map) {
        String type;
        String resourceId = map.get("resourceId") == null ? null : map.get("resourceId").toString();
        List list = this.iSysStruResourcesService.getResourceIdList(resourceId, type = map.get("type") == null ? null : map.get("type").toString());
        if (list.size() > 0) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u64cd\u4f5c\u6210\u529f");
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4e0d\u5b58\u5728\u53ef\u4e0b\u653e\u7684\u8d44\u6e90");
    }

    @BussinessLog(key="/resource/delegateResource", type="03", value="\u8d44\u6e90\u4e0b\u653e")
    @RequiresPermissions(value={"resource:delegateResource"})
    @RequestMapping(value={"/delegateResource"})
    @ResponseBody
    public ApiResponse<Tip> delegateResource(@RequestBody Map<String, Object> body) {
        String type;
        String resourceIdHidden = body.get("resourceIdHidden") == null ? "" : body.get("resourceIdHidden").toString().trim();
        String struIdHidden = body.get("struIdHidden") == null ? "" : body.get("struIdHidden").toString().trim();
        String string = type = body.get("typeHidden") == null ? "" : body.get("typeHidden").toString().trim();
        if (ToolUtil.isEmpty((Object)resourceIdHidden)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("resourceIdHidden", resourceIdHidden);
        map.put("struIdHidden", struIdHidden);
        map.put("type", type);
        return ApiResponse.data((Object)this.iSysStruResourcesService.delegateResource(map));
    }

    @BussinessLog(key="/resource/retrieveResource", type="03", value="\u8d44\u6e90\u56de\u6536")
    @RequiresPermissions(value={"resource:retrieveResource"})
    @RequestMapping(value={"/retrieveResource"})
    @ResponseBody
    public ApiResponse<Tip> retrieveResource(@RequestBody Map<String, Object> body) {
        String resourceIdHidden = body.get("resourceIdHidden") == null ? "" : body.get("resourceIdHidden").toString().trim();
        String struIdHidden = body.get("struIdHidden") == null ? "" : body.get("struIdHidden").toString().trim();
        String type = body.get("typeHidden") == null ? "" : body.get("typeHidden").toString().trim();
        String original = body.get("original") == null ? "" : body.get("original").toString().trim();
        String[] originalArr = original.split(",");
        if (ToolUtil.isEmpty((Object)resourceIdHidden)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        List<String> originalIdList = Arrays.asList(originalArr);
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("resourceIdHidden", resourceIdHidden);
        map.put("struIdHidden", struIdHidden);
        map.put("originalIdList", originalIdList);
        map.put("type", type);
        return ApiResponse.data((Object)this.iSysStruResourcesService.retrieveResource(map));
    }

    @RequestMapping(value={"/editResTree"})
    @ResponseBody
    public ApiResponse<List<JSTreeModel>> editResTree() {
        ArrayList<JSTreeModel> result = new ArrayList();
        result = this.sysResManageService.getEditResTree();
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/checkResource"})
    @ResponseBody
    public ApiResponse<JSONObject> checkResource(@RequestBody Map<String, String> url) {
        String resourceUrl = url.get("resourceUrl");
        JSONObject json = new JSONObject();
        json.put("flag", (Object)this.iSysResourcesService.checkResource(resourceUrl));
        json.put("totp", (Object)this.hussarProperties.getTotpOpen());
        this.abstractOTPCredentialsMatcher.getClass();
        json.put("csrfToken", (Object)this.abstractOTPCredentialsMatcher.generate("FCUD3YLMJYG2F72L2NFDXYPL6UJBUUN24BGBK6JDEIKHUA4ZOD2A"));
        return ApiResponse.data((Object)json);
    }
}

