/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.controller;

import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.encrypt.AbstractCryptoProvider;
import com.jxdinfo.hussar.encrypt.util.SM2Util;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vue/baseData"})
public class SystemBaseDataControler {
    @Autowired
    private HussarProperties hussarProperties;
    @Autowired
    private HussarCacheManager hussarCacheManager;
    @Autowired
    private GlobalProperties global;
    @Autowired
    private AbstractCryptoProvider crypto;

    @RequestMapping(value={"/getBaseData"})
    public ApiResponse<Map<String, Object>> getBaseData() {
        String publicKey_backend = (String)this.hussarCacheManager.getObject("SM2BackEndPubKey", "SM2BackEndPubKey");
        String privateKey_backend = (String)this.hussarCacheManager.getObject("SM2BackEndPriKey", "SM2BackEndPriKey");
        String publicKey_fronend = (String)this.hussarCacheManager.getObject("SM2FronEndPubKey", "SM2FronEndPubKey");
        String privateKey_fronend = (String)this.hussarCacheManager.getObject("SM2FronEndPriKey", "SM2FronEndPriKey");
        if (publicKey_backend == null || privateKey_backend == null || publicKey_fronend == null || privateKey_fronend == null) {
            Map keyMapBackEnd = SM2Util.generateKeyPair();
            Map keyMapFronEnd = SM2Util.generateKeyPair();
            publicKey_backend = (String)keyMapFronEnd.get("pubKey");
            privateKey_backend = (String)keyMapBackEnd.get("priKey");
            publicKey_fronend = (String)keyMapBackEnd.get("pubKey");
            privateKey_fronend = (String)keyMapFronEnd.get("priKey");
            this.hussarCacheManager.setObject("SM2BackEndPubKey", "SM2BackEndPubKey", (Object)publicKey_backend);
            this.hussarCacheManager.setObject("SM2BackEndPriKey", "SM2BackEndPriKey", (Object)privateKey_backend);
            this.hussarCacheManager.setObject("SM2FronEndPubKey", "SM2FronEndPubKey", (Object)publicKey_fronend);
            this.hussarCacheManager.setObject("SM2FronEndPriKey", "SM2FronEndPriKey", (Object)privateKey_fronend);
        }
        String publicKey = (String)this.crypto.getKeyMap().get("publicKey");
        String securityType = this.crypto.getClass().getSimpleName().substring(0, this.crypto.getClass().getSimpleName().indexOf("$"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("h_version", this.hussarProperties.getStaticVersion());
        map.put("SM2PriKey", privateKey_fronend);
        map.put("SM2PubKey", publicKey_fronend);
        map.put("securityType", securityType);
        map.put("publicKey", publicKey);
        map.put("signOpen", this.global.isEncryptSignOpen());
        map.put("kaptcha", this.hussarProperties.getKaptchaOpen());
        map.put("totp", this.hussarProperties.getTotpOpen());
        map.put("rememberme", this.hussarProperties.getRemebermeDays());
        map.put("hmUrl", this.hussarProperties.getHm());
        return ApiResponse.data(map);
    }
}

