/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.login;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.permit.model.SysOnline;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysOnlineHistService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.config.cas.ShiroCasConfiguration;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.front.config.SessionUtils;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.log.HussarLogManager;
import com.jxdinfo.hussar.core.log.factory.LogTaskFactory;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.IShiro;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.jxdinfo.hussar.core.support.HttpKit;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/casFrontLogin"})
public class CasFrontLoginController
extends BaseController {
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private ISysOnlineHistService iSysOnlineHistService;
    @Autowired
    private GlobalProperties globalProperties;
    @Autowired
    private ShiroCasConfiguration casConf;

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    @ResponseBody
    public ApiResponse<?> login() {
        ShiroUser shiroUser = ShiroKit.getUser();
        SysUsers sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)shiroUser.getAccount())).eq((Object)"ACCOUNT_STATUS", (Object)UserStatus.OK.getCode()), false);
        Subject currentUser = ShiroKit.getSubject();
        Session session = currentUser.getSession();
        session.setAttribute((Object)"username", (Object)shiroUser.getName());
        session.setAttribute((Object)"sessionFlag", (Object)true);
        session.setAttribute((Object)"shiroUser", (Object)shiroUser);
        session.setAttribute((Object)"userId", (Object)shiroUser.getId());
        if (sysUsers != null && "1".equals(sysUsers.getLoginTimeLimit())) {
            session.setAttribute((Object)"startTime", (Object)sysUsers.getAccessLoginStartTime());
            session.setAttribute((Object)"endTime", (Object)sysUsers.getAccessLoginEndTime());
        }
        SysOnline online = this.iSysOnlineHistService.addRecord();
        session.setAttribute((Object)"online", (Object)online);
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("sessionId", (String)((Object)ShiroKit.getSession().getId()));
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        HussarLogManager.me().executeLog(LogTaskFactory.loginLog((ShiroUser)shiroUser, (String)"05", info));
        SysUsers user = new SysUsers();
        user.setUserId(shiroUser.getId());
        user.setLastLoginTime(new Date());
        this.iSysUsersService.updateById((Object)user);
        HashMap<String, Object> map = new HashMap<String, Object>();
        IShiro shiroFactory = ShiroFactroy.me();
        List permissionList = shiroFactory.getAuthInfo(shiroUser);
        map.put("accessToken", SessionUtils.encode((String)String.valueOf(session.getId())));
        map.put("permissions", permissionList);
        map.put("userName", shiroUser.getName());
        map.put("gradeAdmin", shiroUser.isGradeadmin());
        map.put("userId", shiroUser.getId());
        map.put("deptId", shiroUser.getDeptId());
        map.put("deptName", shiroUser.getDeptName());
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/logout"})
    public String logOut() {
        Subject currentUser = ShiroKit.getSubject();
        currentUser.logout();
        return BaseController.REDIRECT + this.casConf.getServerLogoutUrl() + "?service=" + this.casConf.getFrontUrl();
    }

    @RequestMapping(value={"/addShiroCookie"})
    public String addShiroCookie(HttpServletRequest request, HttpServletResponse response) {
        String loginUrl = request.getParameter("loginUrl");
        String cookieValue = request.getParameter("shiroCookie");
        Cookie cookie = new Cookie(this.globalProperties.getTitle() + "_hussarShiroCookie", cookieValue);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
        return BaseController.REDIRECT + this.casConf.getFrontUrl() + "/#/toLogin?loginUrl=" + loginUrl;
    }

    @RequestMapping(value={"/getRedirectUrl"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getRedirectUrl(@RequestParam(value="redirectUrl") String redirectUrl, @RequestParam(value="shiroCookie") String shiroCookie) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("redirectUrl", redirectUrl + "&shiroCookie=" + shiroCookie);
        return map;
    }
}

