/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.login;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.permit.model.SysOnline;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysOnlineHistService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.bsp.permit.service.impl.SysStruAssistOrganImpl;
import com.jxdinfo.hussar.bsp.theme.service.IThemeService;
import com.jxdinfo.hussar.bsp.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.InvalidKaptchaException;
import com.jxdinfo.hussar.common.exception.TotpKeyException;
import com.jxdinfo.hussar.config.cas.ShiroCasConfiguration;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.front.common.response.IResultCode;
import com.jxdinfo.hussar.config.front.common.response.ResultCode;
import com.jxdinfo.hussar.config.front.config.SessionUtils;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.aop.NoRepeatMethod;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.encrypt.CryptoUtil;
import com.jxdinfo.hussar.core.log.HussarLogManager;
import com.jxdinfo.hussar.core.log.factory.LogTaskFactory;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.IShiro;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/frontLogin"})
public class FrontLoginController
extends BaseController {
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private IThemeService themeService;
    @Resource
    private ISysOnlineHistService iSysOnlineHistService;
    @Resource
    private HussarProperties hussarProperties;
    @Autowired
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Autowired
    private ShiroCasConfiguration casConf;
    @Resource
    private ISysWelcomeService sysWelcomeService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private SysStruAssistOrganImpl sysStruAssistOrgan;

    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    @NoRepeatMethod(timeout=500L)
    public ApiResponse<?> loginVali(@RequestBody Map<String, String> body) {
        String username = body.get("username");
        String password = body.get("cipher");
        String encrypted = body.get("encrypted");
        String remember = body.get("remember");
        if (StringUtils.isEmpty((CharSequence)password)) {
            password = encrypted;
        }
        password = CryptoUtil.decode((String)password);
        SysUsers sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)username)).eq((Object)"ACCOUNT_STATUS", (Object)UserStatus.OK.getCode()), false);
        if (this.hussarProperties.getKaptchaOpen().booleanValue()) {
            String kaptcha = body.get("kaptcha");
            String code = (String)super.getSession().getAttribute("KAPTCHA_SESSION_KEY");
            if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
                throw new InvalidKaptchaException(username, "\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
        }
        if (this.hussarProperties.getTotpOpen().booleanValue()) {
            String totp = body.get("totp");
            if (sysUsers != null && !this.abstractOTPCredentialsMatcher.verify(sysUsers.getTotpKey(), totp, this.hussarProperties.getTotpOffsetMin())) {
                throw new TotpKeyException(username, "\u52a8\u6001\u5bc6\u7801\u9519\u8bef");
            }
        }
        Subject currentUser = ShiroKit.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(username, password.toCharArray());
        if ("on".equals(remember)) {
            token.setRememberMe(true);
        } else {
            token.setRememberMe(false);
        }
        currentUser.login((AuthenticationToken)token);
        Session session = currentUser.getSession();
        ShiroUser shiroUser = ShiroKit.getUser();
        session.setAttribute((Object)"username", (Object)shiroUser.getName());
        session.setAttribute((Object)"sessionFlag", (Object)true);
        session.setAttribute((Object)"shiroUser", (Object)shiroUser);
        session.setAttribute((Object)"userId", (Object)shiroUser.getId());
        if (sysUsers != null && "1".equals(sysUsers.getLoginTimeLimit())) {
            session.setAttribute((Object)"startTime", (Object)sysUsers.getAccessLoginStartTime());
            session.setAttribute((Object)"endTime", (Object)sysUsers.getAccessLoginEndTime());
        }
        SysOnline online = this.iSysOnlineHistService.addRecord();
        session.setAttribute((Object)"online", (Object)online);
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("sessionId", (String)((Object)ShiroKit.getSession().getId()));
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        HussarLogManager.me().executeLog(LogTaskFactory.loginLog((ShiroUser)shiroUser, (String)"05", info));
        SysUsers user = new SysUsers();
        user.setUserId(shiroUser.getId());
        user.setLastLoginTime(new Date());
        this.iSysUsersService.updateById((Object)user);
        HashMap<String, Object> map = new HashMap<String, Object>();
        IShiro shiroFactory = ShiroFactroy.me();
        List permissionList = shiroFactory.getAuthInfo(shiroUser);
        map.put("accessToken", SessionUtils.encode((String)String.valueOf(session.getId())));
        map.put("permissions", permissionList);
        map.put("userName", shiroUser.getName());
        map.put("gradeAdmin", shiroUser.isGradeadmin());
        map.put("userId", shiroUser.getId());
        map.put("deptId", shiroUser.getDeptId());
        map.put("deptName", shiroUser.getDeptName());
        map.put("theme", this.themeService.getUserTheme());
        List rolesList = this.iSysUserRoleService.getRolesByUserId(shiroUser.getId());
        rolesList.add(shiroUser.getId());
        map.put("welcomeUrl", this.sysWelcomeService.getUserIndex(rolesList));
        List allOrgans = ShiroKit.getAllOrgan();
        List allAssistOrganName = ShiroKit.getAllAssistOrganName();
        map.put("allOrgans", JSON.toJSONString((Object)allOrgans));
        map.put("allAssistOrganName", JSON.toJSONString((Object)allAssistOrganName));
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/logout"})
    public ApiResponse<?> logOut() {
        ShiroKit.getSubject().logout();
        return ApiResponse.success((IResultCode)ResultCode.SUCCESS, (String)ResultCode.SUCCESS.getMessage());
    }

    @RequestMapping(value={"/check"})
    public ApiResponse<Map<String, String>> check() {
        ShiroUser shiroUser = ShiroKit.getUser();
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.globalProperties.isForceChangePwd()) {
            SysUsers sysUser = this.iSysUsersService.getUser(shiroUser.getId());
            if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
                map.put("firstLogin", "NO");
                map.put("changePwd", "NO");
                return ApiResponse.data(map);
            }
            if (this.iSysUsersService.isFirstLogin(shiroUser.getId())) {
                map.put("firstLogin", "YES");
            } else {
                map.put("firstLogin", "NO");
            }
            if (this.iSysUsersService.isPwdOverdue(shiroUser.getId())) {
                map.put("changePwd", "YES");
            } else {
                map.put("changePwd", "NO");
            }
        } else {
            map.put("firstLogin", "NO");
            map.put("changePwd", "NO");
        }
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/getTotpKapcha"})
    public ApiResponse<Map<String, Object>> getShow() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("totp", this.hussarProperties.getTotpOpen());
        map.put("kaptcha", this.hussarProperties.getKaptchaOpen());
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/validateLogin"})
    public Map<String, Object> validateLogin() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", "success");
        return map;
    }

    @RequestMapping(value={"/validateLogout"})
    public Map<String, Object> validateLogout() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.casConf.isActive()) {
            map.put("logoutUrl", this.casConf.getLocalUrl() + "/casFrontLogin/logout");
        }
        return map;
    }

    @RequestMapping(value={"/isCasActive"})
    public Map<String, Object> isCasActive() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("casActive", this.casConf.isActive());
        return map;
    }
}

