/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.system.dict.collection;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.system.dict.service.SysDicFrontService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.dicutil.DictionaryUtil;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.sys.model.DicGroup;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.model.DicType;
import com.jxdinfo.hussar.core.sys.service.ISysDicGroupService;
import com.jxdinfo.hussar.core.sys.service.ISysDicService;
import com.jxdinfo.hussar.core.sys.service.ISysDicSingleService;
import com.jxdinfo.hussar.core.sys.service.ISysDicTypeService;
import com.jxdinfo.hussar.core.sys.vo.DicVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dicFront"})
public class SysDicFrontController
extends BaseController {
    private String prefix = "/core/sys/dict/";
    private String flagOfEdit = "haveType";
    private String flagOfAdd = "0";
    @Autowired
    private ISysDicService dictService;
    @Autowired
    private SysDicFrontService sysDicFrontService;
    @Autowired
    private ISysDicSingleService dicSingleService;
    @Autowired
    private ISysDicGroupService dicGroupService;
    @Autowired
    private ISysDicTypeService dicTypeService;
    @Autowired
    private HussarCacheManager hussarCacheManager;
    @Resource
    private DictionaryUtil dictionaryUtil;

    @RequiresPermissions(value={"dict:getDictByCode"})
    @RequestMapping(value={"/getDictByCode"})
    public ApiResponse<List<DicVo>> getDictByCode(@RequestBody Map<String, Object> map) {
        String type = map.get("code") == null ? null : map.get("code").toString();
        List list = this.dictionaryUtil.getDictListByType(type);
        return ApiResponse.data((Object)list);
    }

    @RequestMapping(value={"/dict_edit/{dictTypeId}/{str}"})
    @RequiresPermissions(value={"dict:edit"})
    public ApiResponse<Map<String, Object>> openDictTypeUpdate(@PathVariable String dictTypeId, @PathVariable String str) {
        DicSingle finder = new DicSingle();
        HashMap<String, Object> map = new HashMap<String, Object>();
        List subDicts = null;
        if (this.flagOfEdit.equals(str)) {
            finder.setTypeId(dictTypeId);
            map.put("dict", this.dicTypeService.getById((Serializable)((Object)dictTypeId)));
            subDicts = this.dicSingleService.list((Wrapper)new QueryWrapper((Object)finder).orderByAsc((Object)"sort"));
        } else {
            finder.setParentId(dictTypeId);
            map.put("dict", this.dicSingleService.getById((Serializable)((Object)dictTypeId)));
            subDicts = this.dicSingleService.list((Wrapper)new QueryWrapper((Object)finder).orderByAsc((Object)"sort"));
        }
        map.put("str", str);
        map.put("subDicts", subDicts);
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/add"})
    @RequiresPermissions(value={"dict:add"})
    @BussinessLog(key="/sys/dic/add", type="01", value="\u5b57\u5178\u7c7b\u522b\u65b0\u589e")
    public ApiResponse<Tip> add(@RequestBody Map<String, Object> map) {
        String dictValues;
        String parentId = map.get("parentId") == null ? null : map.get("parentId").toString();
        String dictName = map.get("dictName") == null ? null : map.get("dictName").toString();
        String dictTypeCode = map.get("dictTypeCode") == null ? null : map.get("dictTypeCode").toString();
        String string = dictValues = map.get("dictValues") == null ? null : map.get("dictValues").toString();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{parentId, dictName, dictTypeCode})) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.dictService.addDictType(parentId, dictName, dictTypeCode, dictValues);
        return ApiResponse.data((Object)SUCCESS_TIP);
    }

    @RequestMapping(value={"/add_single"})
    @RequiresPermissions(value={"dict:add_single"})
    @BussinessLog(key="/sys/dic/add_single", type="01", value="\u5b57\u5178\u5b57\u6bb5\u6dfb\u52a0")
    public ApiResponse<Tip> addSingle(@RequestBody Map<String, String> map) {
        String dictId = map.get("dictId");
        String dictTypeId = map.get("dictTypeId");
        String dictName = map.get("dictName");
        String dictValue = map.get("dictValue");
        String flag = map.get("flag");
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        if (ToolUtil.isOneEmpty((Object[])new Object[]{dictTypeId, dictName, dictValue})) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        if (this.flagOfAdd.equals(flag) ? this.dictService.saveOrUpdateSingle(dictId, dictTypeId, dictName, dictValue) : this.dictService.saveSingleChild(dictId, dictTypeId, dictName, dictValue)) {
            return ApiResponse.data((Object)SUCCESS_TIP);
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/addGroup"})
    @RequiresPermissions(value={"dict:addGroup"})
    @BussinessLog(key="/sys/dic/addGroup", type="01", value="\u5b57\u5178\u65b0\u589e")
    public ApiResponse<Tip> addGroup(@RequestBody Map<String, Object> map) {
        String groupName;
        String groupParentId = map.get("groupParentId") == null ? null : map.get("groupParentId").toString();
        String string = groupName = map.get("groupName") == null ? null : map.get("groupName").toString();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{groupParentId, groupName})) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.dictService.addDicGroup(groupParentId, groupName);
        return ApiResponse.data((Object)SUCCESS_TIP);
    }

    @RequestMapping(value={"/editGroup"})
    @RequiresPermissions(value={"dict:editGroup"})
    @BussinessLog(key="/sys/dic/editGroup", type="03", value="\u5b57\u5178\u4fee\u6539")
    public ApiResponse<Tip> editGroup(@RequestBody Map<String, String> map) {
        String groupId = map.get("id");
        String groupName = map.get("groupName");
        if (ToolUtil.isOneEmpty((Object[])new Object[]{groupId, groupName})) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.dictService.editDictGroup(groupId, groupName);
        return ApiResponse.data((Object)SUCCESS_TIP);
    }

    @RequestMapping(value={"/update_single"})
    @RequiresPermissions(value={"dict:update_single"})
    @BussinessLog(key="/sys/dic/update_single", type="03", value="\u5b57\u5178\u5b57\u6bb5\u4fee\u6539")
    public ApiResponse<Tip> editSingle(@RequestBody Map<String, Object> map) {
        String dictValue;
        String dictId = map.get("dictId") == null ? null : map.get("dictId").toString();
        String dictTypeId = map.get("dictTypeId") == null ? null : map.get("dictTypeId").toString();
        String dictName = map.get("dictName") == null ? null : map.get("dictName").toString();
        String string = dictValue = map.get("dictValue") == null ? null : map.get("dictValue").toString();
        if (ToolUtil.isEmpty((Object)dictId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        if (this.dictService.saveOrUpdateSingle(dictId, dictTypeId, dictName, dictValue)) {
            return ApiResponse.data((Object)SUCCESS_TIP);
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/list/{rangeType}"})
    public ApiResponse<Object> list(@RequestBody Map<String, Object> map, @PathVariable(value="rangeType") String rangeType) {
        String condition = map.get("condition") == null ? null : map.get("condition").toString();
        int pageNo = map.get("page") == null ? 1 : Integer.parseInt(map.get("page").toString());
        int limit = map.get("limit") == null ? 20 : Integer.parseInt(map.get("limit").toString());
        String rootRange = "root";
        Page page = new Page((long)pageNo, (long)limit);
        QueryWrapper ew = new QueryWrapper();
        HashMap<String, Serializable> result = new HashMap<String, Serializable>(5);
        if (ToolUtil.isNotEmpty((Object)condition)) {
            ew.like((Object)"type_description", (Object)condition);
        }
        if (ToolUtil.isNotEmpty((Object)rangeType) && !rootRange.equals(rangeType)) {
            ew.eq((Object)"range_type", (Object)rangeType);
        }
        ew.orderByAsc((Object)"sort");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List list2 = ((Page)this.dicTypeService.page((IPage)page, (Wrapper)ew)).getRecords();
        for (DicType dt : list2) {
            this.warpTheObjectToMap(dt, list);
        }
        result.put("code", Integer.valueOf(0));
        result.put("count", Long.valueOf(page.getTotal()));
        result.put("data", list);
        return ApiResponse.data(result);
    }

    private void warpTheObjectToMap(DicType dt, List<Map<String, Object>> list) {
        StringBuilder detail = new StringBuilder();
        String typeId = dt.getId();
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("id", typeId);
        map.put("parentId", dt.getParentId());
        map.put("typeName", dt.getTypeName());
        map.put("typeDescription", dt.getTypeDescription());
        map.put("rangeType", dt.getRangeType());
        List dicts = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"type_id", (Object)typeId)).orderByAsc((Object)"sort"));
        if (dicts != null) {
            for (DicSingle dict : dicts) {
                detail.append(dict.getValue()).append(":").append(dict.getLabel()).append(", ");
            }
            map.put("detail", ToolUtil.removeSuffix((String)detail.toString(), (String)", "));
        }
        list.add(map);
    }

    @RequestMapping(value={"/list_single/{dictTypeId}"})
    public ApiResponse<Object> listSingle(@RequestBody Map<String, Object> map, @PathVariable(value="dictTypeId") String dictTypeId) {
        int limit;
        String condition = map.get("condition") == null ? null : map.get("condition").toString();
        int pageNo = map.get("page") == null ? 1 : Integer.parseInt(map.get("page").toString());
        int n = limit = map.get("limit") == null ? 20 : Integer.parseInt(map.get("limit").toString());
        if (ToolUtil.isEmpty((Object)dictTypeId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        Page page = new Page((long)pageNo, (long)limit);
        QueryWrapper ew = (QueryWrapper)new QueryWrapper().eq((Object)"type_id", (Object)dictTypeId);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (ToolUtil.isNotEmpty((Object)condition)) {
            ew.like((Object)"label", (Object)condition);
        }
        ew.orderByAsc((Object)"SORT");
        List list = ((Page)this.dicSingleService.page((IPage)page, (Wrapper)ew)).getRecords();
        result.put("code", 0);
        result.put("count", page.getTotal());
        result.put("data", list);
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/detail/{dictId}"})
    public ApiResponse<Object> openSingleDetail(@PathVariable(value="dictId") String dictId) {
        return ApiResponse.data((Object)this.dicSingleService.getById((Serializable)((Object)dictId)));
    }

    @RequestMapping(value={"/update"})
    @RequiresPermissions(value={"dict:edit"})
    @BussinessLog(key="/sys/dic/update", type="03", value="\u5b57\u5178\u7c7b\u522b\u4fee\u6539")
    public ApiResponse<Tip> update(@RequestBody Map<String, Object> map) {
        String delIdString;
        String info = map.get("info") == null ? null : map.get("info").toString();
        String dictValues = map.get("dictValues") == null ? null : map.get("dictValues").toString();
        String string = delIdString = map.get("delIdString") == null ? null : map.get("delIdString").toString();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{map.get("dictId"), map.get("dictName"), map.get("dictTypeCode")})) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.dictService.editDictNew(info, dictValues, delIdString);
        return ApiResponse.data((Object)SUCCESS_TIP);
    }

    @RequestMapping(value={"/delete"})
    @RequiresPermissions(value={"dict:delete"})
    @BussinessLog(key="/sys/dic/delete", type="02", value="\u5b57\u5178\u7c7b\u522b\u5220\u9664")
    public ApiResponse<Tip> delete(@RequestBody Map<String, String> map) {
        String dictId = map.get("dictId");
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        String[] strArr = dictId.split(",");
        this.dictService.deleteCascadeDict(strArr);
        return ApiResponse.data((Object)SUCCESS_TIP);
    }

    @RequestMapping(value={"/delete_single"})
    @RequiresPermissions(value={"dict:delete_single"})
    @BussinessLog(key="/sys/dic/delete_single", type="02", value="\u5b57\u5178\u5b57\u6bb5\u5220\u9664")
    public ApiResponse<Tip> deleteSingle(@RequestBody Map<String, String> map) {
        String dictId = map.get("dictId");
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        String[] strarr = dictId.split(",");
        List<String> list = Arrays.asList(strarr);
        if (this.dicSingleService.removeByIds(list)) {
            return ApiResponse.data((Object)SUCCESS_TIP);
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/dicTypeTree"})
    public ApiResponse<List<JSTreeModel>> dicTypeTreeData() {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("root");
        root.setText("\u6570\u636e\u5b57\u5178");
        root.setParent("#");
        root.setType("root");
        result.add(root);
        JSTreeModel sys = new JSTreeModel();
        sys.setId("sys");
        sys.setText("\u7cfb\u7edf\u5b57\u5178");
        sys.setParent("root");
        sys.setType("sys");
        result.add(sys);
        JSTreeModel biz = new JSTreeModel();
        biz.setId("biz");
        biz.setText("\u4e1a\u52a1\u5b57\u5178");
        biz.setParent("root");
        biz.setType("biz");
        result.add(biz);
        result.addAll(this.sysDicFrontService.dicTypeTreeData());
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/dicOrderTree"})
    public ApiResponse<List<JSTreeModel>> dicOrderTreeData(@RequestBody Map<String, String> map) {
        String typeId = map.get("typeId");
        if (ToolUtil.isEmpty((Object)typeId)) {
            return ApiResponse.data(new ArrayList());
        }
        return ApiResponse.data(ForestNodeMerger.merge(this.sysDicFrontService.dicOrderTreeData(typeId)));
    }

    @RequestMapping(value={"/saveDicOrder"})
    @RequiresPermissions(value={"dict:sort"})
    @BussinessLog(key="/sys/dic/saveDicOrder", type="03", value="\u5b57\u5178\u4e0b\u7ea7\u6392\u5e8f")
    public ApiResponse<Tip> saveDicOrder(@RequestBody Map<String, Object> map) {
        String orderInfo;
        String string = orderInfo = map.get("orderInfo") == null ? null : map.get("orderInfo").toString();
        if (ToolUtil.isEmpty((Object)orderInfo)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        if (this.dictService.saveDicOrder(orderInfo)) {
            return ApiResponse.data((Object)SUCCESS_TIP);
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/singleMove"})
    @RequiresPermissions(value={"dict:sort"})
    @BussinessLog(key="/sys/dic/singleMove", type="03", value="\u5b57\u5178\u4e0a\u79fb/\u4e0b\u79fb")
    public ApiResponse<Tip> updateMoveNode(@RequestBody Map<String, Object> map) {
        String dictId = map.get("dictId") == null ? null : map.get("dictId").toString();
        boolean isUp = map.get("isUp") == null ? null : Boolean.valueOf(map.get("isUp").toString().equals("true"));
        this.dicSingleService.evictTypeCacheBySingleId(dictId);
        if (ToolUtil.isEmpty((Object)dictId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.dictService.updateMoveNode(dictId, isUp);
        return ApiResponse.data((Object)BaseController.SUCCESS_TIP);
    }

    @RequestMapping(value={"/selectListByParentId"})
    public ApiResponse<Object> selectListByParentId() {
        return ApiResponse.data((Object)this.dicTypeService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"sort")));
    }

    @RequestMapping(value={"/selectListByTypeName"})
    public ApiResponse<Object> selectListByTypeName(@RequestBody Map<String, Object> map) {
        return ApiResponse.data((Object)this.dictionaryUtil.getDictByType(map.get("typeName") == null ? "" : map.get("typeName").toString()));
    }

    @RequestMapping(value={"/selectChildsById"})
    public ApiResponse<Object> selectChildsById(@RequestBody Map<String, String> map) {
        String id = map.get("id");
        List object = null;
        List list = this.dicTypeService.list((Wrapper)new QueryWrapper().eq(id != null, (Object)"id", (Object)id));
        object = list.size() > 0 ? this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"type_id", (Object)id)).orderByAsc((Object)"sort")) : this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"parent_id", (Object)id)).orderByAsc((Object)"sort"));
        return ApiResponse.data((Object)object);
    }

    @RequestMapping(value={"/dicExportTree"})
    public ApiResponse<List<JSTreeModel>> dicExportTreeData() {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId("root");
        root.setText("\u6570\u636e\u5b57\u5178");
        root.setParent("#");
        root.setType("root");
        result.add(root);
        JSTreeModel sys = new JSTreeModel();
        sys.setId("sys");
        sys.setText("\u7cfb\u7edf\u5b57\u5178");
        sys.setParent("root");
        sys.setType("sys");
        result.add(sys);
        JSTreeModel biz = new JSTreeModel();
        biz.setId("biz");
        biz.setText("\u4e1a\u52a1\u5b57\u5178");
        biz.setParent("root");
        biz.setType("biz");
        result.add(biz);
        ArrayList<JSTreeModel> mapList = new ArrayList<JSTreeModel>();
        List groups = this.dicGroupService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"SORT"));
        if (groups != null && groups.size() > 0) {
            for (DicGroup group : groups) {
                JSTreeModel tempObject = new JSTreeModel();
                tempObject.setId(group.getId());
                tempObject.setParent(group.getParentId());
                tempObject.setText(group.getGroupDescription());
                tempObject.setType("dict");
                tempObject.setSeq(group.getSort().toString());
                tempObject.setRangeType(group.getRangeType());
                mapList.add(tempObject);
            }
        }
        result.addAll(mapList);
        result.addAll(this.dicTypeService.dicExportTreeData());
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/exportDict"})
    @RequiresPermissions(value={"dict:exportDict"})
    @BussinessLog(key="/sys/dic/exportDict", type="03", value="\u5b57\u5178\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String typeIds = super.getPara("typeIds");
        List<String> typeIdList = Arrays.asList(typeIds.split(","));
        this.dicTypeService.exportDict(typeIdList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @RequiresPermissions(value={"dict:importData"})
    @BussinessLog(key="/sys/dic/importData", type="03", value="\u5b57\u5178\u5bfc\u5165")
    public ApiResponse<Tip> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        Tip tip = this.dicTypeService.importDict(content);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)tip.getMessage());
    }
}

