/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.service.sqlmonitor;

import com.jxdinfo.hussar.bsp.sqlmonitor.service.ISqlMonitorService;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.config.properties.ConnectionPoolProperties;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sqlMonitorFront"})
public class SqlMonitorFrontController {
    @Autowired
    private ISqlMonitorService iSqlMonitorService;
    @Autowired
    private ConnectionPoolProperties connectionPoolProperties;

    @RequiresPermissions(value={"SqlMonitor:list"})
    @RequestMapping(value={"/list"})
    public ApiResponse<Object> list(@RequestBody Map<String, Object> body) {
        String orderBy = body.get("orderBy") == null ? null : body.get("orderBy").toString();
        String orderType = body.get("orderType") == null ? null : body.get("orderType").toString();
        String page = body.get("page") == null ? null : body.get("page").toString();
        String perPageCount = body.get("perPageCount") == null ? null : body.get("perPageCount").toString();
        HashMap<String, String> map = new HashMap<String, String>();
        if (null == orderBy) {
            orderBy = "MaxTimespan";
        }
        if (null == orderType) {
            orderType = "desc";
        }
        map.put("orderBy", orderBy);
        map.put("orderType", orderType);
        map.put("page", page);
        map.put("perPageCount", perPageCount);
        Map result = this.iSqlMonitorService.getList(map);
        int slowSqlMillis = this.connectionPoolProperties.getSlowSqlMillis();
        result.put("slowSqlMillis", slowSqlMillis);
        return ApiResponse.data((Object)result);
    }
}

