/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.organ.controller;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.organ.dictmap.SysOrganTypeDict;
import com.jxdinfo.hussar.bsp.organ.model.SysOrganType;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.aop.NoRepeatMethod;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysOrganFront"})
public class SysOrganTypeFrontController
extends BaseController {
    @Resource
    private ISysOrganTypeService iSysOrganTypeService;
    @Resource
    private ISysStruRuleService isSysStruRuleService;

    @RequestMapping(value={"/list"})
    @RequiresPermissions(value={"orgType:search"})
    @NoRepeatMethod(timeout=50L, autoCompletion=false)
    public ApiResponse<Map<String, Object>> list(@RequestBody Map<String, Object> map) {
        String limit;
        String code = map.get("typeCode") == null ? null : map.get("typeCode").toString();
        String name = map.get("typeName") == null ? null : map.get("typeName").toString();
        String page = map.get("page") == null ? "1" : map.get("page").toString();
        String string = limit = map.get("limit") == null ? "10" : map.get("limit").toString();
        if (!StringUtils.isEmpty((String)code)) {
            code = code.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        if (!StringUtils.isEmpty((String)name)) {
            name = name.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
        }
        Map result = this.iSysOrganTypeService.getOrganTypeList(page, limit, name, code);
        return ApiResponse.data((Object)result);
    }

    @RequestMapping(value={"/orgTypeOption"})
    public ApiResponse<List<SysOrganType>> orgTypeOption() {
        return ApiResponse.data((Object)this.iSysOrganTypeService.getOrgTypeOption());
    }

    @RequiresPermissions(value={"orgType:selectOrg"})
    @RequestMapping(value={"selectOrg"})
    public ApiResponse<SysOrganType> selectOrg(@RequestBody Map<String, String> map) {
        String orgCode = map.get("orgCode");
        return ApiResponse.data((Object)this.iSysOrganTypeService.getById((Serializable)((Object)orgCode)));
    }

    @RequestMapping(value={"/add"})
    @RequiresPermissions(value={"orgType:add"})
    @BussinessLog(key="/orgType/add", type="01", value="\u6dfb\u52a0\u7ec4\u7ec7\u7c7b\u578b", pk="organType", dict=SysOrganTypeDict.class)
    public ApiResponse<Object> add(@RequestBody Map<String, String> map) {
        String orgCode = map.get("typeCode");
        String orgName = map.get("typeName");
        String parentType = map.get("parentType");
        String imgUrl = map.get("typeIcon");
        SysOrganType org = (SysOrganType)this.iSysOrganTypeService.getById((Serializable)((Object)orgCode));
        if (org != null) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u7ec4\u7ec7\u7c7b\u578b\u4ee3\u7801\u5df2\u5b58\u5728\uff01");
        }
        List orgList = this.iSysOrganTypeService.list((Wrapper)new QueryWrapper().eq((Object)"TYPE_NAME", (Object)orgName));
        if (orgList.size() != 0) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        Date nowTime = new Date();
        SysOrganType sysOrganType = new SysOrganType();
        sysOrganType.setTypeName(orgName);
        sysOrganType.setOrganType(orgCode);
        sysOrganType.setImgUrl(imgUrl);
        sysOrganType.setCreateTime(nowTime);
        sysOrganType.setLastTime(nowTime);
        sysOrganType.setParentType(parentType);
        sysOrganType.setInUse("1");
        sysOrganType.setIsSystem("0");
        sysOrganType.setCreator(ShiroKit.getUser().getId());
        sysOrganType.setLastEditor(ShiroKit.getUser().getId());
        Integer count = this.iSysOrganTypeService.add(sysOrganType);
        if (ToolUtil.equals((Object)count, (Object)1)) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/edit"})
    @RequiresPermissions(value={"orgType:edit"})
    @BussinessLog(key="/orgType/edit", type="03", value="\u4fee\u6539\u7ec4\u7ec7\u7c7b\u578b", pk="organType", dict=SysOrganTypeDict.class)
    public ApiResponse<Object> edit(@RequestBody Map<String, String> map) {
        List orgList;
        String orgCode = map.get("organType");
        String orgName = map.get("typeName");
        String oldOrgName = map.get("oldOrgName");
        String typeIcon = map.get("typeIcon");
        if (!orgName.equals(oldOrgName) && (orgList = this.iSysOrganTypeService.list((Wrapper)new QueryWrapper().eq((Object)"TYPE_NAME", (Object)orgName))).size() != 0) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        SysOrganType before = (SysOrganType)this.iSysOrganTypeService.getById((Serializable)((Object)orgCode));
        LogObjectHolder.me().set((Object)before);
        SysOrganType sysOrganType = new SysOrganType();
        sysOrganType.setTypeName(orgName);
        sysOrganType.setImgUrl(typeIcon);
        sysOrganType.setOrganType(orgCode);
        sysOrganType.setLastTime(new Date());
        sysOrganType.setLastEditor(ShiroKit.getUser().getId());
        Integer count = this.iSysOrganTypeService.edit(sysOrganType);
        if (ToolUtil.equals((Object)count, (Object)1)) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/delByIds"})
    @RequiresPermissions(value={"orgType:delete"})
    @BussinessLog(key="/orgType/delByIds", type="02", value="\u5220\u9664\u7ec4\u7ec7\u7c7b\u578b")
    public ApiResponse<Object> delByIds(@RequestBody Map<String, String> map) {
        String idStr = map.get("ids");
        List<String> ids = Arrays.asList(idStr.split(","));
        List orgList = this.iSysOrganTypeService.list((Wrapper)new QueryWrapper().in((Object)"PARENT_TYPE", ids));
        List topOrg = this.isSysStruRuleService.list((Wrapper)new QueryWrapper().in((Object)"SYS_ORGAN_TYPE", ids));
        List dowOrg = this.isSysStruRuleService.list((Wrapper)new QueryWrapper().in((Object)"ORGAN_TYPE", ids));
        if (orgList.size() != 0 || topOrg.size() != 0 || dowOrg.size() != 0) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01\uff08\u7ec4\u7ec7\u7c7b\u578b\u5df2\u5e94\u7528\uff09");
        }
        boolean flag = this.iSysOrganTypeService.delByIds(ids);
        if (flag) {
            return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u5220\u9664\u6210\u529f\uff01");
        }
        return ApiResponse.fail((int)HttpCode.CONFLICT.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }
}

