/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.bsp.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.bsp.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.bsp.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.bsp.organ.model.SysStaff;
import com.jxdinfo.hussar.bsp.organ.service.ISysStaffService;
import com.jxdinfo.hussar.bsp.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.bsp.organ.vo.OrganInfoVo;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysStaffAuditFront"})
public class SysStaffAuditFrontController
extends BaseController {
    @Autowired
    private ISysStruAuditService sysStruAuditService;
    @Autowired
    private ISysStaffAuditService sysStaffAuditService;
    @Autowired
    private ISysStruAuditService iSysStruAuditService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysStaffService sysStaffService;

    @RequestMapping(value={"/list"})
    @ResponseBody
    @RequiresPermissions(value={"sysStaffAudit:list"})
    @BussinessLog(key="/sysStaffAudit/list", type="04", value="\u4eba\u5458\u5ba1\u6838\u5217\u8868")
    public ApiResponse<JSONObject> list(@RequestBody Map<String, Object> map) {
        String userName = map.get("userName") == null ? null : map.get("userName").toString();
        String type = map.get("status") == null ? null : map.get("status").toString();
        int page = map.get("current") == null ? 1 : Integer.parseInt(map.get("current").toString());
        int limit = map.get("size") == null ? 10 : Integer.parseInt(map.get("size").toString());
        Page pages = new Page((long)page, (long)limit);
        JSONObject jsonObject = new JSONObject();
        List list = this.sysStaffAuditService.queryStaffAudit(pages, userName, type);
        jsonObject.put("count", (Object)pages.getTotal());
        jsonObject.put("data", (Object)list);
        jsonObject.put("code", (Object)0);
        jsonObject.put("msg", (Object)"success");
        return ApiResponse.data((Object)jsonObject);
    }

    @RequestMapping(value={"/verify"})
    @ResponseBody
    @BussinessLog(key="/sysStruAudit/verify", type="03", value="\u7ec4\u7ec7\u673a\u6784/\u4eba\u5458\u64cd\u4f5c\u5ba1\u6838")
    @RequiresPermissions(value={"sysStruAudit:verify"})
    public ApiResponse<Object> verify(@RequestBody Map<String, Object> map) {
        String realStruId;
        String struId = map.get("struId") == null ? null : map.get("struId").toString();
        String type = map.get("type") == null ? null : map.get("type").toString();
        String inUse = map.get("inUse") == null ? null : map.get("inUse").toString();
        String string = realStruId = map.get("realStruId") == null ? null : map.get("realStruId").toString();
        if (this.sysStruAuditService.verify(struId, type, inUse, realStruId)) {
            if ("1".equals(type)) {
                return ApiResponse.success((String)"\u901a\u8fc7\u6210\u529f\uff01");
            }
            return ApiResponse.success((String)"\u9a73\u56de\u6210\u529f\uff01");
        }
        if ("1".equals(type)) {
            return ApiResponse.fail((String)"\u901a\u8fc7\u5931\u8d25\uff01");
        }
        return ApiResponse.fail((String)"\u9a73\u56de\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/detail"})
    @BussinessLog(key="/sysStaffAudit/view", type="04", value="\u4eba\u5458\u5ba1\u6838\u8be6\u60c5")
    @RequiresPermissions(value={"sysStaffAudit:view"})
    public ApiResponse<JSONObject> detail(@RequestBody Map<String, Object> map) {
        String sex;
        String struId = map.get("struId") == null ? null : map.get("struId").toString();
        String type = map.get("type") == null ? null : map.get("type").toString();
        JSONObject jsonObject = new JSONObject();
        if ("1".equals(type)) {
            OrganInfoVo orgInfo = this.iSysStruAuditService.getOrgInfoById(struId);
            SysStaffAudit staff = (SysStaffAudit)this.sysStaffAuditService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)struId), false);
            if (ToolUtil.isEmpty((Object)staff)) {
                staff = new SysStaffAudit();
            }
            jsonObject.put("orgData", (Object)orgInfo);
            jsonObject.put("staffData", (Object)staff);
            return ApiResponse.data((Object)jsonObject);
        }
        if ("2".equals(type)) {
            String odlSex;
            String realStruId = map.get("realStruId") == null ? null : map.get("realStruId").toString();
            OrganInfoVo orgInfo = this.iSysStruAuditService.getEditOrgInfoById(struId);
            SysStaffAudit staff = (SysStaffAudit)this.sysStaffAuditService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)struId), false);
            if (ToolUtil.isEmpty((Object)staff)) {
                staff = new SysStaffAudit();
            }
            OrganInfoVo oldOrgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
            SysStaff oldStaff = (SysStaff)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)realStruId), false);
            String sex2 = staff.getSex();
            if (sex2 != null) {
                switch (sex2) {
                    case "1": {
                        sex2 = "\u7537";
                        break;
                    }
                    case "2": {
                        sex2 = "\u5973";
                        break;
                    }
                }
                staff.setSex(sex2);
            }
            if ((odlSex = oldStaff.getSex()) != null) {
                switch (odlSex) {
                    case "1": {
                        odlSex = "\u7537";
                        break;
                    }
                    case "2": {
                        odlSex = "\u5973";
                        break;
                    }
                }
                oldStaff.setSex(odlSex);
            }
            jsonObject.put("orgData", (Object)orgInfo);
            jsonObject.put("staffData", (Object)staff);
            jsonObject.put("oldOrgData", (Object)oldOrgInfo);
            jsonObject.put("oldStaffData", (Object)oldStaff);
            return ApiResponse.data((Object)jsonObject);
        }
        if ("3".equals(type)) {
            String realStruId = map.get("realStruId") == null ? null : map.get("realStruId").toString();
            OrganInfoVo orgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
            SysStaff staff = (SysStaff)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)realStruId), false);
            if (ToolUtil.isEmpty((Object)staff)) {
                staff = new SysStaff();
            }
            jsonObject.put("orgData", (Object)orgInfo);
            jsonObject.put("staffData", (Object)staff);
            return ApiResponse.data((Object)jsonObject);
        }
        String realStruId = map.get("realStruId") == null ? null : map.get("realStruId").toString();
        OrganInfoVo oldOrgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
        String newParentName = this.iSysStruAuditService.getNewParentName(struId);
        SysStaffAudit staff = (SysStaffAudit)this.sysStaffAuditService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)realStruId), false);
        SysStaff oldStaff = (SysStaff)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)realStruId), false);
        if (ToolUtil.isEmpty((Object)staff)) {
            staff = new SysStaffAudit();
        }
        if ((sex = oldStaff.getSex()) != null) {
            switch (sex) {
                case "1": {
                    sex = "\u7537";
                    break;
                }
                case "2": {
                    sex = "\u5973";
                    break;
                }
            }
            staff.setSex(sex);
            oldStaff.setSex(sex);
        }
        staff.setAddress(oldStaff.getAddress());
        staff.setBirthday(oldStaff.getBirthday());
        staff.setGraduateDate(oldStaff.getGraduateDate());
        staff.setGraduateSchool(oldStaff.getGraduateSchool());
        staff.setIdcard(oldStaff.getIdcard());
        staff.setName(oldStaff.getName());
        staff.setWorkDate(oldStaff.getWorkDate());
        staff.setWorkId(oldStaff.getWorkId());
        OrganInfoVo orgInfo = this.orgMaintenanceService.getOldOrgInfoById(realStruId);
        orgInfo.setParentName(newParentName);
        jsonObject.put("orgData", (Object)orgInfo);
        jsonObject.put("staffData", (Object)staff);
        jsonObject.put("oldOrgData", (Object)oldOrgInfo);
        jsonObject.put("oldStaffData", (Object)oldStaff);
        return ApiResponse.data((Object)jsonObject);
    }
}

