/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.system.dict.collection;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.mapper.Wrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.jxdinfo.hussar.bsp.system.dict.service.SysDicFrontService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.dicutil.DictionaryUtil;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.model.DicType;
import com.jxdinfo.hussar.core.sys.service.ISysDicService;
import com.jxdinfo.hussar.core.sys.service.ISysDicSingleService;
import com.jxdinfo.hussar.core.sys.service.ISysDicTypeService;
import com.jxdinfo.hussar.core.sys.vo.DicVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dicFront"})
public class SysDicFrontController
extends BaseController {
    private String prefix = "/core/sys/dict/";
    private String flagOfEdit = "haveType";
    private String flagOfAdd = "0";
    @Autowired
    private ISysDicService dictService;
    @Autowired
    private SysDicFrontService sysDicFrontService;
    @Autowired
    private ISysDicSingleService dicSingleService;
    @Autowired
    private ISysDicTypeService dicTypeService;
    @Autowired
    private HussarCacheManager hussarCacheManager;
    @Resource
    private DictionaryUtil dictionaryUtil;

    @RequestMapping(value={"/getDictByCode"})
    public ApiResponse<List<DicVo>> getDictByCode() {
        String type = super.getPara("code");
        List list = this.dictionaryUtil.getDictListByType(type);
        return ApiResponse.data((Object)list);
    }

    @RequestMapping(value={"/dict_edit/{dictTypeId}/{str}"})
    @RequiresPermissions(value={"dict:edit"})
    public ApiResponse<Map<String, Object>> openDictTypeUpdate(@PathVariable String dictTypeId, @PathVariable String str) {
        DicSingle finder = new DicSingle();
        HashMap<String, Object> map = new HashMap<String, Object>();
        List subDicts = null;
        if (this.flagOfEdit.equals(str)) {
            finder.setTypeId(dictTypeId);
            map.put("dict", this.dicTypeService.selectById((Serializable)((Object)dictTypeId)));
            subDicts = this.dicSingleService.selectList(new EntityWrapper((Object)finder).orderBy("sort"));
        } else {
            finder.setParentId(dictTypeId);
            map.put("dict", this.dicSingleService.selectById((Serializable)((Object)dictTypeId)));
            subDicts = this.dicSingleService.selectList(new EntityWrapper((Object)finder).orderBy("sort"));
        }
        map.put("str", str);
        map.put("subDicts", subDicts);
        return ApiResponse.data(map);
    }

    @RequestMapping(value={"/add"})
    @RequiresPermissions(value={"dict:add"})
    @BussinessLog(key="/sys/dic/add", type="01", value="\u5b57\u5178\u7c7b\u522b\u65b0\u589e")
    public ApiResponse<Tip> add(@RequestBody Map<String, String> map) {
        String parentId = map.get("parentId");
        String dictName = map.get("dictName");
        String dictTypeCode = map.get("dictTypeCode");
        String dictValues = map.get("dictValues");
        if (ToolUtil.isOneEmpty((Object[])new Object[]{parentId, dictName, dictTypeCode})) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.dictService.addDictType(parentId, dictName, dictTypeCode, dictValues);
        return ApiResponse.data((Object)SUCCESS_TIP);
    }

    @RequestMapping(value={"/add_single"})
    @RequiresPermissions(value={"dict:add_single"})
    @BussinessLog(key="/sys/dic/add_single", type="01", value="\u5b57\u5178\u5b57\u6bb5\u6dfb\u52a0")
    public ApiResponse<Tip> addSingle(@RequestBody Map<String, String> map) {
        String dictId = map.get("dictId");
        String dictTypeId = map.get("dictTypeId");
        String dictName = map.get("dictName");
        String dictValue = map.get("dictValue");
        String flag = map.get("flag");
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        if (ToolUtil.isOneEmpty((Object[])new Object[]{dictTypeId, dictName, dictValue})) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        if (this.flagOfAdd.equals(flag) ? this.dictService.saveOrUpdateSingle(dictId, dictTypeId, dictName, dictValue) : this.dictService.saveSingleChild(dictId, dictTypeId, dictName, dictValue)) {
            return ApiResponse.data((Object)SUCCESS_TIP);
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u65b0\u589e\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/update_single"})
    @RequiresPermissions(value={"dict:update_single"})
    @BussinessLog(key="/sys/dic/update_single", type="03", value="\u5b57\u5178\u5b57\u6bb5\u4fee\u6539")
    public ApiResponse<Tip> editSingle(String dictId, String dictTypeId, String dictName, String dictValue, String flag) {
        if (ToolUtil.isEmpty((Object)dictId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        if (this.dictService.saveOrUpdateSingle(dictId, dictTypeId, dictName, dictValue)) {
            return ApiResponse.data((Object)SUCCESS_TIP);
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fee\u6539\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/list/{rangeType}"})
    public ApiResponse<Object> list(@PathVariable(value="rangeType") String rangeType, String condition, @RequestParam(value="page", defaultValue="1") int pageNo, @RequestParam(value="limit", defaultValue="20") int limit) {
        String rootRange = "root";
        Page page = new Page(pageNo, limit);
        EntityWrapper ew = new EntityWrapper();
        HashMap<String, Serializable> result = new HashMap<String, Serializable>(5);
        if (ToolUtil.isNotEmpty((Object)condition)) {
            ew.like("type_description", condition);
        }
        if (ToolUtil.isNotEmpty((Object)rangeType) && !rootRange.equals(rangeType)) {
            ew.and().eq("range_type", (Object)rangeType);
        }
        ew.orderBy("sort");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List list2 = this.dicTypeService.selectPage(page, (Wrapper)ew).getRecords();
        for (DicType dt : list2) {
            this.warpTheObjectToMap(dt, list);
        }
        result.put("code", Integer.valueOf(0));
        result.put("count", Integer.valueOf(page.getTotal()));
        result.put("data", list);
        return ApiResponse.data(result);
    }

    private void warpTheObjectToMap(DicType dt, List<Map<String, Object>> list) {
        StringBuilder detail = new StringBuilder();
        String typeId = dt.getId();
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("id", typeId);
        map.put("parentId", dt.getParentId());
        map.put("typeName", dt.getTypeName());
        map.put("typeDescription", dt.getTypeDescription());
        map.put("rangeType", dt.getRangeType());
        List dicts = this.dicSingleService.selectList(new EntityWrapper().eq("type_id", (Object)typeId).orderBy("sort"));
        if (dicts != null) {
            for (DicSingle dict : dicts) {
                detail.append(dict.getValue()).append(":").append(dict.getLabel()).append(", ");
            }
            map.put("detail", ToolUtil.removeSuffix((String)detail.toString(), (String)", "));
        }
        list.add(map);
    }

    @RequestMapping(value={"/list_single/{dictTypeId}"})
    public ApiResponse<Object> listSingle(@PathVariable(value="dictTypeId") String dictTypeId, String condition, @RequestParam(value="page", defaultValue="1") int pageNo, @RequestParam(value="limit", defaultValue="20") int limit) {
        if (ToolUtil.isEmpty((Object)dictTypeId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        Page page = new Page(pageNo, limit);
        Wrapper ew = new EntityWrapper().eq("type_id", (Object)dictTypeId);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (ToolUtil.isNotEmpty((Object)condition)) {
            ew.and().like("label", condition);
        }
        ew.orderBy("SORT");
        List list = this.dicSingleService.selectPage(page, ew).getRecords();
        result.put("code", 0);
        result.put("count", page.getTotal());
        result.put("data", list);
        return ApiResponse.data(result);
    }

    @RequestMapping(value={"/detail/{dictId}"})
    public ApiResponse<Object> openSingleDetail(@PathVariable(value="dictId") String dictId) {
        return ApiResponse.data((Object)this.dicSingleService.selectById((Serializable)((Object)dictId)));
    }

    @RequestMapping(value={"/update"})
    @RequiresPermissions(value={"dict:edit"})
    @BussinessLog(key="/sys/dic/update", type="03", value="\u5b57\u5178\u7c7b\u522b\u4fee\u6539")
    public ApiResponse<Tip> update(@RequestBody Map<String, String> map) {
        String info = map.get("info");
        String dictValues = map.get("dictValues");
        String delIdString = map.get("delIdString");
        if (ToolUtil.isOneEmpty((Object[])new Object[]{map.get("dictId"), map.get("dictName"), map.get("dictTypeCode")})) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.dictService.editDictNew(info, dictValues, delIdString);
        return ApiResponse.data((Object)SUCCESS_TIP);
    }

    @RequestMapping(value={"/delete"})
    @RequiresPermissions(value={"dict:delete"})
    @BussinessLog(key="/sys/dic/delete", type="02", value="\u5b57\u5178\u7c7b\u522b\u5220\u9664")
    public ApiResponse<Tip> delete(@RequestParam String dictId) {
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        String[] strArr = dictId.split(",");
        this.dictService.deleteCascadeDict(strArr);
        return ApiResponse.data((Object)SUCCESS_TIP);
    }

    @RequestMapping(value={"/delete_single"})
    @RequiresPermissions(value={"dict:delete_single"})
    @BussinessLog(key="/sys/dic/delete_single", type="02", value="\u5b57\u5178\u5b57\u6bb5\u5220\u9664")
    public ApiResponse<Tip> deleteSingle(@RequestParam String dictId) {
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        String[] strarr = dictId.split(",");
        List<String> list = Arrays.asList(strarr);
        if (this.dicSingleService.deleteBatchIds(list)) {
            return ApiResponse.data((Object)SUCCESS_TIP);
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/dicTypeTree"})
    public ApiResponse<List<JSTreeModel>> dicTypeTreeData() {
        List<JSTreeModel> result = this.sysDicFrontService.dicTypeTreeData();
        JSTreeModel root = new JSTreeModel();
        root.setId("root");
        root.setText("\u6570\u636e\u5b57\u5178");
        root.setParent("#");
        root.setType("root");
        result.add(root);
        JSTreeModel sys = new JSTreeModel();
        sys.setId("sys");
        sys.setText("\u7cfb\u7edf\u5b57\u5178");
        sys.setParent("root");
        sys.setType("sys");
        result.add(sys);
        JSTreeModel biz = new JSTreeModel();
        biz.setId("biz");
        biz.setText("\u4e1a\u52a1\u5b57\u5178");
        biz.setParent("root");
        biz.setType("biz");
        result.add(biz);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/dicOrderTree"})
    public ApiResponse<List<JSTreeModel>> dicOrderTreeData(String typeId) {
        if (ToolUtil.isEmpty((Object)typeId)) {
            return ApiResponse.data(new ArrayList());
        }
        return ApiResponse.data(ForestNodeMerger.merge(this.sysDicFrontService.dicOrderTreeData(typeId)));
    }

    @RequestMapping(value={"/saveDicOrder"})
    @RequiresPermissions(value={"dict:sort"})
    @BussinessLog(key="/sys/dic/saveDicOrder", type="03", value="\u5b57\u5178\u4e0b\u7ea7\u6392\u5e8f")
    public ApiResponse<Tip> saveDicOrder(@RequestBody Map<String, String> map) {
        String orderInfo = map.get("orderInfo");
        if (ToolUtil.isEmpty((Object)orderInfo)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        if (this.dictService.saveDicOrder(orderInfo)) {
            return ApiResponse.data((Object)SUCCESS_TIP);
        }
        return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)"\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/singleMove"})
    @RequiresPermissions(value={"dict:sort"})
    @BussinessLog(key="/sys/dic/singleMove", type="03", value="\u5b57\u5178\u4e0a\u79fb/\u4e0b\u79fb")
    public ApiResponse<Tip> updateMoveNode(@RequestBody Map<String, String> map) {
        String dictId = map.get("dictId");
        boolean isUp = map.get("isUp").equals("true");
        this.dicSingleService.evictTypeCacheBySingleId(dictId);
        if (ToolUtil.isEmpty((Object)dictId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.dictService.updateMoveNode(dictId, isUp);
        return ApiResponse.data((Object)BaseController.SUCCESS_TIP);
    }

    @RequestMapping(value={"/selectListByParentId"})
    public ApiResponse<Object> selectListByParentId() {
        return ApiResponse.data((Object)this.dicTypeService.selectList(new EntityWrapper().orderBy("sort")));
    }

    @RequestMapping(value={"/selectListByTypeName"})
    public ApiResponse<Object> selectListByTypeName() {
        return ApiResponse.data((Object)this.dictionaryUtil.getDictByType(super.getPara("typeName")));
    }

    @RequestMapping(value={"/selectChildsById"})
    public ApiResponse<Object> selectChildsById() {
        String id = super.getPara("id");
        List object = null;
        List list = this.dicTypeService.selectList(new EntityWrapper().eq(id != null, "id", (Object)id));
        object = list.size() > 0 ? this.dicSingleService.selectList(new EntityWrapper().eq("type_id", (Object)id).orderBy("sort")) : this.dicSingleService.selectList(new EntityWrapper().eq("parent_id", (Object)id).orderBy("sort"));
        return ApiResponse.data((Object)object);
    }

    @RequestMapping(value={"/dicExportTree"})
    public ApiResponse<List<JSTreeModel>> dicExportTreeData() {
        List result = this.dicTypeService.dicExportTreeData();
        JSTreeModel root = new JSTreeModel();
        root.setId("root");
        root.setText("\u6570\u636e\u5b57\u5178");
        root.setParent("#");
        root.setType("root");
        result.add(root);
        JSTreeModel sys = new JSTreeModel();
        sys.setId("sys");
        sys.setText("\u7cfb\u7edf\u5b57\u5178");
        sys.setParent("root");
        sys.setType("sys");
        result.add(sys);
        JSTreeModel biz = new JSTreeModel();
        biz.setId("biz");
        biz.setText("\u4e1a\u52a1\u5b57\u5178");
        biz.setParent("root");
        biz.setType("biz");
        result.add(biz);
        return ApiResponse.data(ForestNodeMerger.merge(result));
    }

    @RequestMapping(value={"/exportDict"})
    @RequiresPermissions(value={"dict:exportDict"})
    @BussinessLog(key="/sys/dic/exportDict", type="03", value="\u5b57\u5178\u5bfc\u51fa")
    public ApiResponse<Tip> exportData(HttpServletResponse response) {
        String typeIds = super.getPara("typeIds");
        List<String> typeIdList = Arrays.asList(typeIds.split(","));
        this.dicTypeService.exportDict(typeIdList, response);
        return ApiResponse.success((int)HttpCode.OK.value(), (String)"\u64cd\u4f5c\u6210\u529f");
    }
}

